/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Consumer;
import kafka.server.CachedPartition;
import kafka.server.FetchContext;
import kafka.server.FetchSession;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchMetadata;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function2;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\u0005]e\u0001B\r\u001b\u0001}A\u0001B\u000b\u0001\u0003\u0006\u0004%Ia\u000b\u0005\ts\u0001\u0011\t\u0011)A\u0005Y!A!\b\u0001BC\u0002\u0013%1\b\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003=\u0011!\u0019\u0005A!b\u0001\n\u0013!\u0005\u0002\u0003%\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u000b%\u0003A\u0011\u0001&\t\u000b=\u0003A\u0011\t)\t\u000bu\u0003A\u0011\t0\u0007\t9\u0004Aa\u001c\u0005\n\u007f*\u0011)\u0019!C\u0001\u0003\u0003A\u0011\"a\u0001\u000b\u0005\u0003\u0005\u000b\u0011\u0002=\t\u0015\u0005\u0015!B!b\u0001\n\u0003\t9\u0001\u0003\u0006\u0002\u0010)\u0011\t\u0011)A\u0005\u0003\u0013Aa!\u0013\u0006\u0005\u0002\u0005E\u0001\"CA\u000e\u0015\u0001\u0007I\u0011AA\u000f\u0011%\tIE\u0003a\u0001\n\u0003\tY\u0005\u0003\u0005\u0002R)\u0001\u000b\u0015BA\u0010\u0011\u001d\t\u0019F\u0003C!\u0003+Bq!a\u0016\u000b\t\u0003\nI\u0006C\u0004\u0002\\)!\t%!\u0018\t\u000f\u0005\u0015\u0004\u0001\"\u0011\u0002h!9\u00111\u0011\u0001\u0005B\u0005\u0015\u0005bBAH\u0001\u0011\u0005\u0013\u0011\u0013\u0002\u0018\u0013:\u001c'/Z7f]R\fGNR3uG\"\u001cuN\u001c;fqRT!a\u0007\u000f\u0002\rM,'O^3s\u0015\u0005i\u0012!B6bM.\f7\u0001A\n\u0004\u0001\u00012\u0003CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#AB!osJ+g\r\u0005\u0002(Q5\t!$\u0003\u0002*5\taa)\u001a;dQ\u000e{g\u000e^3yi\u0006!A/[7f+\u0005a\u0003CA\u00178\u001b\u0005q#BA\u00181\u0003\u0015)H/\u001b7t\u0015\t\t$'\u0001\u0004d_6lwN\u001c\u0006\u0003;MR!\u0001N\u001b\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0014aA8sO&\u0011\u0001H\f\u0002\u0005)&lW-A\u0003uS6,\u0007%A\u0006sKFlU\r^1eCR\fW#\u0001\u001f\u0011\u0005u\u0002U\"\u0001 \u000b\u0005}\u0002\u0014\u0001\u0003:fcV,7\u000f^:\n\u0005\u0005s$!\u0004$fi\u000eDW*\u001a;bI\u0006$\u0018-\u0001\u0007sKFlU\r^1eCR\f\u0007%A\u0004tKN\u001c\u0018n\u001c8\u0016\u0003\u0015\u0003\"a\n$\n\u0005\u001dS\"\u0001\u0004$fi\u000eD7+Z:tS>t\u0017\u0001C:fgNLwN\u001c\u0011\u0002\rqJg.\u001b;?)\u0011YE*\u0014(\u0011\u0005\u001d\u0002\u0001\"\u0002\u0016\b\u0001\u0004a\u0003\"\u0002\u001e\b\u0001\u0004a\u0004\"B\"\b\u0001\u0004)\u0015AD4fi\u001a+Go\u00195PM\u001a\u001cX\r\u001e\u000b\u0003#^\u00032!\t*U\u0013\t\u0019&E\u0001\u0004PaRLwN\u001c\t\u0003CUK!A\u0016\u0012\u0003\t1{gn\u001a\u0005\u00061\"\u0001\r!W\u0001\u0003iB\u0004\"AW.\u000e\u0003AJ!\u0001\u0018\u0019\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0001bm\u001c:fC\u000eD\u0007+\u0019:uSRLwN\u001c\u000b\u0003?\n\u0004\"!\t1\n\u0005\u0005\u0014#\u0001B+oSRDQaY\u0005A\u0002\u0011\f1AZ;o!\u0015\tS-W4`\u0013\t1'EA\u0005Gk:\u001cG/[8oeA\u0011\u0001n\u001b\b\u0003{%L!A\u001b \u0002\u0019\u0019+Go\u00195SKF,Xm\u001d;\n\u00051l'!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0002k}\t\t\u0002+\u0019:uSRLwN\\%uKJ\fGo\u001c:\u0014\u0007)\u0001\b\u0010\u0005\u0002rm6\t!O\u0003\u0002ti\u0006!A.\u00198h\u0015\u0005)\u0018\u0001\u00026bm\u0006L!a\u001e:\u0003\r=\u0013'.Z2u!\tIHP\u0004\u0002(u&\u00111PG\u0001\r\r\u0016$8\r[*fgNLwN\\\u0005\u0003{z\u0014QBU#T!~k\u0015\tU0J)\u0016\u0013&BA>\u001b\u0003\u0011IG/\u001a:\u0016\u0003a\fQ!\u001b;fe\u0002\nQ%\u001e9eCR,g)\u001a;dQ\u000e{g\u000e^3yi\u0006sGMU3n_Z,WK\\:fY\u0016\u001cG/\u001a3\u0016\u0005\u0005%\u0001cA\u0011\u0002\f%\u0019\u0011Q\u0002\u0012\u0003\u000f\t{w\u000e\\3b]\u00061S\u000f\u001d3bi\u00164U\r^2i\u0007>tG/\u001a=u\u0003:$'+Z7pm\u0016,fn]3mK\u000e$X\r\u001a\u0011\u0015\r\u0005M\u0011qCA\r!\r\t)BC\u0007\u0002\u0001!)qp\u0004a\u0001q\"9\u0011QA\bA\u0002\u0005%\u0011a\u00038fqR,E.Z7f]R,\"!a\b\u0011\u000f\u0005\u0005\u0012\u0011G-\u000289!\u00111EA\u0016\u001d\u0011\t)#a\n\u000e\u0003QL1!!\u000bu\u0003\u0011)H/\u001b7\n\t\u00055\u0012qF\u0001\u0004\u001b\u0006\u0004(bAA\u0015i&!\u00111GA\u001b\u0005\u0015)e\u000e\u001e:z\u0015\u0011\ti#a\f\u0011\t\u0005e\u0012Q\t\b\u0005\u0003w\t\t%\u0004\u0002\u0002>)\u0019\u0011q\b\u0019\u0002\u000f5,7o]1hK&!\u00111IA\u001f\u0003E1U\r^2i%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0004Y\u0006\u001d#\u0002BA\"\u0003{\tqB\\3yi\u0016cW-\\3oi~#S-\u001d\u000b\u0004?\u00065\u0003\"CA(#\u0005\u0005\t\u0019AA\u0010\u0003\rAH%M\u0001\r]\u0016DH/\u00127f[\u0016tG\u000fI\u0001\bQ\u0006\u001ch*\u001a=u)\t\tI!\u0001\u0003oKb$HCAA\u0010\u0003\u0019\u0011X-\\8wKR\u0011\u0011q\f\t\u0004C\u0005\u0005\u0014bAA2E\t9aj\u001c;iS:<\u0017aD4fiJ+7\u000f]8og\u0016\u001c\u0016N_3\u0015\r\u0005%\u0014qNA=!\r\t\u00131N\u0005\u0004\u0003[\u0012#aA%oi\"9\u0011\u0011\u000f\fA\u0002\u0005M\u0014aB;qI\u0006$Xm\u001d\t\u0004s\u0006U\u0014bAA<}\nA!+R*Q?6\u000b\u0005\u000bC\u0004\u0002|Y\u0001\r!! \u0002\u0013Y,'o]5p]&#\u0007cA\u0011\u0002\u0000%\u0019\u0011\u0011\u0011\u0012\u0003\u000bMCwN\u001d;\u0002;U\u0004H-\u0019;f\u0003:$w)\u001a8fe\u0006$XMU3ta>t7/\u001a#bi\u0006$B!a\"\u0002\u000eB\u0019Q(!#\n\u0007\u0005-eHA\u0007GKR\u001c\u0007NU3ta>t7/\u001a\u0005\b\u0003c:\u0002\u0019AA:\u0003Q9W\r\u001e+ie>$H\u000f\\3e%\u0016\u001c\bo\u001c8tKR!\u0011qQAJ\u0011\u001d\t)\n\u0007a\u0001\u0003S\na\u0002\u001e5s_R$H.\u001a+j[\u0016l5\u000f")
public class IncrementalFetchContext
implements FetchContext {
    private final Time time;
    private final FetchMetadata reqMetadata;
    private final FetchSession kafka$server$IncrementalFetchContext$$session;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchMetadata reqMetadata() {
        return this.reqMetadata;
    }

    public FetchSession kafka$server$IncrementalFetchContext$$session() {
        return this.kafka$server$IncrementalFetchContext$$session;
    }

    @Override
    public Option<Object> getFetchOffset(TopicPartition tp) {
        return this.kafka$server$IncrementalFetchContext$$session().getFetchOffset(tp);
    }

    @Override
    public void foreachPartition(Function2<TopicPartition, FetchRequest.PartitionData, BoxedUnit> fun) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            this.kafka$server$IncrementalFetchContext$$session().partitionMap().forEach(part -> fun.apply((Object)new TopicPartition(part.topic(), part.partition()), (Object)part.reqData()));
            return;
        }
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> updates, short versionId) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            int n = this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch ? FetchResponse.sizeOf((short)versionId, new LinkedHashMap().entrySet().iterator()) : FetchResponse.sizeOf((short)versionId, (Iterator)new PartitionIterator(this, updates.entrySet().iterator(), false));
            return n;
        }
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicPartition, FetchResponseData.PartitionData> updates) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                PartitionIterator partitionIter = new PartitionIterator(this, updates.entrySet().iterator(), true);
                while (partitionIter.hasNext()) {
                    partitionIter.next();
                }
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(53).append("Incremental fetch context with session id ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)0, (int)this.kafka$server$IncrementalFetchContext$$session().id(), updates);
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        FetchSession fetchSession = this.kafka$server$IncrementalFetchContext$$session();
        synchronized (fetchSession) {
            FetchResponse fetchResponse;
            int expectedEpoch = FetchMetadata.nextEpoch((int)this.reqMetadata().epoch());
            if (this.kafka$server$IncrementalFetchContext$$session().epoch() != expectedEpoch) {
                this.info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(82).append("Incremental fetch session ").append(this.kafka$server$IncrementalFetchContext$$session().id()).append(" expected epoch ").append(expectedEpoch).append(", but ").append("got ").append(this.kafka$server$IncrementalFetchContext$$session().epoch()).append(".  Possible duplicate request.").toString());
                fetchResponse = FetchResponse.of((Errors)Errors.INVALID_FETCH_SESSION_EPOCH, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            } else {
                fetchResponse = FetchResponse.of((Errors)Errors.NONE, (int)throttleTimeMs, (int)this.kafka$server$IncrementalFetchContext$$session().id(), new LinkedHashMap());
            }
            FetchResponse fetchResponse2 = fetchResponse;
            return fetchResponse2;
        }
    }

    public IncrementalFetchContext(Time time, FetchMetadata reqMetadata, FetchSession session) {
        this.time = time;
        this.reqMetadata = reqMetadata;
        this.kafka$server$IncrementalFetchContext$$session = session;
        Logging.$init$(this);
        FetchContext.$init$(this);
    }

    private class PartitionIterator
    implements Iterator<Map.Entry<TopicPartition, FetchResponseData.PartitionData>> {
        private final Iterator<Map.Entry<TopicPartition, FetchResponseData.PartitionData>> iter;
        private final boolean updateFetchContextAndRemoveUnselected;
        private Map.Entry<TopicPartition, FetchResponseData.PartitionData> nextElement;
        public final /* synthetic */ IncrementalFetchContext $outer;

        @Override
        public void forEachRemaining(Consumer<? super Map.Entry<TopicPartition, FetchResponseData.PartitionData>> x$1) {
            Iterator.super.forEachRemaining(x$1);
        }

        public Iterator<Map.Entry<TopicPartition, FetchResponseData.PartitionData>> iter() {
            return this.iter;
        }

        public boolean updateFetchContextAndRemoveUnselected() {
            return this.updateFetchContextAndRemoveUnselected;
        }

        public Map.Entry<TopicPartition, FetchResponseData.PartitionData> nextElement() {
            return this.nextElement;
        }

        public void nextElement_$eq(Map.Entry<TopicPartition, FetchResponseData.PartitionData> x$1) {
            this.nextElement = x$1;
        }

        @Override
        public boolean hasNext() {
            while (this.nextElement() == null && this.iter().hasNext()) {
                Map.Entry<TopicPartition, FetchResponseData.PartitionData> element = this.iter().next();
                TopicPartition topicPart = element.getKey();
                FetchResponseData.PartitionData respData = element.getValue();
                CachedPartition cachedPart = (CachedPartition)this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().find((ImplicitLinkedHashCollection.Element)new CachedPartition(topicPart));
                if (cachedPart.maybeUpdateResponseData(respData, this.updateFetchContextAndRemoveUnselected())) {
                    this.nextElement_$eq(element);
                    if (!this.updateFetchContextAndRemoveUnselected() || FetchResponse.recordsSize((FetchResponseData.PartitionData)respData) <= 0) continue;
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().remove((Object)cachedPart);
                    this.kafka$server$IncrementalFetchContext$PartitionIterator$$$outer().kafka$server$IncrementalFetchContext$$session().partitionMap().mustAdd((ImplicitLinkedHashCollection.Element)cachedPart);
                    continue;
                }
                if (!this.updateFetchContextAndRemoveUnselected()) continue;
                this.iter().remove();
            }
            return this.nextElement() != null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<TopicPartition, FetchResponseData.PartitionData> next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            Map.Entry<TopicPartition, FetchResponseData.PartitionData> element = this.nextElement();
            this.nextElement_$eq(null);
            return var1_1;
        }

        public Nothing$ remove() {
            throw new UnsupportedOperationException();
        }

        public /* synthetic */ IncrementalFetchContext kafka$server$IncrementalFetchContext$PartitionIterator$$$outer() {
            return this.$outer;
        }

        public PartitionIterator(IncrementalFetchContext $outer, Iterator<Map.Entry<TopicPartition, FetchResponseData.PartitionData>> iter, boolean updateFetchContextAndRemoveUnselected) {
            this.iter = iter;
            this.updateFetchContextAndRemoveUnselected = updateFetchContextAndRemoveUnselected;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.nextElement = null;
        }
    }
}

