/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import com.typesafe.scalalogging.Logger;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.tools.TerseFailure;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import net.sourceforge.argparse4j.ArgumentParsers;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.ArgumentParser;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import net.sourceforge.argparse4j.inf.Subparsers;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.utils.Utils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;

public final class ClusterTool$
implements Logging {
    public static ClusterTool$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new ClusterTool$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        try {
            ArgumentParser parser2 = ArgumentParsers.newArgumentParser((String)"kafka-cluster").defaultHelp(true).description("The Kafka cluster tool.");
            Subparsers subparsers = parser2.addSubparsers().dest("command");
            Subparser clusterIdParser = subparsers.addParser("cluster-id").help("Get information about the ID of a cluster.");
            Subparser unregisterParser = subparsers.addParser("unregister").help("Unregister a broker.");
            new .colon.colon((Object)clusterIdParser, (List)new .colon.colon((Object)unregisterParser, (List)Nil$.MODULE$)).foreach((Function1 & Serializable & scala.Serializable)parser -> {
                parser.addArgument(new String[]{"--bootstrap-server", "-b"}).action((ArgumentAction)Arguments.store()).help("A list of host/port pairs to use for establishing the connection to the kafka cluster.");
                return parser.addArgument(new String[]{"--config", "-c"}).action((ArgumentAction)Arguments.store()).help("A property file containing configs to passed to AdminClient.");
            });
            unregisterParser.addArgument(new String[]{"--id", "-i"}).type(Integer.class).action((ArgumentAction)Arguments.store()).help("The ID of the broker to unregister.");
            Namespace namespace = parser2.parseArgsOrFail(args);
            String command = namespace.getString("command");
            String configPath = namespace.getString("config");
            Properties properties = configPath == null ? new Properties() : Utils.loadProps((String)configPath);
            Option$.MODULE$.apply((Object)namespace.getString("bootstrap_server")).foreach((Function1 & Serializable & scala.Serializable)b -> properties.setProperty("bootstrap.servers", (String)b));
            if (properties.getProperty("bootstrap.servers") == null) {
                throw new TerseFailure("Please specify --bootstrap-server.");
            }
            if ("cluster-id".equals(command)) {
                try (Admin adminClient = Admin.create((Properties)properties);){
                    this.clusterIdCommand(System.out, adminClient);
                }
                throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
            }
            if ("unregister".equals(command)) {
                try (Admin adminClient = Admin.create((Properties)properties);){
                    this.unregisterCommand(System.out, adminClient, Predef$.MODULE$.Integer2int(namespace.getInt("id")));
                }
                throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
            }
            throw new RuntimeException(new StringBuilder(16).append("Unknown command ").append(command).toString());
        }
        catch (TerseFailure e) {
            System.err.println(e.getMessage());
            System.exit(1);
            return;
        }
    }

    public void clusterIdCommand(PrintStream stream, Admin adminClient) {
        Option clusterId = Option$.MODULE$.apply(adminClient.describeCluster().clusterId().get());
        if (None$.MODULE$.equals(clusterId)) {
            stream.println("No cluster ID found. The Kafka version is probably too old.");
            return;
        }
        if (clusterId instanceof Some) {
            String id = (String)((Some)clusterId).value();
            stream.println(new StringBuilder(12).append("Cluster ID: ").append(id).toString());
            return;
        }
        throw new MatchError((Object)clusterId);
    }

    public void unregisterCommand(PrintStream stream, Admin adminClient, int id) {
        try {
            Option$.MODULE$.apply(adminClient.unregisterBroker(id).all().get());
            stream.println(new StringBuilder(32).append("Broker ").append(id).append(" is no longer registered.").toString());
            return;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof UnsupportedVersionException) {
                stream.println("The target cluster does not support the broker unregistration API.");
                return;
            }
            throw e;
        }
    }

    private ClusterTool$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

