/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.admin.AdminOperationException;
import kafka.admin.TopicCommand;
import kafka.admin.TopicCommand$TopicService$;
import kafka.common.AdminCommandFailedException;
import kafka.log.LogConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.IncludeList;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.PartitionReassignment;
import org.apache.kafka.common.TopicPartitionInfo;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.collection.GenSeq;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TopicCommand$
implements Logging {
    public static TopicCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TopicCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        opts.checkArgs();
        TopicCommand.TopicService topicService = TopicCommand$TopicService$.MODULE$.apply(opts.commandConfig(), opts.bootstrapServer());
        int exitCode = 0;
        try {
            try {
                if (opts.hasCreateOption()) {
                    topicService.createTopic(opts);
                } else if (opts.hasAlterOption()) {
                    topicService.alterTopic(opts);
                } else if (opts.hasListOption()) {
                    topicService.listTopics(opts);
                } else if (opts.hasDescribeOption()) {
                    topicService.describeTopic(opts);
                } else if (opts.hasDeleteOption()) {
                    topicService.deleteTopic(opts);
                }
            }
            catch (ExecutionException e) {
                if (e.getCause() != null) {
                    this.printException(e.getCause());
                } else {
                    this.printException(e);
                }
                exitCode = 1;
            }
            catch (Throwable e) {
                this.printException(e);
                exitCode = 1;
            }
        }
        catch (Throwable throwable) {
            topicService.close();
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
        topicService.close();
        throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
    }

    private void printException(Throwable e) {
        Predef$.MODULE$.println((Object)new StringBuilder(38).append("Error while executing topic command : ").append(e.getMessage()).toString());
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error(this.msgWithLogIdent(TopicCommand$.$anonfun$printException$1(e)));
            return;
        }
    }

    public void kafka$admin$TopicCommand$$ensureTopicExists(Seq<String> foundTopics, Option<String> requestedTopic, boolean requireTopicExists) {
        if (requestedTopic.isDefined() && requireTopicExists && foundTopics.isEmpty()) {
            throw new IllegalArgumentException(new StringBuilder(35).append("Topic '").append(requestedTopic.get()).append("' does not exist as expected").toString());
        }
    }

    public Seq<String> kafka$admin$TopicCommand$$doGetTopics(Seq<String> allTopics, Option<String> topicIncludeList, boolean excludeInternalTopics) {
        if (topicIncludeList.isDefined()) {
            IncludeList topicsFilter = new IncludeList((String)topicIncludeList.get());
            return (Seq)allTopics.filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)topicsFilter.isTopicAllowed(x$11, excludeInternalTopics)));
        }
        return (Seq)allTopics.filterNot((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$doGetTopics$2(excludeInternalTopics, x$12)));
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        Buffer configsToBeAdded = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)opts.topicConfig().getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyList())).asScala()).map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.split("\\s*=\\s*"), Buffer$.MODULE$.canBuildFrom());
        Predef$.MODULE$.require(configsToBeAdded.forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$parseTopicConfigsToBeAdded$3(config))), (Function0 & Serializable & scala.Serializable)() -> "Invalid topic config: all configs to be added must be in the format \"key=val\".");
        Properties props = new Properties();
        configsToBeAdded.foreach((Function1 & Serializable & scala.Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].trim()));
        LogConfig$.MODULE$.validate(props);
        if (props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) {
            Predef$.MODULE$.println((Object)new StringBuilder(298).append("WARNING: The configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append("=").append(props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).append(" is specified. ").append("This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker or ").append("if the inter.broker.protocol.version is 3.0 or newer. This configuration is deprecated and it will be removed in Apache Kafka 4.0.").toString());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        void var2_2;
        Buffer configsToBeDeleted = (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter((java.util.List)opts.configsToDelete().getOrElse((Function0 & Serializable & scala.Serializable)() -> Collections.emptyList())).asScala()).map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.trim(), Buffer$.MODULE$.canBuildFrom());
        Properties propsToBeDeleted = new Properties();
        configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$15 -> propsToBeDeleted.setProperty((String)x$15, ""));
        LogConfig$.MODULE$.validateNames(propsToBeDeleted);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        void var3_3;
        String[] partitionList = replicaAssignmentList.split(",");
        LinkedHashMap ret = new LinkedHashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionList)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int[] brokerList = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionList[i].split(":"))).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)TopicCommand$.$anonfun$parseReplicaAssignment$2(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Iterable duplicateBrokers = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerList));
            if (duplicateBrokers.nonEmpty()) {
                throw new AdminCommandFailedException(new StringBuilder(59).append("Partition replica lists may not contain duplicate entries: ").append(duplicateBrokers.mkString(",")).toString());
            }
            ret.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).toList());
            if (((SeqLike)ret.apply((Object)BoxesRunTime.boxToInteger((int)i))).size() != ((SeqLike)ret.apply((Object)BoxesRunTime.boxToInteger((int)0))).size()) {
                throw new AdminOperationException(new StringBuilder(45).append("Partition ").append(i).append(" has different replication factor: ").append(brokerList).toString());
            }
        });
        return var3_3;
    }

    public java.util.Map<Integer, java.util.List<Integer>> asJavaReplicaReassignment(Map<Object, List<Object>> original) {
        return (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)original.map((Function1 & Serializable & scala.Serializable)f -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f._1$mcI$sp()), CollectionConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)f._2()).map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.unboxToInt((Object)e), List$.MODULE$.canBuildFrom())).asJava()), Map$.MODULE$.canBuildFrom())).asJava();
    }

    public int kafka$admin$TopicCommand$$getReplicationFactor(TopicPartitionInfo tpi, Option<PartitionReassignment> reassignment) {
        PartitionReassignment ra;
        int n = reassignment instanceof Some && TopicCommand$.isReassignmentInProgress$1(ra = (PartitionReassignment)((Some)reassignment).value(), tpi) ? ((SeqLike)((SeqLike)CollectionConverters$.MODULE$.asScalaBufferConverter(ra.replicas()).asScala()).diff((GenSeq)CollectionConverters$.MODULE$.asScalaBufferConverter(ra.addingReplicas()).asScala())).size() : tpi.replicas().size();
        return n;
    }

    public static final /* synthetic */ String $anonfun$printException$1(Throwable e$1) {
        return Utils.stackTrace((Throwable)e$1);
    }

    public static final /* synthetic */ boolean $anonfun$doGetTopics$2(boolean excludeInternalTopics$1, String x$12) {
        return Topic.isInternal((String)x$12) && excludeInternalTopics$1;
    }

    public static final /* synthetic */ boolean $anonfun$parseTopicConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ int $anonfun$parseReplicaAssignment$2(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s.trim())).toInt();
    }

    private static final boolean isReassignmentInProgress$1(PartitionReassignment ra, TopicPartitionInfo tpi$1) {
        Set allReplicaIds = ((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(tpi$1.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.id()), Buffer$.MODULE$.canBuildFrom())).toSet();
        Set changingReplicaIds = (Set)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(ra.removingReplicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17), Buffer$.MODULE$.canBuildFrom())).toSet().$plus$plus((GenTraversableOnce)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(ra.addingReplicas()).asScala()).map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18), Buffer$.MODULE$.canBuildFrom())).toSet());
        return allReplicaIds.exists((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)elem -> changingReplicaIds.contains((Object)BoxesRunTime.boxToInteger((int)elem)));
    }

    private TopicCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

