/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import java.util.Collection;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.utils.CommandLineUtils$;
import kafka.utils.Exit$;
import kafka.utils.IncludeList;
import kafka.utils.ToolsUtils$;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndTimestamp;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.serialization.ByteArrayDeserializer;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.utils.Utils;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class GetOffsetShell$ {
    public static GetOffsetShell$ MODULE$;
    private final Pattern TopicPartitionPattern;

    static {
        new GetOffsetShell$();
    }

    private Pattern TopicPartitionPattern() {
        return this.TopicPartitionPattern;
    }

    public void main(String[] args) {
        try {
            this.fetchOffsets(args);
            return;
        }
        catch (Exception e) {
            Predef$.MODULE$.println((Object)new StringBuilder(16).append("Error occurred: ").append(e.getMessage()).toString());
            throw Exit$.MODULE$.exit(1, (Option<String>)new Some((Object)e.getMessage()));
        }
    }

    private void fetchOffsets(String[] args) {
        Function1<PartitionInfo, Object> function1;
        OptionParser parser = new OptionParser(false);
        ArgumentAcceptingOptionSpec brokerListOpt = parser.accepts("broker-list", "DEPRECATED, use --bootstrap-server instead; ignored if --bootstrap-server is specified. The server(s) to connect to in the form HOST1:PORT1,HOST2:PORT2.").withRequiredArg().describedAs("HOST1:PORT1,...,HOST3:PORT3").ofType(String.class);
        ArgumentAcceptingOptionSpec bootstrapServerOpt = parser.accepts("bootstrap-server", "REQUIRED. The server(s) to connect to in the form HOST1:PORT1,HOST2:PORT2.").requiredUnless("broker-list", new String[0]).withRequiredArg().describedAs("HOST1:PORT1,...,HOST3:PORT3").ofType(String.class);
        ArgumentAcceptingOptionSpec topicPartitionsOpt = parser.accepts("topic-partitions", new StringBuilder(496).append("Comma separated list of topic-partition patterns to get the offsets for, with the format of '").append(this.TopicPartitionPattern()).append("'.").append(" The first group is an optional regex for the topic name, if omitted, it matches any topic name.").append(" The section after ':' describes a 'partition' pattern, which can be: a number, a range in the format of 'NUMBER-NUMBER' (lower inclusive, upper exclusive), an inclusive lower bound in the format of 'NUMBER-', an exclusive upper bound in the format of '-NUMBER' or may be omitted to accept all partitions.").toString()).withRequiredArg().describedAs("topic1:1,topic2:0-3,topic3,topic4:5-,topic5:-3").ofType(String.class);
        ArgumentAcceptingOptionSpec topicOpt = parser.accepts("topic", "The topic to get the offsets for. It also accepts a regular expression. If not present, all authorized topics are queried. Cannot be used if --topic-partitions is present.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec partitionsOpt = parser.accepts("partitions", "Comma separated list of partition ids to get the offsets for. If not present, all partitions of the authorized topics are queried. Cannot be used if --topic-partitions is present.").withRequiredArg().describedAs("partition ids").ofType(String.class);
        ArgumentAcceptingOptionSpec timeOpt = parser.accepts("time", "timestamp of the offsets before that. [Note: No offset is returned, if the timestamp greater than recently committed record timestamp is given.]").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo((Object)Predef$.MODULE$.long2Long(-1L), (Object[])new Long[0]);
        ArgumentAcceptingOptionSpec commandConfigOpt = parser.accepts("command-config", "Property file containing configs to be passed to Consumer Client.").withRequiredArg().describedAs("config file").ofType(String.class);
        OptionSpecBuilder excludeInternalTopicsOpt = parser.accepts("exclude-internal-topics", "By default, internal topics are included. If specified, internal topics are excluded.");
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting topic-partition offsets.");
        }
        OptionSet options = parser.parse(args);
        ArgumentAcceptingOptionSpec effectiveBrokerListOpt = options.has((OptionSpec)bootstrapServerOpt) ? bootstrapServerOpt : brokerListOpt;
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{effectiveBrokerListOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = (String)options.valueOf((OptionSpec)effectiveBrokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        boolean excludeInternalTopics = options.has((OptionSpec)excludeInternalTopicsOpt);
        if (options.has((OptionSpec)topicPartitionsOpt) && (options.has((OptionSpec)topicOpt) || options.has((OptionSpec)partitionsOpt))) {
            throw new IllegalArgumentException("--topic-partitions cannot be used with --topic or --partitions");
        }
        long listOffsetsTimestamp = (Long)options.valueOf((OptionSpec)timeOpt);
        if (options.has((OptionSpec)topicPartitionsOpt)) {
            function1 = this.createTopicPartitionFilterWithPatternList((String)options.valueOf((OptionSpec)topicPartitionsOpt), excludeInternalTopics);
        } else {
            Set<Object> partitionIdsRequested = this.createPartitionSet((String)options.valueOf((OptionSpec)partitionsOpt));
            function1 = this.createTopicPartitionFilterWithTopicAndPartitionPattern((Option<String>)(options.has((OptionSpec)topicOpt) ? new Some(options.valueOf((OptionSpec)topicOpt)) : None$.MODULE$), excludeInternalTopics, partitionIdsRequested);
        }
        Function1<PartitionInfo, Object> topicPartitionFilter = function1;
        Properties config = options.has((OptionSpec)commandConfigOpt) ? Utils.loadProps((String)((String)options.valueOf((OptionSpec)commandConfigOpt))) : new Properties();
        config.setProperty("bootstrap.servers", brokerList);
        config.setProperty("client.id", clientId);
        try (KafkaConsumer consumer = new KafkaConsumer(config, (Deserializer)new ByteArrayDeserializer(), (Deserializer)new ByteArrayDeserializer());){
            Map map;
            Seq<PartitionInfo> partitionInfos = this.listPartitionInfos(consumer, topicPartitionFilter);
            if (partitionInfos.isEmpty()) {
                throw new IllegalArgumentException("Could not match any topic-partitions with the specified filters");
            }
            Seq topicPartitions = (Seq)partitionInfos.flatMap((Function1 & Serializable & scala.Serializable)p -> {
                if (p.leader() == null) {
                    System.err.println(new StringBuilder(69).append("Error: topic-partition ").append(p.topic()).append(":").append(p.partition()).append(" does not have a leader. Skip getting offsets").toString());
                    return Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                }
                return Option$.MODULE$.option2Iterable((Option)new Some((Object)new TopicPartition(p.topic(), p.partition())));
            }, Seq$.MODULE$.canBuildFrom());
            if (-2L == listOffsetsTimestamp) {
                map = (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.beginningOffsets((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
            } else if (-1L == listOffsetsTimestamp) {
                map = (Map)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.endOffsets((Collection)CollectionConverters$.MODULE$.seqAsJavaListConverter(topicPartitions).asJava())).asScala();
            } else {
                java.util.Map timestampsToSearch = (java.util.Map)CollectionConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableOnce)topicPartitions.map((Function1 & Serializable & scala.Serializable)tp -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(tp), (Object)Predef$.MODULE$.long2Long(listOffsetsTimestamp)), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms())).asJava();
                map = (Map)((TraversableLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.offsetsForTimes(timestampsToSearch)).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    if (x0$1 == null) {
                        throw new MatchError(null);
                    }
                    TopicPartition k = (TopicPartition)x0$1._1();
                    OffsetAndTimestamp x = (OffsetAndTimestamp)x0$1._2();
                    Tuple2 tuple2 = x == null ? new Tuple2((Object)k, null) : new Tuple2((Object)k, (Object)Predef$.MODULE$.long2Long(x.offset()));
                    return tuple2;
                }, Map$.MODULE$.canBuildFrom());
            }
            ((IterableLike)map.toSeq().sortWith((Function2 & Serializable & scala.Serializable)(tp1, tp2) -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.MODULE$.compareTopicPartitions((TopicPartition)tp1._1(), (TopicPartition)tp2._1())))).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                GetOffsetShell$.$anonfun$fetchOffsets$5(x0$2);
                return BoxedUnit.UNIT;
            });
        }
    }

    public boolean compareTopicPartitions(TopicPartition a, TopicPartition b) {
        return Ordering.Implicits$.MODULE$.infixOrderingOps((Object)new Tuple2((Object)a.topic(), (Object)BoxesRunTime.boxToInteger((int)a.partition())), Ordering$.MODULE$.Tuple2((Ordering)Ordering.String$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).$less((Object)new Tuple2((Object)b.topic(), (Object)BoxesRunTime.boxToInteger((int)b.partition())));
    }

    public Function1<PartitionInfo, Object> createTopicPartitionFilterWithPatternList(String topicPartitions, boolean excludeInternalTopics) {
        String[] ruleSpecs = topicPartitions.split(",");
        return arg_0 -> GetOffsetShell$.$anonfun$createTopicPartitionFilterWithPatternList$2$adapted((Function1[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ruleSpecs)).map((Function1 & Serializable & scala.Serializable)ruleSpec -> MODULE$.parseRuleSpec((String)ruleSpec, excludeInternalTopics), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Function1.class))), arg_0);
    }

    public Function1<PartitionInfo, Object> parseRuleSpec(String ruleSpec, boolean excludeInternalTopics) {
        JFunction1.mcZI.sp & Serializable & scala.Serializable intersect;
        Matcher matcher = this.TopicPartitionPattern().matcher(ruleSpec);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid rule specification: ").append(ruleSpec).toString());
        }
        IncludeList topicFilter = new IncludeList((String)GetOffsetShell$.group$1(1, matcher).getOrElse((Function0 & Serializable & scala.Serializable)() -> ".*"));
        Option option = GetOffsetShell$.group$1(2, matcher).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$parseRuleSpec$3(x$1)));
        if (option instanceof Some) {
            intersect = arg_0 -> GetOffsetShell$.$anonfun$parseRuleSpec$4(BoxesRunTime.unboxToInt((Object)((Some)option).value()), arg_0);
        } else if (None$.MODULE$.equals(option)) {
            int lowerRange = BoxesRunTime.unboxToInt((Object)GetOffsetShell$.group$1(3, matcher).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$parseRuleSpec$5(x$2))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
            int upperRange = BoxesRunTime.unboxToInt((Object)GetOffsetShell$.group$1(4, matcher).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$parseRuleSpec$7(x$3))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> Integer.MAX_VALUE));
            intersect = (JFunction1.mcZI.sp & Serializable & scala.Serializable)p -> p >= lowerRange && p < upperRange;
        } else {
            throw new MatchError((Object)option);
        }
        return arg_0 -> GetOffsetShell$.$anonfun$parseRuleSpec$10$adapted(topicFilter, excludeInternalTopics, (Function1)intersect, arg_0);
    }

    public Function1<PartitionInfo, Object> createTopicPartitionFilterWithTopicAndPartitionPattern(Option<String> topicOpt, boolean excludeInternalTopics, Set<Object> partitionIds) {
        return arg_0 -> GetOffsetShell$.$anonfun$createTopicPartitionFilterWithTopicAndPartitionPattern$2$adapted(new IncludeList((String)topicOpt.getOrElse((Function0 & Serializable & scala.Serializable)() -> ".*")), excludeInternalTopics, partitionIds, arg_0);
    }

    public Set<Object> createPartitionSet(String partitionsString) {
        if (partitionsString == null || partitionsString.isEmpty()) {
            return Predef$.MODULE$.Set().empty();
        }
        return new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionsString.split(","))).map((Function1 & Serializable & scala.Serializable)partitionString -> BoxesRunTime.boxToInteger((int)GetOffsetShell$.$anonfun$createPartitionSet$1(partitionsString, partitionString)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).toSet();
    }

    private Seq<PartitionInfo> listPartitionInfos(KafkaConsumer<?, ?> consumer, Function1<PartitionInfo, Object> topicPartitionFilter) {
        return ((TraversableOnce)((MapLike)CollectionConverters$.MODULE$.mapAsScalaMapConverter(consumer.listTopics()).asScala()).values().flatMap((Function1 & Serializable & scala.Serializable)partitions -> (Buffer)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(partitions).asScala()).filter(topicPartitionFilter), Iterable$.MODULE$.canBuildFrom())).toBuffer();
    }

    public static final /* synthetic */ void $anonfun$fetchOffsets$5(Tuple2 x0$2) {
        if (x0$2 != null) {
            TopicPartition tp = (TopicPartition)x0$2._1();
            Long offset = (Long)x0$2._2();
            Predef$.MODULE$.println((Object)new StringBuilder(2).append(tp.topic()).append(":").append(tp.partition()).append(":").append(Option$.MODULE$.apply((Object)offset).getOrElse((Function0 & Serializable & scala.Serializable)() -> "")).toString());
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$createTopicPartitionFilterWithPatternList$3(PartitionInfo tp$1, Function1 rule) {
        return BoxesRunTime.unboxToBoolean((Object)rule.apply((Object)tp$1));
    }

    public static final /* synthetic */ boolean $anonfun$createTopicPartitionFilterWithPatternList$2(Function1[] rules$1, PartitionInfo tp) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rules$1)).exists((Function1 & Serializable & scala.Serializable)rule -> BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean((Object)rule.apply((Object)tp))));
    }

    public static final /* synthetic */ boolean $anonfun$parseRuleSpec$1(String s) {
        return s != null && new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty();
    }

    private static final Option group$1(int group, Matcher matcher$1) {
        return Option$.MODULE$.apply((Object)matcher$1.group(group)).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.$anonfun$parseRuleSpec$1(s)));
    }

    public static final /* synthetic */ int $anonfun$parseRuleSpec$3(String x$1) {
        return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$parseRuleSpec$4(int partition$1, int p) {
        return p == partition$1;
    }

    public static final /* synthetic */ int $anonfun$parseRuleSpec$5(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
    }

    public static final /* synthetic */ int $anonfun$parseRuleSpec$7(String x$3) {
        return new StringOps(Predef$.MODULE$.augmentString(x$3)).toInt();
    }

    public static final /* synthetic */ boolean $anonfun$parseRuleSpec$10(IncludeList topicFilter$1, boolean excludeInternalTopics$2, Function1 partitionFilter$1, PartitionInfo tp) {
        return topicFilter$1.isTopicAllowed(tp.topic(), excludeInternalTopics$2) && partitionFilter$1.apply$mcZI$sp(tp.partition());
    }

    public static final /* synthetic */ boolean $anonfun$createTopicPartitionFilterWithTopicAndPartitionPattern$2(IncludeList topicsFilter$1, boolean excludeInternalTopics$3, Set partitionIds$1, PartitionInfo t) {
        return topicsFilter$1.isTopicAllowed(t.topic(), excludeInternalTopics$3) && (partitionIds$1.isEmpty() || partitionIds$1.contains((Object)BoxesRunTime.boxToInteger((int)t.partition())));
    }

    public static final /* synthetic */ int $anonfun$createPartitionSet$1(String partitionsString$1, String partitionString) {
        try {
            return new StringOps(Predef$.MODULE$.augmentString(partitionString)).toInt();
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException(new StringBuilder(84).append("--partitions expects a comma separated list of numeric ").append("partition ids, but received: ").append(partitionsString$1).toString());
        }
    }

    private GetOffsetShell$() {
        MODULE$ = this;
        this.TopicPartitionPattern = Pattern.compile("([^:,]*)(?::(?:([0-9]*)|(?:([0-9]*)-([0-9]*))))?");
    }

    public static final /* synthetic */ Object $anonfun$createTopicPartitionFilterWithPatternList$2$adapted(Function1[] rules$1, PartitionInfo tp) {
        return BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.$anonfun$createTopicPartitionFilterWithPatternList$2(rules$1, tp));
    }

    public static final /* synthetic */ Object $anonfun$parseRuleSpec$10$adapted(IncludeList topicFilter$1, boolean excludeInternalTopics$2, Function1 partitionFilter$1, PartitionInfo tp) {
        return BoxesRunTime.boxToBoolean((topicFilter$1.isTopicAllowed(tp.topic(), excludeInternalTopics$2) && partitionFilter$1.apply$mcZI$sp(tp.partition()) ? 1 : 0) != 0);
    }

    public static final /* synthetic */ Object $anonfun$createTopicPartitionFilterWithTopicAndPartitionPattern$2$adapted(IncludeList topicsFilter$1, boolean excludeInternalTopics$3, Set partitionIds$1, PartitionInfo t) {
        return BoxesRunTime.boxToBoolean((boolean)GetOffsetShell$.$anonfun$createTopicPartitionFilterWithTopicAndPartitionPattern$2(topicsFilter$1, excludeInternalTopics$3, partitionIds$1, t));
    }
}

