/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import org.apache.kafka.common.errors.GroupIdNotFoundException;
import org.apache.kafka.common.errors.GroupNotEmptyException;
import org.apache.kafka.common.protocol.Errors;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import scala.;
import scala.$less$colon$less$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001B\u0007\u000f\u0001MAQ\u0001\u0007\u0001\u0005\u0002eAQa\u0007\u0001\u0005\u0002qAQ!\u0014\u0001\u0005\u00029CQa\u0015\u0001\u0005\u0002QCQ!\u0017\u0001\u0005\u0002iCQa\u0018\u0001\u0005\u0002\u0001DQ!\u001a\u0001\u0005\u0002\u0019DQa\u001b\u0001\u0005\u00021DQ!\u001d\u0001\u0005\u0002IDQa\u001e\u0001\u0005\u0002aDQ! \u0001\u0005\u0002yDq!a\u0002\u0001\t\u0003\tIA\u0001\rEK2,G/Z\"p]N,X.\u001a:He>,\bo\u001d+fgRT!a\u0004\t\u0002\u000b\u0005$W.\u001b8\u000b\u0003E\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001)A\u0011QCF\u0007\u0002\u001d%\u0011qC\u0004\u0002\u0019\u0007>t7/^7fe\u001e\u0013x.\u001e9D_6l\u0017M\u001c3UKN$\u0018A\u0002\u001fj]&$h\bF\u0001\u001b!\t)\u0002!A\ruKN$H)\u001a7fi\u0016<\u0016\u000e\u001e5U_BL7m\u00149uS>tGCA\u000f$!\tq\u0012%D\u0001 \u0015\u0005\u0001\u0013!B:dC2\f\u0017B\u0001\u0012 \u0005\u0011)f.\u001b;\t\u000b\u0011\u0012\u0001\u0019A\u0013\u0002\rE,xN];n!\t1SF\u0004\u0002(WA\u0011\u0001fH\u0007\u0002S)\u0011!FE\u0001\u0007yI|w\u000e\u001e \n\u00051z\u0012A\u0002)sK\u0012,g-\u0003\u0002/_\t11\u000b\u001e:j]\u001eT!\u0001L\u0010)\t\t\tTH\u0010\t\u0003emj\u0011a\r\u0006\u0003iU\na\u0001]1sC6\u001c(B\u0001\u001c8\u0003\u001dQW\u000f]5uKJT!\u0001O\u001d\u0002\u000b),h.\u001b;\u000b\u0003i\n1a\u001c:h\u0013\ta4GA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgR\fAA\\1nK\u0006\nq(\u0001\u0012|I&\u001c\b\u000f\\1z\u001d\u0006lW- \u0018|CJ<W/\\3oiN<\u0016\u000e\u001e5OC6,7/ \u0015\u0005\u0005\u0005;\u0005\n\u0005\u0002C\u000b6\t1I\u0003\u0002Eg\u0005A\u0001O]8wS\u0012,'/\u0003\u0002G\u0007\nYa+\u00197vKN{WO]2f\u0003\u001d\u0019HO]5oONd#!S&\"\u0003)\u000b!A_6\"\u00031\u000bQa\u001b:bMR\fQ\u0004^3ti\u0012+G.\u001a;f\u00076$gj\u001c8Fq&\u001cH/\u001b8h\u000fJ|W\u000f\u001d\u000b\u0003;=CQ\u0001J\u0002A\u0002\u0015BCaA\u0019>}!\"1!Q$SY\tI5*\u0001\u000euKN$H)\u001a7fi\u0016tuN\\#ySN$\u0018N\\4He>,\b\u000f\u0006\u0002\u001e+\")A\u0005\u0002a\u0001K!\"A!M\u001f?Q\u0011!\u0011i\u0012--\u0005%[\u0015A\u0007;fgR$U\r\\3uK\u000ekGMT8o\u000b6\u0004H/_$s_V\u0004HCA\u000f\\\u0011\u0015!S\u00011\u0001&Q\u0011)\u0011'\u0010 )\t\u0015\tuI\u0018\u0017\u0003\u0013.\u000bq\u0003^3ti\u0012+G.\u001a;f\u001d>tW)\u001c9us\u001e\u0013x.\u001e9\u0015\u0005u\t\u0007\"\u0002\u0013\u0007\u0001\u0004)\u0003\u0006\u0002\u00042{yBCAB!HI2\u0012\u0011jS\u0001\u0018i\u0016\u001cH\u000fR3mKR,7)\u001c3F[B$\u0018p\u0012:pkB$\"!H4\t\u000b\u0011:\u0001\u0019A\u0013)\t\u001d\tTH\u0010\u0015\u0005\u000f\u0005;%\u000e\f\u0002J\u0017\u00061B/Z:u\t\u0016dW\r^3D[\u0012\fE\u000e\\$s_V\u00048\u000f\u0006\u0002\u001e[\")A\u0005\u0003a\u0001K!\"\u0001\"M\u001f?Q\u0011A\u0011i\u00129-\u0005%[\u0015\u0001\u0006;fgR$U\r\\3uK\u0016k\u0007\u000f^=He>,\b\u000f\u0006\u0002\u001eg\")A%\u0003a\u0001K!\"\u0011\"M\u001f?Q\u0011I\u0011i\u0012<-\u0005%[\u0015!\n;fgR$U\r\\3uK\u000ekGmV5uQ6K\u0007p\u00144Tk\u000e\u001cWm]:B]\u0012,%O]8s)\ti\u0012\u0010C\u0003%\u0015\u0001\u0007Q\u0005\u000b\u0003\u000bcur\u0004\u0006\u0002\u0006B\u000frd#!S&\u0002EQ,7\u000f\u001e#fY\u0016$XmV5uQ6K\u0007p\u00144Tk\u000e\u001cWm]:B]\u0012,%O]8s)\tir\u0010C\u0003%\u0017\u0001\u0007Q\u0005\u000b\u0003\fcur\u0004&B\u0006B\u000f\u0006\u0015AFA%L\u0003-\"Xm\u001d;EK2,G/Z,ji\",fN]3d_\u001et\u0017N_3e\u001d\u0016<8i\u001c8tk6,'o\u00149uS>tGcA\u000f\u0002\f!)A\u0005\u0004a\u0001K!\"A\"M\u001f?Q\u0015a\u0011iRA\tY\tI5\n")
public class DeleteConsumerGroupsTest
extends ConsumerGroupCommandTest {
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWithTopicOption(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group(), "--topic"};
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteCmdNonExistingGroup(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        String missingGroup = "missing.group";
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", missingGroup};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var6_5 = null;
        Object var7_6 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0, (String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString());
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteNonExistingGroup(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        String missingGroup = "missing.group";
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", missingGroup};
        Map result = this.getConsumerGroupService(cgcArgs).deleteGroups();
        Assertions.assertTrue((result.size() == 1 && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getCause() instanceof GroupIdNotFoundException ? 1 : 0) != 0, (String)new StringBuilder(68).append("The expected error (").append(Errors.GROUP_ID_NOT_FOUND).append(") was not detected while deleting consumer group").toString());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteCmdNonEmptyGroup(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdNonEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var11_7 = null;
        Object var12_8 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((output.contains(new StringBuilder(37).append("Group '").append(this.group()).append("' could not be deleted due to:").toString()) && output.contains(Errors.NON_EMPTY_GROUP.message()) ? 1 : 0) != 0, (String)new StringBuilder(84).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Output was: (").append(output).append(")").toString());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteNonEmptyGroup(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteNonEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        Map result = service.deleteGroups();
        Assertions.assertNotNull((Object)result.apply((Object)this.group()), (String)new StringBuilder(73).append("Group was deleted successfully, but it shouldn't have been. Result was:(").append(result).append(")").toString());
        Assertions.assertTrue((result.size() == 1 && result.keySet().contains((Object)this.group()) && ((Throwable)result.apply((Object)this.group())).getCause() instanceof GroupNotEmptyException ? 1 : 0) != 0, (String)new StringBuilder(83).append("The expected error (").append(Errors.NON_EMPTY_GROUP).append(") was not detected while deleting consumer group. Result was:(").append(result).append(")").toString());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteCmdEmptyGroup(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdEmptyGroup$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var17_11 = null;
        Object var18_12 = null;
        Assertions.assertTrue((boolean)grabConsoleOutput_out.toString().contains(new StringBuilder(58).append("Deletion of requested consumer groups ('").append(this.group()).append("') was successful.").toString()), (String)"The consumer group could not be deleted as expected");
    }

    /*
     * Unable to fully structure code
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteCmdAllGroups(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        groups = RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 3).map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$1$adapted(kafka.admin.DeleteConsumerGroupsTest java.lang.Object ), (Ljava/lang/Object;)Lscala/Tuple2;)((DeleteConsumerGroupsTest)this)).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--all-groups"};
        service = this.getConsumerGroupService(cgcArgs);
        var10_5 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$2(service, groups)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        groups.values().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$5$adapted(kafka.admin.ConsumerGroupCommandTest$ConsumerGroupExecutor ), (Lkafka/admin/ConsumerGroupCommandTest$ConsumerGroupExecutor;)Ljava/lang/Object;)());
        var16_8 = 100L;
        waitUntilTrue_waitTimeMs = 15000L;
        waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$6(groups, service)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()V, $anonfun$testDeleteCmdAllGroups$9(kafka.admin.ConsumerGroupCommand$ConsumerGroupService ), ()V)((ConsumerGroupCommand.ConsumerGroupService)service);
        grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        var20_11 = null;
        var21_12 = null;
        output = grabConsoleOutput_out.toString().trim();
        expectedGroupsForDeletion = groups.keySet();
        deletedGroupsGrepped = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(output.substring(output.indexOf(40) + 1, output.indexOf(41))), ',')), (Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$testDeleteCmdAllGroups$10(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)(), ClassTag$.MODULE$.apply(String.class))).toSet();
        if (!output.matches("Deletion of requested consumer groups (.*) was successful.")) ** GOTO lbl-1000
        v0 = deletedGroupsGrepped;
        if (!(v0 != null ? v0.equals(expectedGroupsForDeletion) == false : expectedGroupsForDeletion != null)) {
            v1 = true;
        } else lbl-1000:
        // 2 sources

        {
            v1 = false;
        }
        Assertions.assertTrue((boolean)v1, (String)"The consumer group(s) could not be deleted as expected");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteEmptyGroup(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        String[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService(cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteEmptyGroup$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Map result = service.deleteGroups();
        Assertions.assertTrue((result.size() == 1 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null ? 1 : 0) != 0, (String)"The consumer group could not be deleted as expected");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteCmdWithMixOfSuccessAndError(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        Object[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService((String[])cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteCmdWithMixOfSuccessAndError$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        ConsumerGroupCommand.ConsumerGroupService service2 = this.getConsumerGroupService((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(cgcArgs), (Object)new String[]{"--group", missingGroup}, ClassTag$.MODULE$.apply(String.class)));
        JFunction0.mcV.sp & Serializable grabConsoleOutput_f = (JFunction0.mcV.sp & Serializable)() -> service2.deleteGroups();
        ByteArrayOutputStream grabConsoleOutput_out = new ByteArrayOutputStream();
        try {
            Console$.MODULE$.withOut((OutputStream)grabConsoleOutput_out, (Function0)grabConsoleOutput_f);
        }
        finally {
            Console$.MODULE$.out().flush();
        }
        Object var20_13 = null;
        Object var21_14 = null;
        String output = grabConsoleOutput_out.toString();
        Assertions.assertTrue((output.contains(new StringBuilder(37).append("Group '").append(missingGroup).append("' could not be deleted due to:").toString()) && output.contains(Errors.GROUP_ID_NOT_FOUND.message()) && output.contains(new StringBuilder(51).append("These consumer groups were deleted successfully: '").append(this.group()).append("'").toString()) ? 1 : 0) != 0, (String)"The consumer group deletion did not work as expected");
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWithMixOfSuccessAndError(String quorum) {
        this.createOffsetsTopic(this.createOffsetsTopic$default$1(), this.createOffsetsTopic$default$2());
        String missingGroup = "missing.group";
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.addConsumerGroupExecutor$default$2(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5(), this.addConsumerGroupExecutor$default$6());
        Object[] cgcArgs = new String[]{"--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        ConsumerGroupCommand.ConsumerGroupService service = this.getConsumerGroupService((String[])cgcArgs);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$1(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The group did not initialize as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        executor.shutdown();
        long l2 = 100L;
        long waitUntilTrue_waitTimeMs2 = 15000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!DeleteConsumerGroupsTest.$anonfun$testDeleteWithMixOfSuccessAndError$3(this, service)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs2) {
                Assertions.fail((String)"The group did not become empty as expected.");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs2), (long)waitUntilTrue_pause));
        }
        Map result = this.getConsumerGroupService((String[])ArrayOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.refArrayOps(cgcArgs), (Object)new String[]{"--group", missingGroup}, ClassTag$.MODULE$.apply(String.class))).deleteGroups();
        Assertions.assertTrue((result.size() == 2 && result.keySet().contains((Object)this.group()) && result.apply((Object)this.group()) == null && result.keySet().contains((Object)missingGroup) && ((Throwable)result.apply((Object)missingGroup)).getMessage().contains(Errors.GROUP_ID_NOT_FOUND.message()) ? 1 : 0) != 0, (String)"The consumer group deletion did not work as expected");
    }

    @ParameterizedTest(name="{displayName}.{argumentsWithNames}")
    @ValueSource(strings={"zk", "kraft"})
    public void testDeleteWithUnrecognizedNewConsumerOption(String quorum) {
        String[] cgcArgs = new String[]{"--new-consumer", "--bootstrap-server", this.bootstrapServers(this.bootstrapServers$default$1()), "--delete", "--group", this.group()};
        Assertions.assertThrows(OptionException.class, () -> this.getConsumerGroupService(cgcArgs));
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdNonEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$2) {
        return ((SeqOps)((Option)service$2.collectGroupMembers($this.group(), false)._2()).get()).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdNonEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteNonEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$3) {
        return ((SeqOps)((Option)service$3.collectGroupMembers($this.group(), false)._2()).get()).size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testDeleteNonEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$4) {
        if (service$4.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$4.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdEmptyGroup$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$4) {
        String string = service$4.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdEmptyGroup$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1(DeleteConsumerGroupsTest $this, int i) {
        String group = new StringBuilder(0).append($this.group()).append(i).toString();
        String x$3 = $this.addConsumerGroupExecutor$default$2();
        String x$4 = $this.addConsumerGroupExecutor$default$4();
        Option<Properties> x$5 = $this.addConsumerGroupExecutor$default$5();
        boolean x$6 = $this.addConsumerGroupExecutor$default$6();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, x$3, group, x$4, x$5, x$6);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)group), (Object)executor);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$3(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Stable";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$2(ConsumerGroupCommand.ConsumerGroupService service$5, scala.collection.immutable.Map groups$1) {
        Set set = service$5.listConsumerGroups().toSet();
        Set set2 = groups$1.keySet();
        return !(set != null ? !set.equals(set2) : set2 != null) && groups$1.keySet().forall((Function1 & Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$3(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$4() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$7(ConsumerGroupCommand.ConsumerGroupService service$5, String groupId) {
        String string = service$5.collectGroupState(groupId).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdAllGroups$6(scala.collection.immutable.Map groups$1, ConsumerGroupCommand.ConsumerGroupService service$5) {
        return groups$1.keySet().forall((Function1 & Serializable)groupId -> BoxesRunTime.boxToBoolean((boolean)DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$7(service$5, groupId)));
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$8() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ void $anonfun$testDeleteCmdAllGroups$9(ConsumerGroupCommand.ConsumerGroupService service$5) {
        service$5.deleteGroups();
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdAllGroups$10(String x$1) {
        return x$1.replaceAll("'", "").trim();
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteEmptyGroup$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$6) {
        if (service$6.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$6.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteEmptyGroup$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteEmptyGroup$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$6) {
        String string = service$6.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteEmptyGroup$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdWithMixOfSuccessAndError$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$7) {
        if (service$7.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$7.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdWithMixOfSuccessAndError$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteCmdWithMixOfSuccessAndError$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$7) {
        String string = service$7.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteCmdWithMixOfSuccessAndError$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteWithMixOfSuccessAndError$1(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$8) {
        if (service$8.listConsumerGroups().contains((Object)$this.group())) {
            String string = service$8.collectGroupState($this.group()).state();
            String string2 = "Stable";
            if (string != null && string.equals(string2)) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ String $anonfun$testDeleteWithMixOfSuccessAndError$2() {
        return "The group did not initialize as expected.";
    }

    public static final /* synthetic */ boolean $anonfun$testDeleteWithMixOfSuccessAndError$3(DeleteConsumerGroupsTest $this, ConsumerGroupCommand.ConsumerGroupService service$8) {
        String string = service$8.collectGroupState($this.group()).state();
        String string2 = "Empty";
        return string != null && string.equals(string2);
    }

    public static final /* synthetic */ String $anonfun$testDeleteWithMixOfSuccessAndError$4() {
        return "The group did not become empty as expected.";
    }

    public static final /* synthetic */ Tuple2 $anonfun$testDeleteCmdAllGroups$1$adapted(DeleteConsumerGroupsTest $this, Object i) {
        return DeleteConsumerGroupsTest.$anonfun$testDeleteCmdAllGroups$1($this, BoxesRunTime.unboxToInt((Object)i));
    }

    public static final /* synthetic */ Object $anonfun$testDeleteCmdAllGroups$5$adapted(ConsumerGroupCommandTest.ConsumerGroupExecutor executor) {
        executor.shutdown();
        return BoxedUnit.UNIT;
    }
}

