/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import kafka.api.AbstractConsumerTest;
import kafka.api.BaseConsumerTest$;
import kafka.server.KafkaBroker;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\re!\u0002\f\u0018\u0003\u0003a\u0002\"B\u0011\u0001\t\u0003\u0011\u0003\"\u0002\u0013\u0001\t\u0003)\u0003\"\u0002,\u0001\t\u00039\u0006\"B/\u0001\t\u0003qv!\u00023\u0018\u0011\u0003)g!\u0002\f\u0018\u0011\u00031\u0007\"B\u0011\u0007\t\u0003Q\u0007\"B+\u0007\t\u0003Y\u0007\"B=\u0007\t\u0003Y\u0007b\u0002>\u0007\u0005\u0004%\ta\u001f\u0005\b\u0003\u00131\u0001\u0015!\u0003}\u0011!\tYA\u0002b\u0001\n\u0003Y\bbBA\u0007\r\u0001\u0006I\u0001 \u0004\u0007\u0003\u001f1\u0001!!\u0005\t\r\u0005rA\u0011AA%\u0011\u001d\tyE\u0004C!\u0003#Bq!!\u0018\u000f\t\u0003\nyF\u0002\u0004\u0002j\u0019\u0001\u00111\u000e\u0005\u0007CI!\t!a\u001d\t\u000f\u0005=#\u0003\"\u0011\u0002x!9\u00111\u0010\n\u0005B\u0005u$\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u\u0015\tA\u0012$A\u0002ba&T\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001Q\u0004\u0005\u0002\u001f?5\tq#\u0003\u0002!/\t!\u0012IY:ue\u0006\u001cGoQ8ogVlWM\u001d+fgR\fa\u0001P5oSRtD#A\u0012\u0011\u0005y\u0001\u0011!\u0006;fgR\u001c\u0016.\u001c9mK\u000e{gn];naRLwN\u001c\u000b\u0004M1J\u0004CA\u0014+\u001b\u0005A#\"A\u0015\u0002\u000bM\u001c\u0017\r\\1\n\u0005-B#\u0001B+oSRDQ!\f\u0002A\u00029\na!];peVl\u0007CA\u00187\u001d\t\u0001D\u0007\u0005\u00022Q5\t!G\u0003\u000247\u00051AH]8pizJ!!\u000e\u0015\u0002\rA\u0013X\rZ3g\u0013\t9\u0004H\u0001\u0004TiJLgn\u001a\u0006\u0003k!BQA\u000f\u0002A\u00029\nQb\u001a:pkB\u0004&o\u001c;pG>d\u0007\u0006\u0002\u0002=\u0011&\u0003\"!\u0010$\u000e\u0003yR!a\u0010!\u0002\rA\f'/Y7t\u0015\t\t%)A\u0004kkBLG/\u001a:\u000b\u0005\r#\u0015!\u00026v]&$(\"A#\u0002\u0007=\u0014x-\u0003\u0002H}\t\t\u0002+\u0019:b[\u0016$XM]5{K\u0012$Vm\u001d;\u0002\t9\fW.Z\u0011\u0002\u0015\u0006Q3\u0010Z5ta2\f\u0017PT1nKvt\u0013/^8sk6l4\u0010M?/OJ|W\u000f\u001d)s_R|7m\u001c7>wFj\b\u0006\u0002\u0002M%N\u0003\"!\u0014)\u000e\u00039S!a\u0014 \u0002\u0011A\u0014xN^5eKJL!!\u0015(\u0003\u00195+G\u000f[8e'>,(oY3\u0002\u000bY\fG.^3-\u0003Q\u000b\u0013!V\u0001+O\u0016$H+Z:u#V|'/^7B]\u0012<%o\\;q!J|Go\\2pYB\u000b'/Y7fi\u0016\u00148/\u00117m\u0003m!Xm\u001d;DYV\u001cH/\u001a:SKN|WO]2f\u0019&\u001cH/\u001a8feR\u0019a\u0005W-\t\u000b5\u001a\u0001\u0019\u0001\u0018\t\u000bi\u001a\u0001\u0019\u0001\u0018)\t\ra\u0004*\u0013\u0015\u0005\u00071\u0013F\fL\u0001U\u0003]!Xm\u001d;D_>\u0014H-\u001b8bi>\u0014h)Y5m_Z,'\u000fF\u0002'?\u0002DQ!\f\u0003A\u00029BQA\u000f\u0003A\u00029BC\u0001\u0002\u001fI\u0013\"\"A\u0001\u0014*dY\u0005!\u0016\u0001\u0005\"bg\u0016\u001cuN\\:v[\u0016\u0014H+Z:u!\tqba\u0005\u0002\u0007OB\u0011q\u0005[\u0005\u0003S\"\u0012a!\u00118z%\u00164G#A3\u0015\u00031\u00042!\u001c;w\u001b\u0005q'BA8q\u0003\u0019\u0019HO]3b[*\u0011\u0011O]\u0001\u0005kRLGNC\u0001t\u0003\u0011Q\u0017M^1\n\u0005Ut'AB*ue\u0016\fW\u000e\u0005\u0002No&\u0011\u0001P\u0014\u0002\n\u0003J<W/\\3oiN\fqhZ3u)\u0016\u001cH/U;peVl\u0017I\u001c3He>,\b\u000f\u0015:pi>\u001cw\u000e\u001c)be\u0006lW\r^3sg\u000ec\u0017m]:jG\u001e\u0013x.\u001e9Qe>$xnY8m\u001f:d\u00170A\nva\u0012\fG/\u001a)s_\u0012,8-\u001a:D_VtG/F\u0001}!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\r\u0005$x.\\5d\u0015\r\t\u0019\u0001]\u0001\u000bG>t7-\u001e:sK:$\u0018bAA\u0004}\ni\u0011\t^8nS\u000eLe\u000e^3hKJ\fA#\u001e9eCR,\u0007K]8ek\u000e,'oQ8v]R\u0004\u0013aE;qI\u0006$XmQ8ogVlWM]\"pk:$\u0018\u0001F;qI\u0006$XmQ8ogVlWM]\"pk:$\bEA\u0013UKN$8\t\\;ti\u0016\u0014(+Z:pkJ\u001cW\rT5ti\u0016tWM]*fe&\fG.\u001b>feN9a\"a\u0005\u0002 \u0005\u0005\u0003\u0003BA\u000b\u00037i!!a\u0006\u000b\u0007\u0005e!/\u0001\u0003mC:<\u0017\u0002BA\u000f\u0003/\u0011aa\u00142kK\u000e$\bCBA\u0011\u0003c\t)$\u0004\u0002\u0002$)!\u0011QEA\u0014\u00035\u0019XM]5bY&T\u0018\r^5p]*!\u0011\u0011FA\u0016\u0003\u0019\u0019w.\\7p]*\u0019!$!\f\u000b\u0007\u0005=B)\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003g\t\u0019C\u0001\u0006TKJL\u0017\r\\5{KJ\u0004RaJA\u001c\u0003wI1!!\u000f)\u0005\u0015\t%O]1z!\r9\u0013QH\u0005\u0004\u0003\u007fA#\u0001\u0002\"zi\u0016\u0004B!a\u0011\u0002F5\u0011\u0011qE\u0005\u0005\u0003\u000f\n9CA\fDYV\u001cH/\u001a:SKN|WO]2f\u0019&\u001cH/\u001a8feR\u0011\u00111\n\t\u0004\u0003\u001brQ\"\u0001\u0004\u0002\u0011=tW\u000b\u001d3bi\u0016$2AJA*\u0011\u001d\t)\u0006\u0005a\u0001\u0003/\nqb\u00197vgR,'OU3t_V\u00148-\u001a\t\u0005\u0003\u0007\nI&\u0003\u0003\u0002\\\u0005\u001d\"aD\"mkN$XM\u001d*fg>,(oY3\u0002\u0013M,'/[1mSj,GCBA\u001b\u0003C\n)\u0007\u0003\u0004\u0002dE\u0001\rAL\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0003O\n\u0002\u0019AA\u001b\u0003\u0011!\u0017\r^1\u0003OQ+7\u000f^\"mkN$XM\u001d*fg>,(oY3MSN$XM\\3s\t\u0016\u001cXM]5bY&TXM]\n\b%\u0005M\u0011QNA!!\u0019\t\t#a\u001c\u00026%!\u0011\u0011OA\u0012\u00051!Um]3sS\u0006d\u0017N_3s)\t\t)\bE\u0002\u0002NI!2AJA=\u0011\u001d\t)\u0006\u0006a\u0001\u0003/\n1\u0002Z3tKJL\u0017\r\\5{KR1\u0011QGA@\u0003\u0003Ca!a\u0019\u0016\u0001\u0004q\u0003bBA4+\u0001\u0007\u0011Q\u0007")
public abstract class BaseConsumerTest
extends AbstractConsumerTest {
    public static AtomicInteger updateConsumerCount() {
        return BaseConsumerTest$.MODULE$.updateConsumerCount();
    }

    public static AtomicInteger updateProducerCount() {
        return BaseConsumerTest$.MODULE$.updateProducerCount();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersClassicGroupProtocolOnly();
    }

    public static Stream<Arguments> getTestQuorumAndGroupProtocolParametersAll() {
        return BaseConsumerTest$.MODULE$.getTestQuorumAndGroupProtocolParametersAll();
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testSimpleConsumption(String quorum, String groupProtocol) {
        int numRecords = 10000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        Assertions.assertEquals((int)0, (int)consumer.assignment().size());
        consumer.assign((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp(), (List)Nil$.MODULE$)).asJava());
        Assertions.assertEquals((int)1, (int)consumer.assignment().size());
        consumer.seek(this.tp(), 0L);
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        this.sendAndAwaitAsyncCommit(consumer, this.sendAndAwaitAsyncCommit$default$2());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testClusterResourceListener(String quorum, String groupProtocol) {
        int numRecords = 100;
        Properties producerProps = new Properties();
        producerProps.put("key.serializer", TestClusterResourceListenerSerializer.class);
        producerProps.put("value.serializer", TestClusterResourceListenerSerializer.class);
        KafkaProducer producer = this.createProducer(null, null, producerProps);
        long startingTimestamp = System.currentTimeMillis();
        this.sendRecords(producer, numRecords, this.tp(), startingTimestamp);
        Properties consumerProps = new Properties();
        consumerProps.put("key.deserializer", TestClusterResourceListenerDeserializer.class);
        consumerProps.put("value.deserializer", TestClusterResourceListenerDeserializer.class);
        Consumer consumer = this.createConsumer(null, null, consumerProps, this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.tp().topic(), (List)Nil$.MODULE$)).asJava());
        int x$5 = this.consumeAndVerifyRecords$default$4();
        TimestampType x$6 = this.consumeAndVerifyRecords$default$6();
        TopicPartition x$7 = this.consumeAndVerifyRecords$default$7();
        int x$8 = this.consumeAndVerifyRecords$default$8();
        this.consumeAndVerifyRecords(consumer, numRecords, 0, x$5, startingTimestamp, x$6, x$7, x$8);
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateProducerCount().get());
        Assertions.assertNotEquals((int)0, (int)BaseConsumerTest$.MODULE$.updateConsumerCount().get());
    }

    @ParameterizedTest(name="{displayName}.quorum={0}.groupProtocol={1}")
    @MethodSource(value={"getTestQuorumAndGroupProtocolParametersAll"})
    public void testCoordinatorFailover(String quorum, String groupProtocol) {
        AbstractConsumerTest.TestConsumerReassignmentListener listener = new AbstractConsumerTest.TestConsumerReassignmentListener(this);
        this.consumerConfig().setProperty("session.timeout.ms", "5001");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("max.poll.interval.ms", "15000");
        Consumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe((Collection)CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)this.topic(), (List)Nil$.MODULE$)).asJava(), (ConsumerRebalanceListener)listener);
        this.awaitRebalance(consumer, listener);
        Assertions.assertEquals((int)1, (int)listener.callsToAssigned());
        Buffer parts = null;
        while (parts == null) {
            parts = CollectionConverters$.MODULE$.ListHasAsScala(consumer.partitionsFor("__consumer_offsets")).asScala();
        }
        Assertions.assertEquals((int)1, (int)parts.size());
        Assertions.assertNotNull((Object)((PartitionInfo)parts.head()).leader());
        int coordinator = ((PartitionInfo)parts.head()).leader().id();
        ((KafkaBroker)this.brokers().apply(coordinator)).shutdown();
        this.ensureNoRebalance(consumer, listener);
    }

    public static class TestClusterResourceListenerDeserializer
    implements Deserializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public Object deserialize(String x$1, Headers x$2, byte[] x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public Object deserialize(String x$1, Headers x$2, ByteBuffer x$3) {
            return super.deserialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateConsumerCount().incrementAndGet();
        }

        public byte[] deserialize(String topic, byte[] data) {
            return data;
        }
    }

    public static class TestClusterResourceListenerSerializer
    implements Serializer<byte[]>,
    ClusterResourceListener {
        public void configure(Map<String, ?> x$1, boolean x$2) {
            super.configure(x$1, x$2);
        }

        public byte[] serialize(String x$1, Headers x$2, Object x$3) {
            return super.serialize(x$1, x$2, x$3);
        }

        public void close() {
            super.close();
        }

        public void onUpdate(ClusterResource clusterResource) {
            BaseConsumerTest$.MODULE$.updateProducerCount().incrementAndGet();
        }

        public byte[] serialize(String topic, byte[] data) {
            return data;
        }
    }
}

