/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.io.Serializable;
import java.nio.channels.ClosedChannelException;
import java.util.Collections;
import java.util.Properties;
import java.util.regex.Pattern;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LocalLogTest;
import kafka.log.LocalLogTest$KeyValue$;
import kafka.log.LogTestUtils$;
import kafka.log.LogTruncation;
import kafka.log.SegmentDeletionReason;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.FetchDataInfo;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogFileUtils;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0011\rc\u0001B5k\u0001=DQA\u001e\u0001\u0005\u0002]D\u0011B\u001f\u0001A\u0002\u0003\u0007I\u0011A>\t\u0017\u0005\u0015\u0001\u00011AA\u0002\u0013\u0005\u0011q\u0001\u0005\u000b\u0003'\u0001\u0001\u0019!A!B\u0013a\b\"CA\u000b\u0001\t\u0007I\u0011AA\f\u0011!\tI\u0003\u0001Q\u0001\n\u0005e\u0001\"CA\u0016\u0001\t\u0007I\u0011AA\f\u0011!\ti\u0003\u0001Q\u0001\n\u0005e\u0001\"CA\u0018\u0001\t\u0007I\u0011AA\u0019\u0011!\tI\u0005\u0001Q\u0001\n\u0005M\u0002\"CA&\u0001\t\u0007I\u0011AA'\u0011!\t\t\u0007\u0001Q\u0001\n\u0005=\u0003\"CA2\u0001\t\u0007I\u0011AA3\u0011!\t)\b\u0001Q\u0001\n\u0005\u001d\u0004\u0002C6\u0001\u0005\u0004%\t!a\u001e\t\u0011\u0005}\u0004\u0001)A\u0005\u0003sBq!!!\u0001\t\u0003\t\u0019\tC\u0004\u0002\u001c\u0002!\t!a!\u0007\r\u0005\u0015\u0006\u0001QAT\u0011)\t9m\u0005BK\u0002\u0013\u0005\u0011\u0011\u001a\u0005\u000b\u00037\u001c\"\u0011#Q\u0001\n\u0005-\u0007BCAo'\tU\r\u0011\"\u0001\u0002J\"Q\u0011q\\\n\u0003\u0012\u0003\u0006I!a3\t\rY\u001cB\u0011AAq\u0011\u001d\tYo\u0005C\u0001\u0003[D\u0011Ba\u0003\u0014#\u0003%\tA!\u0004\t\u0013\t\r2#!A\u0005\u0002\t\u0015\u0002\"\u0003B\u0016'E\u0005I\u0011\u0001B\u0017\u0011%\u0011\tdEI\u0001\n\u0003\u0011i\u0003C\u0005\u00034M\t\t\u0011\"\u0011\u00036!I!\u0011I\n\u0002\u0002\u0013\u0005!1\t\u0005\n\u0005\u0017\u001a\u0012\u0011!C\u0001\u0005\u001bB\u0011Ba\u0016\u0014\u0003\u0003%\tE!\u0017\t\u0013\t\u001d4#!A\u0005\u0002\t%\u0004\"\u0003B:'\u0005\u0005I\u0011\tB;\u0011%\u0011IhEA\u0001\n\u0003\u0012Y\bC\u0005\u0003~M\t\t\u0011\"\u0011\u0003\u0000!I!\u0011Q\n\u0002\u0002\u0013\u0005#1Q\u0004\b\u0005\u000f\u0003\u0001\u0012\u0001BE\r\u001d\t)\u000b\u0001E\u0001\u0005\u0017CaA\u001e\u0015\u0005\u0002\tE\u0005b\u0002BJQ\u0011\u0005!Q\u0013\u0005\n\u0005?C\u0013\u0011!CA\u0005CC\u0011Ba*)\u0003\u0003%\tI!+\t\u000f\tm\u0006\u0001\"\u0003\u0003>\"9!1\u001a\u0001\u0005\n\t5\u0007b\u0002Bk\u0001\u0011%!q\u001b\u0005\n\u0005C\u0004\u0011\u0013!C\u0005\u0005GD\u0011Ba:\u0001#\u0003%IA!\u0004\t\u000f\t%\b\u0001\"\u0003\u0003l\"I11\u0003\u0001\u0012\u0002\u0013%!1\u001d\u0005\n\u0007+\u0001\u0011\u0013!C\u0005\u0005\u001bA\u0011ba\u0006\u0001#\u0003%Ia!\u0007\t\u0013\ru\u0001!%A\u0005\n\r}\u0001\"CB\u0012\u0001E\u0005I\u0011BB\u0013\u0011%\u0019I\u0003AI\u0001\n\u0013\u0019y\u0002C\u0004\u0004,\u0001!\t!a!\t\u000f\rU\u0002\u0001\"\u0001\u0002\u0004\"91\u0011\b\u0001\u0005\u0002\u0005\r\u0005bBB\u001f\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007\u0003\u0002A\u0011AAB\u0011\u001d\u0019)\u0005\u0001C\u0001\u0003\u0007Cqa!\u0013\u0001\t\u0003\t\u0019\tC\u0004\u0004N\u0001!\t!a!\t\u000f\rE\u0003\u0001\"\u0001\u0002\u0004\"91Q\u000b\u0001\u0005\u0002\u0005\r\u0005bBB-\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007;\u0002A\u0011AAB\u0011\u001d\u0019\t\u0007\u0001C\u0001\u0003\u0007Cqa!\u001a\u0001\t\u0013\u00199\u0007C\u0004\u0004n\u0001!\t!a!\t\u000f\rE\u0004\u0001\"\u0001\u0002\u0004\"91Q\u000f\u0001\u0005\n\r]\u0004bBB>\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007\u007f\u0002A\u0011AAB\u0011\u001d\u0019\u0019\t\u0001C\u0001\u0003\u0007Cqaa\"\u0001\t\u0003\t\u0019\tC\u0004\u0004\f\u0002!\t!a!\t\u000f\r=\u0005\u0001\"\u0001\u0002\u0004\"911\u0013\u0001\u0005\n\rU\u0005bBBP\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007G\u0003A\u0011AAB\u0011\u001d\u00199\u000b\u0001C\u0001\u0003\u0007Cqaa+\u0001\t\u0003\t\u0019\tC\u0004\u00040\u0002!\t!a!\t\u000f\rM\u0006\u0001\"\u0001\u0002\u0004\"91q\u0017\u0001\u0005\u0002\u0005\r\u0005bBB^\u0001\u0011\u0005\u00111\u0011\u0005\b\u0007\u007f\u0003A\u0011AAB\u0011\u001d\u0019\u0019\r\u0001C\u0001\u0003\u0007Cqaa2\u0001\t\u0003\t\u0019\tC\u0004\u0004L\u0002!\t!a!\t\u000f\r=\u0007\u0001\"\u0001\u0002\u0004\"911\u001b\u0001\u0005\u0002\u0005\r\u0005bBBl\u0001\u0011\u0005\u00111\u0011\u0005\b\u00077\u0004A\u0011BBo\u0011%!Y\u0002AI\u0001\n\u0013!i\u0002C\u0005\u0005\"\u0001\t\n\u0011\"\u0003\u0005$!IAq\u0005\u0001\u0012\u0002\u0013%!Q\u0002\u0005\n\tS\u0001\u0011\u0013!C\u0005\u0007KA\u0011\u0002b\u000b\u0001#\u0003%I\u0001\"\f\t\u0013\u0011E\u0002!%A\u0005\n\u0011M\u0002\"\u0003C\u001c\u0001E\u0005I\u0011\u0002C\u001d\u0011%!i\u0004AI\u0001\n\u0013!yD\u0001\u0007M_\u000e\fG\u000eT8h)\u0016\u001cHO\u0003\u0002lY\u0006\u0019An\\4\u000b\u00035\fQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001aB\u0011\u0011\u000f^\u0007\u0002e*\t1/A\u0003tG\u0006d\u0017-\u0003\u0002ve\n1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001=\u0011\u0005e\u0004Q\"\u00016\u0002\r\r|gNZ5h+\u0005a\bcA?\u0002\u00025\taP\u0003\u0002\u0000Y\u000611/\u001a:wKJL1!a\u0001\u007f\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\u0015\r|gNZ5h?\u0012*\u0017\u000f\u0006\u0003\u0002\n\u0005=\u0001cA9\u0002\f%\u0019\u0011Q\u0002:\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003#\u0019\u0011\u0011!a\u0001y\u0006\u0019\u0001\u0010J\u0019\u0002\u000f\r|gNZ5hA\u00051A/\u001c9ESJ,\"!!\u0007\u0011\t\u0005m\u0011QE\u0007\u0003\u0003;QA!a\b\u0002\"\u0005\u0011\u0011n\u001c\u0006\u0003\u0003G\tAA[1wC&!\u0011qEA\u000f\u0005\u00111\u0015\u000e\\3\u0002\u000fQl\u0007\u000fR5sA\u00051An\\4ESJ\fq\u0001\\8h\t&\u0014\b%\u0001\bu_BL7\rU1si&$\u0018n\u001c8\u0016\u0005\u0005M\u0002\u0003BA\u001b\u0003\u000bj!!a\u000e\u000b\t\u0005e\u00121H\u0001\u0007G>lWn\u001c8\u000b\u00075\fiD\u0003\u0003\u0002@\u0005\u0005\u0013AB1qC\u000eDWM\u0003\u0002\u0002D\u0005\u0019qN]4\n\t\u0005\u001d\u0013q\u0007\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013\u0001\u00067pO\u0012K'OR1jYV\u0014Xm\u00115b]:,G.\u0006\u0002\u0002PA!\u0011\u0011KA/\u001b\t\t\u0019FC\u0002l\u0003+RA!a\u0016\u0002Z\u0005I\u0011N\u001c;fe:\fGn\u001d\u0006\u0005\u00037\nY$A\u0004ti>\u0014\u0018mZ3\n\t\u0005}\u00131\u000b\u0002\u0015\u0019><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0002+1|w\rR5s\r\u0006LG.\u001e:f\u0007\"\fgN\\3mA\u0005AQn\\2l)&lW-\u0006\u0002\u0002hA!\u0011\u0011NA9\u001b\t\tYG\u0003\u0003\u0002n\u0005=\u0014\u0001B;uS2T1a`A\u001e\u0013\u0011\t\u0019(a\u001b\u0003\u00115{7m\u001b+j[\u0016\f\u0011\"\\8dWRKW.\u001a\u0011\u0016\u0005\u0005e\u0004cA=\u0002|%\u0019\u0011Q\u00106\u0003\u00111{7-\u00197M_\u001e\fA\u0001\\8hA\u0005)1/\u001a;VaR\u0011\u0011\u0011\u0002\u0015\u0004#\u0005\u001d\u0005\u0003BAE\u0003/k!!a#\u000b\t\u00055\u0015qR\u0001\u0004CBL'\u0002BAI\u0003'\u000bqA[;qSR,'O\u0003\u0003\u0002\u0016\u0006\u0005\u0013!\u00026v]&$\u0018\u0002BAM\u0003\u0017\u0013!BQ3g_J,W)Y2i\u0003!!X-\u0019:E_^t\u0007f\u0001\n\u0002 B!\u0011\u0011RAQ\u0013\u0011\t\u0019+a#\u0003\u0013\u00053G/\u001a:FC\u000eD'\u0001C&fsZ\u000bG.^3\u0014\rM\u0001\u0018\u0011VAX!\r\t\u00181V\u0005\u0004\u0003[\u0013(a\u0002)s_\u0012,8\r\u001e\t\u0005\u0003c\u000b\tM\u0004\u0003\u00024\u0006uf\u0002BA[\u0003wk!!a.\u000b\u0007\u0005ef.\u0001\u0004=e>|GOP\u0005\u0002g&\u0019\u0011q\u0018:\u0002\u000fA\f7m[1hK&!\u00111YAc\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\tyL]\u0001\u0004W\u0016LXCAAf!\u0011\ti-!6\u000f\t\u0005=\u0017\u0011\u001b\t\u0004\u0003k\u0013\u0018bAAje\u00061\u0001K]3eK\u001aLA!a6\u0002Z\n11\u000b\u001e:j]\u001eT1!a5s\u0003\u0011YW-\u001f\u0011\u0002\u000bY\fG.^3\u0002\rY\fG.^3!)\u0019\t\u0019/a:\u0002jB\u0019\u0011Q]\n\u000e\u0003\u0001Aq!a2\u0019\u0001\u0004\tY\rC\u0004\u0002^b\u0001\r!a3\u0002\u0011Q|'+Z2pe\u0012$B!a<\u0002|B!\u0011\u0011_A|\u001b\t\t\u0019P\u0003\u0003\u0002v\u0006]\u0012A\u0002:fG>\u0014H-\u0003\u0003\u0002z\u0006M(\u0001D*j[BdWMU3d_J$\u0007\"CA\u007f3A%\t\u0019AA\u0000\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0003r\u0005\u0003\u0011)!C\u0002\u0003\u0004I\u0014\u0001\u0002\u00102z]\u0006lWM\u0010\t\u0004c\n\u001d\u0011b\u0001B\u0005e\n!Aj\u001c8h\u0003I!xNU3d_J$G\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\t=!\u0006\u0002B\u0003\u0005#Y#Aa\u0005\u0011\t\tU!qD\u0007\u0003\u0005/QAA!\u0007\u0003\u001c\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005;\u0011\u0018AC1o]>$\u0018\r^5p]&!!\u0011\u0005B\f\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0005G>\u0004\u0018\u0010\u0006\u0004\u0002d\n\u001d\"\u0011\u0006\u0005\n\u0003\u000f\\\u0002\u0013!a\u0001\u0003\u0017D\u0011\"!8\u001c!\u0003\u0005\r!a3\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!q\u0006\u0016\u0005\u0003\u0017\u0014\t\"\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u0004\u0005\u0003\u0003:\t}RB\u0001B\u001e\u0015\u0011\u0011i$!\t\u0002\t1\fgnZ\u0005\u0005\u0003/\u0014Y$\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0003FA\u0019\u0011Oa\u0012\n\u0007\t%#OA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003P\tU\u0003cA9\u0003R%\u0019!1\u000b:\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002\u0012\u0001\n\t\u00111\u0001\u0003F\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\\A1!Q\fB2\u0005\u001fj!Aa\u0018\u000b\u0007\t\u0005$/\u0001\u0006d_2dWm\u0019;j_:LAA!\u001a\u0003`\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011YG!\u001d\u0011\u0007E\u0014i'C\u0002\u0003pI\u0014qAQ8pY\u0016\fg\u000eC\u0005\u0002\u0012\t\n\t\u00111\u0001\u0003P\u0005\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\u00119Da\u001e\t\u0013\u0005E1%!AA\u0002\t\u0015\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\t\u0015\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t]\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003l\t\u0015\u0005\"CA\tM\u0005\u0005\t\u0019\u0001B(\u0003!YU-\u001f,bYV,\u0007cAAsQM!\u0001\u0006\u001dBG!\u0011\tYBa$\n\t\u0005\r\u0017Q\u0004\u000b\u0003\u0005\u0013\u000b!B\u001a:p[J+7m\u001c:e)\u0011\t\u0019Oa&\t\u000f\u0005U(\u00061\u0001\u0003\u001aB!\u0011\u0011\u001fBN\u0013\u0011\u0011i*a=\u0003\rI+7m\u001c:e\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\t\u0019Oa)\u0003&\"9\u0011qY\u0016A\u0002\u0005-\u0007bBAoW\u0001\u0007\u00111Z\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YKa.\u0011\u000bE\u0014iK!-\n\u0007\t=&O\u0001\u0004PaRLwN\u001c\t\bc\nM\u00161ZAf\u0013\r\u0011)L\u001d\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\teF&!AA\u0002\u0005\r\u0018a\u0001=%a\u0005a1N^:U_J+7m\u001c:egR!!q\u0018Bc!\u0019\t\tL!1\u0002p&!!1YAc\u0005!IE/\u001a:bE2,\u0007b\u0002Bd[\u0001\u0007!\u0011Z\u0001\nW\u0016Lh+\u00197vKN\u0004b!!-\u0003B\u0006\r\u0018\u0001\u0004:fG>\u0014Hm\u001d+p\u0017Z\u001cH\u0003\u0002Be\u0005\u001fDqA!5/\u0001\u0004\u0011\u0019.A\u0004sK\u000e|'\u000fZ:\u0011\r\u0005E&\u0011\u0019BM\u00035\t\u0007\u000f]3oIJ+7m\u001c:egRA\u0011\u0011\u0002Bm\u00057\u0014i\u000eC\u0004\u0003R>\u0002\rAa0\t\u0011-|\u0003\u0013!a\u0001\u0003sB\u0011Ba80!\u0003\u0005\rA!\u0002\u0002\u001b%t\u0017\u000e^5bY>3gm]3u\u0003]\t\u0007\u000f]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$#'\u0006\u0002\u0003f*\"\u0011\u0011\u0010B\t\u0003]\t\u0007\u000f]3oIJ+7m\u001c:eg\u0012\"WMZ1vYR$3'A\u0006sK\u0006$'+Z2pe\u0012\u001cHC\u0004Bw\u0005g\u0014)P!?\u0003\u0000\u000e\r1q\u0002\t\u0005\u0003#\u0012y/\u0003\u0003\u0003r\u0006M#!\u0004$fi\u000eDG)\u0019;b\u0013:4w\u000e\u0003\u0005leA\u0005\t\u0019AA=\u0011%\u00119P\rI\u0001\u0002\u0004\u0011)!A\u0006ti\u0006\u0014Ho\u00144gg\u0016$\b\"\u0003B~eA%\t\u0019\u0001B\u007f\u0003%i\u0017\r\u001f'f]\u001e$\b\u000eE\u0003r\u0005\u0003\u0011)\u0005C\u0005\u0004\u0002I\u0002\n\u00111\u0001\u0003l\u0005iQ.\u001b8P]\u0016lUm]:bO\u0016D\u0011b!\u00023!\u0013\u0005\raa\u0002\u0002#5\f\u0007p\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\rE\u0003r\u0005\u0003\u0019I\u0001\u0005\u0003\u0002R\r-\u0011\u0002BB\u0007\u0003'\u0012\u0011\u0003T8h\u001f\u001a47/\u001a;NKR\fG-\u0019;b\u0011%\u0019\tB\rI\u0001\u0002\u0004\u0011Y'\u0001\nj]\u000edW\u000fZ3BE>\u0014H/\u001a3Uq:\u001c\u0018!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%M\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00133\u0003U\u0011X-\u00193SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"aa\u0007+\t\t\u0015#\u0011C\u0001\u0016e\u0016\fGMU3d_J$7\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\u0019\tC\u000b\u0003\u0003l\tE\u0011!\u0006:fC\u0012\u0014VmY8sIN$C-\u001a4bk2$H%N\u000b\u0003\u0007OQCa!\u0003\u0003\u0012\u0005)\"/Z1e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u00122\u0014\u0001\b;fgRdun\u001a#fY\u0016$XmU3h[\u0016tGo]*vG\u000e,7o\u001d\u0015\u0004s\r=\u0002\u0003BAE\u0007cIAaa\r\u0002\f\n!A+Z:u\u0003i!Xm\u001d;S_2dW)\u001c9us\u0006\u001bG/\u001b<f'\u0016<W.\u001a8uQ\rQ4qF\u00017i\u0016\u001cH\u000fT8h\t\u0016dW\r^3ESJ\u001cVoY2fgN<\u0006.\u001a8F[B$\u00180\u00118e\r\u0006LG.\u001e:f/\",gNT8o\u000b6\u0004H/\u001f\u0015\u0004w\r=\u0012\u0001\u0005;fgR,\u0006\u000fZ1uK\u000e{gNZ5hQ\ra4qF\u0001\u0019i\u0016\u001cH\u000fT8h\t&\u0014(+\u001a8b[\u0016$vNT3x\t&\u0014\bfA\u001f\u00040\u0005iB/Z:u\u0019><G)\u001b:SK:\fW.\u001a+p\u000bbL7\u000f^5oO\u0012K'\u000fK\u0002?\u0007_\tA\u0002^3ti2{wM\u00127vg\"D3aPB\u0018\u00035!Xm\u001d;M_\u001e\f\u0005\u000f]3oI\"\u001a\u0001ia\f\u0002'Q,7\u000f\u001e'pO\u000ecwn]3Tk\u000e\u001cWm]:)\u0007\u0005\u001by#\u0001\fuKN$Hj\\4DY>\u001cX-\u00133f[B|G/\u001a8uQ\r\u00115qF\u0001,i\u0016\u001cH\u000fT8h\u00072|7/\u001a$bS2,(/Z,iK:Le.T3n_JL()\u001e4gKJ\u001cEn\\:fI\"\u001a1ia\f\u0002)Q,7\u000f\u001e'pO\u000ecwn]3IC:$G.\u001a:tQ\r!5qF\u0001\u001fi\u0016\u001cH\u000fT8h\u00072|7/\u001a%b]\u0012dWM]:JI\u0016l\u0007o\u001c;f]RD3!RB\u0018\u0003m!Xm\u001d;SK6|g/Z!oI\u0012+G.\u001a;f'\u0016<W.\u001a8ugR!\u0011\u0011BB5\u0011\u001d\u0019YG\u0012a\u0001\u0005W\n1\"Y:z]\u000e$U\r\\3uK\u0006yB/Z:u%\u0016lwN^3B]\u0012$U\r\\3uKN+w-\\3oiN\u001c\u0016P\\2)\u0007\u001d\u001by#\u0001\u0011uKN$(+Z7pm\u0016\fe\u000e\u001a#fY\u0016$XmU3h[\u0016tGo]!ts:\u001c\u0007f\u0001%\u00040\u00051B/Z:u\t\u0016dW\r^3TK\u001elWM\u001c;GS2,7\u000f\u0006\u0003\u0002\n\re\u0004bBB6\u0013\u0002\u0007!1N\u0001\u001bi\u0016\u001cH\u000fR3mKR,7+Z4nK:$h)\u001b7fgNKhn\u0019\u0015\u0004\u0015\u000e=\u0012a\u0007;fgR$U\r\\3uKN+w-\\3oi\u001aKG.Z:Bgft7\rK\u0002L\u0007_\t!\u0004^3ti\u000e\u0013X-\u0019;f\u0003:$G)\u001a7fi\u0016\u001cVmZ7f]RD3\u0001TB\u0018\u0003m!Xm\u001d;UeVt7-\u0019;f\rVdG._!oIN#\u0018M\u001d;Bi\"\u001aQja\f\u0002\u001dQ,7\u000f\u001e+sk:\u001c\u0017\r^3U_\"\u001aaja\f\u00023Q,7\u000f\u001e(p]\u0006\u001bG/\u001b<f'\u0016<W.\u001a8ug\u001a\u0013x.\u001c\u0015\u0004\u001f\u000e=\u0012A\u0005;pa&\u001c\u0007+\u0019:uSRLwN\u001c(b[\u0016$b!a3\u0004\u0018\u000em\u0005bBBM!\u0002\u0007\u00111Z\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0007;\u0003\u0006\u0019AAf\u0003%\u0001\u0018M\u001d;ji&|g.A\u000euKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a\u0015\u0004#\u000e=\u0012\u0001\u000e;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWmV5uQB+'/[8e\r>\u0014H)\u001a7fi\u0016$Gk\u001c9jG\"\u001a!ka\f\u0002OQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X)\u001c9us:\u000bW.\u001a\u0015\u0004'\u000e=\u0012A\t;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u001dVdG\u000eK\u0002U\u0007_\ta\u0006^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:NSN\u001c\u0018N\\4TKB\f'/\u0019;pe\"\u001aQka\f\u0002UQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X*[:tS:<Gk\u001c9jG\"\u001aaka\f\u0002]Q,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X*[:tS:<\u0007+\u0019:uSRLwN\u001c\u0015\u0004/\u000e=\u0012A\f;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u0013:4\u0018\r\\5e!\u0006\u0014H/\u001b;j_:D3\u0001WB\u0018\u0003A\"Xm\u001d;QCJ\u001cX\rV8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nK\u001a{'/\u0012=jgRLgnZ%om\u0006d\u0017\u000e\u001a#je\"\u001a\u0011la\f\u0002)Q,7\u000f\u001e'pO\u0012+G.\u001a;f\t&\u0014h*Y7fQ\rQ6qF\u0001\u0013i\u0016\u001cHo\u00144gg\u0016$hI]8n\r&dW\rK\u0002\\\u0007_\t\u0001\u0005^3tiJ{G\u000e\\*fO6,g\u000e\u001e+iCR\fEN]3bIf,\u00050[:ug\"\u001aAla\f\u00021Q,7\u000f\u001e(foN+w-\\3oiN\fe\r^3s%>dG\u000eK\u0002^\u0007_\t1\u0006^3tiJ{G\u000e\\*fO6,g\u000e^#se>\u0014x\u000b[3o\u001d\u0016DHo\u00144gg\u0016$\u0018j]%mY\u0016<\u0017\r\u001c\u0015\u0004=\u000e=\u0012A\u0007;fgR4E.^:iS:<gj\u001c8Fq&\u001cH/\u001a8u\t&\u0014\bfA0\u00040\u0005y2M]3bi\u0016dunY1m\u0019><w+\u001b;i\u0003\u000e$\u0018N^3TK\u001elWM\u001c;\u0015)\u0005e4q\\Br\u0007W\u001c)p!?\u0004~\u0012\u001dAq\u0003C\r\u0011%\u0019\t\u000f\u0019I\u0001\u0002\u0004\tI\"A\u0002eSJDaA\u001f1A\u0002\r\u0015\b\u0003BA)\u0007OLAa!;\u0002T\tIAj\\4D_:4\u0017n\u001a\u0005\n\u0007[\u0004\u0007\u0013!a\u0001\u0007_\f\u0001b]3h[\u0016tGo\u001d\t\u0005\u0003#\u001a\t0\u0003\u0003\u0004t\u0006M#a\u0003'pON+w-\\3oiND\u0011ba>a!\u0003\u0005\rA!\u0002\u0002\u001bI,7m\u001c<fef\u0004v.\u001b8u\u0011%\u0019Y\u0010\u0019I\u0001\u0002\u0004\u0019I!\u0001\noKb$xJ\u001a4tKRlU\r^1eCR\f\u0007\"CB\u0000AB\u0005\t\u0019\u0001C\u0001\u0003%\u00198\r[3ek2,'\u000f\u0005\u0003\u0002j\u0011\r\u0011\u0002\u0002C\u0003\u0003W\u0012\u0011bU2iK\u0012,H.\u001a:\t\u0013\u0011%\u0001\r%AA\u0002\u0011-\u0011\u0001\u0002;j[\u0016\u0004B\u0001\"\u0004\u0005\u00145\u0011Aq\u0002\u0006\u0005\t#\t9$A\u0003vi&d7/\u0003\u0003\u0005\u0016\u0011=!\u0001\u0002+j[\u0016D\u0011\"a\fa!\u0003\u0005\r!a\r\t\u0013\u0005-\u0003\r%AA\u0002\u0005=\u0013!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0005 )\"\u0011\u0011\u0004B\t\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%gU\u0011AQ\u0005\u0016\u0005\u0007_\u0014\t\"A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H\u0005N\u0001*GJ,\u0017\r^3M_\u000e\fG\u000eT8h/&$\b.Q2uSZ,7+Z4nK:$H\u0005Z3gCVdG\u000fJ\u001b\u0002S\r\u0014X-\u0019;f\u0019>\u001c\u0017\r\u001c'pO^KG\u000f[!di&4XmU3h[\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00137+\t!yC\u000b\u0003\u0005\u0002\tE\u0011!K2sK\u0006$X\rT8dC2dunZ,ji\"\f5\r^5wKN+w-\\3oi\u0012\"WMZ1vYR$s'\u0006\u0002\u00056)\"A1\u0002B\t\u0003%\u001a'/Z1uK2{7-\u00197M_\u001e<\u0016\u000e\u001e5BGRLg/Z*fO6,g\u000e\u001e\u0013eK\u001a\fW\u000f\u001c;%qU\u0011A1\b\u0016\u0005\u0003g\u0011\t\"A\u0015de\u0016\fG/\u001a'pG\u0006dGj\\4XSRD\u0017i\u0019;jm\u0016\u001cVmZ7f]R$C-\u001a4bk2$H%O\u000b\u0003\t\u0003RC!a\u0014\u0003\u0012\u0001")
public class LocalLogTest {
    private volatile LocalLogTest$KeyValue$ KeyValue$module;
    private KafkaConfig config;
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("test_topic", 1);
    private final LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
    private final MockTime mockTime = new MockTime();
    private final LocalLog log;

    public LocalLogTest$KeyValue$ KeyValue() {
        if (this.KeyValue$module == null) {
            this.KeyValue$lzycompute$1();
        }
        return this.KeyValue$module;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public MockTime mockTime() {
        return this.mockTime;
    }

    public LocalLog log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        boolean x$4 = true;
        boolean x$5 = true;
        None$ x$6 = None$.MODULE$;
        None$ x$7 = None$.MODULE$;
        None$ x$8 = None$.MODULE$;
        boolean x$9 = true;
        boolean x$10 = false;
        TestUtils$ createBrokerConfig$default$11_this = TestUtils$.MODULE$;
        Object var20_8 = null;
        int x$11 = createBrokerConfig$default$11_this.RandomPort();
        boolean x$12 = false;
        TestUtils$ createBrokerConfig$default$13_this = TestUtils$.MODULE$;
        Object var21_11 = null;
        int x$13 = createBrokerConfig$default$13_this.RandomPort();
        boolean x$14 = false;
        TestUtils$ createBrokerConfig$default$15_this = TestUtils$.MODULE$;
        Object var22_14 = null;
        int x$15 = createBrokerConfig$default$15_this.RandomPort();
        None$ x$16 = None$.MODULE$;
        int x$17 = 1;
        boolean x$18 = false;
        int x$19 = 1;
        short x$20 = 1;
        boolean x$21 = false;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "127.0.0.1:1", x$4, x$5, -1, (Option<SecurityProtocol>)x$6, (Option<File>)x$7, (Option<Properties>)x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, (Option<String>)x$16, x$17, x$18, x$19, x$20, x$21);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @AfterEach
    public void tearDown() {
        try {
            this.log().close();
        }
        catch (KafkaStorageException kafkaStorageException) {}
        Utils.delete((File)this.tmpDir());
    }

    private Iterable<SimpleRecord> kvsToRecords(Iterable<KeyValue> keyValues) {
        return (Iterable)keyValues.map((Function1 & Serializable)kv -> kv.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> kv.toRecord$default$1()));
    }

    private Iterable<KeyValue> recordsToKvs(Iterable<Record> records) {
        return (Iterable)records.map((Function1 & Serializable)r -> this.KeyValue().fromRecord((Record)r));
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(Iterable<SimpleRecord> records, LocalLog log, long initialOffset) {
        void withRecords_records;
        void withRecords_partitionLeaderEpoch;
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toList().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        boolean bl = false;
        CompressionType withRecords_compressionType = CompressionType.NONE;
        Object var5_6 = null;
        simpleRecordArray = null;
        log.append(initialOffset + (long)records.size() - 1L, ((SimpleRecord)records.head()).timestamp(), initialOffset, MemoryRecords.withRecords((byte)2, (long)initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)-1L, (short)-1, (int)-1, (int)withRecords_partitionLeaderEpoch, (boolean)false, (SimpleRecord[])withRecords_records));
    }

    private LocalLog appendRecords$default$2() {
        return this.log();
    }

    private long appendRecords$default$3() {
        return 0L;
    }

    private FetchDataInfo readRecords(LocalLog log, long startOffset, Function0<Object> maxLength, boolean minOneMessage, Function0<LogOffsetMetadata> maxOffsetMetadata, boolean includeAbortedTxns) {
        return log.read(startOffset, maxLength.apply$mcI$sp(), minOneMessage, (LogOffsetMetadata)maxOffsetMetadata.apply(), includeAbortedTxns);
    }

    private LocalLog readRecords$default$1() {
        return this.log();
    }

    private long readRecords$default$2() {
        return 0L;
    }

    private int readRecords$default$3() {
        return this.log().segments().activeSegment().size();
    }

    private boolean readRecords$default$4() {
        return false;
    }

    private LogOffsetMetadata readRecords$default$5() {
        return this.log().logEndOffsetMetadata();
    }

    private boolean readRecords$default$6() {
        return false;
    }

    @Test
    public void testLogDeleteSegmentsSuccess() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Vector segmentsBeforeDelete = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values()).asScala().toVector();
        Iterable deletedSegments = this.log().deleteAllSegments();
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)segmentsBeforeDelete, (Object)deletedSegments);
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().checkIfMemoryMappedBufferClosed());
        Assertions.assertTrue((boolean)this.logDir().exists());
    }

    @Test
    public void testRollEmptyActiveSegment() {
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    @Test
    public void testLogDeleteDirSuccessWhenEmptyAndFailureWhenNonEmpty() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertFalse((boolean)ArrayOps$.MODULE$.isEmpty$extension(Predef$.MODULE$.refArrayOps((Object[])this.logDir().listFiles())));
        Assertions.assertThrows(IllegalStateException.class, () -> this.log().deleteEmptyDir());
        Assertions.assertTrue((boolean)this.logDir().exists());
        this.log().deleteAllSegments();
        this.log().deleteEmptyDir();
        Assertions.assertFalse((boolean)this.logDir().exists());
    }

    @Test
    public void testUpdateConfig() {
        LogConfig oldConfig = this.log().config();
        Assertions.assertEquals((Object)oldConfig, (Object)this.log().config());
        int x$1 = oldConfig.segmentSize + 1;
        long x$2 = 604800000L;
        long x$3 = 604800000L;
        long x$4 = -2L;
        long x$5 = -1L;
        long x$6 = -2L;
        long x$7 = 0L;
        String x$8 = "delete";
        int x$9 = 0x10000C;
        int x$10 = 4096;
        int x$11 = 0xA00000;
        long x$12 = 60000L;
        boolean x$13 = false;
        LogConfig newConfig = LogTestUtils$.MODULE$.createLogConfig(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13);
        this.log().updateConfig(newConfig);
        Assertions.assertEquals((Object)newConfig, (Object)this.log().config());
    }

    @Test
    public void testLogDirRenameToNewDir() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        File newLogDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        Assertions.assertTrue((boolean)this.log().renameDir(newLogDir.getName()));
        Assertions.assertFalse((boolean)this.logDir().exists());
        Assertions.assertTrue((boolean)newLogDir.exists());
        Assertions.assertEquals((Object)newLogDir, (Object)this.log().dir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().parentDir());
        Assertions.assertEquals((Object)newLogDir.getParent(), (Object)this.log().dir().getParent());
        this.log().segments().values().forEach(segment -> Assertions.assertEquals((Object)newLogDir.getPath(), (Object)segment.log().file().getParentFile().getPath()));
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
    }

    @Test
    public void testLogDirRenameToExistingDir() {
        Assertions.assertFalse((boolean)this.log().renameDir(this.log().dir().getName()));
    }

    @Test
    public void testLogFlush() {
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        this.log().flush(newSegment.baseOffset());
        this.log().markFlushed(newSegment.baseOffset());
        Assertions.assertEquals((long)1L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)this.mockTime().milliseconds(), (long)this.log().lastFlushTime());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testLogAppend() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        LocalLog x$2 = this.log();
        long x$3 = 0L;
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfoBeforeAppend = x$2.read(x$3, 1, x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfoBeforeAppend.records.records()).asScala().isEmpty());
        this.mockTime().sleep(1L);
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var9_10 = null;
        FetchDataInfo fetchDataInfo = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().size());
        Assertions.assertEquals((Object)keyValues, this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala()));
    }

    @Test
    public void testLogCloseSuccess() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().close();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseSuccess$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseIdempotent() {
        this.log().close();
        this.log().close();
    }

    @Test
    public void testLogCloseFailureWhenInMemoryBufferClosed() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(KafkaStorageException.class, () -> this.log().close());
    }

    @Test
    public void testLogCloseHandlers() {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "abc", "ABC"), (List)new .colon.colon((Object)new KeyValue(this, "de", "DE"), (List)Nil$.MODULE$));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        this.log().closeHandlers();
        Assertions.assertThrows(ClosedChannelException.class, () -> LocalLogTest.$anonfun$testLogCloseHandlers$1(this, (Seq)keyValues));
    }

    @Test
    public void testLogCloseHandlersIdempotent() {
        this.log().closeHandlers();
        this.log().closeHandlers();
    }

    private void testRemoveAndDeleteSegments(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testRemoveAndDeleteSegments$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        public class Kafka_log_LocalLogTest$TestDeletionReason$1
        implements SegmentDeletionReason {
            private Iterable<LogSegment> _deletedSegments;

            private Iterable<LogSegment> _deletedSegments() {
                return this._deletedSegments;
            }

            private void _deletedSegments_$eq(Iterable<LogSegment> x$1) {
                this._deletedSegments = x$1;
            }

            public void logReason(List<LogSegment> toDelete) {
                this._deletedSegments_$eq((Iterable<LogSegment>)((Iterable)Nil$.MODULE$.$plus$plus(toDelete)));
            }

            public Iterable<LogSegment> deletedSegments() {
                return this._deletedSegments();
            }

            public Kafka_log_LocalLogTest$TestDeletionReason$1(LocalLogTest $outer) {
                this._deletedSegments = Nil$.MODULE$;
            }
        }
        Kafka_log_LocalLogTest$TestDeletionReason$1 reason = new Kafka_log_LocalLogTest$TestDeletionReason$1(null);
        Vector toDelete = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values()).asScala().toVector();
        this.log().removeAndDeleteSegments((Iterable)toDelete, asyncDelete, (SegmentDeletionReason)reason);
        if (asyncDelete) {
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        Assertions.assertTrue((boolean)this.log().segments().isEmpty());
        Assertions.assertEquals((Object)toDelete, reason.deletedSegments());
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testRemoveAndDeleteSegments$2(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testRemoveAndDeleteSegmentsSync() {
        this.testRemoveAndDeleteSegments(false);
    }

    @Test
    public void testRemoveAndDeleteSegmentsAsync() {
        this.testRemoveAndDeleteSegments(true);
    }

    private void testDeleteSegmentFiles(boolean asyncDelete) {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testDeleteSegmentFiles$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((long)10L, (long)this.log().segments().numberOfSegments());
        Vector toDelete = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values()).asScala().toVector();
        LocalLog$.MODULE$.deleteSegmentFiles((scala.collection.immutable.Iterable)toDelete, asyncDelete, this.log().dir(), this.log().topicPartition(), this.log().config(), this.log().scheduler(), this.log().logDirFailureChannel(), "");
        if (asyncDelete) {
            toDelete.foreach((Function1 & Serializable)segment -> {
                LocalLogTest.$anonfun$testDeleteSegmentFiles$2(segment);
                return BoxedUnit.UNIT;
            });
            this.mockTime().sleep(this.log().config().fileDeleteDelayMs + 1L);
        }
        toDelete.foreach((Function1 & Serializable)segment -> {
            LocalLogTest.$anonfun$testDeleteSegmentFiles$3(segment);
            return BoxedUnit.UNIT;
        });
    }

    @Test
    public void testDeleteSegmentFilesSync() {
        this.testDeleteSegmentFiles(false);
    }

    @Test
    public void testDeleteSegmentFilesAsync() {
        this.testDeleteSegmentFiles(true);
    }

    @Test
    public void testCreateAndDeleteSegment() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        long newOffset = this.log().segments().activeSegment().baseOffset() + 1L;
        LogSegment oldActiveSegment = this.log().segments().activeSegment();
        LogSegment newActiveSegment = this.log().createAndDeleteSegment(newOffset, this.log().segments().activeSegment(), true, (SegmentDeletionReason)new LogTruncation(this.log()));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((Object)newActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertNotEquals((Object)oldActiveSegment, (Object)this.log().segments().activeSegment());
        Assertions.assertTrue((boolean)oldActiveSegment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
        Assertions.assertEquals((long)newOffset, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)newOffset, (long)this.log().logEndOffset());
        LocalLog x$2 = this.log();
        boolean x$4 = false;
        boolean x$6 = false;
        FetchDataInfo fetchDataInfo = x$2.read(newOffset, this.readRecords$default$3(), x$4, this.readRecords$default$5(), x$6);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateFullyAndStartAt() {
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 7).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateFullyAndStartAt$1(this, record, BoxesRunTime.unboxToInt((Object)offset)));
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(8), 12).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)offset -> {
            SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
            .colon.colon x$4 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
            long x$5 = offset;
            LocalLog x$6 = this.log();
            this.appendRecords((Iterable<SimpleRecord>)x$4, x$6, x$5);
        });
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertNotEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Vector expected = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values()).asScala().toVector();
        Iterable deleted = this.log().truncateFullyAndStartAt(10L);
        Assertions.assertEquals((Object)expected, (Object)deleted);
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)10L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)10L, (long)this.log().logEndOffset());
        LocalLog x$8 = this.log();
        boolean x$10 = false;
        boolean x$12 = false;
        long readRecords_startOffset = 10L;
        FetchDataInfo fetchDataInfo = x$8.read(readRecords_startOffset, this.readRecords$default$3(), x$10, this.readRecords$default$5(), x$12);
        Assertions.assertTrue((boolean)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().isEmpty());
    }

    @Test
    public void testTruncateTo() {
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(0), 11).foreach((Function1 & Serializable)offset -> LocalLogTest.$anonfun$testTruncateTo$1(this, BoxesRunTime.unboxToInt((Object)offset)));
        Assertions.assertEquals((int)5, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)12L, (long)this.log().logEndOffset());
        Vector expected = CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().values(9L, this.log().logEndOffset() + 1L)).asScala().toVector();
        Iterable deleted = this.log().truncateTo(7L);
        Assertions.assertEquals((Object)expected, (Object)deleted.toVector());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)6L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)0L, (long)this.log().recoveryPoint());
        Assertions.assertEquals((long)7L, (long)this.log().logEndOffset());
        LocalLog x$5 = this.log();
        boolean x$7 = false;
        boolean x$9 = false;
        long readRecords_startOffset = 6L;
        FetchDataInfo fetchDataInfo = x$5.read(readRecords_startOffset, this.readRecords$default$3(), x$7, this.readRecords$default$5(), x$9);
        Assertions.assertEquals((int)1, (int)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala().size());
        Assertions.assertEquals((Object)new .colon.colon((Object)new KeyValue(this, "", "a"), (List)Nil$.MODULE$), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(fetchDataInfo.records.records()).asScala()));
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$10 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        LocalLog x$12 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$10, x$12, 7L);
        Assertions.assertEquals((long)8L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNonActiveSegmentsFrom() {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5).foreach((Function1 & Serializable)i -> LocalLogTest.$anonfun$testNonActiveSegmentsFrom$1(this, BoxesRunTime.unboxToInt((Object)i)));
        Assertions.assertEquals((long)5L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 5), (Object)this.nonActiveBaseOffsetsFrom$1(0L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(5L));
        Assertions.assertEquals((Object)RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(2), 5), (Object)this.nonActiveBaseOffsetsFrom$1(2L));
        Assertions.assertEquals((Object)package$.MODULE$.Seq().empty(), (Object)this.nonActiveBaseOffsetsFrom$1(6L));
    }

    private String topicPartitionName(String topic, String partition) {
        return new StringBuilder(1).append(topic).append("-").append(partition).toString();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic());
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition());
    }

    @Test
    public void testParseTopicPartitionNameWithPeriodForDeletedTopic() {
        String topic = "foo.bar-testtopic";
        String partition = "42";
        File dir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        TopicPartition topicPartition = LocalLog$.MODULE$.parseTopicPartitionName(dir);
        Assertions.assertEquals((Object)topic, (Object)topicPartition.topic(), (String)"Unexpected topic name parsed");
        Assertions.assertEquals((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)), (int)topicPartition.partition(), (String)"Unexpected partition number parsed");
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        File dir = new File("");
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        Assertions.assertThrows(KafkaException.class, () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$1(null), () -> LocalLogTest.$anonfun$testParseTopicPartitionNameForNull$2(null));
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(this.logDir(), new StringBuilder(0).append(topic).append(partition).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(topic, StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(partition)))));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(new StringBuilder(0).append(this.logDir().getPath()).append(this.topicPartitionName(topic, partition)).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(this.topicPartitionName(topic, partition)).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForInvalidPartition() {
        String topic = "test_topic";
        String partition = "1999a";
        File dir = new File(this.logDir(), this.topicPartitionName(topic, partition));
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir.getCanonicalPath()).toString());
        File deleteMarkerDir = new File(this.logDir(), new StringBuilder(1).append(topic).append(partition).append(".").append(LocalLog$.MODULE$.DeleteDirSuffix()).toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(deleteMarkerDir), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(deleteMarkerDir.getCanonicalPath()).toString());
    }

    @Test
    public void testParseTopicPartitionNameForExistingInvalidDir() {
        File dir1 = new File(new StringBuilder(14).append(this.logDir().getPath()).append("/non_kafka_dir").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir1), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir1.getCanonicalPath()).toString());
        File dir2 = new File(new StringBuilder(21).append(this.logDir().getPath()).append("/non_kafka_dir-delete").toString());
        Assertions.assertThrows(KafkaException.class, () -> LocalLog$.MODULE$.parseTopicPartitionName(dir2), () -> new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir2.getCanonicalPath()).toString());
    }

    @Test
    public void testLogDeleteDirName() {
        String name1 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition("foo", 3));
        Assertions.assertTrue((name1.length() <= 255 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)Pattern.compile("foo-3\\.[0-9a-z]{32}-delete").matcher(name1).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name1).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name1).matches());
        String name2 = LocalLog$.MODULE$.logDeleteDirName(new TopicPartition(new StringBuilder(1).append("n").append(String.join((CharSequence)"", Collections.nCopies(248, "o"))).toString(), 5));
        Assertions.assertEquals((int)255, (int)name2.length());
        Assertions.assertTrue((boolean)Pattern.compile("n[o]{212}-5\\.[0-9a-z]{32}-delete").matcher(name2).matches());
        Assertions.assertTrue((boolean)LocalLog$.MODULE$.DeleteDirPattern().matcher(name2).matches());
        Assertions.assertFalse((boolean)LocalLog$.MODULE$.FutureDirPattern().matcher(name2).matches());
    }

    @Test
    public void testOffsetFromFile() {
        long offset = 23423423L;
        File logFile_dir = this.tmpDir();
        Object var6_2 = null;
        File logFile = LogFileUtils.logFile((File)logFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)logFile));
        File offsetIndexFile_dir = this.tmpDir();
        Object var7_4 = null;
        File offsetIndexFile = LogFileUtils.offsetIndexFile((File)offsetIndexFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)offsetIndexFile));
        File timeIndexFile_dir = this.tmpDir();
        Object var8_6 = null;
        File timeIndexFile = LogFileUtils.timeIndexFile((File)timeIndexFile_dir, (long)offset, (String)"");
        Assertions.assertEquals((long)offset, (Long)LogFileUtils.offsetFromFile((File)timeIndexFile));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRollSegmentThatAlreadyExists() {
        void readRecords_includeAbortedTxns;
        void readRecords_minOneMessage;
        void readRecords_startOffset;
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Expect 1 segment after roll() empty segment with base offset.");
        .colon.colon keyValues1 = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)Nil$.MODULE$);
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues1), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        .colon.colon keyValues2 = new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)Nil$.MODULE$);
        List x$1 = keyValues2.map((Function1 & Serializable)x$3 -> x$3.toRecord((Function0<Object>)(JFunction0.mcJ.sp & Serializable)() -> this.mockTime().milliseconds() + 10L));
        LocalLog x$32 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$1, x$32, 1L);
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        boolean bl = false;
        boolean bl2 = false;
        long l = 0L;
        LocalLog readRecords_log = this.log();
        Object var6_8 = null;
        FetchDataInfo readResult = readRecords_log.read((long)readRecords_startOffset, this.readRecords$default$3(), (boolean)readRecords_minOneMessage, this.readRecords$default$5(), (boolean)readRecords_includeAbortedTxns);
        Assertions.assertEquals((long)2L, (long)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records.records()).asScala().size());
        Assertions.assertEquals((Object)keyValues1.$plus$plus((IterableOnce)keyValues2), this.recordsToKvs((Iterable<Record>)CollectionConverters$.MODULE$.IterableHasAsScala(readResult.records.records()).asScala()));
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)2L, (long)this.log().segments().activeSegment().baseOffset(), (String)"Expect base offset of active segment to be LEO");
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments(), (String)"Expect two segments.");
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testNewSegmentsAfterRoll() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)0L, (long)newSegment.baseOffset());
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)0L, (long)this.log().logEndOffset());
        KeyValue qual$1 = new KeyValue(this, "k1", "v1");
        JFunction0.mcJ.sp & Serializable x$1 = (JFunction0.mcJ.sp & Serializable)() -> qual$1.toRecord$default$1();
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)qual$1.toRecord((Function0<Object>)x$1), (List)Nil$.MODULE$), this.log(), 0L);
        LogSegment newSegment2 = this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)1L, (long)newSegment2.baseOffset());
        Assertions.assertEquals((int)2, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)1L, (long)this.log().logEndOffset());
        KeyValue qual$2 = new KeyValue(this, "k2", "v2");
        JFunction0.mcJ.sp & Serializable x$2 = (JFunction0.mcJ.sp & Serializable)() -> qual$2.toRecord$default$1();
        .colon.colon x$3 = new .colon.colon((Object)qual$2.toRecord((Function0<Object>)x$2), (List)Nil$.MODULE$);
        LocalLog x$5 = this.log();
        this.appendRecords((Iterable<SimpleRecord>)x$3, x$5, 1L);
        LogSegment newSegment3 = this.log().roll((Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)));
        Assertions.assertEquals((long)2L, (long)newSegment3.baseOffset());
        Assertions.assertEquals((int)3, (int)this.log().segments().numberOfSegments());
        Assertions.assertEquals((long)2L, (long)this.log().logEndOffset());
    }

    @Test
    public void testRollSegmentErrorWhenNextOffsetIsIllegal() {
        Assertions.assertEquals((int)1, (int)this.log().segments().numberOfSegments(), (String)"Log begins with a single empty segment.");
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue(this, "k1", "v1"), (List)new .colon.colon((Object)new KeyValue(this, "k2", "v2"), (List)new .colon.colon((Object)new KeyValue(this, "k3", "v3"), (List)Nil$.MODULE$)));
        this.appendRecords(this.kvsToRecords((Iterable<KeyValue>)keyValues), this.log(), 0L);
        Assertions.assertEquals((long)0L, (long)this.log().segments().activeSegment().baseOffset());
        Assertions.assertEquals((long)3L, (long)this.log().logEndOffset(), (String)"Expect two records in the log");
        this.log().roll(this.log().roll$default$1());
        Assertions.assertEquals((long)3L, (long)this.log().segments().activeSegment().baseOffset());
        this.log().updateLogEndOffset(1L);
        Assertions.assertThrows(KafkaException.class, () -> this.log().roll(this.log().roll$default$1()));
    }

    @Test
    public void testFlushingNonExistentDir() {
        LocalLog spyLog = (LocalLog)Mockito.spy((Object)this.log());
        SimpleRecord record = new SimpleRecord(this.mockTime().milliseconds(), "a".getBytes());
        this.appendRecords((Iterable<SimpleRecord>)new .colon.colon((Object)record, (List)Nil$.MODULE$), this.log(), 0L);
        this.mockTime().sleep(1L);
        LogSegment newSegment = this.log().roll(this.log().roll$default$1());
        ((LocalLog)Mockito.doReturn((Object)new File("__NON_EXISTENT__"), (Object[])ScalaRunTime$.MODULE$.toObjectArray(Nil$.MODULE$.toArray(ClassTag$.MODULE$.Any()))).when((Object)spyLog)).dir();
        Assertions.assertDoesNotThrow(() -> spyLog.flush(newSegment.baseOffset()));
    }

    /*
     * WARNING - void declaration
     */
    private LocalLog createLocalLogWithActiveSegment(File dir, LogConfig config, LogSegments segments, long recoveryPoint, LogOffsetMetadata nextOffsetMetadata, Scheduler scheduler, Time time, TopicPartition topicPartition, LogDirFailureChannel logDirFailureChannel) {
        void open_preallocate;
        void open_initFileSize;
        boolean bl = config.preallocate;
        int n = config.initFileSize();
        long open_baseOffset = 0L;
        segments.add(LogSegment.open((File)dir, (long)open_baseOffset, (LogConfig)config, (Time)time, (boolean)false, (int)open_initFileSize, (boolean)open_preallocate, (String)""));
        return new LocalLog(dir, config, segments, recoveryPoint, nextOffsetMetadata, scheduler, time, topicPartition, logDirFailureChannel);
    }

    private File createLocalLogWithActiveSegment$default$1() {
        return this.logDir();
    }

    private LogSegments createLocalLogWithActiveSegment$default$3() {
        return new LogSegments(this.topicPartition());
    }

    private long createLocalLogWithActiveSegment$default$4() {
        return 0L;
    }

    private LogOffsetMetadata createLocalLogWithActiveSegment$default$5() {
        return new LogOffsetMetadata(0L, 0L, 0);
    }

    private Scheduler createLocalLogWithActiveSegment$default$6() {
        return this.mockTime().scheduler;
    }

    private Time createLocalLogWithActiveSegment$default$7() {
        return this.mockTime();
    }

    private TopicPartition createLocalLogWithActiveSegment$default$8() {
        return this.topicPartition();
    }

    private LogDirFailureChannel createLocalLogWithActiveSegment$default$9() {
        return this.logDirFailureChannel();
    }

    private final void KeyValue$lzycompute$1() {
        synchronized (this) {
            if (this.KeyValue$module == null) {
                this.KeyValue$module = new LocalLogTest$KeyValue$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ int $anonfun$testLogAppend$1() {
        return 1;
    }

    public static final /* synthetic */ void $anonfun$testLogCloseSuccess$1(LocalLogTest $this, Seq keyValues$1) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$1);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ void $anonfun$testLogCloseHandlers$1(LocalLogTest $this, Seq keyValues$2) {
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues$2);
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, 2L);
    }

    public static final /* synthetic */ LogSegment $anonfun$testRemoveAndDeleteSegments$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testRemoveAndDeleteSegments$2(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ LogSegment $anonfun$testDeleteSegmentFiles$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$2(LogSegment segment) {
        Assertions.assertFalse((boolean)segment.deleted());
        Assertions.assertTrue((boolean)segment.hasSuffix(LocalLog$.MODULE$.DeletedFileSuffix()));
    }

    public static final /* synthetic */ void $anonfun$testDeleteSegmentFiles$3(LogSegment segment) {
        Assertions.assertTrue((boolean)segment.deleted());
    }

    public static final /* synthetic */ Object $anonfun$testTruncateFullyAndStartAt$1(LocalLogTest $this, SimpleRecord record$1, int offset) {
        .colon.colon x$1 = new .colon.colon((Object)record$1, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 2 != 0) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Object $anonfun$testTruncateTo$1(LocalLogTest $this, int offset) {
        SimpleRecord record = new SimpleRecord($this.mockTime().milliseconds(), "a".getBytes());
        .colon.colon x$1 = new .colon.colon((Object)record, (List)Nil$.MODULE$);
        long x$2 = offset;
        LocalLog x$3 = $this.log();
        $this.appendRecords((Iterable<SimpleRecord>)x$1, x$3, x$2);
        if (offset % 3 == 2) {
            return $this.log().roll($this.log().roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ LogSegment $anonfun$testNonActiveSegmentsFrom$1(LocalLogTest $this, int i) {
        .colon.colon keyValues = new .colon.colon((Object)new KeyValue($this, Integer.toString(i), Integer.toString(i)), (List)Nil$.MODULE$);
        Iterable<SimpleRecord> x$1 = $this.kvsToRecords((Iterable<KeyValue>)keyValues);
        long x$2 = i;
        LocalLog x$3 = $this.log();
        $this.appendRecords(x$1, x$3, x$2);
        return $this.log().roll($this.log().roll$default$1());
    }

    private final Seq nonActiveBaseOffsetsFrom$1(long startOffset) {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.log().segments().nonActiveLogSegmentsFrom(startOffset)).asScala().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.baseOffset()))).toSeq();
    }

    public static final /* synthetic */ void $anonfun$testParseTopicPartitionNameForNull$1(File dir$2) {
        LocalLog$.MODULE$.parseTopicPartitionName(dir$2);
    }

    public static final /* synthetic */ String $anonfun$testParseTopicPartitionNameForNull$2(File dir$2) {
        return new StringBuilder(48).append("KafkaException should have been thrown for dir: ").append(dir$2).toString();
    }

    public LocalLogTest() {
        LogConfig x$1 = LogTestUtils$.MODULE$.createLogConfig(604800000L, 0x40000000, 604800000L, -2L, -1L, -2L, 0L, "delete", 0x10000C, 4096, 0xA00000, 60000L, false);
        File x$2 = this.logDir();
        LogSegments x$3 = this.createLocalLogWithActiveSegment$default$3();
        long x$4 = 0L;
        LogOffsetMetadata x$5 = this.createLocalLogWithActiveSegment$default$5();
        Scheduler x$6 = this.createLocalLogWithActiveSegment$default$6();
        MockTime x$7 = this.mockTime();
        TopicPartition x$8 = this.topicPartition();
        LogDirFailureChannel x$9 = this.logDirFailureChannel();
        this.log = this.createLocalLogWithActiveSegment(x$2, x$1, x$3, x$4, x$5, x$6, (Time)x$7, x$8, x$9);
    }

    public class KeyValue
    implements Product,
    Serializable {
        private final String key;
        private final String value;
        public final /* synthetic */ LocalLogTest $outer;

        public Iterator<String> productElementNames() {
            return Product.productElementNames$((Product)this);
        }

        public String key() {
            return this.key;
        }

        public String value() {
            return this.value;
        }

        public SimpleRecord toRecord(Function0<Object> timestamp) {
            return new SimpleRecord(timestamp.apply$mcJ$sp(), this.key().getBytes(), this.value().getBytes());
        }

        public long toRecord$default$1() {
            return this.kafka$log$LocalLogTest$KeyValue$$$outer().mockTime().milliseconds();
        }

        public KeyValue copy(String key, String value) {
            return new KeyValue(this.kafka$log$LocalLogTest$KeyValue$$$outer(), key, value);
        }

        public String copy$default$1() {
            return this.key();
        }

        public String copy$default$2() {
            return this.value();
        }

        public String productPrefix() {
            return "KeyValue";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.key();
                }
                case 1: {
                    return this.value();
                }
            }
            return Statics.ioobe((int)x$1);
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof KeyValue;
        }

        public String productElementName(int x$1) {
            switch (x$1) {
                case 0: {
                    return "key";
                }
                case 1: {
                    return "value";
                }
            }
            return (String)Statics.ioobe((int)x$1);
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean equals(Object x$1) {
            block3: {
                block2: {
                    if (this == x$1) break block2;
                    if (!(x$1 instanceof KeyValue && ((KeyValue)x$1).kafka$log$LocalLogTest$KeyValue$$$outer() == this.kafka$log$LocalLogTest$KeyValue$$$outer())) break block3;
                    KeyValue keyValue = (KeyValue)x$1;
                    String string = this.key();
                    String string2 = keyValue.key();
                    if (string != null ? !string.equals(string2) : string2 != null) break block3;
                    String string3 = this.value();
                    String string4 = keyValue.value();
                    if ((string3 != null ? !string3.equals(string4) : string4 != null) || !keyValue.canEqual(this)) break block3;
                }
                return true;
            }
            return false;
        }

        public /* synthetic */ LocalLogTest kafka$log$LocalLogTest$KeyValue$$$outer() {
            return this.$outer;
        }

        public KeyValue(LocalLogTest $outer, String key, String value) {
            this.key = key;
            this.value = value;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

