/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.typesafe.scalalogging.Logger;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import kafka.log.LocalLog;
import kafka.log.LocalLog$;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogCleanerManagerTest;
import kafka.log.LogCleaningAborted$;
import kafka.log.LogCleaningException;
import kafka.log.LogCleaningInProgress$;
import kafka.log.LogCleaningPaused;
import kafka.log.LogCleaningState;
import kafka.log.LogLoader;
import kafka.log.LogToClean;
import kafka.log.OffsetsToClean;
import kafka.log.UnifiedLog;
import kafka.log.UnifiedLog$;
import kafka.server.BrokerTopicStats;
import kafka.server.Defaults$;
import kafka.utils.Logging;
import kafka.utils.Pool;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.util.MockScheduler;
import org.apache.kafka.server.util.MockTime;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.storage.internals.log.AppendOrigin;
import org.apache.kafka.storage.internals.log.LoadedLogOffsets;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogSegments;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.storage.internals.log.ProducerStateManager;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\r\u001dc\u0001\u0002(P\u0001QCQ!\u0019\u0001\u0005\u0002\tDq!\u001a\u0001C\u0002\u0013\u0005a\r\u0003\u0004p\u0001\u0001\u0006Ia\u001a\u0005\ba\u0002\u0011\r\u0011\"\u0001g\u0011\u0019\t\b\u0001)A\u0005O\"9!\u000f\u0001b\u0001\n\u00031\u0007BB:\u0001A\u0003%q\rC\u0004u\u0001\t\u0007I\u0011\u00014\t\rU\u0004\u0001\u0015!\u0003h\u0011\u001d1\bA1A\u0005\u0002]Dq!a\u0002\u0001A\u0003%\u0001\u0010\u0003\u0005\u0002\n\u0001\u0011\r\u0011\"\u0001x\u0011\u001d\tY\u0001\u0001Q\u0001\naD\u0011\"!\u0004\u0001\u0005\u0004%\t!a\u0004\t\u0011\u0005u\u0001\u0001)A\u0005\u0003#A\u0011\"a\b\u0001\u0005\u0004%\t!!\t\t\u0011\u0005U\u0002\u0001)A\u0005\u0003GA\u0011\"a\u000e\u0001\u0005\u0004%\t!!\u000f\t\u0011\u0005%\u0003\u0001)A\u0005\u0003wA\u0011\"a\u0013\u0001\u0005\u0004%\t!!\u0014\t\u0011\u0005U\u0003\u0001)A\u0005\u0003\u001fB\u0011\"a\u0016\u0001\u0005\u0004%\t!!\u0017\t\u0011\u0005\u0005\u0004\u0001)A\u0005\u00037B\u0011\"a\u0019\u0001\u0005\u0004%\t!!\u001a\t\u0011\u0005u\u0004\u0001)A\u0005\u0003O2a!a \u0001\u0001\u0005\u0005\u0005\u0002DAE5\t\u0005\t\u0015!\u0003\u0002\f\u0006\r\u0006\u0002DAS5\t\u0005\t\u0015!\u0003\u0002(\u0006M\u0006\u0002DA[5\t\u0005\t\u0015!\u0003\u00028\u0006u\u0006BB1\u001b\t\u0003\ty\fC\u0004\u0002Lj!\t%!4\t\u000f\u0005u'\u0004\"\u0011\u0002`\"I!\u0011\u0001\u000e\u0012\u0002\u0013\u0005!1\u0001\u0005\n\u00053Q\u0012\u0013!C\u0001\u00057AqAa\b\u0001\t\u0003\u0011\t\u0003C\u0004\u0003:\u0001!IAa\u000f\t\u000f\t-\u0003\u0001\"\u0001\u0003\"!9!Q\u000b\u0001\u0005\u0002\t\u0005\u0002b\u0002B-\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005;\u0002A\u0011\u0001B\u0011\u0011\u001d\u0011\t\u0007\u0001C\u0001\u0005CAqA!\u001a\u0001\t\u0003\u0011\t\u0003C\u0004\u0003j\u0001!\tA!\t\t\u000f\t5\u0004\u0001\"\u0001\u0003\"!9!\u0011\u000f\u0001\u0005\u0002\t\u0005\u0002b\u0002B;\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005s\u0002A\u0011\u0001B\u0011\u0011\u001d\u0011i\b\u0001C\u0001\u0005CAqA!!\u0001\t\u0003\u0011\t\u0003C\u0004\u0003\u0006\u0002!\tA!\t\t\u000f\t%\u0005\u0001\"\u0001\u0003\"!9!Q\u0012\u0001\u0005\u0002\t\u0005\u0002b\u0002BI\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005+\u0003A\u0011\u0001B\u0011\u0011\u001d\u0011I\n\u0001C\u0001\u0005CAqA!(\u0001\t\u0003\u0011\t\u0003C\u0004\u0003\"\u0002!\tA!\t\t\u000f\t\u0015\u0006\u0001\"\u0001\u0003\"!9!\u0011\u0016\u0001\u0005\u0002\t\u0005\u0002b\u0002BW\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005c\u0003A\u0011\u0001B\u0011\u0011\u001d\u0011)\f\u0001C\u0001\u0005CAqA!/\u0001\t\u0003\u0011\t\u0003C\u0004\u0003>\u0002!\tA!\t\t\u000f\t\u0005\u0007\u0001\"\u0001\u0003\"!9!Q\u0019\u0001\u0005\u0002\t\u0005\u0002b\u0002Be\u0001\u0011\u0005!\u0011\u0005\u0005\b\u0005\u001b\u0004A\u0011\u0002Bh\u0011\u001d\u0011\u0019\u000e\u0001C\u0005\u0005+DqAa7\u0001\t\u0013\u0011i\u000eC\u0005\u0003p\u0002\t\n\u0011\"\u0003\u0003r\"9!Q\u001f\u0001\u0005\n\t]\bb\u0002B\u007f\u0001\u0011%!q \u0005\b\u0007\u001f\u0001A\u0011BB\t\u0011\u001d\u0019I\u0002\u0001C\u0005\u00077A\u0011b!\n\u0001#\u0003%Iaa\n\t\u000f\r-\u0002\u0001\"\u0003\u0004.\t)Bj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:UKN$(B\u0001)R\u0003\rawn\u001a\u0006\u0002%\u0006)1.\u00194lC\u000e\u00011c\u0001\u0001V7B\u0011a+W\u0007\u0002/*\t\u0001,A\u0003tG\u0006d\u0017-\u0003\u0002[/\n1\u0011I\\=SK\u001a\u0004\"\u0001X0\u000e\u0003uS!AX)\u0002\u000bU$\u0018\u000e\\:\n\u0005\u0001l&a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\r\u0004\"\u0001\u001a\u0001\u000e\u0003=\u000ba\u0001^7q\t&\u0014X#A4\u0011\u0005!lW\"A5\u000b\u0005)\\\u0017AA5p\u0015\u0005a\u0017\u0001\u00026bm\u0006L!A\\5\u0003\t\u0019KG.Z\u0001\bi6\u0004H)\u001b:!\u0003\u001d!X\u000e\u001d#jeJ\n\u0001\u0002^7q\t&\u0014(\u0007I\u0001\u0007Y><G)\u001b:\u0002\u000f1|w\rR5sA\u00059An\\4ESJ\u0014\u0014\u0001\u00037pO\u0012K'O\r\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\t\u0001\u0010E\u0002z\u0003\u0007i\u0011A\u001f\u0006\u0003wr\faaY8n[>t'B\u0001*~\u0015\tqx0\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u0003\t1a\u001c:h\u0013\r\t)A\u001f\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003=!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\u0013a\u0004;pa&\u001c\u0007+\u0019:uSRLwN\u001c\u001a\u0002!Q|\u0007/[2QCJ$\u0018\u000e^5p]J\u0002\u0013\u0001\u00037pOB\u0013x\u000e]:\u0016\u0005\u0005E\u0001\u0003BA\n\u00033i!!!\u0006\u000b\u0007\u0005]1.\u0001\u0003vi&d\u0017\u0002BA\u000e\u0003+\u0011!\u0002\u0015:pa\u0016\u0014H/[3t\u0003%awn\u001a)s_B\u001c\b%A\u0005m_\u001e\u001cuN\u001c4jOV\u0011\u00111\u0005\t\u0005\u0003K\t\t$\u0004\u0002\u0002()\u0019\u0001+!\u000b\u000b\t\u0005-\u0012QF\u0001\nS:$XM\u001d8bYNT1!a\f}\u0003\u001d\u0019Ho\u001c:bO\u0016LA!a\r\u0002(\tIAj\\4D_:4\u0017nZ\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0013\u0001\u0002;j[\u0016,\"!a\u000f\u0011\t\u0005u\u0012QI\u0007\u0003\u0003\u007fQA!a\u0006\u0002B)\u0019\u00111\t?\u0002\rM,'O^3s\u0013\u0011\t9%a\u0010\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\naa\u001c4gg\u0016$XCAA(!\r1\u0016\u0011K\u0005\u0004\u0003':&aA%oi\u00069qN\u001a4tKR\u0004\u0013A\u00079s_\u0012,8-\u001a:Ti\u0006$X-T1oC\u001e,'oQ8oM&<WCAA.!\u0011\t)#!\u0018\n\t\u0005}\u0013q\u0005\u0002\u001b!J|G-^2feN#\u0018\r^3NC:\fw-\u001a:D_:4\u0017nZ\u0001\u001caJ|G-^2feN#\u0018\r^3NC:\fw-\u001a:D_:4\u0017n\u001a\u0011\u0002%\rdW-\u00198fe\u000eCWmY6q_&tGo]\u000b\u0003\u0003O\u0002r!!\u001b\u0002ta\f9(\u0004\u0002\u0002l)!\u0011QNA8\u0003\u001diW\u000f^1cY\u0016T1!!\u001dX\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003k\nYGA\u0002NCB\u00042AVA=\u0013\r\tYh\u0016\u0002\u0005\u0019>tw-A\ndY\u0016\fg.\u001a:DQ\u0016\u001c7\u000e]8j]R\u001c\bEA\u000bM_\u001e\u001cE.Z1oKJl\u0015M\\1hKJlunY6\u0014\u0007i\t\u0019\tE\u0002e\u0003\u000bK1!a\"P\u0005EaunZ\"mK\u0006tWM]'b]\u0006<WM]\u0001\bY><G)\u001b:t!\u0015\ti)!(h\u001d\u0011\ty)!'\u000f\t\u0005E\u0015qS\u0007\u0003\u0003'S1!!&T\u0003\u0019a$o\\8u}%\t\u0001,C\u0002\u0002\u001c^\u000bq\u0001]1dW\u0006<W-\u0003\u0003\u0002 \u0006\u0005&aA*fc*\u0019\u00111T,\n\t\u0005%\u0015QQ\u0001\u0005Y><7\u000f\u0005\u0004]\u0003SC\u0018QV\u0005\u0004\u0003Wk&\u0001\u0002)p_2\u00042\u0001ZAX\u0013\r\t\tl\u0014\u0002\u000b+:Lg-[3e\u0019><\u0017\u0002BAS\u0003\u000b\u000bA\u0003\\8h\t&\u0014h)Y5mkJ,7\t[1o]\u0016d\u0007\u0003BA\u0013\u0003sKA!a/\u0002(\t!Bj\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2LA!!.\u0002\u0006RA\u0011\u0011YAc\u0003\u000f\fI\rE\u0002\u0002Dji\u0011\u0001\u0001\u0005\b\u0003\u0013s\u0002\u0019AAF\u0011\u001d\t)K\ba\u0001\u0003OCq!!.\u001f\u0001\u0004\t9,A\u000bbY2\u001cE.Z1oKJ\u001c\u0005.Z2la>Lg\u000e^:\u0016\u0005\u0005=\u0007cBAi\u00033D\u0018q\u000f\b\u0005\u0003'\f)\u000eE\u0002\u0002\u0012^K1!a6X\u0003\u0019\u0001&/\u001a3fM&!\u0011QOAn\u0015\r\t9nV\u0001\u0012kB$\u0017\r^3DQ\u0016\u001c7\u000e]8j]R\u001cH\u0003CAq\u0003O\fY/a?\u0011\u0007Y\u000b\u0019/C\u0002\u0002f^\u0013A!\u00168ji\"1\u0011\u0011\u001e\u0011A\u0002\u001d\fq\u0001Z1uC\u0012K'\u000fC\u0005\u0002n\u0002\u0002\n\u00111\u0001\u0002p\u00061\u0002/\u0019:uSRLwN\u001c+p+B$\u0017\r^3Pe\u0006#G\rE\u0003W\u0003c\f)0C\u0002\u0002t^\u0013aa\u00149uS>t\u0007C\u0002,\u0002xb\f9(C\u0002\u0002z^\u0013a\u0001V;qY\u0016\u0014\u0004\"CA\u007fAA\u0005\t\u0019AA\u0000\u0003E\u0001\u0018M\u001d;ji&|g\u000eV8SK6|g/\u001a\t\u0005-\u0006E\b0A\u000eva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$C-\u001a4bk2$HEM\u000b\u0003\u0005\u000bQC!a<\u0003\b-\u0012!\u0011\u0002\t\u0005\u0005\u0017\u0011)\"\u0004\u0002\u0003\u000e)!!q\u0002B\t\u0003%)hn\u00195fG.,GMC\u0002\u0003\u0014]\u000b!\"\u00198o_R\fG/[8o\u0013\u0011\u00119B!\u0004\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000eva\u0012\fG/Z\"iK\u000e\\\u0007o\\5oiN$C-\u001a4bk2$HeM\u000b\u0003\u0005;QC!a@\u0003\b\u0005AA/Z1s\t><h\u000e\u0006\u0002\u0002b\"\u001a1E!\n\u0011\t\t\u001d\"QG\u0007\u0003\u0005SQAAa\u000b\u0003.\u0005\u0019\u0011\r]5\u000b\t\t=\"\u0011G\u0001\bUV\u0004\u0018\u000e^3s\u0015\r\u0011\u0019d`\u0001\u0006UVt\u0017\u000e^\u0005\u0005\u0005o\u0011ICA\u0005BMR,'/R1dQ\u0006Y2/\u001a;va&s7M]3bg&tw\r\\=GS2$\b.\u001f'pON$\u0002\"a*\u0003>\t\r#q\t\u0005\b\u0005\u007f!\u0003\u0019\u0001B!\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0006\u0003\u001b\u000bi\n\u001f\u0005\b\u0005\u000b\"\u0003\u0019AA(\u0003=\u0019H/\u0019:u\u001dVl')\u0019;dQ\u0016\u001c\bb\u0002B%I\u0001\u0007\u0011qJ\u0001\u000fE\u0006$8\r[%oGJ,W.\u001a8u\u00031\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><G\u000b\u001b:poN,\u0005pY3qi&|g\u000eK\u0002&\u0005\u001f\u0002BAa\n\u0003R%!!1\u000bB\u0015\u0005\u0011!Vm\u001d;\u0002qQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001e\u0014V\r^;s]NdunZ,ji\"$\u0015N\u001d;jKN$(+\u0019;j_\"\u001aaEa\u0014\u0002sQ,7\u000f^$sC\n4\u0015\u000e\u001c;iS\u0016\u001cHoQ8na\u0006\u001cG/\u001a3M_\u001eLuM\\8sKN,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3a\nB(\u0003a\"Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001c\u0018J\u001c)s_\u001e\u0014Xm]:QCJ$\u0018\u000e^5p]ND3\u0001\u000bB(\u0003Q#Xm\u001d;He\u0006\u0014g)\u001b7uQ&,7\u000f^\"p[B\f7\r^3e\u0019><\u0017j\u001a8pe\u0016\u001c(i\u001c;i\u0013:\u0004&o\\4sKN\u001c\b+\u0019:uSRLwN\\:B]\u0012,fn\u00197fC:\f'\r\\3QCJ$\u0018\u000e^5p]ND3!\u000bB(\u0003%\"Xm\u001d;ESJ$\u0018p\u00144gg\u0016$(+Z:fi&3G*\u0019:hKJ$\u0006.\u00198F]\u0012|eMZ:fi\"\u001a!Fa\u0014\u0002YQ,7\u000f\u001e#jeRLxJ\u001a4tKR\u0014Vm]3u\u0013\u001a\u001cV.\u00197mKJ$\u0006.\u00198Ti\u0006\u0014Ho\u00144gg\u0016$\bfA\u0016\u0003P\u0005\u0019D/Z:u\u0019><7\u000b^1si>3gm]3u\u0019\u0006\u0014x-\u001a:UQ\u0006t\u0017i\u0019;jm\u0016\u001cVmZ7f]R\u0014\u0015m]3PM\u001a\u001cX\r\u001e\u0015\u0004Y\t=\u0013\u0001\r;fgR$\u0015N\u001d;z\u001f\u001a47/\u001a;MCJ<WM\u001d+iC:\f5\r^5wKN+w-\\3oi\n\u000b7/Z(gMN,G\u000fK\u0002.\u0005\u001f\nA\t^3ti2{wm],ji\"\u001cVmZ7f]R\u001cHk\u001c#fY\u0016$Xm\u00155pk2$gj\u001c;D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=EK2,G/\u001a'pOND3A\fB(\u0003!#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u000e{W\u000e]1di\u0012+G.\u001a;f\u0019><7\u000fK\u00020\u0005\u001f\n!\t^3ti2{wm],ji\"\u001cVmZ7f]R\u001cHk\u001c#fY\u0016$Xm\u00155pk2$7i\u001c8tS\u0012,'o\u00117fC:,\b\u000fU8mS\u000eL8i\\7qC\u000e$Hj\\4tQ\r\u0001$qJ\u0001,i\u0016\u001cH\u000fT8hgVsG-\u001a:DY\u0016\fg.\u001e9J]\u0016d\u0017nZ5cY\u00164uN]\"p[B\f7\r^5p]\"\u001a\u0011Ga\u0014\u0002_Q,7\u000f^+qI\u0006$Xm\u00115fG.\u0004x.\u001b8ugNCw.\u001e7e\u0003\u0012$wJ\u001a4tKR$v\u000eU1si&$\u0018n\u001c8)\u0007I\u0012y%\u0001\u0018uKN$X\u000b\u001d3bi\u0016\u001c\u0005.Z2la>Lg\u000e^:TQ>,H\u000e\u001a*f[>4X\rU1si&$\u0018n\u001c8ECR\f\u0007fA\u001a\u0003P\u0005iC/Z:u\u0011\u0006tG\r\\3M_\u001e$\u0015N\u001d$bS2,(/Z*i_VdGMU3n_Z,G)\u001b:B]\u0012$\u0015\r^1)\u0007Q\u0012y%A\u0017uKN$X*Y=cKR\u0013XO\\2bi\u0016\u001c\u0005.Z2la>Lg\u000e^*i_VdG\r\u0016:v]\u000e\fG/\u001a#bi\u0006D3!\u000eB(\u0003q\"Xm\u001d;BYR,'o\u00115fG.\u0004x.\u001b8u\t&\u00148\u000b[8vY\u0012\u0014V-\\8wK\u0012\u000bG/Y%o'J\u001cG)\u001b:B]\u0012\fE\rZ%o\u001d\u0016<H)\u001b:)\u0007Y\u0012y%\u0001\u0015uKN$8i\u001c8dkJ\u0014XM\u001c;M_\u001e\u001cE.Z1okB\fe\u000e\u001a'pOR\u0013XO\\2bi&|g\u000eK\u00028\u0005\u001f\n\u0001\u0006^3ti\u000e{gnY;se\u0016tG\u000fT8h\u00072,\u0017M\\;q\u0003:$Gk\u001c9jG\u0012+G.\u001a;j_:D3\u0001\u000fB(\u0003\t#Xm\u001d;M_\u001e\u001cx+\u001b;i'\u0016<W.\u001a8ugR{G)\u001a7fi\u0016\u001c\u0006n\\;mI:{GoQ8og&$WM]+oG2,\u0017M\\1cY\u0016\u0004\u0016M\u001d;ji&|gn\u001d\u0015\u0004s\t=\u0013a\u0007;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s\u001d>tW\rK\u0002;\u0005\u001f\n\u0011\u0005^3ti\u000ecW-\u00198bE2,wJ\u001a4tKR\u001c\u0018i\u0019;jm\u0016\u001cVmZ7f]RD3a\u000fB(\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'\u000fV5nK\"\u001aAHa\u0014\u0002AQ,7\u000f^\"mK\u0006t\u0017M\u00197f\u001f\u001a47/\u001a;t\r>\u00148\u000b[8siRKW.\u001a\u0015\u0004{\t=\u0013\u0001\u000b;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OT3fIN\u001c\u0005.Z2la>Lg\u000e\u001e*fg\u0016$\bf\u0001 \u0003P\u0005QC/Z:u+:$WmY5eK\u0012$&/\u00198tC\u000e$\u0018n\u001c8bY\u0012\u000bG/\u0019(pi\u000ecW-\u00198bE2,\u0007fA \u0003P\u0005\u0001B/Z:u\t>tWm\u00117fC:Lgn\u001a\u0015\u0004\u0001\n=\u0013\u0001\u0005;fgR$uN\\3EK2,G/\u001b8hQ\r\t%qJ\u00010i\u0016\u001cHo\u00115fG.\u0004x.\u001b8u+B$\u0017\r^3e\r>\u0014\u0018J\u001c<bY&$wJ\u001a4tKRtun\u00117fC:Lgn\u001a\u0015\u0004\u0005\n=\u0013\u0001\r;fgR\u001c\u0005.Z2la>Lg\u000e^+qI\u0006$X\r\u001a$pe&sg/\u00197jI>3gm]3u\u001d>$8+\u001a7fGR,G\rK\u0002D\u0005\u001f\nAc\u0019:fCR,7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014H\u0003BAB\u0005#Da\u0001\u0015#A\u0002\u00055\u0016\u0001G2sK\u0006$Xm\u00117fC:,'/T1oC\u001e,'/T8dWR!\u0011\u0011\u0019Bl\u0011\u001d\u0011I.\u0012a\u0001\u0003O\u000bA\u0001]8pY\u0006I1M]3bi\u0016dun\u001a\u000b\t\u0003[\u0013yNa9\u0003n\"9!\u0011\u001d$A\u0002\u0005=\u0013aC:fO6,g\u000e^*ju\u0016DqA!:G\u0001\u0004\u00119/A\u0007dY\u0016\fg.\u001e9Q_2L7-\u001f\t\u0005\u0003#\u0014I/\u0003\u0003\u0003l\u0006m'AB*ue&tw\rC\u0004w\rB\u0005\t\u0019\u0001=\u0002'\r\u0014X-\u0019;f\u0019><G\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\tM(f\u0001=\u0003\b\u0005Y2M]3bi\u0016dun\u001e*fi\u0016tG/[8o\u0019><7i\u001c8gS\u001e$b!a\t\u0003z\nm\bb\u0002Bq\u0011\u0002\u0007\u0011q\n\u0005\b\u0005KD\u0005\u0019\u0001Bt\u000319(/\u001b;f%\u0016\u001cwN\u001d3t))\t\to!\u0001\u0004\u0004\r\u001d11\u0002\u0005\u0007!&\u0003\r!!,\t\u000f\r\u0015\u0011\n1\u0001\u0002P\u0005Qa.^7CCR\u001c\u0007.Z:\t\u000f\r%\u0011\n1\u0001\u0002P\u0005y!/Z2pe\u0012\u001c\b+\u001a:CCR\u001c\u0007\u000eC\u0004\u0004\u000e%\u0003\r!a\u0014\u0002#\t\fGo\u00195fgB+'oU3h[\u0016tG/A\u0007baB,g\u000e\u001a*fG>\u0014Hm\u001d\u000b\u0007\u0003C\u001c\u0019b!\u0006\t\rAS\u0005\u0019AAW\u0011\u001d\u00199B\u0013a\u0001\u0003\u001f\n!B\\;n%\u0016\u001cwN\u001d3t\u0003\u001di\u0017m[3M_\u001e$b!!,\u0004\u001e\r\u0005\u0002\u0002CB\u0010\u0017B\u0005\t\u0019A4\u0002\u0007\u0011L'\u000fC\u0004\u0004$-\u0003\r!a\t\u0002\r\r|gNZ5h\u0003Ei\u0017m[3M_\u001e$C-\u001a4bk2$H%M\u000b\u0003\u0007SQ3a\u001aB\u0004\u0003\u001d\u0011XmY8sIN$\u0002ba\f\u0004<\r}21\t\t\u0005\u0007c\u00199$\u0004\u0002\u00044)\u00191Q\u0007>\u0002\rI,7m\u001c:e\u0013\u0011\u0019Ida\r\u0003\u001b5+Wn\u001c:z%\u0016\u001cwN\u001d3t\u0011\u001d\u0019i$\u0014a\u0001\u0003\u001f\n1a[3z\u0011\u001d\u0019\t%\u0014a\u0001\u0003\u001f\nQA^1mk\u0016Dqa!\u0012N\u0001\u0004\t9(A\u0005uS6,7\u000f^1na\u0002")
public class LogCleanerManagerTest
implements Logging {
    private final File tmpDir = TestUtils.tempDirectory(null, null);
    private final File tmpDir2 = TestUtils.tempDirectory(null, null);
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final File logDir2 = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final TopicPartition topicPartition = new TopicPartition("log", 0);
    private final TopicPartition topicPartition2 = new TopicPartition("log2", 0);
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final int offset;
    private final ProducerStateManagerConfig producerStateManagerConfig;
    private final scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$((Logging)this, (String)msg);
    }

    public void trace(Function0<String> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$((Logging)this, msg, e);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$((Logging)this, msg, e);
    }

    public void info(Function0<String> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$((Logging)this, msg, e);
    }

    public void warn(Function0<String> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$((Logging)this, msg, e);
    }

    public void error(Function0<String> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$((Logging)this, msg, e);
    }

    public void fatal(Function0<String> msg) {
        Logging.fatal$((Logging)this, msg);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$((Logging)this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File tmpDir2() {
        return this.tmpDir2;
    }

    public File logDir() {
        return this.logDir;
    }

    public File logDir2() {
        return this.logDir2;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public TopicPartition topicPartition2() {
        return this.topicPartition2;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public int offset() {
        return this.offset;
    }

    public ProducerStateManagerConfig producerStateManagerConfig() {
        return this.producerStateManagerConfig;
    }

    public scala.collection.mutable.Map<TopicPartition, Object> cleanerCheckpoints() {
        return this.cleanerCheckpoints;
    }

    @AfterEach
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    private Pool<TopicPartition, UnifiedLog> setupIncreasinglyFilthyLogs(scala.collection.immutable.Seq<TopicPartition> partitions, int startNumBatches, int batchIncrement) {
        Pool logs = new Pool((Option)None$.MODULE$);
        IntRef numBatches = IntRef.create((int)startNumBatches);
        partitions.foreach((Function1 & Serializable)tp -> {
            LogCleanerManagerTest.$anonfun$setupIncreasinglyFilthyLogs$1(this, logs, numBatches, batchIncrement, tp);
            return BoxedUnit.UNIT;
        });
        return logs;
    }

    @Test
    public void testGrabFilthiestCompactedLogThrowsException() {
        TopicPartition tp = new TopicPartition("A", 1);
        int logSegmentSize = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2).sizeInBytes() * 10;
        int logSegmentsCount = 2;
        File tpDir = new File(this.logDir(), "A-1");
        Files.createDirectories(tpDir.toPath(), new FileAttribute[0]);
        LogDirFailureChannel logDirFailureChannel = new LogDirFailureChannel(10);
        LogConfig config = this.createLowRetentionLogConfig(logSegmentSize, "compact");
        int maxTransactionTimeoutMs = 300000;
        int producerIdExpirationCheckIntervalMs = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogSegments segments = new LogSegments(tp);
        Option leaderEpochCache = UnifiedLog$.MODULE$.maybeCreateLeaderEpochCache(tpDir, this.topicPartition(), logDirFailureChannel, config.recordVersion(), "");
        ProducerStateManager producerStateManager = new ProducerStateManager(this.topicPartition(), tpDir, maxTransactionTimeoutMs, this.producerStateManagerConfig(), (Time)this.time());
        LoadedLogOffsets offsets = new LogLoader(tpDir, tp, config, (Scheduler)this.time().scheduler, (Time)this.time(), logDirFailureChannel, true, segments, 0L, 0L, OptionConverters.RichOptionForJava8$.MODULE$.asJava$extension(OptionConverters$.MODULE$.RichOptionForJava8(leaderEpochCache)), producerStateManager, new ConcurrentHashMap(), false).load();
        LocalLog localLog = new LocalLog(tpDir, config, segments, offsets.recoveryPoint, offsets.nextOffsetMetadata, (Scheduler)this.time().scheduler, (Time)this.time(), tp, logDirFailureChannel);
        public class Kafka_log_LogCleanerManagerTest$LogMock$1
        extends UnifiedLog {
            public Collection<Long> getFirstBatchTimestampForSegments(Collection<LogSegment> segments) {
                throw new IllegalStateException("Error!");
            }

            public Kafka_log_LogCleanerManagerTest$LogMock$1(LogCleanerManagerTest $outer, LoadedLogOffsets offsets$1, LocalLog localLog$1, int producerIdExpirationCheckIntervalMs$1, Option leaderEpochCache$1, ProducerStateManager producerStateManager$1) {
                super(offsets$1.logStartOffset, localLog$1, new BrokerTopicStats(Optional.empty()), producerIdExpirationCheckIntervalMs$1, leaderEpochCache$1, producerStateManager$1, (Option)None$.MODULE$, true, false, LogOffsetsListener.NO_OP_OFFSETS_LISTENER);
            }
        }
        Kafka_log_LogCleanerManagerTest$LogMock$1 log = new Kafka_log_LogCleanerManagerTest$LogMock$1(null, offsets, localLog, producerIdExpirationCheckIntervalMs, leaderEpochCache, producerStateManager);
        this.writeRecords(log, logSegmentsCount * 2, 10, 2);
        Pool logsPool = new Pool((Option)None$.MODULE$);
        logsPool.put((Object)tp, (Object)log);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logsPool);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)1L));
        LogCleaningException thrownException = (LogCleaningException)Assertions.assertThrows(LogCleaningException.class, () -> cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get());
        Assertions.assertEquals((Object)((Object)log), (Object)thrownException.log());
        Assertions.assertTrue((boolean)(thrownException.getCause() instanceof IllegalStateException));
    }

    @Test
    public void testGrabFilthiestCompactedLogReturnsLogWithDirtiestRatio() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp2, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get((Object)tp2)).dir().getParent(), tp2);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresInProgressPartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition());
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.log().topicPartition());
    }

    @Test
    public void testGrabFilthiestCompactedLogIgnoresBothInProgressPartitionsAndUncleanablePartitions() {
        TopicPartition tp0 = new TopicPartition("wishing-well", 0);
        TopicPartition tp1 = new TopicPartition("wishing-well", 1);
        TopicPartition tp2 = new TopicPartition("wishing-well", 2);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)new .colon.colon((Object)tp2, (List)Nil$.MODULE$)));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        partitions.foreach((Function1 & Serializable)partition -> this.cleanerCheckpoints().put(partition, (Object)BoxesRunTime.boxToLong((long)20L)));
        cleanerManager.setCleaningState(tp2, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.markPartitionUncleanable(((UnifiedLog)logs.get((Object)tp1)).dir().getParent(), tp1);
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetResetIfLargerThanEndOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)200L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)0L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testDirtyOffsetResetIfSmallerThanStartOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((long)10L, (long)filthiestLog.firstDirtyOffset());
    }

    @Test
    public void testLogStartOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        UnifiedLog log = this.createLog(2048, "compact", tp);
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        log.maybeIncrementLogStartOffset(2L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)0L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testDirtyOffsetLargerThanActiveSegmentBaseOffset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool logs = new Pool((Option)None$.MODULE$);
        UnifiedLog log = this.createLog(2048, "compact", tp);
        logs.put((Object)tp, (Object)log);
        this.appendRecords(log, 3);
        this.appendRecords(log, 3);
        Assertions.assertEquals((int)1, (int)log.logSegments().size());
        Assertions.assertEquals((long)0L, (long)log.activeSegment().baseOffset());
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock((Pool<TopicPartition, UnifiedLog>)logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)3L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), null, CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        int readyToDelete = this.createCleanerManager(log).deletableLogs().size();
        Assertions.assertEquals((int)1, (int)readyToDelete, (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testLogsUnderCleanupIneligibleForCompaction() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.roll(log.roll$default$1());
        log.appendAsLeader(records, 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.updateHighWatermark(2L);
        Iterable deletableLog = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog.size(), (String)"should have 1 logs ready to be deleted");
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(log.config().segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.long2Long(log.config().retentionMs));
        logProps.put("cleanup.policy", "compact");
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps);
        log.updateConfig(config);
        Option cleanable = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)0, (int)Option$.MODULE$.option2Iterable(cleanable).size(), (String)"should have 0 logs ready to be compacted");
        cleanerManager.resumeCleaning((Iterable)deletableLog.map((Function1 & Serializable)x$2 -> (TopicPartition)x$2._1()));
        Option cleanable2 = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((int)1, (int)Option$.MODULE$.option2Iterable(cleanable2).size(), (String)"should have 1 logs ready to be compacted");
        logProps.put("cleanup.policy", "delete");
        LogConfig config2 = new LogConfig((Map)logProps);
        log.updateConfig(config2);
        Iterable deletableLog2 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)0, (int)deletableLog2.size(), (String)"should have 0 logs ready to be deleted");
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)((LogToClean)cleanable2.get()).topicPartition(), (List)Nil$.MODULE$));
        Iterable deletableLog3 = cleanerManager.pauseCleaningForNonCompactedPartitions();
        Assertions.assertEquals((int)1, (int)deletableLog3.size(), (String)"should have 1 logs ready to be deleted");
    }

    @Test
    public void testUpdateCheckpointsShouldAddOffsetToPartition() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertNotEquals((Object)BoxesRunTime.boxToInteger((int)this.offset()), (Object)cleanerManager.allCleanerCheckpoints().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcI.sp & Serializable)() -> 0));
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testUpdateCheckpointsShouldRemovePartitionData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        File x$1 = this.logDir();
        Option x$2 = Option$.MODULE$.apply((Object)this.topicPartition());
        Option x$3 = cleanerManager.updateCheckpoints$default$2();
        cleanerManager.updateCheckpoints(x$1, x$3, x$2);
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testHandleLogDirFailureShouldRemoveDirAndData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        cleanerManager.updateCheckpoints(this.logDir2(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition2(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        cleanerManager.handleLogDirFailure(this.logDir().getAbsolutePath());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition2())));
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testMaybeTruncateCheckpointShouldTruncateData() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        long lowerOffset = 1L;
        long higherOffset = 1000L;
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), higherOffset);
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.maybeTruncateCheckpoint(this.logDir(), this.topicPartition(), lowerOffset);
        Assertions.assertEquals((long)lowerOffset, (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
    }

    @Test
    public void testAlterCheckpointDirShouldRemoveDataInSrcDirAndAddInNewDir() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.updateCheckpoints(this.logDir(), Option$.MODULE$.apply((Object)new Tuple2((Object)this.topicPartition(), (Object)BoxesRunTime.boxToLong((long)this.offset()))), cleanerManager.updateCheckpoints$default$3());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.alterCheckpointDir(this.topicPartition(), this.logDir(), this.logDir2());
        Assertions.assertEquals((long)this.offset(), (long)BoxesRunTime.unboxToLong((Object)cleanerManager.allCleanerCheckpoints().apply((Object)this.topicPartition())));
        cleanerManager.handleLogDirFailure(this.logDir2().getAbsolutePath());
        Assertions.assertFalse((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndLogTruncation() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortAndPauseCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)new .colon.colon((Object)log.topicPartition(), (List)Nil$.MODULE$));
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$3 -> (TopicPartition)x$3._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testConcurrentLogCleanupAndTopicDeletion() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Iterable pausedPartitions = cleanerManager.pauseCleaningForNonCompactedPartitions();
        cleanerManager.abortCleaning(log.topicPartition());
        cleanerManager.resumeCleaning((Iterable)pausedPartitions.map((Function1 & Serializable)x$4 -> (TopicPartition)x$4._1()));
        Assertions.assertEquals((Object)None$.MODULE$, (Object)cleanerManager.cleaningState(log.topicPartition()));
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderUncleanablePartitions() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        cleanerManager.markPartitionUncleanable(log.dir().getParent(), this.topicPartition());
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assertions.assertEquals((int)0, (int)readyToDelete, (String)"should have 0 logs ready to be deleted");
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        log.updateHighWatermark(50L);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.highWatermark(), (long)log.lastStableOffset(), (String)"The high watermark equals the last stable offset as no transactions are in progress");
        Assertions.assertEquals((long)log.lastStableOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset is bounded by the last stable offset.");
    }

    @Test
    public void testCleanableOffsetsActiveSegment() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the active segment.");
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep((long)(compactionLag + 1));
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t1), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        log.updateHighWatermark(log.logEndOffset());
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)activeSegAtT0.baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with the second block of log entries.");
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), t0), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        log.updateHighWatermark(log.logEndOffset());
        this.time().sleep((long)(compactionLag + 1));
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)0L));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)lastCleanOffset, this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset(), (String)"The first cleanable offset starts at the beginning of the log.");
        Assertions.assertEquals((long)log.activeSegment().baseOffset(), (long)cleanableOffsets.firstUncleanableDirtyOffset(), (String)"The first uncleanable offset begins with active segment.");
    }

    @Test
    public void testCleanableOffsetsNeedsCheckpointReset() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(10L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Some lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)15L));
        Assertions.assertFalse((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset should not be reset if valid");
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if less than log start offset");
        lastCleanOffset = new Some((Object)BoxesRunTime.boxToLong((long)25L));
        Assertions.assertTrue((boolean)LogCleanerManager$.MODULE$.cleanableOffsets((UnifiedLog)logs.get((Object)tp), (Option)lastCleanOffset, this.time().milliseconds()).forceUpdateCheckpoint(), (String)"Checkpoint offset needs to be reset if greater than log end offset");
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testUndecidedTransactionalDataNotCleanable() {
        void withEndTransactionMarker_marker;
        void withTransactionalRecords_records;
        void withTransactionalRecords_baseSequence;
        void withTransactionalRecords_records2;
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        logProps.put("min.compaction.lag.ms", Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        long producerId = 15L;
        short producerEpoch = (short)0;
        int sequence = 0;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "1".getBytes(), "a".getBytes()), new SimpleRecord(this.time().milliseconds(), "2".getBytes(), "b".getBytes())};
        CompressionType withTransactionalRecords_compressionType = CompressionType.NONE;
        Object var11_10 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)sequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        SimpleRecord[] simpleRecordArray2 = new SimpleRecord[]{new SimpleRecord(this.time().milliseconds(), "3".getBytes(), "c".getBytes())};
        int n = sequence + 2;
        CompressionType withTransactionalRecords_compressionType2 = CompressionType.NONE;
        Object var13_13 = null;
        simpleRecordArray2 = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)2, (long)0L, (CompressionType)withTransactionalRecords_compressionType2, (TimestampType)TimestampType.CREATE_TIME, (long)producerId, (short)producerEpoch, (int)withTransactionalRecords_baseSequence, (int)-1, (boolean)true, (SimpleRecord[])withTransactionalRecords_records), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(3L);
        this.time().sleep((long)(compactionLag + 1));
        OffsetsToClean cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        EndTransactionMarker endTransactionMarker = new EndTransactionMarker(ControlRecordType.ABORT, 15);
        long withEndTransactionMarker_timestamp = this.time().milliseconds();
        endTransactionMarker = null;
        log.appendAsLeader(MemoryRecords.withEndTransactionMarker((long)0L, (long)withEndTransactionMarker_timestamp, (int)-1, (long)producerId, (short)producerEpoch, (EndTransactionMarker)withEndTransactionMarker_marker), 0, AppendOrigin.COORDINATOR, log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.roll(log.roll$default$1());
        log.updateHighWatermark(4L);
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)3L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
        this.time().sleep((long)(compactionLag + 1));
        cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, (Option)new Some((Object)BoxesRunTime.boxToLong((long)0L)), this.time().milliseconds());
        Assertions.assertEquals((long)0L, (long)cleanableOffsets.firstDirtyOffset());
        Assertions.assertEquals((long)4L, (long)cleanableOffsets.firstUncleanableDirtyOffset());
    }

    @Test
    public void testDoneCleaning() {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig.fromProps((Map)this.logConfig().originals(), (Properties)logProps);
        File x$2 = this.logDir();
        UnifiedLog log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.appendAsLeader(this.records((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        }
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneCleaning(this.topicPartition(), log.dir(), 1L));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningInProgress$.MODULE$);
        long endOffset = 1L;
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(this.topicPartition()).isEmpty());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
        Assertions.assertEquals((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)), (Object)cleanerManager.allCleanerCheckpoints().get((Object)this.topicPartition()));
        cleanerManager.setCleaningState(this.topicPartition(), (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneCleaning(this.topicPartition(), log.dir(), endOffset);
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(this.topicPartition()).get());
        Assertions.assertTrue((boolean)cleanerManager.allCleanerCheckpoints().contains((Object)this.topicPartition()));
    }

    @Test
    public void testDoneDeleting() {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), CompressionType.NONE, -1L, (byte)2);
        UnifiedLog log = this.createLog(records.sizeInBytes() * 5, "compact,delete", this.createLog$default$3());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        TopicPartition tp = new TopicPartition("log", 0);
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)new LogCleaningPaused(1));
        Assertions.assertThrows(IllegalStateException.class, () -> cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$)));
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningInProgress$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertTrue((boolean)cleanerManager.cleaningState(tp).isEmpty());
        cleanerManager.setCleaningState(tp, (LogCleaningState)LogCleaningAborted$.MODULE$);
        cleanerManager.doneDeleting((Iterable)new .colon.colon((Object)tp, (List)Nil$.MODULE$));
        Assertions.assertEquals((Object)new LogCleaningPaused(1), (Object)cleanerManager.cleaningState(tp).get());
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNoCleaning() {
        TopicPartition tp = new TopicPartition("foo", 0);
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)new .colon.colon((Object)tp, (List)Nil$.MODULE$), 20, 5);
        ((UnifiedLog)logs.get((Object)tp)).maybeIncrementLogStartOffset(20L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp, (Object)BoxesRunTime.boxToLong((long)15L));
        Option filthiestLog = cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2());
        Assertions.assertEquals((Object)None$.MODULE$, (Object)filthiestLog, (String)"Log should not be selected for cleaning");
        Assertions.assertEquals((long)20L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp)), (String)"Unselected log should have checkpoint offset updated");
    }

    @Test
    public void testCheckpointUpdatedForInvalidOffsetNotSelected() {
        TopicPartition tp0 = new TopicPartition("foo", 0);
        TopicPartition tp1 = new TopicPartition("foo", 1);
        .colon.colon partitions = new .colon.colon((Object)tp0, (List)new .colon.colon((Object)tp1, (List)Nil$.MODULE$));
        Pool<TopicPartition, UnifiedLog> logs = this.setupIncreasinglyFilthyLogs((scala.collection.immutable.Seq<TopicPartition>)partitions, 20, 5);
        ((UnifiedLog)logs.get((Object)tp0)).maybeIncrementLogStartOffset(15L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        LogCleanerManagerMock cleanerManager = this.createCleanerManagerMock(logs);
        this.cleanerCheckpoints().put((Object)tp0, (Object)BoxesRunTime.boxToLong((long)10L));
        this.cleanerCheckpoints().put((Object)tp1, (Object)BoxesRunTime.boxToLong((long)5L));
        LogToClean filthiestLog = (LogToClean)cleanerManager.grabFilthiestCompactedLog((Time)this.time(), cleanerManager.grabFilthiestCompactedLog$default$2()).get();
        Assertions.assertEquals((Object)tp1, (Object)filthiestLog.topicPartition(), (String)"Dirtier log should be selected");
        Assertions.assertEquals((long)15L, (long)BoxesRunTime.unboxToLong((Object)this.cleanerCheckpoints().apply((Object)tp0)), (String)"Unselected log should have checkpoint offset updated");
    }

    private LogCleanerManager createCleanerManager(UnifiedLog log) {
        Pool logs = new Pool((Option)None$.MODULE$);
        logs.put((Object)this.topicPartition(), (Object)log);
        return new LogCleanerManager((Seq)new .colon.colon((Object)this.logDir(), (List)new .colon.colon((Object)this.logDir2(), (List)Nil$.MODULE$)), logs, null);
    }

    private LogCleanerManagerMock createCleanerManagerMock(Pool<TopicPartition, UnifiedLog> pool) {
        return new LogCleanerManagerMock((scala.collection.immutable.Seq<File>)new .colon.colon((Object)this.logDir(), (List)Nil$.MODULE$), pool, null);
    }

    private UnifiedLog createLog(int segmentSize, String cleanupPolicy, TopicPartition topicPartition) {
        LogConfig config = this.createLowRetentionLogConfig(segmentSize, cleanupPolicy);
        File partitionDir = new File(this.logDir(), LocalLog$.MODULE$.logDirName(topicPartition));
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats(Optional.empty());
        ProducerStateManagerConfig x$9 = this.producerStateManagerConfig();
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        return UnifiedLog$.MODULE$.apply(partitionDir, config, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, x$10, x$11, x$14, (Option)x$12, true, x$15, x$16, x$17);
    }

    private TopicPartition createLog$default$3() {
        return new TopicPartition("log", 0);
    }

    private LogConfig createLowRetentionLogConfig(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put("segment.bytes", Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put("retention.ms", Predef$.MODULE$.int2Integer(1));
        logProps.put("cleanup.policy", cleanupPolicy);
        logProps.put("min.cleanable.dirty.ratio", Predef$.MODULE$.double2Double(0.05));
        return new LogConfig((Map)logProps);
    }

    private void writeRecords(UnifiedLog log, int numBatches, int recordsPerBatch, int batchesPerSegment) {
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numBatches).foreach((Function1 & Serializable)i -> LogCleanerManagerTest.$anonfun$writeRecords$1(this, log, recordsPerBatch, batchesPerSegment, BoxesRunTime.unboxToInt((Object)i)));
        log.roll(log.roll$default$1());
    }

    /*
     * WARNING - void declaration
     */
    private void appendRecords(UnifiedLog log, int numRecords) {
        void withRecords_records;
        void withRecords_timestampType;
        long startOffset = log.logEndOffset();
        long endOffset = startOffset + (long)numRecords;
        LongRef lastTimestamp = LongRef.create((long)0L);
        IndexedSeq records = (IndexedSeq)new RichLong(Predef$.MODULE$.longWrapper(startOffset)).until((Object)BoxesRunTime.boxToLong((long)endOffset)).map((Function1 & Serializable)offset -> LogCleanerManagerTest.$anonfun$appendRecords$1(this, endOffset, lastTimestamp, BoxesRunTime.unboxToLong((Object)offset)));
        SimpleRecord[] simpleRecordArray = (SimpleRecord[])records.toArray(ClassTag$.MODULE$.apply(SimpleRecord.class));
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        timestampType = null;
        Object var9_8 = null;
        simpleRecordArray = null;
        log.appendAsLeader(MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records), 1, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6());
        log.maybeIncrementHighWatermark(log.logEndOffsetMetadata());
    }

    private UnifiedLog makeLog(File dir, LogConfig config) {
        MockScheduler x$5 = this.time().scheduler;
        MockTime x$6 = this.time();
        BrokerTopicStats x$7 = new BrokerTopicStats(Optional.empty());
        ProducerStateManagerConfig x$9 = this.producerStateManagerConfig();
        int x$10 = Defaults$.MODULE$.ProducerIdExpirationCheckIntervalMs();
        LogDirFailureChannel x$11 = new LogDirFailureChannel(10);
        None$ x$12 = None$.MODULE$;
        boolean x$14 = true;
        ConcurrentHashMap x$15 = new ConcurrentHashMap();
        boolean x$16 = false;
        LogOffsetsListener x$17 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        return UnifiedLog$.MODULE$.apply(dir, config, 0L, 0L, (Scheduler)x$5, x$7, (Time)x$6, 300000, x$9, x$10, x$11, x$14, (Option)x$12, true, x$15, x$16, x$17);
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    /*
     * WARNING - void declaration
     */
    private MemoryRecords records(int key, int value, long timestamp) {
        void withRecords_records;
        void withRecords_timestampType;
        SimpleRecord[] simpleRecordArray = new SimpleRecord[]{new SimpleRecord(timestamp, Integer.toString(key).getBytes(), Integer.toString(value).getBytes())};
        CompressionType withRecords_compressionType = CompressionType.NONE;
        byte withRecords_magic = 2;
        TimestampType timestampType = TimestampType.CREATE_TIME;
        long withRecords_initialOffset = 0L;
        return MemoryRecords.withRecords((byte)withRecords_magic, (long)withRecords_initialOffset, (CompressionType)withRecords_compressionType, (TimestampType)withRecords_timestampType, (long)-1L, (short)-1, (int)-1, (int)-1, (boolean)false, (SimpleRecord[])withRecords_records);
    }

    public static final /* synthetic */ void $anonfun$setupIncreasinglyFilthyLogs$1(LogCleanerManagerTest $this, Pool logs$1, IntRef numBatches$1, int batchIncrement$1, TopicPartition tp) {
        UnifiedLog log = $this.createLog(2048, "compact", tp);
        logs$1.put((Object)tp, (Object)log);
        $this.writeRecords(log, numBatches$1.elem, 1, 5);
        numBatches$1.elem += batchIncrement$1;
    }

    public static final /* synthetic */ Object $anonfun$writeRecords$1(LogCleanerManagerTest $this, UnifiedLog log$2, int recordsPerBatch$1, int batchesPerSegment$1, int i) {
        $this.appendRecords(log$2, recordsPerBatch$1);
        if (i % batchesPerSegment$1 == 0) {
            return log$2.roll(log$2.roll$default$1());
        }
        return BoxedUnit.UNIT;
    }

    public static final /* synthetic */ SimpleRecord $anonfun$appendRecords$1(LogCleanerManagerTest $this, long endOffset$1, LongRef lastTimestamp$1, long offset) {
        long currentTimestamp = $this.time().milliseconds();
        if (offset == endOffset$1 - 1L) {
            lastTimestamp$1.elem = currentTimestamp;
        }
        return new SimpleRecord(currentTimestamp, new StringBuilder(4).append("key-").append(offset).toString().getBytes(), new StringBuilder(6).append("value-").append(offset).toString().getBytes());
    }

    public LogCleanerManagerTest() {
        this.logProps().put("segment.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("segment.index.bytes", Predef$.MODULE$.int2Integer(1024));
        this.logProps().put("cleanup.policy", "compact");
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime(1400000000000L, 1000L);
        this.offset = 999;
        this.producerStateManagerConfig = new ProducerStateManagerConfig(Defaults$.MODULE$.ProducerIdExpirationMs(), false);
        this.cleanerCheckpoints = (scala.collection.mutable.Map)Map$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
    }

    public class LogCleanerManagerMock
    extends LogCleanerManager {
        public scala.collection.immutable.Map<TopicPartition, Object> allCleanerCheckpoints() {
            return this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }

        /*
         * WARNING - void declaration
         */
        public void updateCheckpoints(File dataDir, Option<Tuple2<TopicPartition, Object>> partitionToUpdateOrAdd, Option<TopicPartition> partitionToRemove) {
            void var5_5;
            Predef$.MODULE$.assert(partitionToRemove.isEmpty(), (Function0 & Serializable)() -> "partitionToRemove argument with value not yet handled");
            Tuple2 tuple2 = (Tuple2)partitionToUpdateOrAdd.getOrElse((Function0 & Serializable)() -> {
                throw new IllegalArgumentException("partitionToUpdateOrAdd==None argument not yet handled");
            });
            if (tuple2 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)tuple2._1();
            long l = tuple2._2$mcJ$sp();
            this.kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer().cleanerCheckpoints().put((Object)var5_5, (Object)BoxesRunTime.boxToLong((long)l));
        }

        public Option<Tuple2<TopicPartition, Object>> updateCheckpoints$default$2() {
            return None$.MODULE$;
        }

        public Option<TopicPartition> updateCheckpoints$default$3() {
            return None$.MODULE$;
        }

        public /* synthetic */ LogCleanerManagerTest kafka$log$LogCleanerManagerTest$LogCleanerManagerMock$$$outer() {
            return LogCleanerManagerTest.this;
        }

        public LogCleanerManagerMock(scala.collection.immutable.Seq<File> logDirs, Pool<TopicPartition, UnifiedLog> logs, LogDirFailureChannel logDirFailureChannel) {
            if (LogCleanerManagerTest.this == null) {
                throw null;
            }
            super(logDirs, logs, logDirFailureChannel);
        }
    }
}

