/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.log.LogManager;
import kafka.log.UnifiedLog;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaBroker;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.ListOffsetsRequestData;
import org.apache.kafka.common.message.ListOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.ListOffsetsRequest;
import org.apache.kafka.common.requests.ListOffsetsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.storage.internals.log.LogAppendInfo;
import org.apache.kafka.storage.internals.log.LogSegment;
import org.apache.kafka.storage.internals.log.LogStartOffsetIncrementReason;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@Timeout(value=300L)
@ScalaSignature(bytes="\u0006\u0005\t%c\u0001B\u000b\u0017\u0001mAQ\u0001\t\u0001\u0005\u0002\u0005BQa\t\u0001\u0005B\u0011BQa\u000b\u0001\u0005R1BQA\u000f\u0001\u0005\u0002mBQ!\u001c\u0001\u0005\u00029DQ\u0001\u001e\u0001\u0005\u0002UDQA\u001f\u0001\u0005\u0002mDq!!\u0001\u0001\t\u0003\t\u0019\u0001C\u0004\u0002\u000e\u0001!\t!a\u0004\t\u000f\u0005e\u0001\u0001\"\u0001\u0002\u001c!9\u0011Q\u0005\u0001\u0005\u0002\u0005\u001d\u0002bBA\u001c\u0001\u0011\u0005\u0011\u0011\b\u0005\b\u0003\u000b\u0002A\u0011AA$\u0011\u001d\t\t\u0006\u0001C\u0001\u0003'Bq!!\u0018\u0001\t\u0013\ty\u0006C\u0004\u0002h\u0001!I!!\u001b\t\u000f\u0005-\u0005\u0001\"\u0003\u0002\u000e\"9\u0011Q\u0014\u0001\u0005\n\u0005}\u0005bBAy\u0001\u0011%\u00111\u001f\u0005\b\u0005?\u0001A\u0011\u0002B\u0011\u00055aunZ(gMN,G\u000fV3ti*\u0011q\u0003G\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003e\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u00019A\u0011QDH\u0007\u0002-%\u0011qD\u0006\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\u00061A(\u001b8jiz\"\u0012A\t\t\u0003;\u0001\t1B\u0019:pW\u0016\u00148i\\;oiV\tQ\u0005\u0005\u0002'S5\tqEC\u0001)\u0003\u0015\u00198-\u00197b\u0013\tQsEA\u0002J]R\fqC\u0019:pW\u0016\u0014\bK]8qKJ$\u0018p\u0014<feJLG-Z:\u0015\u00055\u0002\u0004C\u0001\u0014/\u0013\tysE\u0001\u0003V]&$\b\"B\u0019\u0004\u0001\u0004\u0011\u0014!\u00029s_B\u001c\bCA\u001a9\u001b\u0005!$BA\u001b7\u0003\u0011)H/\u001b7\u000b\u0003]\nAA[1wC&\u0011\u0011\b\u000e\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018!\b;fgR<U\r^(gMN,Go\u001d$peVs7N\\8x]R{\u0007/[2\u0015\u00055b\u0004\"B\u001f\u0005\u0001\u0004q\u0014AB9v_J,X\u000e\u0005\u0002@\r:\u0011\u0001\t\u0012\t\u0003\u0003\u001ej\u0011A\u0011\u0006\u0003\u0007j\ta\u0001\u0010:p_Rt\u0014BA#(\u0003\u0019\u0001&/\u001a3fM&\u0011q\t\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0015;\u0003F\u0002\u0003K\u001b:\u0003\u0016\u000b\u0005\u0002'\u0017&\u0011Aj\n\u0002\u000bI\u0016\u0004(/Z2bi\u0016$\u0017aB7fgN\fw-Z\u0011\u0002\u001f\u0006)B*[:u\u001f\u001a47/\u001a;t%\u0016\fX/Z:uAY\u0003\u0014!B:j]\u000e,\u0017%\u0001*\u0002\u0001!\u0012A\u0001\u0016\t\u0003+zk\u0011A\u0016\u0006\u0003/b\u000ba\u0001]1sC6\u001c(BA-[\u0003\u001dQW\u000f]5uKJT!a\u0017/\u0002\u000b),h.\u001b;\u000b\u0003u\u000b1a\u001c:h\u0013\tyfKA\tQCJ\fW.\u001a;fe&TX\r\u001a+fgRDC\u0001B1hQB\u0011!-Z\u0007\u0002G*\u0011AMV\u0001\taJ|g/\u001b3fe&\u0011am\u0019\u0002\f-\u0006dW/Z*pkJ\u001cW-A\u0004tiJLgnZ:-\u0005%\\\u0017%\u00016\u0002\u0005i\\\u0017%\u00017\u0002\u000b-\u0014\u0018M\u001a;\u0002AQ,7\u000f^$fi>3gm]3ug\u00063G/\u001a:EK2,G/\u001a*fG>\u0014Hm\u001d\u000b\u0003[=DQ!P\u0003A\u0002yBc!\u0002&N\u001dB\u000b\u0006FA\u0003UQ\u0011)\u0011mZ:-\u0005%\\\u0017A\u000e;fgR4U\r^2i\u001f\u001a47/\u001a;CsRKW.Z:uC6\u0004hi\u001c:NCb$\u0016.\\3ti\u0006l\u0007/\u00114uKJ$&/\u001e8dCR,GCA\u0017w\u0011\u0015id\u00011\u0001?Q\t1A\u000b\u000b\u0003\u0007C\u001eLHFA5l\u0003\u0001#Xm\u001d;GKR\u001c\u0007n\u00144gg\u0016$()\u001f+j[\u0016\u001cH/Y7q\r>\u0014X*\u0019=US6,7\u000f^1na^KG\u000f[+o_J$WM]3e)&lWm\u001d;b[B\u001cHCA\u0017}\u0011\u0015it\u00011\u0001?Q\t9A\u000b\u000b\u0003\bC\u001e|HFA5l\u0003y!Xm\u001d;HKR|eMZ:fiN\u0014UMZ8sK2\u000bG/Z:u)&lW\rF\u0002.\u0003\u000bAQ!\u0010\u0005A\u0002yB#\u0001\u0003+)\u000b!\tw-a\u0003-\u0005%\\\u0017a\u0006;fgR,U\u000e\u001d;z\u0019><7oR3u\u001f\u001a47/\u001a;t)\ri\u0013\u0011\u0003\u0005\u0006{%\u0001\rA\u0010\u0015\u0003\u0013QCS!C1h\u0003/a#![6\u0002kQ,7\u000f\u001e$fi\u000eDwJ\u001a4tKR\u0014\u0015\u0010V5nKN$\u0018-\u001c9G_Jl\u0015\r\u001f+j[\u0016\u001cH/Y7q/&$\b.R7qifdun\u001a\u000b\u0004[\u0005u\u0001\"B\u001f\u000b\u0001\u0004q\u0004F\u0001\u0006UQ\u0015Q\u0011mZA\u0012Y\tI7.A\fuKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/\u001a(poR\u0019Q&!\u000b\t\u000buZ\u0001\u0019\u0001 )\u000f-QU*!\fQ#\u0006\u0012\u0011qF\u0001\u0019Y\u0016<\u0017mY=GKR\u001c\u0007n\u00144gg\u0016$8OQ3g_J,\u0007FA\u0006UQ\u0015Y\u0011mZA\u001bY\tI7.\u0001\u0011uKN$x)\u001a;PM\u001a\u001cX\r^:CK\u001a|'/Z#be2LWm\u001d;US6,GcA\u0017\u0002<!)Q\b\u0004a\u0001}!:ABS'\u0002.A\u000b\u0006F\u0001\u0007UQ\u0015a\u0011mZA\"Y\tI7.A\u0017uKN$h)\u001a;dQ>3gm]3ug\n+gm\u001c:f/&$\bn\u00115b]\u001eLgnZ*fO6,g\u000e^*ju\u0016$2!LA%\u0011\u0015iT\u00021\u0001?Q\tiA\u000bK\u0003\u000eC\u001e\fy\u0005\f\u0002jW\u0006QC/Z:u\r\u0016$8\r[(gMN,Go\u001d\"fM>\u0014XmV5uQ\u000eC\u0017M\\4j]\u001e\u001cVmZ7f]R\u001cHcA\u0017\u0002V!)QH\u0004a\u0001}!\u0012a\u0002\u0016\u0015\u0006\u001d\u0005<\u00171\f\u0017\u0003S.\faA\u0019:pW\u0016\u0014XCAA1!\ri\u00121M\u0005\u0004\u0003K2\"aC&bM.\f'I]8lKJ\fac]3oI2K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e\u000b\u0005\u0003W\n\t\t\u0005\u0003\u0002n\u0005uTBAA8\u0015\u0011\t\t(a\u001d\u0002\u0011I,\u0017/^3tiNTA!!\u001e\u0002x\u000511m\\7n_:T1!GA=\u0015\r\tY\bX\u0001\u0007CB\f7\r[3\n\t\u0005}\u0014q\u000e\u0002\u0014\u0019&\u001cHo\u00144gg\u0016$8OU3ta>t7/\u001a\u0005\b\u0003\u0007\u0003\u0002\u0019AAC\u0003\u001d\u0011X-];fgR\u0004B!!\u001c\u0002\b&!\u0011\u0011RA8\u0005Ia\u0015n\u001d;PM\u001a\u001cX\r^:SKF,Xm\u001d;\u0002!M,g\u000e\u001a$fi\u000eD'+Z9vKN$H\u0003BAH\u0003+\u0003B!!\u001c\u0002\u0012&!\u00111SA8\u000551U\r^2i%\u0016\u001c\bo\u001c8tK\"9\u00111Q\tA\u0002\u0005]\u0005\u0003BA7\u00033KA!a'\u0002p\taa)\u001a;dQJ+\u0017/^3ti\u0006\u0001\"-^5mIR\u000b'oZ3u)&lWm\u001d\u000b\t\u0003C\u000b9.a9\u0002nB1\u00111UAW\u0003gsA!!*\u0002*:\u0019\u0011)a*\n\u0003!J1!a+(\u0003\u001d\u0001\u0018mY6bO\u0016LA!a,\u00022\n!A*[:u\u0015\r\tYk\n\t\u0005\u0003k\u000b\tN\u0004\u0003\u00028\u0006-g\u0002BA]\u0003\u0013tA!a/\u0002H:!\u0011QXAc\u001d\u0011\ty,a1\u000f\u0007\u0005\u000b\t-C\u0001^\u0013\r\tY\bX\u0005\u00043\u0005e\u0014\u0002BA;\u0003oJ1!TA:\u0013\u0011\ti-a4\u0002-1K7\u000f^(gMN,Go\u001d*fcV,7\u000f\u001e#bi\u0006T1!TA:\u0013\u0011\t\u0019.!6\u0003!1K7\u000f^(gMN,Go\u001d+pa&\u001c'\u0002BAg\u0003\u001fDq!!7\u0013\u0001\u0004\tY.\u0001\u0002uaB!\u0011Q\\Ap\u001b\t\t\u0019(\u0003\u0003\u0002b\u0006M$A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003K\u0014\u0002\u0019AAt\u0003%!\u0018.\\3ti\u0006l\u0007\u000fE\u0002'\u0003SL1!a;(\u0005\u0011auN\\4\t\r\u0005=(\u00031\u0001&\u00035i\u0017\r\u001f(v[>3gm]3ug\u0006ia-\u001b8e!\u0006\u0014H/\u001b;j_:$b!!>\u0003\u0004\tu\u0001\u0003BA|\u0003{tA!a.\u0002z&!\u00111`Ah\u0003]a\u0015n\u001d;PM\u001a\u001cX\r^:SKN\u0004xN\\:f\t\u0006$\u0018-\u0003\u0003\u0002\u0000\n\u0005!\u0001\b'jgR|eMZ:fiN\u0004\u0016M\u001d;ji&|gNU3ta>t7/\u001a\u0006\u0005\u0003w\fy\rC\u0004\u0003\u0006M\u0001\rAa\u0002\u0002\rQ|\u0007/[2t!\u0019\u0011IAa\u0005\u0003\u00185\u0011!1\u0002\u0006\u0005\u0005\u001b\u0011y!A\u0004nkR\f'\r\\3\u000b\u0007\tEq%\u0001\u0006d_2dWm\u0019;j_:LAA!\u0006\u0003\f\t1!)\u001e4gKJ\u0004B!a>\u0003\u001a%!!1\u0004B\u0001\u0005aa\u0015n\u001d;PM\u001a\u001cX\r^:U_BL7MU3ta>t7/\u001a\u0005\b\u00033\u001c\u0002\u0019AAn\u0003Q\u0019'/Z1uKR{\u0007/[2B]\u0012<U\r\u001e'pOR1!1\u0005B\u0018\u0005g\u0001BA!\n\u0003,5\u0011!q\u0005\u0006\u0004\u0005SA\u0012a\u00017pO&!!Q\u0006B\u0014\u0005))f.\u001b4jK\u0012dun\u001a\u0005\u0007\u0005c!\u0002\u0019\u0001 \u0002\u000bQ|\u0007/[2\t\u000f\tUB\u00031\u0001\u0002\\\u0006qAo\u001c9jGB\u000b'\u000f^5uS>t\u0007f\u0002\u0001\u0003:\t\u0015#q\t\t\u0005\u0005w\u0011\t%\u0004\u0002\u0003>)\u0019!q\b-\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0003D\tu\"a\u0002+j[\u0016|W\u000f^\u0001\u0006m\u0006dW/\u001a\u0010\u0003\u00031\u0002")
public class LogOffsetTest
extends BaseRequestTest {
    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties props) {
        props.put("log.flush.interval.messages", "1");
        props.put("num.partitions", "20");
        props.put("log.retention.hours", "10");
        props.put("log.retention.check.interval.ms", Integer.toString(300000));
        props.put("log.segment.bytes", "140");
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsForUnknownTopic(String quorum) {
        TopicPartition topicPartition = new TopicPartition("foo", 0);
        ListOffsetsRequest request = ListOffsetsRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED, (boolean)false).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 10)).asJava()).build((short)0);
        ListOffsetsResponse response = this.sendListOffsetsRequest(request);
        Assertions.assertEquals((short)Errors.UNKNOWN_TOPIC_OR_PARTITION.code(), (short)this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(response.topics()).asScala(), topicPartition).errorCode());
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsAfterDeleteRecords(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$1 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        log.maybeIncrementLogStartOffset(3L, LogStartOffsetIncrementReason.ClientRecordDeletion);
        log.deleteOldSegments();
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 3L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampAfterTruncate(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(log, BoxesRunTime.unboxToInt((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option firstOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).offset);
        Assertions.assertEquals((long)19L, (long)((FileRecords.TimestampAndOffset)firstOffset.get()).timestamp);
        log.truncateTo(0L);
        Option secondOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)secondOffset.get()).timestamp);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        ((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L, 1L, 2L, 3L, 4L, 6L, 5L}))).foreach((Function1 & Serializable)timestamp -> LogOffsetTest.$anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(log, BoxesRunTime.unboxToLong((Object)timestamp)));
        log.flush(false);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)7L, (long)log.logEndOffset());
        Assertions.assertEquals((long)5L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)6L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeLatestTime(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        java.util.Map topicIds = CollectionConverters$.MODULE$.MapHasAsJava(this.getTopicIds((Seq<String>)new .colon.colon((Object)"kafka-", (List)Nil$.MODULE$))).asJava();
        java.util.Map topicNames = CollectionConverters$.MODULE$.MutableMapHasAsJava((scala.collection.mutable.Map)CollectionConverters$.MODULE$.MapHasAsScala(topicIds).asScala().map((Function1 & Serializable)x$2 -> x$2.swap())).asJava();
        Uuid topicId = (Uuid)topicIds.get(topic);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$3 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        Seq offsets = log.legacyFetchOffsetsBefore(-1L, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, 0, this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -1L, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
        FetchRequest fetchRequest = (FetchRequest)FetchRequest.Builder.forConsumer((short)ApiKeys.FETCH.latestVersion(), (int)0, (int)1, (java.util.Map)CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new FetchRequest.PartitionData(topicId, Predef$.MODULE$.Long2long((Long)consumerOffsets.head()), -1L, 307200, Optional.empty()))}))).asJava()).build();
        Assertions.assertFalse((boolean)FetchResponse.recordsOrFail((FetchResponseData.PartitionData)((FetchResponseData.PartitionData)this.sendFetchRequest(fetchRequest).responseData(topicNames, ApiKeys.FETCH.latestVersion()).get(topicPartition))).batches().iterator().hasNext());
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testEmptyLogsGetOffsets(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(10));
        String topicPartitionPath = new StringBuilder(2).append(TestUtils.tempDirectory(null, null).getAbsolutePath()).append("/").append(topic).append("-").append(topicPartition.partition()).toString();
        new File(topicPartitionPath).mkdir();
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        BooleanRef offsetChanged = BooleanRef.create((boolean)false);
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(1), 14).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)x$4 -> {
            TopicPartition topicPartition = new TopicPartition(topic, 0);
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, -2L, 1)).asJava()).build();
            if (BoxesRunTime.equals((Object)CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala().head(), (Object)BoxesRunTime.boxToInteger((int)1))) {
                offsetChanged$1.elem = true;
                return;
            }
        });
        Assertions.assertFalse((boolean)offsetChanged.elem);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetByTimestampForMaxTimestampWithEmptyLog(String quorum) {
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        UnifiedLog log = this.createTopicAndGetLog(topic, topicPartition);
        log.updateHighWatermark(log.logEndOffset());
        Option maxTimestampOffset = log.fetchOffsetByTimestamp(-3L, log.fetchOffsetByTimestamp$default$2());
        Assertions.assertEquals((long)0L, (long)log.logEndOffset());
        Assertions.assertEquals((long)0L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).offset);
        Assertions.assertEquals((long)-1L, (long)((FileRecords.TimestampAndOffset)maxTimestampOffset.get()).timestamp);
    }

    /*
     * WARNING - void declaration
     */
    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeNow(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$52 = logManager.getOrCreateLog$default$5();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2, x$52);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$5 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        long now = Time.SYSTEM.milliseconds() + 30000L;
        Seq offsets = log.legacyFetchOffsetsBefore(now, 15);
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)offsets);
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Leader should be elected");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, now, 15)).asJava()).build();
        Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
        Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{20L, 18L, 16L, 14L, 12L, 10L, 8L, 6L, 4L, 2L, 0L})), (Object)consumerOffsets);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testGetOffsetsBeforeEarliestTime(String quorum) {
        Random random = new Random();
        String topic = "kafka-";
        TopicPartition topicPartition = new TopicPartition(topic, random.nextInt(3));
        this.createTopic(topic, 3, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        None$ x$2 = None$.MODULE$;
        boolean x$3 = logManager.getOrCreateLog$default$2();
        boolean x$4 = logManager.getOrCreateLog$default$3();
        Option x$5 = logManager.getOrCreateLog$default$5();
        UnifiedLog log = logManager.getOrCreateLog(topicPartition, x$3, x$4, (Option)x$2, x$5);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), 20).foreach((Function1 & Serializable)x$6 -> log.appendAsLeader(TestUtils$.MODULE$.singletonRecords(Integer.toString(42).getBytes(), null, CompressionType.NONE, -1L, (byte)2), 0, log.appendAsLeader$default$3(), log.appendAsLeader$default$4(), log.appendAsLeader$default$5(), log.appendAsLeader$default$6()));
        log.flush(false);
        package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{-2L, -4L})).foreach((Function1)(JFunction1.mcVJ.sp & Serializable)timestamp -> {
            Seq offsets = log.legacyFetchOffsetsBefore(timestamp, 10);
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)offsets);
            long l = 100L;
            long waitUntilTrue_waitTimeMs = 15000L;
            long waitUntilTrue_startTime = System.currentTimeMillis();
            while (!TestUtils$.MODULE$.isLeaderLocalOnBroker(topic, topicPartition.partition(), this.broker())) {
                void waitUntilTrue_pause;
                if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                    Assertions.fail((String)"Leader should be elected");
                }
                Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
            }
            ListOffsetsRequest request = (ListOffsetsRequest)ListOffsetsRequest.Builder.forReplica((short)0, (int)0).setTargetTimes(CollectionConverters$.MODULE$.SeqHasAsJava(this.buildTargetTimes(topicPartition, timestamp, 10)).asJava()).build();
            Buffer consumerOffsets = CollectionConverters$.MODULE$.ListHasAsScala(this.findPartition((Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse>)CollectionConverters$.MODULE$.ListHasAsScala(this.sendListOffsetsRequest(request).topics()).asScala(), topicPartition).oldStyleOffsets()).asScala();
            Assertions.assertEquals((Object)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapLongArray(new long[]{0L})), (Object)consumerOffsets);
        });
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegmentSize(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)BoxesRunTime.boxToInteger((int)logSegment.size())).thenAnswer((Answer)new Answer<Object>(null){
            private final AtomicInteger value;

            public int answer(InvocationOnMock invocation) {
                return this.value.getAndIncrement();
            }
            {
                this.value = new AtomicInteger(0);
            }
        });
        java.util.List logSegments = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)logSegment, (List)Nil$.MODULE$)).asJava();
        Mockito.when((Object)log.logSegments()).thenReturn((Object)logSegments);
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    @ParameterizedTest
    @ValueSource(strings={"zk", "kraft"})
    public void testFetchOffsetsBeforeWithChangingSegments(String quorum) {
        UnifiedLog log = (UnifiedLog)Mockito.mock(UnifiedLog.class);
        LogSegment logSegment = (LogSegment)Mockito.mock(LogSegment.class);
        Mockito.when((Object)log.logSegments()).thenReturn((Object)new AbstractCollection<LogSegment>(null, logSegment){
            private final LogSegment logSegment$1;

            public int size() {
                return 2;
            }

            public Iterator<LogSegment> iterator() {
                return Arrays.asList(this.logSegment$1).iterator();
            }
            {
                this.logSegment$1 = logSegment$1;
            }
        });
        log.legacyFetchOffsetsBefore(System.currentTimeMillis(), 100);
    }

    private KafkaBroker broker() {
        return (KafkaBroker)this.brokers().head();
    }

    private ListOffsetsResponse sendListOffsetsRequest(ListOffsetsRequest request) {
        return (ListOffsetsResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private FetchResponse sendFetchRequest(FetchRequest request) {
        return (FetchResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FetchResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    private List<ListOffsetsRequestData.ListOffsetsTopic> buildTargetTimes(TopicPartition tp, long timestamp, int maxNumOffsets) {
        return new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsTopic().setName(tp.topic()).setPartitions(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)new .colon.colon((Object)new ListOffsetsRequestData.ListOffsetsPartition().setPartitionIndex(tp.partition()).setTimestamp(timestamp).setMaxNumOffsets(maxNumOffsets), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$);
    }

    private ListOffsetsResponseData.ListOffsetsPartitionResponse findPartition(Buffer<ListOffsetsResponseData.ListOffsetsTopicResponse> topics, TopicPartition tp) {
        return (ListOffsetsResponseData.ListOffsetsPartitionResponse)CollectionConverters$.MODULE$.ListHasAsScala(((ListOffsetsResponseData.ListOffsetsTopicResponse)topics.find((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$1(tp, x$7))).get()).partitions()).asScala().find((Function1 & Serializable)x$8 -> BoxesRunTime.boxToBoolean((boolean)LogOffsetTest.$anonfun$findPartition$2(tp, x$8))).get();
    }

    /*
     * WARNING - void declaration
     */
    private UnifiedLog createTopicAndGetLog(String topic, TopicPartition topicPartition) {
        this.createTopic(topic, 1, 1, this.createTopic$default$4(), this.createTopic$default$5(), this.createTopic$default$6());
        LogManager logManager = this.broker().logManager();
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 15000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!LogOffsetTest.$anonfun$createTopicAndGetLog$1(logManager, topicPartition)) {
            void waitUntilTrue_pause;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"Log for partition [topic,0] should be created");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), (long)waitUntilTrue_pause));
        }
        return (UnifiedLog)logManager.getLog(topicPartition, logManager.getLog$default$2()).get();
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsAfterDeleteRecords$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampAfterTruncate$1(UnifiedLog log$2, int timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        long x$2 = timestamp;
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return log$2.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, x$2, x$5), 0, log$2.appendAsLeader$default$3(), log$2.appendAsLeader$default$4(), log$2.appendAsLeader$default$5(), log$2.appendAsLeader$default$6());
    }

    public static final /* synthetic */ LogAppendInfo $anonfun$testFetchOffsetByTimestampForMaxTimestampWithUnorderedTimestamps$1(UnifiedLog log$3, long timestamp) {
        byte[] x$1 = Integer.toString(42).getBytes();
        CompressionType x$4 = CompressionType.NONE;
        byte x$5 = 2;
        return log$3.appendAsLeader(TestUtils$.MODULE$.singletonRecords(x$1, null, x$4, timestamp, x$5), 0, log$3.appendAsLeader$default$3(), log$3.appendAsLeader$default$4(), log$3.appendAsLeader$default$5(), log$3.appendAsLeader$default$6());
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeLatestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeNow$3() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ String $anonfun$testGetOffsetsBeforeEarliestTime$4() {
        return "Leader should be elected";
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$1(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsTopicResponse x$7) {
        String string = x$7.name();
        String string2 = tp$1.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$findPartition$2(TopicPartition tp$1, ListOffsetsResponseData.ListOffsetsPartitionResponse x$8) {
        return x$8.partitionIndex() == tp$1.partition();
    }

    public static final /* synthetic */ boolean $anonfun$createTopicAndGetLog$1(LogManager logManager$1, TopicPartition topicPartition$4) {
        return logManager$1.getLog(topicPartition$4, logManager$1.getLog$default$2()).isDefined();
    }

    public static final /* synthetic */ String $anonfun$createTopicAndGetLog$2() {
        return "Log for partition [topic,0] should be created";
    }
}

