/*
 * Decompiled with CFR 0.152.
 */
package kafka.testkit;

import java.io.File;
import java.nio.file.Paths;
import java.util.Optional;
import kafka.testkit.TestKitNode;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.metadata.properties.MetaProperties;
import org.apache.kafka.metadata.properties.MetaPropertiesEnsemble;
import org.apache.kafka.metadata.properties.MetaPropertiesVersion;

public class ControllerNode
implements TestKitNode {
    private final MetaPropertiesEnsemble initialMetaPropertiesEnsemble;
    private final boolean combined;

    ControllerNode(MetaPropertiesEnsemble initialMetaPropertiesEnsemble, boolean combined) {
        this.initialMetaPropertiesEnsemble = initialMetaPropertiesEnsemble;
        this.combined = combined;
    }

    @Override
    public MetaPropertiesEnsemble initialMetaPropertiesEnsemble() {
        return this.initialMetaPropertiesEnsemble;
    }

    @Override
    public boolean combined() {
        return this.combined;
    }

    public static class Builder {
        private int id = -1;
        private String baseDirectory = null;
        private String metadataDirectory = null;
        private Uuid clusterId = null;

        public int id() {
            return this.id;
        }

        public Builder setId(int id) {
            this.id = id;
            return this;
        }

        public Builder setMetadataDirectory(String metadataDirectory) {
            this.metadataDirectory = metadataDirectory;
            return this;
        }

        public ControllerNode build(String baseDirectory, Uuid clusterId, boolean combined) {
            if (this.id == -1) {
                throw new RuntimeException("You must set the node id.");
            }
            if (baseDirectory == null) {
                throw new RuntimeException("You must set the base directory.");
            }
            if (this.metadataDirectory == null) {
                this.metadataDirectory = combined ? String.format("combined_%d_0", this.id) : String.format("controller_%d", this.id);
            }
            if (!Paths.get(this.metadataDirectory, new String[0]).isAbsolute()) {
                this.metadataDirectory = new File(baseDirectory, this.metadataDirectory).getAbsolutePath();
            }
            MetaPropertiesEnsemble.Copier copier = new MetaPropertiesEnsemble.Copier(MetaPropertiesEnsemble.EMPTY);
            copier.setMetaLogDir(Optional.of(this.metadataDirectory));
            copier.setLogDirProps(this.metadataDirectory, new MetaProperties.Builder().setVersion(MetaPropertiesVersion.V1).setClusterId(clusterId.toString()).setNodeId(this.id).setDirectoryId(copier.generateValidDirectoryId()).build());
            return new ControllerNode(copier.copy(), combined);
        }
    }
}

