/*
 * Decompiled with CFR 0.152.
 */
package kafka.cluster;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.Timer;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kafka.admin.AdminUtils$;
import kafka.api.LeaderAndIsr;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.cluster.Broker;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.common.ErrorMapping$;
import kafka.common.NotAssignedReplicaException;
import kafka.common.NotLeaderForPartitionException;
import kafka.common.TopicAndPartition;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.message.ByteBufferMessageSet;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.OffsetCheckpoint;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Time;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\tUg\u0001B\u0001\u0003\u0001\u001d\u0011\u0011\u0002U1si&$\u0018n\u001c8\u000b\u0005\r!\u0011aB2mkN$XM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011#\u0002\u0001\t!Ya\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E!R\"\u0001\n\u000b\u0005M!\u0011!B;uS2\u001c\u0018BA\u000b\u0013\u0005\u001daunZ4j]\u001e\u0004\"a\u0006\u000e\u000e\u0003aQ!!\u0007\u0003\u0002\u000f5,GO]5dg&\u00111\u0004\u0007\u0002\u0012\u0017\u000647.Y'fiJL7m]$s_V\u0004\bCA\u000f!\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"aC*dC2\fwJ\u00196fGRD\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001J\u0001\u0006i>\u0004\u0018nY\u000b\u0002KA\u0011a%\u000b\b\u0003;\u001dJ!\u0001\u000b\u0010\u0002\rA\u0013X\rZ3g\u0013\tQ3F\u0001\u0004TiJLgn\u001a\u0006\u0003QyA\u0001\"\f\u0001\u0003\u0002\u0003\u0006I!J\u0001\u0007i>\u0004\u0018n\u0019\u0011\t\u0011=\u0002!Q1A\u0005\u0002A\n1\u0002]1si&$\u0018n\u001c8JIV\t\u0011\u0007\u0005\u0002\u001ee%\u00111G\b\u0002\u0004\u0013:$\b\u0002C\u001b\u0001\u0005\u0003\u0005\u000b\u0011B\u0019\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\t\u0011]\u0002!\u00111A\u0005\u0002A\n\u0011C]3qY&\u001c\u0017\r^5p]\u001a\u000b7\r^8s\u0011!I\u0004A!a\u0001\n\u0003Q\u0014!\u0006:fa2L7-\u0019;j_:4\u0015m\u0019;pe~#S-\u001d\u000b\u0003wy\u0002\"!\b\u001f\n\u0005ur\"\u0001B+oSRDqa\u0010\u001d\u0002\u0002\u0003\u0007\u0011'A\u0002yIEB\u0001\"\u0011\u0001\u0003\u0002\u0003\u0006K!M\u0001\u0013e\u0016\u0004H.[2bi&|gNR1di>\u0014\b\u0005\u0003\u0005D\u0001\t\u0005\t\u0015!\u0003E\u0003\u0011!\u0018.\\3\u0011\u0005E)\u0015B\u0001$\u0013\u0005\u0011!\u0016.\\3\t\u0011!\u0003!Q1A\u0005\u0002%\u000baB]3qY&\u001c\u0017-T1oC\u001e,'/F\u0001K!\tYe*D\u0001M\u0015\tiE!\u0001\u0004tKJ4XM]\u0005\u0003\u001f2\u0013aBU3qY&\u001c\u0017-T1oC\u001e,'\u000f\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003K\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003\"B*\u0001\t\u0003!\u0016A\u0002\u001fj]&$h\b\u0006\u0004V/bK&l\u0017\t\u0003-\u0002i\u0011A\u0001\u0005\u0006GI\u0003\r!\n\u0005\u0006_I\u0003\r!\r\u0005\u0006oI\u0003\r!\r\u0005\u0006\u0007J\u0003\r\u0001\u0012\u0005\u0006\u0011J\u0003\rA\u0013\u0005\b;\u0002\u0011\r\u0011\"\u00031\u00035awnY1m\u0005J|7.\u001a:JI\"1q\f\u0001Q\u0001\nE\na\u0002\\8dC2\u0014%o\\6fe&#\u0007\u0005C\u0004b\u0001\t\u0007I\u0011\u00022\u0002\u00151|w-T1oC\u001e,'/F\u0001d!\t!w-D\u0001f\u0015\t1G!A\u0002m_\u001eL!\u0001[3\u0003\u00151{w-T1oC\u001e,'\u000f\u0003\u0004k\u0001\u0001\u0006IaY\u0001\fY><W*\u00198bO\u0016\u0014\b\u0005C\u0004m\u0001\t\u0007I\u0011B7\u0002\u0011i\\7\t\\5f]R,\u0012A\u001c\t\u0003_Zl\u0011\u0001\u001d\u0006\u0003cJ\f\u0001B_6dY&,g\u000e\u001e\u0006\u0003gR\fa!\u0013\u0019Ji\u0016\u001c'\"A;\u0002\u0007=\u0014x-\u0003\u0002xa\nA!l[\"mS\u0016tG\u000f\u0003\u0004z\u0001\u0001\u0006IA\\\u0001\nu.\u001cE.[3oi\u0002Bqa\u001f\u0001A\u0002\u0013\u0005A0\u0001\nmK\u0006$WM\u001d*fa2L7-Y%e\u001fB$X#A?\u0011\u0007uq\u0018'\u0003\u0002\u0000=\t1q\n\u001d;j_:D\u0011\"a\u0001\u0001\u0001\u0004%\t!!\u0002\u0002-1,\u0017\rZ3s%\u0016\u0004H.[2b\u0013\u0012|\u0005\u000f^0%KF$2aOA\u0004\u0011!y\u0014\u0011AA\u0001\u0002\u0004i\bbBA\u0006\u0001\u0001\u0006K!`\u0001\u0014Y\u0016\fG-\u001a:SKBd\u0017nY1JI>\u0003H\u000f\t\u0005\n\u0003\u001f\u0001\u0001\u0019!C\u0001\u0003#\ta\"\u001b8Ts:\u001c'+\u001a9mS\u000e\f7/\u0006\u0002\u0002\u0014A1\u0011QCA\u000e\u0003?i!!a\u0006\u000b\u0007\u0005ea$\u0001\u0006d_2dWm\u0019;j_:LA!!\b\u0002\u0018\t\u00191+\u001a;\u0011\u0007Y\u000b\t#C\u0002\u0002$\t\u0011qAU3qY&\u001c\u0017\rC\u0005\u0002(\u0001\u0001\r\u0011\"\u0001\u0002*\u0005\u0011\u0012N\\*z]\u000e\u0014V\r\u001d7jG\u0006\u001cx\fJ3r)\rY\u00141\u0006\u0005\n\u007f\u0005\u0015\u0012\u0011!a\u0001\u0003'A\u0001\"a\f\u0001A\u0003&\u00111C\u0001\u0010S:\u001c\u0016P\\2SKBd\u0017nY1tA!I\u00111\u0007\u0001C\u0002\u0013%\u0011QG\u0001\u0013CN\u001c\u0018n\u001a8fIJ+\u0007\u000f\\5dC6\u000b\u0007/\u0006\u0002\u00028A1\u0011#!\u000f2\u0003?I1!a\u000f\u0013\u0005\u0011\u0001vn\u001c7\t\u0011\u0005}\u0002\u0001)A\u0005\u0003o\t1#Y:tS\u001etW\r\u001a*fa2L7-Y'ba\u0002B\u0011\"a\u0011\u0001\u0005\u0004%I!!\u0012\u0002'1,\u0017\rZ3s\u0013N\u0014X\u000b\u001d3bi\u0016dunY6\u0016\u0003!Aq!!\u0013\u0001A\u0003%\u0001\"\u0001\u000bmK\u0006$WM]%teV\u0003H-\u0019;f\u0019>\u001c7\u000e\t\u0005\t\u0003\u001b\u0002\u0001\u0019!C\u0005a\u0005I!p\u001b,feNLwN\u001c\u0005\n\u0003#\u0002\u0001\u0019!C\u0005\u0003'\nQB_6WKJ\u001c\u0018n\u001c8`I\u0015\fHcA\u001e\u0002V!Aq(a\u0014\u0002\u0002\u0003\u0007\u0011\u0007C\u0004\u0002Z\u0001\u0001\u000b\u0015B\u0019\u0002\u0015i\\g+\u001a:tS>t\u0007\u0005\u0003\u0005\u0002^\u0001\u0001\r\u0011\"\u00031\u0003-aW-\u00193fe\u0016\u0003xn\u00195\t\u0013\u0005\u0005\u0004\u00011A\u0005\n\u0005\r\u0014a\u00047fC\u0012,'/\u00129pG\"|F%Z9\u0015\u0007m\n)\u0007\u0003\u0005@\u0003?\n\t\u00111\u00012\u0011\u001d\tI\u0007\u0001Q!\nE\nA\u0002\\3bI\u0016\u0014X\t]8dQ\u0002B\u0001\"!\u001c\u0001\u0001\u0004%I\u0001M\u0001\u0010G>tGO]8mY\u0016\u0014X\t]8dQ\"I\u0011\u0011\u000f\u0001A\u0002\u0013%\u00111O\u0001\u0014G>tGO]8mY\u0016\u0014X\t]8dQ~#S-\u001d\u000b\u0004w\u0005U\u0004\u0002C \u0002p\u0005\u0005\t\u0019A\u0019\t\u000f\u0005e\u0004\u0001)Q\u0005c\u0005\u00012m\u001c8ue>dG.\u001a:Fa>\u001c\u0007\u000e\t\u0005\n\u0003{\u0002!\u0019!C\u0005\u0003\u007f\n\u0011c\u001d;bi\u0016\u001c\u0005.\u00198hK2{wmZ3s+\t\t\t\t\u0005\u0003\u0002\u0004\u00065UBAAC\u0015\u0011\t9)!#\u0002\u000b1|w\r\u000e6\u000b\u0007\u0005-E/\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0005\u0003\u001f\u000b)I\u0001\u0004M_\u001e<WM\u001d\u0005\t\u0003'\u0003\u0001\u0015!\u0003\u0002\u0002\u0006\u00112\u000f^1uK\u000eC\u0017M\\4f\u0019><w-\u001a:!\u0011\u001d\t9\n\u0001C\u0005\u00033\u000ba\"[:SKBd\u0017nY1M_\u000e\fG\u000e\u0006\u0003\u0002\u001c\u0006\u0005\u0006cA\u000f\u0002\u001e&\u0019\u0011q\u0014\u0010\u0003\u000f\t{w\u000e\\3b]\"9\u00111UAK\u0001\u0004\t\u0014!\u0003:fa2L7-Y%e\u0011\u001d\t9\u000b\u0001C\u0001\u0003S\u000b\u0011#[:V]\u0012,'OU3qY&\u001c\u0017\r^3e)\t\tY\nC\u0004\u0002.\u0002!\t!a,\u0002%\u001d,Go\u0014:De\u0016\fG/\u001a*fa2L7-\u0019\u000b\u0005\u0003?\t\t\fC\u0005\u0002$\u0006-\u0006\u0013!a\u0001c!9\u0011Q\u0017\u0001\u0005\u0002\u0005]\u0016AC4fiJ+\u0007\u000f\\5dCR!\u0011\u0011XA^!\u0011ib0a\b\t\u0013\u0005\r\u00161\u0017I\u0001\u0002\u0004\t\u0004bBA`\u0001\u0011\u0005\u0011\u0011Y\u0001\u0015Y\u0016\fG-\u001a:SKBd\u0017nY1JM2{7-\u00197\u0015\u0005\u0005e\u0006bBAc\u0001\u0011\u0005\u0011qY\u0001\u0016C\u0012$'+\u001a9mS\u000e\f\u0017J\u001a(pi\u0016C\u0018n\u001d;t)\u0011\ty\"!3\t\u0011\u0005-\u00171\u0019a\u0001\u0003?\tqA]3qY&\u001c\u0017\rC\u0004\u0002P\u0002!\t!!5\u0002!\u0005\u001c8/[4oK\u0012\u0014V\r\u001d7jG\u0006\u001cHCAA\n\u0011\u001d\t)\u000e\u0001C\u0001\u0003/\fQB]3n_Z,'+\u001a9mS\u000e\fGcA\u001e\u0002Z\"9\u00111UAj\u0001\u0004\t\u0004bBAo\u0001\u0011\u0005\u0011q\\\u0001\u0007I\u0016dW\r^3\u0015\u0003mBq!a9\u0001\t\u0003\t)/\u0001\bhKRdU-\u00193fe\u0016\u0003xn\u00195\u0015\u0003EBq!!;\u0001\t\u0003\tY/\u0001\u0006nC.,G*Z1eKJ$\u0002\"a'\u0002n\u0006E(\u0011\u0001\u0005\b\u0003_\f9\u000f1\u00012\u00031\u0019wN\u001c;s_2dWM]%e\u0011!\t\u00190a:A\u0002\u0005U\u0018A\u00059beRLG/[8o'R\fG/Z%oM>\u0004B!a>\u0002~6\u0011\u0011\u0011 \u0006\u0004\u0003w$\u0011aA1qS&!\u0011q`A}\u0005I\u0001\u0016M\u001d;ji&|gn\u0015;bi\u0016LeNZ8\t\u000f\t\r\u0011q\u001da\u0001c\u0005i1m\u001c:sK2\fG/[8o\u0013\u0012DqAa\u0002\u0001\t\u0003\u0011I!\u0001\u0007nC.,gi\u001c7m_^,'\u000f\u0006\u0006\u0002\u001c\n-!Q\u0002B\b\u00057Aq!a<\u0003\u0006\u0001\u0007\u0011\u0007\u0003\u0005\u0002t\n\u0015\u0001\u0019AA{\u0011!\u0011\tB!\u0002A\u0002\tM\u0011a\u00027fC\u0012,'o\u001d\t\u0007\u0003+\tYB!\u0006\u0011\u0007Y\u00139\"C\u0002\u0003\u001a\t\u0011aA\u0011:pW\u0016\u0014\bb\u0002B\u0002\u0005\u000b\u0001\r!\r\u0005\b\u0005?\u0001A\u0011\u0001B\u0011\u0003})\b\u000fZ1uK2+\u0017\rZ3s\u0011^\u000be\u000eZ'bs\n,W\t\u001f9b]\u0012L5O\u001d\u000b\u0006w\t\r\"Q\u0005\u0005\b\u0003G\u0013i\u00021\u00012\u0011!\u00119C!\bA\u0002\t%\u0012AB8gMN,G\u000fE\u0002\u001e\u0005WI1A!\f\u001f\u0005\u0011auN\\4\t\u000f\tE\u0002\u0001\"\u0001\u00034\u0005q2\r[3dW\u0016sw.^4i%\u0016\u0004H.[2bgJ+\u0017m\u00195PM\u001a\u001cX\r\u001e\u000b\u0007\u0005k\u0011\tE!\u0012\u0011\u000fu\u00119$a'\u0003<%\u0019!\u0011\b\u0010\u0003\rQ+\b\u000f\\33!\ri\"QH\u0005\u0004\u0005\u007fq\"!B*i_J$\b\u0002\u0003B\"\u0005_\u0001\rA!\u000b\u0002\u001dI,\u0017/^5sK\u0012|eMZ:fi\"9!q\tB\u0018\u0001\u0004\t\u0014\u0001\u0004:fcVL'/\u001a3BG.\u001c\bb\u0002B&\u0001\u0011%!QJ\u0001\u0017[\u0006L(-Z%oGJ,W.\u001a8u\u0019\u0016\fG-\u001a:I/R\u00191Ha\u0014\t\u0011\tE#\u0011\na\u0001\u0003?\tQ\u0002\\3bI\u0016\u0014(+\u001a9mS\u000e\f\u0007b\u0002B+\u0001\u0011\u0005!qK\u0001\u000f[\u0006L(-Z*ie&t7.S:s)\u0015Y$\u0011\fB/\u0011!\u0011YFa\u0015A\u0002\t%\u0012a\u0005:fa2L7-Y'bq2\u000bw\rV5nK6\u001b\b\u0002\u0003B0\u0005'\u0002\rA!\u000b\u0002+I,\u0007\u000f\\5dC6\u000b\u0007\u0010T1h\u001b\u0016\u001c8/Y4fg\"9!1\r\u0001\u0005\u0002\t\u0015\u0014\u0001F4fi>+Ho\u00144Ts:\u001c'+\u001a9mS\u000e\f7\u000f\u0006\u0005\u0002\u0014\t\u001d$\u0011\u000eB7\u0011!\u0011\tF!\u0019A\u0002\u0005}\u0001\u0002\u0003B6\u0005C\u0002\rA!\u000b\u0002!-,W\r]%o'ft7\rV5nK6\u001b\b\u0002\u0003B8\u0005C\u0002\rA!\u000b\u0002%-,W\r]%o'ft7-T3tg\u0006<Wm\u001d\u0005\b\u0005g\u0002A\u0011\u0001B;\u0003Y\t\u0007\u000f]3oI6+7o]1hKN$v\u000eT3bI\u0016\u0014H\u0003\u0002B<\u0005\u0007\u0003BA!\u001f\u0003\u0000A\u0019AMa\u001f\n\u0007\tuTMA\u0002M_\u001eLAA!!\u0003|\tiAj\\4BaB,g\u000eZ%oM>D\u0001B!\"\u0003r\u0001\u0007!qQ\u0001\t[\u0016\u001c8/Y4fgB!!\u0011\u0012BH\u001b\t\u0011YIC\u0002\u0003\u000e\u0012\tq!\\3tg\u0006<W-\u0003\u0003\u0003\u0012\n-%\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+G\u000fC\u0004\u0003\u0016\u0002!IAa&\u0002\u0013U\u0004H-\u0019;f\u0013N\u0014HcA\u001e\u0003\u001a\"A!1\u0014BJ\u0001\u0004\t\u0019\"\u0001\u0004oK^L5O\u001d\u0005\b\u0005?\u0003A\u0011\tBQ\u0003\u0019)\u0017/^1mgR!\u00111\u0014BR\u0011!\u0011)K!(A\u0002\t\u001d\u0016\u0001\u0002;iCR\u00042!\bBU\u0013\r\u0011YK\b\u0002\u0004\u0003:L\bb\u0002BX\u0001\u0011\u0005\u0013Q]\u0001\tQ\u0006\u001c\bnQ8eK\"9!1\u0017\u0001\u0005B\tU\u0016\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003\u0015B\u0011B!/\u0001#\u0003%\tAa/\u00029\u001d,Go\u0014:De\u0016\fG/\u001a*fa2L7-\u0019\u0013eK\u001a\fW\u000f\u001c;%cU\u0011!Q\u0018\u0016\u0004c\t}6F\u0001Ba!\u0011\u0011\u0019M!4\u000e\u0005\t\u0015'\u0002\u0002Bd\u0005\u0013\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t-g$\u0001\u0006b]:|G/\u0019;j_:LAAa4\u0003F\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\tM\u0007!%A\u0005\u0002\tm\u0016\u0001F4fiJ+\u0007\u000f\\5dC\u0012\"WMZ1vYR$\u0013\u0007")
public class Partition
implements KafkaMetricsGroup {
    private final String topic;
    private final int partitionId;
    private int replicationFactor;
    public final Time kafka$cluster$Partition$$time;
    private final ReplicaManager replicaManager;
    private final int kafka$cluster$Partition$$localBrokerId;
    private final LogManager logManager;
    private final ZkClient zkClient;
    private Option<Object> leaderReplicaIdOpt;
    private Set<Replica> inSyncReplicas;
    private final Pool<Object, Replica> assignedReplicaMap;
    private final Object leaderIsrUpdateLock;
    private int kafka$cluster$Partition$$zkVersion;
    private int leaderEpoch;
    private int controllerEpoch;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Partition partition = this;
        synchronized (partition) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public int replicationFactor() {
        return this.replicationFactor;
    }

    public void replicationFactor_$eq(int n) {
        this.replicationFactor = n;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public final int kafka$cluster$Partition$$localBrokerId() {
        return this.kafka$cluster$Partition$$localBrokerId;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    private ZkClient zkClient() {
        return this.zkClient;
    }

    public Option<Object> leaderReplicaIdOpt() {
        return this.leaderReplicaIdOpt;
    }

    public void leaderReplicaIdOpt_$eq(Option<Object> option) {
        this.leaderReplicaIdOpt = option;
    }

    public Set<Replica> inSyncReplicas() {
        return this.inSyncReplicas;
    }

    public void inSyncReplicas_$eq(Set<Replica> set) {
        this.inSyncReplicas = set;
    }

    private Pool<Object, Replica> assignedReplicaMap() {
        return this.assignedReplicaMap;
    }

    private Object leaderIsrUpdateLock() {
        return this.leaderIsrUpdateLock;
    }

    public final int kafka$cluster$Partition$$zkVersion() {
        return this.kafka$cluster$Partition$$zkVersion;
    }

    private void kafka$cluster$Partition$$zkVersion_$eq(int n) {
        this.kafka$cluster$Partition$$zkVersion = n;
    }

    private int leaderEpoch() {
        return this.leaderEpoch;
    }

    private void leaderEpoch_$eq(int n) {
        this.leaderEpoch = n;
    }

    private int controllerEpoch() {
        return this.controllerEpoch;
    }

    private void controllerEpoch_$eq(int n) {
        this.controllerEpoch = n;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private boolean isReplicaLocal(int replicaId) {
        return replicaId == this.kafka$cluster$Partition$$localBrokerId();
    }

    public boolean isUnderReplicated() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block6: {
                Boolean bl;
                option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    bl = BoxesRunTime.boxToBoolean((this.inSyncReplicas().size() < this.assignedReplicas().size() ? 1 : 0) != 0);
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    bl = BoxesRunTime.boxToBoolean((boolean)false);
                }
                Boolean bl2 = bl;
                return BoxesRunTime.unboxToBoolean((Object)bl2);
            }
            throw new MatchError(option);
        }
    }

    public Replica getOrCreateReplica(int replicaId) {
        Option<Replica> option;
        block8: {
            Replica replica;
            block7: {
                Replica replica2;
                block6: {
                    Option<Replica> replicaOpt = this.getReplica(replicaId);
                    option = replicaOpt;
                    if (!(option instanceof Some)) break block6;
                    replica = (Replica)((Some)option).x();
                    break block7;
                }
                None$ none$ = None$.MODULE$;
                Option<Replica> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block8;
                if (this.isReplicaLocal(replicaId)) {
                    LogConfig config = LogConfig$.MODULE$.fromProps(this.logManager().defaultConfig().toProps(), AdminUtils$.MODULE$.fetchTopicConfig(this.zkClient(), this.topic()));
                    Log log = this.logManager().createLog(new TopicAndPartition(this.topic(), this.partitionId()), config);
                    OffsetCheckpoint checkpoint = (OffsetCheckpoint)this.replicaManager().highWatermarkCheckpoints().apply((Object)log.dir().getParent());
                    Map<TopicAndPartition, Object> offsetMap = checkpoint.read();
                    if (!offsetMap.contains((Object)new TopicAndPartition(this.topic(), this.partitionId()))) {
                        this.warn((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID;
                            private final Partition $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final String apply() {
                                return Predef$.MODULE$.augmentString("No checkpointed highwatermark is found for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                    long offset = BoxesRunTime.unboxToLong((Object)Predef$.MODULE$.longWrapper(BoxesRunTime.unboxToLong((Object)offsetMap.getOrElse((Object)new TopicAndPartition(this.topic(), this.partitionId()), (Function0)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final long apply() {
                            return this.apply$mcJ$sp();
                        }

                        public long apply$mcJ$sp() {
                            return 0L;
                        }
                    }))).min((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())));
                    Replica localReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, offset, (Option<Log>)new Some((Object)log));
                    replica2 = this.addReplicaIfNotExists(localReplica);
                } else {
                    Replica remoteReplica = new Replica(replicaId, this, this.kafka$cluster$Partition$$time, Replica$.MODULE$.init$default$4(), (Option<Log>)Replica$.MODULE$.init$default$5());
                    replica2 = this.addReplicaIfNotExists(remoteReplica);
                }
                replica = (Replica)this.getReplica(replicaId).get();
            }
            return replica;
        }
        throw new MatchError(option);
    }

    public int getOrCreateReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public Option<Replica> getReplica(int replicaId) {
        Replica replica = this.assignedReplicaMap().get(BoxesRunTime.boxToInteger((int)replicaId));
        return replica == null ? None$.MODULE$ : new Some((Object)replica);
    }

    public int getReplica$default$1() {
        return this.kafka$cluster$Partition$$localBrokerId();
    }

    public Option<Replica> leaderReplicaIfLocal() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Object> option;
            block6: {
                Option<Replica> option2;
                option = this.leaderReplicaIdOpt();
                if (option instanceof Some) {
                    option2 = BoxesRunTime.unboxToInt((Object)((Some)option).x()) == this.kafka$cluster$Partition$$localBrokerId() ? this.getReplica(this.kafka$cluster$Partition$$localBrokerId()) : None$.MODULE$;
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Object> option3 = option;
                    if (none$ != null ? !none$.equals(option3) : option3 != null) break block6;
                    option2 = None$.MODULE$;
                }
                Option<Replica> option4 = option2;
                return option4;
            }
            throw new MatchError(option);
        }
    }

    public Replica addReplicaIfNotExists(Replica replica) {
        return this.assignedReplicaMap().putIfNotExists(BoxesRunTime.boxToInteger((int)replica.brokerId()), replica);
    }

    public Set<Replica> assignedReplicas() {
        return this.assignedReplicaMap().values().toSet();
    }

    public void removeReplica(int replicaId) {
        this.assignedReplicaMap().remove(BoxesRunTime.boxToInteger((int)replicaId));
    }

    public void delete() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            this.assignedReplicaMap().clear();
            this.inSyncReplicas_$eq((Set<Replica>)Set$.MODULE$.empty());
            this.leaderReplicaIdOpt_$eq((Option<Object>)None$.MODULE$);
            this.liftedTree1$1();
            return;
        }
    }

    public int getLeaderEpoch() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            return this.leaderEpoch();
        }
    }

    public boolean makeLeader(int controllerId, PartitionStateInfo partitionStateInfo, int correlationId) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Set<Object> allReplicas = partitionStateInfo.allReplicas();
            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = partitionStateInfo.leaderIsrAndControllerEpoch();
            LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
            this.controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
            allReplicas.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final Partition $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Replica apply(int replica) {
                    return this.$outer.getOrCreateReplica(replica);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            scala.collection.immutable.Set newInSyncReplicas = ((TraversableOnce)leaderAndIsr.isr().map((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final Partition $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final Replica apply(int r) {
                    return this.$outer.getOrCreateReplica(r);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, List$.MODULE$.canBuildFrom())).toSet();
            ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Replica replica) {
                    return replica.brokerId();
                }
            }, Set$.MODULE$.canBuildFrom())).$minus$minus(allReplicas)).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final Partition $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(int n) {
                    this.apply$mcVI$sp(n);
                }

                public void apply$mcVI$sp(int v1) {
                    this.$outer.removeReplica(v1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.assignedReplicas().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID;
                private final Partition $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Replica r) {
                    if (r.brokerId() != this.$outer.kafka$cluster$Partition$$localBrokerId()) {
                        r.logEndOffset_$eq(ReplicaManager$.MODULE$.UnknownLogEndOffset());
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            this.inSyncReplicas_$eq((Set<Replica>)newInSyncReplicas);
            this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
            this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
            this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())));
            this.maybeIncrementLeaderHW((Replica)this.getReplica(this.getReplica$default$1()).get());
            Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
            return BoxesRunTime.unboxToBoolean((Object)bl);
        }
    }

    public boolean makeFollower(int controllerId, PartitionStateInfo partitionStateInfo, Set<Broker> leaders, int correlationId) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option option;
            block6: {
                Set<Object> allReplicas = partitionStateInfo.allReplicas();
                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch = partitionStateInfo.leaderIsrAndControllerEpoch();
                LeaderAndIsr leaderAndIsr = leaderIsrAndControllerEpoch.leaderAndIsr();
                int newLeaderBrokerId$1 = leaderAndIsr.leader();
                this.controllerEpoch_$eq(leaderIsrAndControllerEpoch.controllerEpoch());
                option = leaders.find((Function1)new Serializable(this, newLeaderBrokerId$1){
                    public static final long serialVersionUID;
                    private final int newLeaderBrokerId$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final boolean apply(Broker broker) {
                        return broker.id() == this.newLeaderBrokerId$1;
                    }
                    {
                        this.newLeaderBrokerId$1 = n;
                    }
                });
                if (option instanceof Some) {
                    allReplicas.foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final Partition $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Replica apply(int r) {
                            return this.$outer.getOrCreateReplica(r);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    ((IterableLike)((Subtractable)this.assignedReplicas().map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply(Replica replica) {
                            return replica.brokerId();
                        }
                    }, Set$.MODULE$.canBuildFrom())).$minus$minus(allReplicas)).foreach((Function1)new Serializable(this){
                        public static final long serialVersionUID;
                        private final Partition $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply(int n) {
                            this.apply$mcVI$sp(n);
                        }

                        public void apply$mcVI$sp(int v1) {
                            this.$outer.removeReplica(v1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.inSyncReplicas_$eq((Set<Replica>)Set$.MODULE$.empty());
                    this.leaderEpoch_$eq(leaderAndIsr.leaderEpoch());
                    this.kafka$cluster$Partition$$zkVersion_$eq(leaderAndIsr.zkVersion());
                    this.leaderReplicaIdOpt_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)newLeaderBrokerId$1)));
                } else {
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Broker %d aborted the become-follower state change with correlation id %d from controller %d epoch %d for partition [%s,%d] new leader %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)correlationId), BoxesRunTime.boxToInteger((int)controllerId), BoxesRunTime.boxToInteger((int)leaderIsrAndControllerEpoch.controllerEpoch()), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)newLeaderBrokerId$1)})));
                }
                Boolean bl = BoxesRunTime.boxToBoolean((boolean)true);
                return BoxesRunTime.unboxToBoolean((Object)bl);
            }
            throw new MatchError((Object)option);
        }
    }

    public void updateLeaderHWAndMaybeExpandIsr(int replicaId$1, long offset$1) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            block7: {
                Option<Replica> option;
                block10: {
                    block9: {
                        BoxedUnit boxedUnit;
                        block8: {
                            Replica replica;
                            this.debug((Function0<String>)new Serializable(this, replicaId$1, offset$1){
                                public static final long serialVersionUID;
                                private final Partition $outer;
                                private final int replicaId$1;
                                private final long offset$1;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Recording follower %d position %d for partition [%s,%d].").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.replicaId$1), BoxesRunTime.boxToLong((long)this.offset$1), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId())}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.replicaId$1 = n;
                                    this.offset$1 = l;
                                }
                            });
                            Option<Replica> replicaOpt = this.getReplica(replicaId$1);
                            if (!replicaOpt.isDefined()) break block7;
                            Replica replica2 = (Replica)replicaOpt.get();
                            replica2.logEndOffset_$eq(offset$1);
                            option = this.leaderReplicaIfLocal();
                            if (!(option instanceof Some)) break block8;
                            Some some = (Some)option;
                            Replica leaderReplica = replica = (Replica)some.x();
                            Replica replica3 = (Replica)this.getReplica(replicaId$1).get();
                            long leaderHW = leaderReplica.highWatermark();
                            if (!this.inSyncReplicas().contains((Object)replica3) && ((SetLike)this.assignedReplicas().map((Function1)new Serializable(this){
                                public static final long serialVersionUID;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final int apply(Replica replica) {
                                    return replica.brokerId();
                                }
                            }, Set$.MODULE$.canBuildFrom())).contains((Object)BoxesRunTime.boxToInteger((int)replicaId$1)) && replica3.logEndOffset() >= leaderHW) {
                                Set newInSyncReplicas$1 = this.inSyncReplicas().$plus((Object)replica3);
                                this.info((Function0<String>)new Serializable(this, newInSyncReplicas$1){
                                    public static final long serialVersionUID;
                                    private final Partition $outer;
                                    private final Set newInSyncReplicas$1;

                                    static {
                                        long l = serialVersionUID = 0L;
                                    }

                                    public final String apply() {
                                        return Predef$.MODULE$.augmentString("Expanding ISR for partition [%s,%d] from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), ((TraversableOnce)this.$outer.inSyncReplicas().map((Function1)new Serializable(this){
                                            public static final long serialVersionUID;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final int apply(Replica replica) {
                                                return replica.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)this.newInSyncReplicas$1.map((Function1)new Serializable(this){
                                            public static final long serialVersionUID;

                                            static {
                                                long l = serialVersionUID = 0L;
                                            }

                                            public final int apply(Replica replica) {
                                                return replica.brokerId();
                                            }
                                        }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.newInSyncReplicas$1 = set;
                                    }
                                });
                                this.updateIsr((Set<Replica>)newInSyncReplicas$1);
                                this.replicaManager().isrExpandRate().mark();
                            }
                            this.maybeIncrementLeaderHW(leaderReplica);
                            boxedUnit = BoxedUnit.UNIT;
                            break block9;
                        }
                        None$ none$ = None$.MODULE$;
                        Option<Replica> option2 = option;
                        if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            throw new NotAssignedReplicaException(Predef$.MODULE$.augmentString("Leader %d failed to record follower %d's position %d for partition [%s,%d] since the replica %d is not recognized to be one of the assigned replicas %s for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId()), BoxesRunTime.boxToInteger((int)replicaId$1), BoxesRunTime.boxToLong((long)offset$1), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)replicaId$1), ((TraversableOnce)this.assignedReplicas().map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Replica replica) {
                    return replica.brokerId();
                }
            }, Set$.MODULE$.canBuildFrom())).mkString(","), this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId())})));
        }
    }

    public Tuple2<Object, Object> checkEnoughReplicasReachOffset(long requiredOffset$1, int requiredAcks$1) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block6: {
                Tuple2 tuple2;
                option = this.leaderReplicaIfLocal();
                if (option instanceof Some) {
                    int numAcks$1 = this.inSyncReplicas().count((Function1)new Serializable(this, requiredOffset$1){
                        public static final long serialVersionUID;
                        private final long requiredOffset$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final boolean apply(Replica r) {
                            return r.isLocal() ? true : r.logEndOffset() >= this.requiredOffset$1;
                        }
                        {
                            this.requiredOffset$1 = l;
                        }
                    });
                    this.trace((Function0<String>)new Serializable(this, requiredAcks$1, numAcks$1){
                        public static final long serialVersionUID;
                        private final Partition $outer;
                        private final int requiredAcks$1;
                        private final int numAcks$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("%d/%d acks satisfied for %s-%d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numAcks$1), BoxesRunTime.boxToInteger((int)this.requiredAcks$1), this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId())}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.requiredAcks$1 = n;
                            this.numAcks$1 = n2;
                        }
                    });
                    tuple2 = requiredAcks$1 < 0 && numAcks$1 >= this.inSyncReplicas().size() || requiredAcks$1 > 0 && numAcks$1 >= requiredAcks$1 ? new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError())) : new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NoError()));
                } else {
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block6;
                    tuple2 = new Tuple2((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)BoxesRunTime.boxToShort((short)ErrorMapping$.MODULE$.NotLeaderForPartitionCode()));
                }
                Tuple2 tuple22 = tuple2;
                return tuple22;
            }
            throw new MatchError(option);
        }
    }

    private void maybeIncrementLeaderHW(Replica leaderReplica) {
        long oldHighWatermark$1;
        Set allLogEndOffsets$1 = (Set)this.inSyncReplicas().map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final long apply(Replica replica) {
                return replica.logEndOffset();
            }
        }, Set$.MODULE$.canBuildFrom());
        long newHighWatermark$1 = BoxesRunTime.unboxToLong((Object)allLogEndOffsets$1.min((Ordering)Ordering.Long$.MODULE$));
        if (newHighWatermark$1 > (oldHighWatermark$1 = leaderReplica.highWatermark())) {
            leaderReplica.highWatermark_$eq(newHighWatermark$1);
            this.debug((Function0<String>)new Serializable(this, newHighWatermark$1){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final long newHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Highwatermark for partition [%s,%d] updated to %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), BoxesRunTime.boxToLong((long)this.newHighWatermark$1)}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = l;
                }
            });
        } else {
            this.debug((Function0<String>)new Serializable(this, allLogEndOffsets$1, newHighWatermark$1, oldHighWatermark$1){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final Set allLogEndOffsets$1;
                private final long newHighWatermark$1;
                private final long oldHighWatermark$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Old hw for partition [%s,%d] is %d. New hw is %d. All leo's are %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), BoxesRunTime.boxToLong((long)this.oldHighWatermark$1), BoxesRunTime.boxToLong((long)this.newHighWatermark$1), this.allLogEndOffsets$1.mkString(",")}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.allLogEndOffsets$1 = set;
                    this.newHighWatermark$1 = l;
                    this.oldHighWatermark$1 = l2;
                }
            });
        }
    }

    public void maybeShrinkIsr(long replicaMaxLagTimeMs, long replicaMaxLagMessages) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block10: {
                block9: {
                    BoxedUnit boxedUnit;
                    block8: {
                        option = this.leaderReplicaIfLocal();
                        if (!(option instanceof Some)) break block8;
                        Some some = (Some)option;
                        Replica replica = (Replica)some.x();
                        Replica leaderReplica = replica;
                        Set<Replica> outOfSyncReplicas = this.getOutOfSyncReplicas(leaderReplica, replicaMaxLagTimeMs, replicaMaxLagMessages);
                        if (outOfSyncReplicas.size() > 0) {
                            Set newInSyncReplicas$2 = (Set)this.inSyncReplicas().$minus$minus(outOfSyncReplicas);
                            Predef$.MODULE$.assert(newInSyncReplicas$2.size() > 0);
                            this.info((Function0<String>)new Serializable(this, newInSyncReplicas$2){
                                public static final long serialVersionUID;
                                private final Partition $outer;
                                private final Set newInSyncReplicas$2;

                                static {
                                    long l = serialVersionUID = 0L;
                                }

                                public final String apply() {
                                    return Predef$.MODULE$.augmentString("Shrinking ISR for partition [%s,%d] from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), ((TraversableOnce)this.$outer.inSyncReplicas().map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final int apply(Replica replica) {
                                            return replica.brokerId();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).mkString(","), ((TraversableOnce)this.newInSyncReplicas$2.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final int apply(Replica replica) {
                                            return replica.brokerId();
                                        }
                                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.newInSyncReplicas$2 = set;
                                }
                            });
                            this.updateIsr((Set<Replica>)newInSyncReplicas$2);
                            this.maybeIncrementLeaderHW(leaderReplica);
                            this.replicaManager().isrShrinkRate().mark();
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        break block9;
                    }
                    None$ none$ = None$.MODULE$;
                    Option<Replica> option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block10;
                    boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option);
        }
    }

    public Set<Replica> getOutOfSyncReplicas(Replica leaderReplica, long keepInSyncTimeMs$1, long keepInSyncMessages$1) {
        Set slowReplicas$1;
        long leaderLogEndOffset$1 = leaderReplica.logEndOffset();
        Set candidateReplicas = this.inSyncReplicas().$minus((Object)leaderReplica);
        Set stuckReplicas$1 = (Set)candidateReplicas.filter((Function1)new Serializable(this, keepInSyncTimeMs$1){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final long keepInSyncTimeMs$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica r) {
                return this.$outer.kafka$cluster$Partition$$time.milliseconds() - r.logEndOffsetUpdateTimeMs() > this.keepInSyncTimeMs$1;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.keepInSyncTimeMs$1 = l;
            }
        });
        if (stuckReplicas$1.size() > 0) {
            this.debug((Function0<String>)new Serializable(this, stuckReplicas$1){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final Set stuckReplicas$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Stuck replicas for partition [%s,%d] are %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), ((TraversableOnce)this.stuckReplicas$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply(Replica replica) {
                            return replica.brokerId();
                        }
                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.stuckReplicas$1 = set;
                }
            });
        }
        if ((slowReplicas$1 = (Set)candidateReplicas.filter((Function1)new Serializable(this, keepInSyncMessages$1, leaderLogEndOffset$1){
            public static final long serialVersionUID;
            private final long keepInSyncMessages$1;
            private final long leaderLogEndOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Replica r) {
                return r.logEndOffset() >= 0L && this.leaderLogEndOffset$1 - r.logEndOffset() > this.keepInSyncMessages$1;
            }
            {
                this.keepInSyncMessages$1 = l;
                this.leaderLogEndOffset$1 = l2;
            }
        })).size() > 0) {
            this.debug((Function0<String>)new Serializable(this, slowReplicas$1){
                public static final long serialVersionUID;
                private final Partition $outer;
                private final Set slowReplicas$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Slow replicas for partition [%s,%d] are %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), ((TraversableOnce)this.slowReplicas$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final int apply(Replica replica) {
                            return replica.brokerId();
                        }
                    }, Set$.MODULE$.canBuildFrom())).mkString(",")}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.slowReplicas$1 = set;
                }
            });
        }
        return stuckReplicas$1.$plus$plus((GenTraversableOnce)slowReplicas$1);
    }

    public Log.LogAppendInfo appendMessagesToLeader(ByteBufferMessageSet messages) {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            Option<Replica> option;
            block5: {
                Replica replica;
                Option<Replica> leaderReplicaOpt;
                option = leaderReplicaOpt = this.leaderReplicaIfLocal();
                if (!(option instanceof Some)) break block5;
                Some some = (Some)option;
                Replica leaderReplica = replica = (Replica)some.x();
                Log log = (Log)leaderReplica.log().get();
                Log.LogAppendInfo info = log.append(messages, true);
                this.maybeIncrementLeaderHW(leaderReplica);
                Log.LogAppendInfo logAppendInfo = info;
                return logAppendInfo;
            }
            None$ none$ = None$.MODULE$;
            Option<Replica> option2 = option;
            if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
                throw new NotLeaderForPartitionException(Predef$.MODULE$.augmentString("Leader not local for partition [%s,%d] on broker %d").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic(), BoxesRunTime.boxToInteger((int)this.partitionId()), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
            }
            throw new MatchError(option);
        }
    }

    private void updateIsr(Set<Replica> newIsr$1) {
        this.debug((Function0<String>)new Serializable(this, newIsr$1){
            public static final long serialVersionUID;
            private final Partition $outer;
            private final Set newIsr$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Updated ISR for partition [%s,%d] to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId()), this.newIsr$1.mkString(",")}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newIsr$1 = set;
            }
        });
        LeaderAndIsr newLeaderAndIsr = new LeaderAndIsr(this.kafka$cluster$Partition$$localBrokerId(), this.leaderEpoch(), (List<Object>)((TraversableOnce)newIsr$1.map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final int apply(Replica r) {
                return r.brokerId();
            }
        }, Set$.MODULE$.canBuildFrom())).toList(), this.kafka$cluster$Partition$$zkVersion());
        Tuple2<Object, Object> tuple2 = ZkUtils$.MODULE$.conditionalUpdatePersistentPath(this.zkClient(), ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(this.topic(), this.partitionId()), ZkUtils$.MODULE$.leaderAndIsrZkData(newLeaderAndIsr, this.controllerEpoch()), this.kafka$cluster$Partition$$zkVersion());
        if (tuple2 != null) {
            Tuple2 tuple22 = new Tuple2(tuple2._1(), tuple2._2());
            boolean updateSucceeded = BoxesRunTime.unboxToBoolean((Object)tuple22._1());
            int newVersion = tuple22._2$mcI$sp();
            if (updateSucceeded) {
                this.inSyncReplicas_$eq(newIsr$1);
                this.kafka$cluster$Partition$$zkVersion_$eq(newVersion);
                this.trace((Function0<String>)new Serializable(this, newIsr$1){
                    public static final long serialVersionUID;
                    private final Partition $outer;
                    private final Set newIsr$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("ISR updated to [%s] and zkVersion updated to [%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newIsr$1.mkString(","), BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$zkVersion())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.newIsr$1 = set;
                    }
                });
            } else {
                this.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;
                    private final Partition $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Cached zkVersion [%d] not equal to that in zookeeper, skip updating ISR").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.kafka$cluster$Partition$$zkVersion())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            return;
        }
        throw new MatchError(tuple2);
    }

    public boolean equals(Object that) {
        if (that instanceof Partition) {
            Partition other = (Partition)that;
            return this.topic().equals(other.topic()) && this.partitionId() == other.partitionId();
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.partitionId();
    }

    public String toString() {
        Object object = this.leaderIsrUpdateLock();
        synchronized (object) {
            StringBuilder partitionString = new StringBuilder();
            partitionString.append(new StringBuilder().append((Object)"Topic: ").append((Object)this.topic()).toString());
            partitionString.append(new StringBuilder().append((Object)"; Partition: ").append((Object)BoxesRunTime.boxToInteger((int)this.partitionId())).toString());
            partitionString.append(new StringBuilder().append((Object)"; Leader: ").append(this.leaderReplicaIdOpt()).toString());
            partitionString.append(new StringBuilder().append((Object)"; AssignedReplicas: ").append((Object)this.assignedReplicaMap().keys().mkString(",")).toString());
            partitionString.append(new StringBuilder().append((Object)"; InSyncReplicas: ").append((Object)((TraversableOnce)this.inSyncReplicas().map((Function1)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final int apply(Replica replica) {
                    return replica.brokerId();
                }
            }, Set$.MODULE$.canBuildFrom())).mkString(",")).toString());
            String string = partitionString.toString();
            return string;
        }
    }

    private final void liftedTree1$1() {
        try {
            this.logManager().deleteLog(new TopicAndPartition(this.topic(), this.partitionId()));
        }
        catch (IOException iOException) {
            this.fatal((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;
                private final Partition $outer;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Error deleting the log for partition [%s,%d]").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic(), BoxesRunTime.boxToInteger((int)this.$outer.partitionId())}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Function0<Throwable>)new Serializable(this, iOException){
                public static final long serialVersionUID;
                private final IOException e$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final IOException apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = iOException;
                }
            });
            Runtime.getRuntime().halt(1);
        }
    }

    public Partition(String topic, int partitionId, int replicationFactor, Time time, ReplicaManager replicaManager) {
        this.topic = topic;
        this.partitionId = partitionId;
        this.replicationFactor = replicationFactor;
        this.kafka$cluster$Partition$$time = time;
        this.replicaManager = replicaManager;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.kafka$cluster$Partition$$localBrokerId = replicaManager.config().brokerId();
        this.logManager = replicaManager.logManager();
        this.zkClient = replicaManager.zkClient();
        this.leaderReplicaIdOpt = None$.MODULE$;
        this.inSyncReplicas = Set$.MODULE$.empty();
        this.assignedReplicaMap = new Pool(Pool$.MODULE$.init$default$1());
        this.leaderIsrUpdateLock = new Object();
        this.kafka$cluster$Partition$$zkVersion = LeaderAndIsr$.MODULE$.initialZKVersion();
        this.leaderEpoch = LeaderAndIsr$.MODULE$.initialLeaderEpoch() - 1;
        this.controllerEpoch = KafkaController$.MODULE$.InitialControllerEpoch() - 1;
        this.logIdent_$eq(Predef$.MODULE$.augmentString("Partition [%s,%d] on broker %d: ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionId), BoxesRunTime.boxToInteger((int)this.kafka$cluster$Partition$$localBrokerId())})));
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
        this.newGauge(new StringBuilder().append((Object)topic).append((Object)"-").append((Object)BoxesRunTime.boxToInteger((int)partitionId)).append((Object)"-UnderReplicated").toString(), new Gauge<Object>(this){
            private final Partition $outer;

            public int value() {
                return this.$outer.isUnderReplicated() ? 1 : 0;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }
}

