/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.common.StateChangeFailedException;
import kafka.common.TopicAndPartition;
import kafka.controller.Callbacks;
import kafka.controller.ControllerBrokerRequestBatch;
import kafka.controller.ControllerContext;
import kafka.controller.ControllerStats$;
import kafka.controller.KafkaController;
import kafka.controller.KafkaController$;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.controller.NewReplica$;
import kafka.controller.NonExistentReplica$;
import kafka.controller.OfflineReplica$;
import kafka.controller.OnlineReplica$;
import kafka.controller.PartitionAndReplica;
import kafka.controller.ReplicaDeletionIneligible$;
import kafka.controller.ReplicaDeletionStarted$;
import kafka.controller.ReplicaDeletionSuccessful$;
import kafka.controller.ReplicaState;
import kafka.controller.ReplicaStateMachine$;
import kafka.controller.ReplicaStateMachine$BrokerChangeListener$;
import kafka.controller.ReplicaStateMachine$BrokerChangeListener$$anonfun$handleChildChange$1$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Utils$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkChildListener;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001\u001d\u00111CU3qY&\u001c\u0017m\u0015;bi\u0016l\u0015m\u00195j]\u0016T!a\u0001\u0003\u0002\u0015\r|g\u000e\u001e:pY2,'OC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001\u0005\u0011-A\u0011\u0011BD\u0007\u0002\u0015)\u00111\u0002D\u0001\u0005Y\u0006twMC\u0001\u000e\u0003\u0011Q\u0017M^1\n\u0005=Q!AB(cU\u0016\u001cG\u000f\u0005\u0002\u0012)5\t!C\u0003\u0002\u0014\t\u0005)Q\u000f^5mg&\u0011QC\u0005\u0002\b\u0019><w-\u001b8h!\t9\"$D\u0001\u0019\u0015\u0005I\u0012!B:dC2\f\u0017BA\u000e\u0019\u0005-\u00196-\u00197b\u001f\nTWm\u0019;\t\u0011\r\u0001!\u0011!Q\u0001\nu\u0001\"AH\u0010\u000e\u0003\tI!\u0001\t\u0002\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJDQA\t\u0001\u0005\u0002\r\na\u0001P5oSRtDC\u0001\u0013&!\tq\u0002\u0001C\u0003\u0004C\u0001\u0007Q\u0004C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\u0002#\r|g\u000e\u001e:pY2,'oQ8oi\u0016DH/F\u0001*!\tq\"&\u0003\u0002,\u0005\t\t2i\u001c8ue>dG.\u001a:D_:$X\r\u001f;\t\r5\u0002\u0001\u0015!\u0003*\u0003I\u0019wN\u001c;s_2dWM]\"p]R,\u0007\u0010\u001e\u0011\t\u000f=\u0002!\u0019!C\u0005a\u0005a1m\u001c8ue>dG.\u001a:JIV\t\u0011\u0007\u0005\u0002\u0018e%\u00111\u0007\u0007\u0002\u0004\u0013:$\bBB\u001b\u0001A\u0003%\u0011'A\u0007d_:$(o\u001c7mKJLE\r\t\u0005\bo\u0001\u0011\r\u0011\"\u00039\u0003!Q8n\u00117jK:$X#A\u001d\u0011\u0005i\nU\"A\u001e\u000b\u0005qj\u0014\u0001\u0003>lG2LWM\u001c;\u000b\u0005yz\u0014AB%1\u0013R,7MC\u0001A\u0003\ry'oZ\u0005\u0003\u0005n\u0012\u0001BW6DY&,g\u000e\u001e\u0005\u0007\t\u0002\u0001\u000b\u0011B\u001d\u0002\u0013i\\7\t\\5f]R\u0004\u0003b\u0002$\u0001\u0001\u0004%\taR\u0001\re\u0016\u0004H.[2b'R\fG/Z\u000b\u0002\u0011B!\u0011J\u0014)T\u001b\u0005Q%BA&M\u0003\u001diW\u000f^1cY\u0016T!!\u0014\r\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002P\u0015\n\u0019Q*\u00199\u0011\u0005y\t\u0016B\u0001*\u0003\u0005M\u0001\u0016M\u001d;ji&|g.\u00118e%\u0016\u0004H.[2b!\tqB+\u0003\u0002V\u0005\ta!+\u001a9mS\u000e\f7\u000b^1uK\"9q\u000b\u0001a\u0001\n\u0003A\u0016\u0001\u0005:fa2L7-Y*uCR,w\fJ3r)\tIF\f\u0005\u0002\u00185&\u00111\f\u0007\u0002\u0005+:LG\u000fC\u0004^-\u0006\u0005\t\u0019\u0001%\u0002\u0007a$\u0013\u0007\u0003\u0004`\u0001\u0001\u0006K\u0001S\u0001\u000ee\u0016\u0004H.[2b'R\fG/\u001a\u0011\t\u000f\u0005\u0004!\u0019!C\u0001E\u0006\u0011\"M]8lKJ\u0014V-];fgR\u0014\u0015\r^2i+\u0005\u0019\u0007C\u0001\u0010e\u0013\t)'A\u0001\u000fD_:$(o\u001c7mKJ\u0014%o\\6feJ+\u0017/^3ti\n\u000bGo\u00195\t\r\u001d\u0004\u0001\u0015!\u0003d\u0003M\u0011'o\\6feJ+\u0017/^3ti\n\u000bGo\u00195!\u0011\u001dI\u0007A1A\u0005\n)\f!\u0002[1t'R\f'\u000f^3e+\u0005Y\u0007C\u00017t\u001b\u0005i'B\u00018p\u0003\u0019\tGo\\7jG*\u0011\u0001/]\u0001\u000bG>t7-\u001e:sK:$(B\u0001:\r\u0003\u0011)H/\u001b7\n\u0005Ql'!D!u_6L7MQ8pY\u0016\fg\u000e\u0003\u0004w\u0001\u0001\u0006Ia[\u0001\fQ\u0006\u001c8\u000b^1si\u0016$\u0007\u0005C\u0004y\u0001\t\u0007I\u0011B=\u0002#M$\u0018\r^3DQ\u0006tw-\u001a'pO\u001e,'/F\u0001{!\rY\u0018\u0011A\u0007\u0002y*\u0011QP`\u0001\u0006Y><GG\u001b\u0006\u0003\u007f~\na!\u00199bG\",\u0017bAA\u0002y\n1Aj\\4hKJDq!a\u0002\u0001A\u0003%!0\u0001\nti\u0006$Xm\u00115b]\u001e,Gj\\4hKJ\u0004\u0003bBA\u0006\u0001\u0011\u0005\u0011QB\u0001\bgR\f'\u000f^;q)\u0005I\u0006bBA\t\u0001\u0011\u0005\u0011QB\u0001\u0012e\u0016<\u0017n\u001d;fe2K7\u000f^3oKJ\u001c\bbBA\u000b\u0001\u0011\u0005\u0011QB\u0001\tg\",H\u000fZ8x]\"9\u0011\u0011\u0004\u0001\u0005\u0002\u0005m\u0011A\u00055b]\u0012dWm\u0015;bi\u0016\u001c\u0005.\u00198hKN$r!WA\u000f\u0003S\ti\u0003\u0003\u0005\u0002 \u0005]\u0001\u0019AA\u0011\u0003!\u0011X\r\u001d7jG\u0006\u001c\b#BA\u0012\u0003K\u0001V\"\u0001'\n\u0007\u0005\u001dBJA\u0002TKRDq!a\u000b\u0002\u0018\u0001\u00071+A\u0006uCJ<W\r^*uCR,\u0007BCA\u0018\u0003/\u0001\n\u00111\u0001\u00022\u0005I1-\u00197mE\u0006\u001c7n\u001d\t\u0004=\u0005M\u0012bAA\u001b\u0005\tI1)\u00197mE\u0006\u001c7n\u001d\u0005\b\u0003s\u0001A\u0011AA\u001e\u0003EA\u0017M\u001c3mKN#\u0018\r^3DQ\u0006tw-\u001a\u000b\b3\u0006u\u0012\u0011IA\"\u0011\u001d\ty$a\u000eA\u0002A\u000b1\u0003]1si&$\u0018n\u001c8B]\u0012\u0014V\r\u001d7jG\u0006Dq!a\u000b\u00028\u0001\u00071\u000b\u0003\u0005\u00020\u0005]\u0002\u0019AA\u0019\u0011\u001d\t9\u0005\u0001C\u0001\u0003\u0013\nQ$\u0019:f\u00032d'+\u001a9mS\u000e\f7OR8s)>\u0004\u0018n\u0019#fY\u0016$X\r\u001a\u000b\u0005\u0003\u0017\n\t\u0006E\u0002\u0018\u0003\u001bJ1!a\u0014\u0019\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u0015\u0002F\u0001\u0007\u0011QK\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003/\niFD\u0002\u0018\u00033J1!a\u0017\u0019\u0003\u0019\u0001&/\u001a3fM&!\u0011qLA1\u0005\u0019\u0019FO]5oO*\u0019\u00111\f\r\t\u000f\u0005\u0015\u0004\u0001\"\u0001\u0002h\u0005I\u0013n]!u\u0019\u0016\f7\u000f^(oKJ+\u0007\u000f\\5dC&sG)\u001a7fi&|gn\u0015;beR,Gm\u0015;bi\u0016$B!a\u0013\u0002j!A\u00111KA2\u0001\u0004\t)\u0006C\u0004\u0002n\u0001!\t!a\u001c\u0002\u001fI,\u0007\u000f\\5dCNLen\u0015;bi\u0016$b!!\t\u0002r\u0005M\u0004\u0002CA*\u0003W\u0002\r!!\u0016\t\u000f\u0005U\u00141\u000ea\u0001'\u0006)1\u000f^1uK\"9\u0011\u0011\u0010\u0001\u0005\u0002\u0005m\u0014\u0001\u0007:fa2L7-Y:J]\u0012+G.\u001a;j_:\u001cF/\u0019;fgR!\u0011\u0011EA?\u0011!\t\u0019&a\u001eA\u0002\u0005U\u0003bBAA\u0001\u0011%\u00111Q\u0001\u001aCN\u001cXM\u001d;WC2LG\r\u0015:fm&|Wo]*uCR,7\u000fF\u0004Z\u0003\u000b\u000b9)!%\t\u000f\u0005}\u0012q\u0010a\u0001!\"A\u0011\u0011RA@\u0001\u0004\tY)\u0001\u0006ge>l7\u000b^1uKN\u0004R!a\t\u0002\u000eNK1!a$M\u0005\r\u0019V-\u001d\u0005\b\u0003W\ty\b1\u0001T\u0011\u001d\t)\n\u0001C\u0005\u0003/\u000bAD]3hSN$XM\u001d\"s_.,'o\u00115b]\u001e,G*[:uK:,'\u000f\u0006\u0002\u0002\u001aB1\u00111TAO\u0003Ck\u0011!]\u0005\u0004\u0003?\u000b(\u0001\u0002'jgR\u00042!CAR\u0013\r\tyF\u0003\u0005\b\u0003O\u0003A\u0011BA\u0007\u0003YIg.\u001b;jC2L'0\u001a*fa2L7-Y*uCR,\u0007bBAV\u0001\u0011\u0005\u0011QV\u0001\u001ba\u0006\u0014H/\u001b;j_:\u001c\u0018i]:jO:,G\rV8Ce>\\WM\u001d\u000b\u0007\u0003_\u000bi,a1\u0011\r\u0005\r\u0012QRAY!\u0011\t\u0019,!/\u000e\u0005\u0005U&bAA\\\t\u000511m\\7n_:LA!a/\u00026\n\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\t\u0011\u0005}\u0016\u0011\u0016a\u0001\u0003\u0003\fa\u0001^8qS\u000e\u001c\bCBA\u0012\u0003\u001b\u000b)\u0006C\u0004\u0002F\u0006%\u0006\u0019A\u0019\u0002\u0011\t\u0014xn[3s\u0013\u00124a!!3\u0001\u0001\u0005-'\u0001\u0006\"s_.,'o\u00115b]\u001e,G*[:uK:,'oE\u0004\u0002H\"\ti\r\u0005\f\u0011\u0007i\ny-C\u0002\u0002Rn\u0012\u0001#\u0013.l\u0007\"LG\u000e\u001a'jgR,g.\u001a:\t\u000f\t\n9\r\"\u0001\u0002VR\u0011\u0011q\u001b\t\u0005\u00033\f9-D\u0001\u0001\u0011!\ti.a2\u0005\u0002\u0005}\u0017!\u00055b]\u0012dWm\u00115jY\u0012\u001c\u0005.\u00198hKR)\u0011,!9\u0002f\"A\u00111]An\u0001\u0004\t)&\u0001\u0006qCJ,g\u000e\u001e)bi\"D\u0001\"a:\u0002\\\u0002\u0007\u0011\u0011^\u0001\u0012GV\u0014(/\u001a8u\u0005J|7.\u001a:MSN$\bCBAN\u0003;\u000b)\u0006C\u0005\u0002n\u0002\t\n\u0011\"\u0001\u0002p\u0006a\u0002.\u00198eY\u0016\u001cF/\u0019;f\u0007\"\fgnZ3tI\u0011,g-Y;mi\u0012\u001aTCAAyU\u0011\t\t$a=,\u0005\u0005U\b\u0003BA|\u0005\u0003i!!!?\u000b\t\u0005m\u0018Q`\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a@\u0019\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005\u0007\tIPA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class ReplicaStateMachine
implements Logging {
    public final KafkaController kafka$controller$ReplicaStateMachine$$controller;
    private final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext;
    private final int controllerId;
    private final ZkClient kafka$controller$ReplicaStateMachine$$zkClient;
    private Map<PartitionAndReplica, ReplicaState> replicaState;
    private final ControllerBrokerRequestBatch brokerRequestBatch;
    private final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted;
    private final Logger stateChangeLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        ReplicaStateMachine replicaStateMachine = this;
        synchronized (replicaStateMachine) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
        this.loggerName = string;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public final ControllerContext kafka$controller$ReplicaStateMachine$$controllerContext() {
        return this.kafka$controller$ReplicaStateMachine$$controllerContext;
    }

    private int controllerId() {
        return this.controllerId;
    }

    public final ZkClient kafka$controller$ReplicaStateMachine$$zkClient() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient;
    }

    public Map<PartitionAndReplica, ReplicaState> replicaState() {
        return this.replicaState;
    }

    public void replicaState_$eq(Map<PartitionAndReplica, ReplicaState> map) {
        this.replicaState = map;
    }

    public ControllerBrokerRequestBatch brokerRequestBatch() {
        return this.brokerRequestBatch;
    }

    public final AtomicBoolean kafka$controller$ReplicaStateMachine$$hasStarted() {
        return this.kafka$controller$ReplicaStateMachine$$hasStarted;
    }

    private Logger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    public void startup() {
        this.initializeReplicaState();
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(true);
        this.handleStateChanges(this.kafka$controller$ReplicaStateMachine$$controllerContext().allLiveReplicas(), OnlineReplica$.MODULE$, this.handleStateChanges$default$3());
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Started replica state machine with initial state -> ").append((Object)this.$outer.replicaState().toString()).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void registerListeners() {
        this.registerBrokerChangeListener();
    }

    public void shutdown() {
        this.kafka$controller$ReplicaStateMachine$$hasStarted().set(false);
        this.replicaState().clear();
    }

    public void handleStateChanges(Set<PartitionAndReplica> replicas$1, ReplicaState targetState$1, Callbacks callbacks$1) {
        if (replicas$1.size() > 0) {
            this.info((Function0<String>)new Serializable(this, replicas$1, targetState$1){
                public static final long serialVersionUID;
                private final Set replicas$1;
                private final ReplicaState targetState$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Invoking state change to %s for replicas %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1, this.replicas$1.mkString(",")}));
                }
                {
                    this.replicas$1 = set;
                    this.targetState$1 = replicaState;
                }
            });
            try {
                this.brokerRequestBatch().newBatch();
                replicas$1.foreach((Function1)new Serializable(this, targetState$1, callbacks$1){
                    public static final long serialVersionUID;
                    private final ReplicaStateMachine $outer;
                    private final ReplicaState targetState$1;
                    private final Callbacks callbacks$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply(PartitionAndReplica r) {
                        this.$outer.handleStateChange(r, this.targetState$1, this.callbacks$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.targetState$1 = replicaState;
                        this.callbacks$1 = callbacks;
                    }
                });
                this.brokerRequestBatch().sendRequestsToBrokers(this.kafka$controller$ReplicaStateMachine$$controller.epoch(), this.kafka$controller$ReplicaStateMachine$$controllerContext().correlationId().getAndIncrement());
            }
            catch (Throwable throwable) {
                this.error((Function0<String>)new Serializable(this, targetState$1){
                    public static final long serialVersionUID;
                    private final ReplicaState targetState$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return Predef$.MODULE$.augmentString("Error while moving some replicas to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.targetState$1}));
                    }
                    {
                        this.targetState$1 = replicaState;
                    }
                }, (Function0<Throwable>)new Serializable(this, throwable){
                    public static final long serialVersionUID;
                    private final Throwable e$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final Throwable apply() {
                        return this.e$1;
                    }
                    {
                        this.e$1 = throwable;
                    }
                });
            }
        }
    }

    public void handleStateChange(PartitionAndReplica partitionAndReplica, ReplicaState targetState, Callbacks callbacks) {
        block14: {
            TopicAndPartition topicAndPartition;
            int replicaId$1;
            block15: {
                String topic = partitionAndReplica.topic();
                int partition = partitionAndReplica.partition();
                replicaId$1 = partitionAndReplica.replica();
                topicAndPartition = new TopicAndPartition(topic, partition);
                if (!this.kafka$controller$ReplicaStateMachine$$hasStarted().get()) break block15;
                ReplicaState currState = (ReplicaState)this.replicaState().getOrElseUpdate((Object)partitionAndReplica, (Function0)new Serializable(this){
                    public static final long serialVersionUID;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final NonExistentReplica$ apply() {
                        return NonExistentReplica$.MODULE$;
                    }
                });
                try {
                    ReplicaState replicaState;
                    block25: {
                        Option option;
                        block30: {
                            boolean leaderAndIsrIsEmpty;
                            block28: {
                                boolean bl;
                                block26: {
                                    Option<LeaderIsrAndControllerEpoch> option2;
                                    block29: {
                                        block27: {
                                            LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch;
                                            Seq replicaAssignment;
                                            block20: {
                                                Option option3;
                                                block24: {
                                                    block22: {
                                                        block23: {
                                                            block21: {
                                                                block16: {
                                                                    Option<LeaderIsrAndControllerEpoch> option4;
                                                                    block19: {
                                                                        block18: {
                                                                            block17: {
                                                                                Option<LeaderIsrAndControllerEpoch> leaderIsrAndControllerEpochOpt;
                                                                                replicaAssignment = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                                replicaState = targetState;
                                                                                NewReplica$ newReplica$ = NewReplica$.MODULE$;
                                                                                ReplicaState replicaState2 = replicaState;
                                                                                if (newReplica$ != null ? !newReplica$.equals(replicaState2) : replicaState2 != null) break block16;
                                                                                this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NonExistentReplica$[]{NonExistentReplica$.MODULE$})), targetState);
                                                                                option4 = leaderIsrAndControllerEpochOpt = ZkUtils$.MODULE$.getLeaderIsrAndEpochForPartition(this.kafka$controller$ReplicaStateMachine$$zkClient(), topic, partition);
                                                                                if (!(option4 instanceof Some)) break block17;
                                                                                Some some = (Some)option4;
                                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch2 = (LeaderIsrAndControllerEpoch)some.x();
                                                                                LeaderIsrAndControllerEpoch leaderIsrAndControllerEpoch3 = leaderIsrAndControllerEpoch2;
                                                                                if (leaderIsrAndControllerEpoch3.leaderAndIsr().leader() == replicaId$1) {
                                                                                    throw new StateChangeFailedException(new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Replica %d for partition %s cannot be moved to NewReplica").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition}))).append((Object)"state as it is being requested to become leader").toString());
                                                                                }
                                                                                this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic, partition, leaderIsrAndControllerEpoch3, (Seq<Object>)replicaAssignment, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                                                break block18;
                                                                            }
                                                                            None$ none$ = None$.MODULE$;
                                                                            Option<LeaderIsrAndControllerEpoch> option5 = option4;
                                                                            if (none$ != null ? !none$.equals(option5) : option5 != null) break block19;
                                                                        }
                                                                        this.replicaState().put((Object)partitionAndReplica, (Object)NewReplica$.MODULE$);
                                                                        this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                        break block14;
                                                                    }
                                                                    throw new MatchError(option4);
                                                                }
                                                                ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
                                                                ReplicaState replicaState3 = replicaState;
                                                                if (!(replicaDeletionStarted$ != null ? !replicaDeletionStarted$.equals(replicaState3) : replicaState3 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OfflineReplica$[]{OfflineReplica$.MODULE$})), targetState);
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionStarted$.MODULE$);
                                                                    this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic, partition, true, callbacks.stopReplicaResponseCallback());
                                                                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                    break block14;
                                                                }
                                                                ReplicaDeletionIneligible$ replicaDeletionIneligible$ = ReplicaDeletionIneligible$.MODULE$;
                                                                ReplicaState replicaState4 = replicaState;
                                                                if (!(replicaDeletionIneligible$ != null ? !replicaDeletionIneligible$.equals(replicaState4) : replicaState4 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState);
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                                                                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                    break block14;
                                                                }
                                                                ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
                                                                ReplicaState replicaState5 = replicaState;
                                                                if (!(replicaDeletionSuccessful$ != null ? !replicaDeletionSuccessful$.equals(replicaState5) : replicaState5 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionStarted$[]{ReplicaDeletionStarted$.MODULE$})), targetState);
                                                                    this.replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionSuccessful$.MODULE$);
                                                                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                    break block14;
                                                                }
                                                                NonExistentReplica$ nonExistentReplica$ = NonExistentReplica$.MODULE$;
                                                                ReplicaState replicaState6 = replicaState;
                                                                if (!(nonExistentReplica$ != null ? !nonExistentReplica$.equals(replicaState6) : replicaState6 != null)) {
                                                                    this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ReplicaDeletionSuccessful$[]{ReplicaDeletionSuccessful$.MODULE$})), targetState);
                                                                    Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                    this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.filterNot((Function1)new Serializable(this, replicaId$1){
                                                                        public static final long serialVersionUID;
                                                                        private final int replicaId$1;

                                                                        static {
                                                                            long l = serialVersionUID = 0L;
                                                                        }

                                                                        public final boolean apply(int n) {
                                                                            return this.apply$mcZI$sp(n);
                                                                        }

                                                                        public boolean apply$mcZI$sp(int v1) {
                                                                            return v1 == this.replicaId$1;
                                                                        }
                                                                        {
                                                                            this.replicaId$1 = n;
                                                                        }
                                                                    }));
                                                                    this.replicaState().remove((Object)partitionAndReplica);
                                                                    this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                    break block14;
                                                                }
                                                                OnlineReplica$ onlineReplica$ = OnlineReplica$.MODULE$;
                                                                ReplicaState replicaState7 = replicaState;
                                                                if (onlineReplica$ != null ? !onlineReplica$.equals(replicaState7) : replicaState7 != null) break block20;
                                                                this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState);
                                                                ReplicaState replicaState8 = (ReplicaState)this.replicaState().apply((Object)partitionAndReplica);
                                                                NewReplica$ newReplica$ = NewReplica$.MODULE$;
                                                                ReplicaState replicaState9 = replicaState8;
                                                                if (newReplica$ != null ? !newReplica$.equals(replicaState9) : replicaState9 != null) break block21;
                                                                Seq currentAssignedReplicas = (Seq)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().apply((Object)topicAndPartition);
                                                                Object object = currentAssignedReplicas.contains((Object)BoxesRunTime.boxToInteger((int)replicaId$1)) ? BoxedUnit.UNIT : this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().put((Object)topicAndPartition, currentAssignedReplicas.$colon$plus((Object)BoxesRunTime.boxToInteger((int)replicaId$1), Seq$.MODULE$.canBuildFrom()));
                                                                this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                                break block22;
                                                            }
                                                            option3 = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                                            if (!(option3 instanceof Some)) break block23;
                                                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic, partition, (LeaderIsrAndControllerEpoch)((Some)option3).x(), (Seq<Object>)replicaAssignment, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                                            this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                            this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                                            break block22;
                                                        }
                                                        None$ none$ = None$.MODULE$;
                                                        Option option6 = option3;
                                                        if (none$ != null ? !none$.equals(option6) : option6 != null) break block24;
                                                    }
                                                    this.replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                                    break block14;
                                                }
                                                throw new MatchError((Object)option3);
                                            }
                                            OfflineReplica$ offlineReplica$ = OfflineReplica$.MODULE$;
                                            ReplicaState replicaState10 = replicaState;
                                            if (offlineReplica$ != null ? !offlineReplica$.equals(replicaState10) : replicaState10 != null) break block25;
                                            this.assertValidPreviousStates(partitionAndReplica, (Seq<ReplicaState>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{NewReplica$.MODULE$, OnlineReplica$.MODULE$, OfflineReplica$.MODULE$, ReplicaDeletionIneligible$.MODULE$})), targetState);
                                            this.brokerRequestBatch().addStopReplicaRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{replicaId$1})), topic, partition, false, (Function2<RequestOrResponse, Object, BoxedUnit>)this.brokerRequestBatch().addStopReplicaRequestForBrokers$default$5());
                                            option = this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionLeadershipInfo().get((Object)topicAndPartition);
                                            if (!(option instanceof Some)) break block26;
                                            option2 = this.kafka$controller$ReplicaStateMachine$$controller.removeReplicaFromIsr(topic, partition, replicaId$1);
                                            if (!(option2 instanceof Some)) break block27;
                                            Some some = (Some)option2;
                                            LeaderIsrAndControllerEpoch updatedLeaderIsrAndControllerEpoch = leaderIsrAndControllerEpoch = (LeaderIsrAndControllerEpoch)some.x();
                                            this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers((Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{updatedLeaderIsrAndControllerEpoch.leaderAndIsr().leader()})), topic, partition, updatedLeaderIsrAndControllerEpoch, (Seq<Object>)replicaAssignment, (Function1<RequestOrResponse, BoxedUnit>)this.brokerRequestBatch().addLeaderAndIsrRequestForBrokers$default$6());
                                            this.replicaState().put((Object)partitionAndReplica, (Object)OfflineReplica$.MODULE$);
                                            this.stateChangeLogger().trace((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d changed state of replica %d for partition %s from %s to %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, currState, targetState})));
                                            bl = false;
                                            break block28;
                                        }
                                        None$ none$ = None$.MODULE$;
                                        Option<LeaderIsrAndControllerEpoch> option7 = option2;
                                        if (none$ != null ? !none$.equals(option7) : option7 != null) break block29;
                                        bl = true;
                                        break block28;
                                    }
                                    throw new MatchError(option2);
                                }
                                None$ none$ = None$.MODULE$;
                                Option option8 = option;
                                if (none$ != null ? !none$.equals(option8) : option8 != null) break block30;
                                bl = leaderAndIsrIsEmpty = true;
                            }
                            if (leaderAndIsrIsEmpty) {
                                throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Failed to change state of replica %d for partition %s since the leader and isr path in zookeeper is empty").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition})));
                            }
                            break block14;
                        }
                        throw new MatchError((Object)option);
                    }
                    throw new MatchError((Object)replicaState);
                }
                catch (Throwable throwable) {
                    this.stateChangeLogger().error((Object)Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition [%s,%d] from %s to %s failed").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topic, BoxesRunTime.boxToInteger((int)partition), currState, targetState})), throwable);
                }
            }
            throw new StateChangeFailedException(Predef$.MODULE$.augmentString("Controller %d epoch %d initiated state change of replica %d for partition %s to %s failed because replica state machine has not started").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.controllerId()), BoxesRunTime.boxToInteger((int)this.kafka$controller$ReplicaStateMachine$$controller.epoch()), BoxesRunTime.boxToInteger((int)replicaId$1), topicAndPartition, targetState})));
        }
    }

    public Callbacks handleStateChanges$default$3() {
        return new Callbacks.CallbackBuilder().build();
    }

    public boolean areAllReplicasForTopicDeleted(String topic$1) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic$1);
        scala.collection.immutable.Map replicaStatesForTopic$1 = ((TraversableOnce)replicasForTopic2.map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<PartitionAndReplica, ReplicaState> apply(PartitionAndReplica r) {
                return new Tuple2((Object)r, this.$outer.replicaState().apply((Object)r));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        this.debug((Function0<String>)new Serializable(this, topic$1, replicaStatesForTopic$1){
            public static final long serialVersionUID;
            private final String topic$1;
            private final scala.collection.immutable.Map replicaStatesForTopic$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Are all replicas for topic %s deleted %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, this.replicaStatesForTopic$1}));
            }
            {
                this.topic$1 = string;
                this.replicaStatesForTopic$1 = map;
            }
        });
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic$1.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(boolean deletionState, Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (!deletionState) return false;
                Object object = r._2();
                ReplicaDeletionSuccessful$ replicaDeletionSuccessful$ = ReplicaDeletionSuccessful$.MODULE$;
                if (object != null) {
                    if (!object.equals(replicaDeletionSuccessful$)) return false;
                    return true;
                }
                if (replicaDeletionSuccessful$ == null) return true;
                return false;
            }
        }));
    }

    public boolean isAtLeastOneReplicaInDeletionStartedState(String topic) {
        Set<PartitionAndReplica> replicasForTopic2 = this.kafka$controller$ReplicaStateMachine$$controller.controllerContext().replicasForTopic(topic);
        scala.collection.immutable.Map replicaStatesForTopic = ((TraversableOnce)replicasForTopic2.map((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final Tuple2<PartitionAndReplica, ReplicaState> apply(PartitionAndReplica r) {
                return new Tuple2((Object)r, this.$outer.replicaState().apply((Object)r));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        return BoxesRunTime.unboxToBoolean((Object)replicaStatesForTopic.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)false), (Function2)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(boolean deletionState, Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (deletionState) return true;
                Object object = r._2();
                ReplicaDeletionStarted$ replicaDeletionStarted$ = ReplicaDeletionStarted$.MODULE$;
                if (object != null) {
                    if (!object.equals(replicaDeletionStarted$)) return false;
                    return true;
                }
                if (replicaDeletionStarted$ == null) return true;
                return false;
            }
        }));
    }

    public Set<PartitionAndReplica> replicasInState(String topic$2, ReplicaState state$1) {
        return ((MapLike)this.replicaState().filter((Function1)new Serializable(this, topic$2, state$1){
            public static final long serialVersionUID;
            private final String topic$2;
            private final ReplicaState state$1;

            static {
                long l = serialVersionUID = 0L;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                if (!((PartitionAndReplica)r._1()).topic().equals(this.topic$2)) return false;
                Object object = r._2();
                ReplicaState replicaState = this.state$1;
                if (object != null) {
                    if (!object.equals(replicaState)) return false;
                    return true;
                }
                if (replicaState == null) return true;
                return false;
            }
            {
                this.topic$2 = string;
                this.state$1 = replicaState;
            }
        })).keySet();
    }

    public Set<PartitionAndReplica> replicasInDeletionStates(String topic$3) {
        Set deletionStates$1 = (Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{ReplicaDeletionStarted$.MODULE$, ReplicaDeletionSuccessful$.MODULE$, ReplicaDeletionIneligible$.MODULE$}));
        return ((MapLike)this.replicaState().filter((Function1)new Serializable(this, topic$3, deletionStates$1){
            public static final long serialVersionUID;
            private final String topic$3;
            private final Set deletionStates$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<PartitionAndReplica, ReplicaState> r) {
                return ((PartitionAndReplica)r._1()).topic().equals(this.topic$3) && JavaConversions$.MODULE$.setAsJavaSet(this.deletionStates$1).contains(r._2());
            }
            {
                this.topic$3 = string;
                this.deletionStates$1 = set;
            }
        })).keySet();
    }

    private void assertValidPreviousStates(PartitionAndReplica partitionAndReplica$1, Seq<ReplicaState> fromStates$1, ReplicaState targetState$2) {
        Predef$.MODULE$.assert(fromStates$1.contains(this.replicaState().apply((Object)partitionAndReplica$1)), (Function0)new Serializable(this, partitionAndReplica$1, fromStates$1, targetState$2){
            public static final long serialVersionUID;
            private final ReplicaStateMachine $outer;
            private final PartitionAndReplica partitionAndReplica$1;
            private final Seq fromStates$1;
            private final ReplicaState targetState$2;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)Predef$.MODULE$.augmentString("Replica %s should be in the %s states before moving to %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.partitionAndReplica$1, this.fromStates$1.mkString(","), this.targetState$2}))).append((Object)Predef$.MODULE$.augmentString(". Instead it is in %s state").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.replicaState().apply((Object)this.partitionAndReplica$1)}))).toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.partitionAndReplica$1 = partitionAndReplica;
                this.fromStates$1 = seq;
                this.targetState$2 = replicaState;
            }
        });
    }

    private List<String> registerBrokerChangeListener() {
        return this.kafka$controller$ReplicaStateMachine$$zkClient().subscribeChildChanges(ZkUtils$.MODULE$.BrokerIdsPath(), (IZkChildListener)new BrokerChangeListener(this));
    }

    private void initializeReplicaState() {
        ((IterableLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22 = tuple2;
                return tuple22 != null;
            }
        })).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final ReplicaStateMachine $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple22 = tuple2;
                if (tuple22 != null) {
                    TopicAndPartition topicAndPartition;
                    TopicAndPartition topicPartition = topicAndPartition = (TopicAndPartition)tuple22._1();
                    String topic$4 = topicPartition.topic();
                    int partition$1 = topicPartition.partition();
                    ((IterableLike)tuple22._2()).foreach((Function1)new Serializable(this, topic$4, partition$1){
                        public static final long serialVersionUID;
                        private final $anonfun$initializeReplicaState$2 $outer;
                        private final String topic$4;
                        private final int partition$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final Option<ReplicaState> apply(int replicaId) {
                            boolean bl;
                            block4: {
                                Option option;
                                block3: {
                                    PartitionAndReplica partitionAndReplica;
                                    block2: {
                                        partitionAndReplica = new PartitionAndReplica(this.topic$4, this.partition$1, replicaId);
                                        bl = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().contains((Object)BoxesRunTime.boxToInteger((int)replicaId));
                                        if (!bl) break block2;
                                        option = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().replicaState().put((Object)partitionAndReplica, (Object)OnlineReplica$.MODULE$);
                                        break block3;
                                    }
                                    if (bl) break block4;
                                    option = this.$outer.kafka$controller$ReplicaStateMachine$$anonfun$$$outer().replicaState().put((Object)partitionAndReplica, (Object)ReplicaDeletionIneligible$.MODULE$);
                                }
                                return option;
                            }
                            throw new MatchError((Object)BoxesRunTime.boxToBoolean((boolean)bl));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.topic$4 = string;
                            this.partition$1 = n;
                        }
                    });
                    return;
                }
                throw new MatchError(tuple22);
            }

            public ReplicaStateMachine kafka$controller$ReplicaStateMachine$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public Seq<TopicAndPartition> partitionsAssignedToBroker(Seq<String> topics, int brokerId$1) {
        return ((MapLike)this.kafka$controller$ReplicaStateMachine$$controllerContext().partitionReplicaAssignment().filter((Function1)new Serializable(this, brokerId$1){
            public static final long serialVersionUID;
            private final int brokerId$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final boolean apply(Tuple2<TopicAndPartition, Seq<Object>> tuple2) {
                return ((SeqLike)tuple2._2()).contains((Object)BoxesRunTime.boxToInteger((int)this.brokerId$1));
            }
            {
                this.brokerId$1 = n;
            }
        })).keySet().toSeq();
    }

    public ReplicaStateMachine(KafkaController controller) {
        this.kafka$controller$ReplicaStateMachine$$controller = controller;
        Logging$class.$init$(this);
        this.kafka$controller$ReplicaStateMachine$$controllerContext = controller.controllerContext();
        this.controllerId = controller.config().brokerId();
        this.kafka$controller$ReplicaStateMachine$$zkClient = this.kafka$controller$ReplicaStateMachine$$controllerContext().zkClient();
        this.replicaState = Map$.MODULE$.empty();
        this.brokerRequestBatch = new ControllerBrokerRequestBatch(controller);
        this.kafka$controller$ReplicaStateMachine$$hasStarted = new AtomicBoolean(false);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Replica state machine on controller ").append((Object)BoxesRunTime.boxToInteger((int)controller.config().brokerId())).append((Object)"]: ").toString());
        this.stateChangeLogger = Logger.getLogger((String)KafkaController$.MODULE$.stateChangeLogger());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     * Duplicate member names - consider using --renamedupmembers true
     */
    public class BrokerChangeListener
    implements IZkChildListener,
    Logging {
        public final ReplicaStateMachine $outer;
        private final String loggerName;
        private final Logger logger;
        private String logIdent;
        private final Log4jController$ kafka$utils$Logging$$log4jController;
        public volatile int bitmap$0;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Logger logger() {
            if ((this.bitmap$0 & 1) != 0) return this.logger;
            BrokerChangeListener brokerChangeListener = this;
            synchronized (brokerChangeListener) {
                if ((this.bitmap$0 & 1) == 0) {
                    this.logger = Logging$class.logger(this);
                    this.bitmap$0 |= 1;
                }
                return this.logger;
            }
        }

        @Override
        public String logIdent() {
            return this.logIdent;
        }

        @Override
        public void logIdent_$eq(String string) {
            this.logIdent = string;
        }

        @Override
        public final Log4jController$ kafka$utils$Logging$$log4jController() {
            return this.kafka$utils$Logging$$log4jController;
        }

        @Override
        public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
            this.loggerName = string;
        }

        @Override
        public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
            this.kafka$utils$Logging$$log4jController = log4jController$;
        }

        @Override
        public void trace(Function0<String> msg) {
            Logging$class.trace(this, msg);
        }

        @Override
        public Object trace(Function0<Throwable> e) {
            return Logging$class.trace(this, e);
        }

        @Override
        public void trace(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.trace(this, msg, e);
        }

        @Override
        public void swallowTrace(Function0<BoxedUnit> action) {
            Logging$class.swallowTrace(this, action);
        }

        @Override
        public void debug(Function0<String> msg) {
            Logging$class.debug(this, msg);
        }

        @Override
        public Object debug(Function0<Throwable> e) {
            return Logging$class.debug(this, e);
        }

        @Override
        public void debug(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.debug(this, msg, e);
        }

        @Override
        public void swallowDebug(Function0<BoxedUnit> action) {
            Logging$class.swallowDebug(this, action);
        }

        @Override
        public void info(Function0<String> msg) {
            Logging$class.info(this, msg);
        }

        @Override
        public Object info(Function0<Throwable> e) {
            return Logging$class.info(this, e);
        }

        @Override
        public void info(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.info(this, msg, e);
        }

        @Override
        public void swallowInfo(Function0<BoxedUnit> action) {
            Logging$class.swallowInfo(this, action);
        }

        @Override
        public void warn(Function0<String> msg) {
            Logging$class.warn(this, msg);
        }

        @Override
        public Object warn(Function0<Throwable> e) {
            return Logging$class.warn(this, e);
        }

        @Override
        public void warn(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.warn(this, msg, e);
        }

        @Override
        public void swallowWarn(Function0<BoxedUnit> action) {
            Logging$class.swallowWarn(this, action);
        }

        @Override
        public void swallow(Function0<BoxedUnit> action) {
            Logging$class.swallow(this, action);
        }

        @Override
        public void error(Function0<String> msg) {
            Logging$class.error(this, msg);
        }

        @Override
        public Object error(Function0<Throwable> e) {
            return Logging$class.error(this, e);
        }

        @Override
        public void error(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.error(this, msg, e);
        }

        @Override
        public void swallowError(Function0<BoxedUnit> action) {
            Logging$class.swallowError(this, action);
        }

        @Override
        public void fatal(Function0<String> msg) {
            Logging$class.fatal(this, msg);
        }

        @Override
        public Object fatal(Function0<Throwable> e) {
            return Logging$class.fatal(this, e);
        }

        @Override
        public void fatal(Function0<String> msg, Function0<Throwable> e) {
            Logging$class.fatal(this, msg, e);
        }

        public void handleChildChange(String parentPath$1, List<String> currentBrokerList$1) {
            this.info((Function0<String>)new Serializable(this, parentPath$1, currentBrokerList$1){
                public static final long serialVersionUID;
                private final String parentPath$1;
                private final List currentBrokerList$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Broker change listener fired for path %s with children %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.parentPath$1, JavaConversions$.MODULE$.asScalaBuffer(this.currentBrokerList$1).mkString(",")}));
                }
                {
                    this.parentPath$1 = string;
                    this.currentBrokerList$1 = list;
                }
            });
            Utils$.MODULE$.inLock(this.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerLock(), new Serializable(this, currentBrokerList$1){
                public static final long serialVersionUID;
                private final BrokerChangeListener $outer;
                public final List currentBrokerList$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    if (this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$hasStarted().get()) {
                        ControllerStats$.MODULE$.leaderElectionTimer().time(new Serializable(this){
                            public static final long serialVersionUID;
                            private final BrokerChangeListener$$anonfun$handleChildChange$1 $outer;

                            static {
                                long l = serialVersionUID = 0L;
                            }

                            public final void apply() {
                                this.apply$mcV$sp();
                            }

                            public void apply$mcV$sp() {
                                try {
                                    scala.collection.immutable.Set curBrokerIds = ((TraversableOnce)JavaConversions$.MODULE$.asScalaBuffer(this.$outer.currentBrokerList$1).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final int apply(String string) {
                                            return Predef$.MODULE$.augmentString(string).toInt();
                                        }
                                    }, Buffer$.MODULE$.canBuildFrom())).toSet();
                                    scala.collection.immutable.Set newBrokerIds$1 = (scala.collection.immutable.Set)curBrokerIds.$minus$minus(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveOrShuttingDownBrokerIds());
                                    scala.collection.immutable.Set newBrokerInfo = (scala.collection.immutable.Set)newBrokerIds$1.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;
                                        private final BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final Option<Broker> apply(int n) {
                                            return ZkUtils$.MODULE$.getBrokerInfo(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$zkClient(), n);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                                    scala.collection.immutable.Set newBrokers = (scala.collection.immutable.Set)((SetLike)newBrokerInfo.filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final boolean apply(Option<Broker> option) {
                                            return option.isDefined();
                                        }
                                    })).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final Broker apply(Option<Broker> option) {
                                            return (Broker)option.get();
                                        }
                                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom());
                                    Set deadBrokerIds$1 = (Set)this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveOrShuttingDownBrokerIds().$minus$minus((GenTraversableOnce)curBrokerIds);
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokers_$eq((Set<Broker>)((Set)((SetLike)((TraversableLike)curBrokerIds.map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;
                                        private final BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final Option<Broker> apply(int n) {
                                            return ZkUtils$.MODULE$.getBrokerInfo(this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$zkClient(), n);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final boolean apply(Option<Broker> option) {
                                            return option.isDefined();
                                        }
                                    })).map((Function1)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final Broker apply(Option<Broker> option) {
                                            return (Broker)option.get();
                                        }
                                    }, scala.collection.immutable.Set$.MODULE$.canBuildFrom())));
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().info((Function0<String>)new Serializable(this, newBrokerIds$1, deadBrokerIds$1){
                                        public static final long serialVersionUID;
                                        private final BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;
                                        private final scala.collection.immutable.Set newBrokerIds$1;
                                        private final Set deadBrokerIds$1;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return Predef$.MODULE$.augmentString("Newly added brokers: %s, deleted brokers: %s, all live brokers: %s").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.newBrokerIds$1.mkString(","), this.deadBrokerIds$1.mkString(","), this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().liveBrokerIds().mkString(",")}));
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                            this.newBrokerIds$1 = set;
                                            this.deadBrokerIds$1 = set2;
                                        }
                                    });
                                    newBrokers.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID;
                                        private final BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final void apply(Broker broker) {
                                            this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager().addBroker(broker);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    deadBrokerIds$1.foreach((Function1)new Serializable(this){
                                        public static final long serialVersionUID;
                                        private final BrokerChangeListener$$anonfun$handleChildChange$1$$anonfun$apply$mcV$sp$1 $outer;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final void apply(int n) {
                                            this.apply$mcVI$sp(n);
                                        }

                                        public void apply$mcVI$sp(int v1) {
                                            this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controllerContext().controllerChannelManager().removeBroker(v1);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw new NullPointerException();
                                            }
                                            this.$outer = $outer;
                                        }
                                    });
                                    if (newBrokerIds$1.size() > 0) {
                                        this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerStartup((Seq<Object>)newBrokerIds$1.toSeq());
                                    }
                                    if (deadBrokerIds$1.size() > 0) {
                                        this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer().kafka$controller$ReplicaStateMachine$$controller.onBrokerFailure((Seq<Object>)deadBrokerIds$1.toSeq());
                                    }
                                }
                                catch (Throwable throwable) {
                                    this.$outer.kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer().error((Function0<String>)new Serializable(this){
                                        public static final long serialVersionUID;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final String apply() {
                                            return "Error while handling broker changes";
                                        }
                                    }, (Function0<Throwable>)new Serializable(this, throwable){
                                        public static final long serialVersionUID;
                                        private final Throwable e$2;

                                        static {
                                            long l = serialVersionUID = 0L;
                                        }

                                        public final Throwable apply() {
                                            return this.e$2;
                                        }
                                        {
                                            this.e$2 = throwable;
                                        }
                                    });
                                }
                            }

                            public BrokerChangeListener$$anonfun$handleChildChange$1 kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }

                public BrokerChangeListener kafka$controller$ReplicaStateMachine$BrokerChangeListener$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.currentBrokerList$1 = list;
                }
            });
        }

        public ReplicaStateMachine kafka$controller$ReplicaStateMachine$BrokerChangeListener$$$outer() {
            return this.$outer;
        }

        public BrokerChangeListener(ReplicaStateMachine $outer) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            Logging$class.$init$(this);
            this.logIdent_$eq(new StringBuilder().append((Object)"[BrokerChangeListener on Controller ").append((Object)BoxesRunTime.boxToInteger((int)$outer.kafka$controller$ReplicaStateMachine$$controller.config().brokerId())).append((Object)"]: ").toString());
        }
    }
}

