/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Date;
import kafka.common.LogCleaningAbortedException;
import kafka.common.TopicAndPartition;
import kafka.log.Cleaner$;
import kafka.log.CleanerStats;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogCleaner;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetIndex;
import kafka.log.OffsetMap;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.Throttler;
import kafka.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]f!B\u0001\u0003\u0001\t1!aB\"mK\u0006tWM\u001d\u0006\u0003\u0007\u0011\t1\u0001\\8h\u0015\u0005)\u0011!B6bM.\f7\u0003\u0002\u0001\b\u001fU\u0001\"\u0001C\u0007\u000e\u0003%Q!AC\u0006\u0002\t1\fgn\u001a\u0006\u0002\u0019\u0005!!.\u0019<b\u0013\tq\u0011B\u0001\u0004PE*,7\r\u001e\t\u0003!Mi\u0011!\u0005\u0006\u0003%\u0011\tQ!\u001e;jYNL!\u0001F\t\u0003\u000f1{wmZ5oOB\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\tY1kY1mC>\u0013'.Z2u\u0011!a\u0002A!b\u0001\n\u0003q\u0012AA5e\u0007\u0001)\u0012a\b\t\u0003-\u0001J!!I\f\u0003\u0007%sG\u000f\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003 \u0003\rIG\r\t\u0005\tK\u0001\u0011\t\u0011)A\u0005M\u0005IqN\u001a4tKRl\u0015\r\u001d\t\u0003O!j\u0011AA\u0005\u0003S\t\u0011\u0011b\u00144gg\u0016$X*\u00199\t\u0011-\u0002!\u0011!Q\u0001\n}\tA\"[8Ck\u001a4WM]*ju\u0016D\u0001\"\f\u0001\u0003\u0002\u0003\u0006IaH\u0001\u0010[\u0006D\u0018j\u001c\"vM\u001a,'oU5{K\"Aq\u0006\u0001B\u0001B\u0003%\u0001'A\nekB\u0014UO\u001a4fe2{\u0017\r\u001a$bGR|'\u000f\u0005\u0002\u0017c%\u0011!g\u0006\u0002\u0007\t>,(\r\\3\t\u0011Q\u0002!\u0011!Q\u0001\nU\n\u0011\u0002\u001e5s_R$H.\u001a:\u0011\u0005A1\u0014BA\u001c\u0012\u0005%!\u0006N]8ui2,'\u000f\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0003\u0011!\u0018.\\3\u0011\u0005AY\u0014B\u0001\u001f\u0012\u0005\u0011!\u0016.\\3\t\u0011y\u0002!\u0011!Q\u0001\n}\n\u0011b\u00195fG.$uN\\3\u0011\tY\u0001%\tS\u0005\u0003\u0003^\u0011\u0011BR;oGRLwN\\\u0019\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015#\u0011AB2p[6|g.\u0003\u0002H\t\n\tBk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8\u0011\u0005YI\u0015B\u0001&\u0018\u0005\u0011)f.\u001b;\t\u000b1\u0003A\u0011A'\u0002\rqJg.\u001b;?)%qu\nU)S'R+f\u000b\u0005\u0002(\u0001!)Ad\u0013a\u0001?!)Qe\u0013a\u0001M!)1f\u0013a\u0001?!)Qf\u0013a\u0001?!)qf\u0013a\u0001a!)Ag\u0013a\u0001k!)\u0011h\u0013a\u0001u!)ah\u0013a\u0001\u007f!9\u0001\f\u0001b\u0001\n\u0003J\u0016A\u00037pO\u001e,'OT1nKV\t!\f\u0005\u0002\t7&\u0011A,\u0003\u0002\u0007'R\u0014\u0018N\\4\t\ry\u0003\u0001\u0015!\u0003[\u0003-awnZ4fe:\u000bW.\u001a\u0011\t\u000f\u0001\u0004!\u0019!C\u0001C\u0006)1\u000f^1ugV\t!\r\u0005\u0002(G&\u0011AM\u0001\u0002\r\u00072,\u0017M\\3s'R\fGo\u001d\u0005\u0007M\u0002\u0001\u000b\u0011\u00022\u0002\rM$\u0018\r^:!\u0011\u001dA\u0007\u00011A\u0005\n%\f!B]3bI\n+hMZ3s+\u0005Q\u0007CA6o\u001b\u0005a'BA7\f\u0003\rq\u0017n\\\u0005\u0003_2\u0014!BQ=uK\n+hMZ3s\u0011\u001d\t\b\u00011A\u0005\nI\faB]3bI\n+hMZ3s?\u0012*\u0017\u000f\u0006\u0002Ig\"9A\u000f]A\u0001\u0002\u0004Q\u0017a\u0001=%c!1a\u000f\u0001Q!\n)\f1B]3bI\n+hMZ3sA!9\u0001\u0010\u0001a\u0001\n\u0013I\u0017aC<sSR,')\u001e4gKJDqA\u001f\u0001A\u0002\u0013%10A\bxe&$XMQ;gM\u0016\u0014x\fJ3r)\tAE\u0010C\u0004us\u0006\u0005\t\u0019\u00016\t\ry\u0004\u0001\u0015)\u0003k\u000319(/\u001b;f\u0005V4g-\u001a:!\u0011!\t\t\u0001\u0001C\u0001\u0005\u0005\r\u0011!B2mK\u0006tG\u0003BA\u0003\u0003\u0017\u00012AFA\u0004\u0013\r\tIa\u0006\u0002\u0005\u0019>tw\rC\u0004\u0002\u000e}\u0004\r!a\u0004\u0002\u0013\rdW-\u00198bE2,\u0007cA\u0014\u0002\u0012%\u0019\u00111\u0003\u0002\u0003\u00151{w\rV8DY\u0016\fg\u000e\u0003\u0005\u0002\u0018\u0001!\tAAA\r\u00035\u0019G.Z1o'\u0016<W.\u001a8ugRI\u0001*a\u0007\u0002$\u0005e\u0012Q\b\u0005\b\u0007\u0005U\u0001\u0019AA\u000f!\r9\u0013qD\u0005\u0004\u0003C\u0011!a\u0001'pO\"A\u0011QEA\u000b\u0001\u0004\t9#\u0001\u0005tK\u001elWM\u001c;t!\u0019\tI#a\f\u000245\u0011\u00111\u0006\u0006\u0004\u0003[9\u0012AC2pY2,7\r^5p]&!\u0011\u0011GA\u0016\u0005\r\u0019V-\u001d\t\u0004O\u0005U\u0012bAA\u001c\u0005\tQAj\\4TK\u001elWM\u001c;\t\u000f\u0005m\u0012Q\u0003a\u0001M\u0005\u0019Q.\u00199\t\u0011\u0005}\u0012Q\u0003a\u0001\u0003\u000b\tq\u0002Z3mKR,\u0007j\u001c:ju>tWj\u001d\u0005\t\u0003\u0007\u0002A\u0011\u0001\u0002\u0002F\u0005I1\r\\3b]&sGo\u001c\u000b\f\u0011\u0006\u001d\u00131JA(\u0003'\n)\u0006C\u0004\u0002J\u0005\u0005\u0003\u0019\u0001\"\u0002#Q|\u0007/[2B]\u0012\u0004\u0016M\u001d;ji&|g\u000e\u0003\u0005\u0002N\u0005\u0005\u0003\u0019AA\u001a\u0003\u0019\u0019x.\u001e:dK\"A\u0011\u0011KA!\u0001\u0004\t\u0019$\u0001\u0003eKN$\bbBA\u001e\u0003\u0003\u0002\rA\n\u0005\t\u0003/\n\t\u00051\u0001\u0002Z\u0005i!/\u001a;bS:$U\r\\3uKN\u00042AFA.\u0013\r\tif\u0006\u0002\b\u0005>|G.Z1o\u0011\u001d\t\t\u0007\u0001C\u0001\u0003G\n1b\u001a:po\n+hMZ3sgR\t\u0001\nC\u0004\u0002h\u0001!\t!a\u0019\u0002\u001dI,7\u000f^8sK\n+hMZ3sg\"A\u00111\u000e\u0001\u0005\u0002\t\ti'A\nhe>,\boU3h[\u0016tGo\u001d\"z'&TX\r\u0006\u0005\u0002p\u0005\u001d\u0015qRAJ!\u0019\t\t(!!\u0002(9!\u00111OA?\u001d\u0011\t)(a\u001f\u000e\u0005\u0005]$bAA=;\u00051AH]8pizJ\u0011\u0001G\u0005\u0004\u0003\u007f:\u0012a\u00029bG.\fw-Z\u0005\u0005\u0003\u0007\u000b)I\u0001\u0003MSN$(bAA@/!A\u0011QEA5\u0001\u0004\tI\t\u0005\u0004\u0002*\u0005-\u00151G\u0005\u0005\u0003\u001b\u000bYC\u0001\u0005Ji\u0016\u0014\u0018M\u00197f\u0011\u001d\t\t*!\u001bA\u0002}\tq!\\1y'&TX\rC\u0004\u0002\u0016\u0006%\u0004\u0019A\u0010\u0002\u00195\f\u00070\u00138eKb\u001c\u0016N_3\t\u0011\u0005e\u0005\u0001\"\u0001\u0003\u00037\u000baBY;jY\u0012|eMZ:fi6\u000b\u0007\u000f\u0006\u0006\u0002\u0006\u0005u\u0015qTAR\u0003OCqaAAL\u0001\u0004\ti\u0002\u0003\u0005\u0002\"\u0006]\u0005\u0019AA\u0003\u0003\u0015\u0019H/\u0019:u\u0011!\t)+a&A\u0002\u0005\u0015\u0011aA3oI\"9\u00111HAL\u0001\u00041\u0003bBAV\u0001\u0011%\u0011QV\u0001\u0019EVLG\u000eZ(gMN,G/T1q\r>\u00148+Z4nK:$H\u0003CA\u0003\u0003_\u000b\t,!.\t\u000f\u0005%\u0013\u0011\u0016a\u0001\u0005\"A\u00111WAU\u0001\u0004\t\u0019$A\u0004tK\u001elWM\u001c;\t\u000f\u0005m\u0012\u0011\u0016a\u0001M\u0001")
public class Cleaner
implements Logging {
    private final int id;
    public final OffsetMap kafka$log$Cleaner$$offsetMap;
    private final int ioBufferSize;
    private final int maxIoBufferSize;
    public final double kafka$log$Cleaner$$dupBufferLoadFactor;
    private final Throttler throttler;
    private final Time time;
    public final Function1<TopicAndPartition, BoxedUnit> kafka$log$Cleaner$$checkDone;
    private final String loggerName;
    private final CleanerStats stats;
    private ByteBuffer kafka$log$Cleaner$$readBuffer;
    private ByteBuffer kafka$log$Cleaner$$writeBuffer;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    public volatile int bitmap$0;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Logger logger() {
        if ((this.bitmap$0 & 1) != 0) return this.logger;
        Cleaner cleaner = this;
        synchronized (cleaner) {
            if ((this.bitmap$0 & 1) == 0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 |= 1;
            }
            return this.logger;
        }
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String string) {
        this.logIdent = string;
    }

    @Override
    public final Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String string) {
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ log4jController$) {
        this.kafka$utils$Logging$$log4jController = log4jController$;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int id() {
        return this.id;
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    public CleanerStats stats() {
        return this.stats;
    }

    public final ByteBuffer kafka$log$Cleaner$$readBuffer() {
        return this.kafka$log$Cleaner$$readBuffer;
    }

    private void kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer byteBuffer) {
        this.kafka$log$Cleaner$$readBuffer = byteBuffer;
    }

    public final ByteBuffer kafka$log$Cleaner$$writeBuffer() {
        return this.kafka$log$Cleaner$$writeBuffer;
    }

    private void kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer byteBuffer) {
        this.kafka$log$Cleaner$$writeBuffer = byteBuffer;
    }

    public long clean(LogToClean cleanable$1) {
        Option option;
        block4: {
            long l;
            long endOffset;
            Log log$2;
            block3: {
                block2: {
                    this.stats().clear();
                    this.info((Function0<String>)new Serializable(this, cleanable$1){
                        public static final long serialVersionUID;
                        private final LogToClean cleanable$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Beginning cleaning of log %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = logToClean;
                        }
                    });
                    log$2 = cleanable$1.log();
                    this.info((Function0<String>)new Serializable(this, cleanable$1){
                        public static final long serialVersionUID;
                        private final LogToClean cleanable$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Building offset map for %s...").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.cleanable$1.log().name()}));
                        }
                        {
                            this.cleanable$1 = logToClean;
                        }
                    });
                    long upperBoundOffset = log$2.activeSegment().baseOffset();
                    endOffset = this.buildOffsetMap(log$2, cleanable$1.firstDirtyOffset(), upperBoundOffset, this.kafka$log$Cleaner$$offsetMap) + 1L;
                    this.stats().indexDone();
                    option = log$2.logSegments(0L, cleanable$1.firstDirtyOffset()).lastOption();
                    None$ none$ = None$.MODULE$;
                    Option option2 = option;
                    if (none$ != null ? !none$.equals(option2) : option2 != null) break block2;
                    l = 0L;
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                l = ((LogSegment)((Some)option).x()).lastModified() - log$2.config().deleteRetentionMs();
            }
            long deleteHorizonMs$1 = l;
            this.info((Function0<String>)new Serializable(this, log$2, deleteHorizonMs$1){
                public static final long serialVersionUID;
                private final Log log$2;
                private final long deleteHorizonMs$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Cleaning log %s (discarding tombstones prior to %s)...").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$2.name(), new Date(this.deleteHorizonMs$1)}));
                }
                {
                    this.log$2 = log;
                    this.deleteHorizonMs$1 = l;
                }
            });
            this.groupSegmentsBySize(log$2.logSegments(0L, endOffset), log$2.config().segmentSize(), log$2.config().maxIndexSize()).foreach((Function1)new Serializable(this, log$2, deleteHorizonMs$1){
                public static final long serialVersionUID;
                private final Cleaner $outer;
                private final Log log$2;
                private final long deleteHorizonMs$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(Seq<LogSegment> group) {
                    this.$outer.cleanSegments(this.log$2, group, this.$outer.kafka$log$Cleaner$$offsetMap, this.deleteHorizonMs$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$2 = log;
                    this.deleteHorizonMs$1 = l;
                }
            });
            this.stats().allDone();
            return endOffset;
        }
        throw new MatchError((Object)option);
    }

    public void cleanSegments(Log log$4, Seq<LogSegment> segments$1, OffsetMap map$2, long deleteHorizonMs$2) {
        File logFile = new File(new StringBuilder().append((Object)((LogSegment)segments$1.head()).log().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        logFile.delete();
        File indexFile = new File(new StringBuilder().append((Object)((LogSegment)segments$1.head()).index().file().getPath()).append((Object)Log$.MODULE$.CleanedFileSuffix()).toString());
        indexFile.delete();
        FileMessageSet messages = new FileMessageSet(logFile);
        OffsetIndex index = new OffsetIndex(indexFile, ((LogSegment)segments$1.head()).baseOffset(), ((LogSegment)segments$1.head()).index().maxIndexSize());
        LogSegment cleaned$1 = new LogSegment(messages, index, ((LogSegment)segments$1.head()).baseOffset(), ((LogSegment)segments$1.head()).indexIntervalBytes(), this.time);
        try {
            segments$1.foreach((Function1)new Serializable(this, log$4, map$2, deleteHorizonMs$2, cleaned$1){
                public static final long serialVersionUID;
                private final Cleaner $outer;
                public final Log log$4;
                private final OffsetMap map$2;
                private final long deleteHorizonMs$2;
                public final LogSegment cleaned$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(LogSegment old$1) {
                    boolean retainDeletes$1 = old$1.lastModified() > this.deleteHorizonMs$2;
                    this.$outer.info((Function0<String>)new Serializable(this, old$1, retainDeletes$1){
                        public static final long serialVersionUID;
                        private final $anonfun$cleanSegments$1 $outer;
                        private final LogSegment old$1;
                        private final boolean retainDeletes$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Cleaning segment %s in log %s (last modified %s) into %s, %s deletes.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.old$1.baseOffset()), this.$outer.log$4.name(), new Date(this.old$1.lastModified()), BoxesRunTime.boxToLong((long)this.$outer.cleaned$1.baseOffset()), this.retainDeletes$1 ? "retaining" : "discarding"}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.old$1 = logSegment;
                            this.retainDeletes$1 = bl;
                        }
                    });
                    this.$outer.cleanInto(this.log$4.topicAndPartition(), old$1, this.cleaned$1, this.map$2, retainDeletes$1);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.log$4 = log;
                    this.map$2 = offsetMap;
                    this.deleteHorizonMs$2 = l;
                    this.cleaned$1 = logSegment;
                }
            });
            index.trimToValidSize();
            cleaned$1.flush();
            long modified = ((LogSegment)segments$1.last()).lastModified();
            cleaned$1.lastModified_$eq(modified);
            this.info((Function0<String>)new Serializable(this, log$4, segments$1, cleaned$1){
                public static final long serialVersionUID;
                private final Log log$4;
                private final Seq segments$1;
                private final LogSegment cleaned$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return Predef$.MODULE$.augmentString("Swapping in cleaned segment %d for segment(s) %s in log %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.cleaned$1.baseOffset()), ((TraversableOnce)this.segments$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final long apply(LogSegment logSegment) {
                            return logSegment.baseOffset();
                        }
                    }, Seq$.MODULE$.canBuildFrom())).mkString(","), this.log$4.name()}));
                }
                {
                    this.log$4 = log;
                    this.segments$1 = seq;
                    this.cleaned$1 = logSegment;
                }
            });
            log$4.replaceSegments(cleaned$1, segments$1);
            return;
        }
        catch (LogCleaningAbortedException logCleaningAbortedException) {
            cleaned$1.delete();
            throw logCleaningAbortedException;
        }
    }

    public void cleanInto(TopicAndPartition topicAndPartition, LogSegment source$1, LogSegment dest, OffsetMap map$3, boolean retainDeletes$2) {
        IntRef position$1 = new IntRef(0);
        while (position$1.elem < source$1.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            this.kafka$log$Cleaner$$writeBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(source$1.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position$1.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            IntRef messagesRead$1 = new IntRef(0);
            messages.foreach((Function1)new Serializable(this, source$1, map$3, retainDeletes$2, position$1, messagesRead$1){
                public static final long serialVersionUID;
                private final Cleaner $outer;
                public final LogSegment source$1;
                private final OffsetMap map$3;
                private final boolean retainDeletes$2;
                private final IntRef position$1;
                private final IntRef messagesRead$1;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(MessageAndOffset entry2) {
                    boolean obsoleteDelete;
                    ++this.messagesRead$1.elem;
                    int size2 = MessageSet$.MODULE$.entrySize(entry2.message());
                    this.position$1.elem += size2;
                    this.$outer.stats().readMessage(size2);
                    ByteBuffer key = entry2.message().key();
                    Predef$.MODULE$.require(key != null, (Function0)new Serializable(this){
                        public static final long serialVersionUID;
                        private final $anonfun$cleanInto$1 $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return Predef$.MODULE$.augmentString("Found null key in log segment %s which is marked as dedupe.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.source$1.log().file().getAbsolutePath()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    long foundOffset = this.map$3.get(key);
                    boolean redundant = foundOffset >= 0L && entry2.offset() < foundOffset;
                    boolean bl = obsoleteDelete = !this.retainDeletes$2 && entry2.message().isNull();
                    if (!redundant && !obsoleteDelete) {
                        ByteBufferMessageSet$.MODULE$.writeMessage(this.$outer.kafka$log$Cleaner$$writeBuffer(), entry2.message(), entry2.offset());
                        this.$outer.stats().recopyMessage(size2);
                    }
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.source$1 = logSegment;
                    this.map$3 = offsetMap;
                    this.retainDeletes$2 = bl;
                    this.position$1 = intRef;
                    this.messagesRead$1 = intRef2;
                }
            });
            if (this.kafka$log$Cleaner$$writeBuffer().position() > 0) {
                this.kafka$log$Cleaner$$writeBuffer().flip();
                ByteBufferMessageSet retained = new ByteBufferMessageSet(this.kafka$log$Cleaner$$writeBuffer());
                dest.append(((MessageAndOffset)retained.head()).offset(), retained);
                this.throttler.maybeThrottle(this.kafka$log$Cleaner$$writeBuffer().limit());
            }
            if (this.kafka$log$Cleaner$$readBuffer().limit() <= 0 || messagesRead$1.elem != 0) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
    }

    public void growBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() >= this.maxIoBufferSize || this.kafka$log$Cleaner$$writeBuffer().capacity() >= this.maxIoBufferSize) {
            throw new IllegalStateException(Predef$.MODULE$.augmentString("This log contains a message larger than maximum allowable size of %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.maxIoBufferSize)})));
        }
        int newSize$1 = package$.MODULE$.min(this.kafka$log$Cleaner$$readBuffer().capacity() * 2, this.maxIoBufferSize);
        this.info((Function0<String>)new Serializable(this, newSize$1){
            public static final long serialVersionUID;
            private final Cleaner $outer;
            private final int newSize$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return new StringBuilder().append((Object)"Growing cleaner I/O buffers from ").append((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$Cleaner$$readBuffer().capacity())).append((Object)"bytes to ").append((Object)BoxesRunTime.boxToInteger((int)this.newSize$1)).append((Object)" bytes.").toString();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.newSize$1 = n;
            }
        });
        this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(newSize$1));
        this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(newSize$1));
    }

    public void restoreBuffers() {
        if (this.kafka$log$Cleaner$$readBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$readBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
        if (this.kafka$log$Cleaner$$writeBuffer().capacity() > this.ioBufferSize) {
            this.kafka$log$Cleaner$$writeBuffer_$eq(ByteBuffer.allocate(this.ioBufferSize));
        }
    }

    public List<Seq<LogSegment>> groupSegmentsBySize(Iterable<LogSegment> segments, int maxSize, int maxIndexSize) {
        Nil$ grouped = Nil$.MODULE$;
        List segs = segments.toList();
        while (!segs.isEmpty()) {
            List group = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)segs.head()}));
            long logSize = ((LogSegment)segs.head()).size();
            int indexSize = ((LogSegment)segs.head()).index().sizeInBytes();
            segs = (List)segs.tail();
            while (!segs.isEmpty() && logSize + ((LogSegment)segs.head()).size() < (long)maxSize && indexSize + ((LogSegment)segs.head()).index().sizeInBytes() < maxIndexSize) {
                LogSegment logSegment = (LogSegment)segs.head();
                group = group.$colon$colon((Object)logSegment);
                logSize += ((LogSegment)segs.head()).size();
                indexSize += ((LogSegment)segs.head()).index().sizeInBytes();
                segs = (List)segs.tail();
            }
            grouped = grouped.$colon$colon((Object)group.reverse());
        }
        return grouped.reverse();
    }

    public long buildOffsetMap(Log log$3, long start$1, long end$1, OffsetMap map$1) {
        map$1.clear();
        Seq dirty$1 = log$3.logSegments(start$1, end$1).toSeq();
        this.info((Function0<String>)new Serializable(this, log$3, start$1, end$1, dirty$1){
            public static final long serialVersionUID;
            private final Log log$3;
            private final long start$1;
            private final long end$1;
            private final Seq dirty$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Building offset map for log %s for %d segments in offset range [%d, %d).").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$3.name(), BoxesRunTime.boxToInteger((int)this.dirty$1.size()), BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.end$1)}));
            }
            {
                this.log$3 = log;
                this.start$1 = l;
                this.end$1 = l2;
                this.dirty$1 = seq;
            }
        });
        LongRef offset$1 = new LongRef(((LogSegment)dirty$1.head()).baseOffset());
        Predef$.MODULE$.require(offset$1.elem == start$1, (Function0)new Serializable(this, log$3, start$1, offset$1){
            public static final long serialVersionUID;
            private final Log log$3;
            private final long start$1;
            private final LongRef offset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Last clean offset is %d but segment base offset is %d for log %s.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.start$1), BoxesRunTime.boxToLong((long)this.offset$1.elem), this.log$3.name()}));
            }
            {
                this.log$3 = log;
                this.start$1 = l;
                this.offset$1 = longRef;
            }
        });
        long minStopOffset$1 = (long)((double)start$1 + (double)map$1.slots() * this.kafka$log$Cleaner$$dupBufferLoadFactor);
        dirty$1.foreach((Function1)new Serializable(this, log$3, map$1, offset$1, minStopOffset$1){
            public static final long serialVersionUID;
            private final Cleaner $outer;
            private final Log log$3;
            private final OffsetMap map$1;
            private final LongRef offset$1;
            private final long minStopOffset$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(LogSegment segment) {
                this.$outer.kafka$log$Cleaner$$checkDone.apply((Object)this.log$3.topicAndPartition());
                if (segment.baseOffset() <= this.minStopOffset$1 || this.map$1.utilization() < this.$outer.kafka$log$Cleaner$$dupBufferLoadFactor) {
                    this.offset$1.elem = this.$outer.kafka$log$Cleaner$$buildOffsetMapForSegment(this.log$3.topicAndPartition(), segment, this.map$1);
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$3 = log;
                this.map$1 = offsetMap;
                this.offset$1 = longRef;
                this.minStopOffset$1 = l;
            }
        });
        this.info((Function0<String>)new Serializable(this, log$3){
            public static final long serialVersionUID;
            private final Log log$3;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply() {
                return Predef$.MODULE$.augmentString("Offset map for log %s complete.").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.log$3.name()}));
            }
            {
                this.log$3 = log;
            }
        });
        return offset$1.elem;
    }

    public final long kafka$log$Cleaner$$buildOffsetMapForSegment(TopicAndPartition topicAndPartition, LogSegment segment, OffsetMap map$4) {
        IntRef position$2 = new IntRef(0);
        LongRef offset$2 = new LongRef(segment.baseOffset());
        while (position$2.elem < segment.log().sizeInBytes()) {
            this.kafka$log$Cleaner$$checkDone.apply((Object)topicAndPartition);
            this.kafka$log$Cleaner$$readBuffer().clear();
            ByteBufferMessageSet messages = new ByteBufferMessageSet(segment.log().readInto(this.kafka$log$Cleaner$$readBuffer(), position$2.elem));
            this.throttler.maybeThrottle(messages.sizeInBytes());
            int startPosition = position$2.elem;
            messages.foreach((Function1)new Serializable(this, map$4, position$2, offset$2){
                public static final long serialVersionUID;
                private final Cleaner $outer;
                private final OffsetMap map$4;
                private final IntRef position$2;
                private final LongRef offset$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(MessageAndOffset entry2) {
                    Message message = entry2.message();
                    Predef$.MODULE$.require(message.hasKey());
                    int size2 = MessageSet$.MODULE$.entrySize(message);
                    this.position$2.elem += size2;
                    this.map$4.put(message.key(), entry2.offset());
                    this.offset$2.elem = entry2.offset();
                    this.$outer.stats().indexMessage(size2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.map$4 = offsetMap;
                    this.position$2 = intRef;
                    this.offset$2 = longRef;
                }
            });
            if (position$2.elem != startPosition) continue;
            this.growBuffers();
        }
        this.restoreBuffers();
        return offset$2.elem;
    }

    public Cleaner(int id, OffsetMap offsetMap, int ioBufferSize, int maxIoBufferSize, double dupBufferLoadFactor, Throttler throttler, Time time, Function1<TopicAndPartition, BoxedUnit> checkDone) {
        this.id = id;
        this.kafka$log$Cleaner$$offsetMap = offsetMap;
        this.ioBufferSize = ioBufferSize;
        this.maxIoBufferSize = maxIoBufferSize;
        this.kafka$log$Cleaner$$dupBufferLoadFactor = dupBufferLoadFactor;
        this.throttler = throttler;
        this.time = time;
        this.kafka$log$Cleaner$$checkDone = checkDone;
        Logging$class.$init$(this);
        this.loggerName = LogCleaner.class.getName();
        this.logIdent_$eq(new StringBuilder().append((Object)"Cleaner ").append((Object)BoxesRunTime.boxToInteger((int)id)).append((Object)": ").toString());
        this.stats = new CleanerStats(time);
        this.kafka$log$Cleaner$$readBuffer = ByteBuffer.allocate(ioBufferSize);
        this.kafka$log$Cleaner$$writeBuffer = ByteBuffer.allocate(ioBufferSize);
    }
}

