/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.error;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.util.HashMap;
import java.util.List;
import javax.ws.rs.core.Response;
import org.apache.lens.api.error.ErrorCollection;
import org.apache.lens.api.error.ErrorMap;
import org.apache.lens.api.error.LensError;

public class ErrorCollectionFactory {
    private static final String LENS_ERROR_FILE_NAME = "lens-errors";
    private static final String LENS_ERRORS_OVERRIDE_FILE_NAME = "lens-errors-override";
    private static final String ERRORS_ARRAY_NAME = "errors";
    private static final String ERROR_CODE_KEY = "errorCode";
    private static final String HTTP_STATUS_CODE_KEY = "httpStatusCode";
    private static final String ERROR_MSG_KEY = "errorMsg";
    private static final String PAYLOAD_CLASS_KEY = "payloadClass";

    public ErrorCollection createErrorCollection() throws ClassNotFoundException {
        HashMap<Integer, LensError> errorCollection = new HashMap<Integer, LensError>();
        Config baseConfig = ConfigFactory.load((String)LENS_ERROR_FILE_NAME);
        Config usedConfig = ConfigFactory.load((String)LENS_ERRORS_OVERRIDE_FILE_NAME).withFallback((ConfigMergeable)baseConfig);
        List configList = usedConfig.getConfigList(ERRORS_ARRAY_NAME);
        for (Config config : configList) {
            int errorCode = config.getInt(ERROR_CODE_KEY);
            int httpStatusCodeInt = config.getInt(HTTP_STATUS_CODE_KEY);
            Response.Status httpStatusCode = Response.Status.fromStatusCode((int)httpStatusCodeInt);
            String errorMsg = config.getString(ERROR_MSG_KEY);
            Class<?> payloadClass = null;
            if (config.hasPath(PAYLOAD_CLASS_KEY)) {
                String payloadClassStr = config.getString(PAYLOAD_CLASS_KEY);
                payloadClass = Class.forName(payloadClassStr);
            }
            LensError lensError = new LensError(errorCode, httpStatusCode, errorMsg, (Optional<Class>)Optional.fromNullable(payloadClass));
            errorCollection.put(errorCode, lensError);
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf(errorCollection);
        return new ErrorMap((ImmutableMap<Integer, LensError>)immutableMap);
    }
}

