/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.error;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedList;
import lombok.NonNull;
import org.apache.lens.api.error.ErrorCollection;
import org.apache.lens.api.error.LensCommonErrorCode;
import org.apache.lens.api.error.LensError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMap
implements ErrorCollection {
    private static final Logger log = LoggerFactory.getLogger(ErrorMap.class);
    private final ImmutableMap<Integer, LensError> errors;

    public ErrorMap(@NonNull ImmutableMap<Integer, LensError> errors) {
        if (errors == null) {
            throw new NullPointerException("errors");
        }
        Preconditions.checkArgument((!errors.isEmpty() ? 1 : 0) != 0);
        this.errors = errors;
        Preconditions.checkState((this.getErrorPayloadClassesList().size() == this.getErrorPayloadClasses().size() ? 1 : 0) != 0, (Object)"In error conf files, error objects defined with different error codes must have different error payload class.");
    }

    @Override
    public LensError getLensError(int errorCode) {
        LensError lensError = (LensError)this.errors.get((Object)errorCode);
        if (lensError == null) {
            if (log.isWarnEnabled()) {
                log.warn("Error Code {} not found in initialized error collection. This could be a case of a pluggable code trying to send a random error code without initializing it in lens-errors.conf or lens-additional-errors.conf. We will drop this random error code and send INTERNAL SERVER ERROR instead of this.", (Object)errorCode);
            }
            lensError = (LensError)this.errors.get((Object)LensCommonErrorCode.INTERNAL_SERVER_ERROR.getValue());
        }
        return lensError;
    }

    @Override
    public ImmutableSet<Class> getErrorPayloadClasses() {
        return ImmutableSet.copyOf(this.getErrorPayloadClassesList());
    }

    private ImmutableList<Class> getErrorPayloadClassesList() {
        LinkedList<Object> errorPayloadClasses = new LinkedList<Object>();
        for (LensError lensError : this.errors.values()) {
            Optional<Class> errorPayloadClass = lensError.getPayloadClass();
            if (!errorPayloadClass.isPresent()) continue;
            errorPayloadClasses.add(errorPayloadClass.get());
        }
        return ImmutableList.copyOf(errorPayloadClasses);
    }
}

