/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.error;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import javax.ws.rs.core.Response;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;

public final class LensError {
    private final int errorCode;
    private final Response.Status httpStatusCode;
    private final String errorMsg;
    private final Optional<Class> payloadClass;

    public LensError(int errorCode, Response.Status httpStatusCode, String errorMsg, @NonNull Optional<Class> payloadClass) {
        if (payloadClass == null) {
            throw new NullPointerException("payloadClass");
        }
        Preconditions.checkArgument((errorCode > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)errorMsg));
        this.errorCode = errorCode;
        this.httpStatusCode = httpStatusCode;
        this.errorMsg = errorMsg;
        this.payloadClass = payloadClass;
    }

    public String getFormattedErrorMsg(Object ... args) {
        return String.format(this.errorMsg, args);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Response.Status getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public Optional<Class> getPayloadClass() {
        return this.payloadClass;
    }
}

