/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.query;

import java.beans.ConstructorProperties;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.lens.api.query.QueryResult;

@XmlRootElement
public class PersistentQueryResult
extends QueryResult {
    @XmlElement
    private String persistedURI;
    @XmlElement
    private Integer numRows;
    @XmlElement
    private Long fileSize;
    @XmlElement
    private String httpResultUrl;

    @Override
    public String toPrettyString() {
        StringBuilder sb = new StringBuilder().append("Result available at ").append(this.persistedURI).append(".");
        if (this.numRows != null) {
            sb.append(" Number of rows: ").append(this.numRows).append(".");
        }
        if (this.fileSize != null) {
            sb.append(" File size: ").append(this.fileSize).append(".");
        }
        if (this.httpResultUrl != null) {
            sb.append(" Downloadable from ").append(this.httpResultUrl).append(".");
        }
        return sb.toString();
    }

    @ConstructorProperties(value={"persistedURI", "numRows", "fileSize", "httpResultUrl"})
    public PersistentQueryResult(String persistedURI, Integer numRows, Long fileSize, String httpResultUrl) {
        this.persistedURI = persistedURI;
        this.numRows = numRows;
        this.fileSize = fileSize;
        this.httpResultUrl = httpResultUrl;
    }

    protected PersistentQueryResult() {
    }

    public String getPersistedURI() {
        return this.persistedURI;
    }

    public Integer getNumRows() {
        return this.numRows;
    }

    public Long getFileSize() {
        return this.fileSize;
    }

    public String getHttpResultUrl() {
        return this.httpResultUrl;
    }
}

