/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.query;

import java.beans.ConstructorProperties;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.lens.api.query.QueryPrepareHandle;
import org.apache.lens.api.query.QuerySubmitResult;
import org.apache.lens.api.result.QueryCostTO;

@XmlRootElement
public class QueryPlan
extends QuerySubmitResult {
    @XmlElementWrapper
    private List<String> tablesQueried;
    @XmlElement
    private boolean hasSubQuery = false;
    @XmlElement
    private String execMode;
    @XmlElement
    private String scanMode;
    private QueryPrepareHandle prepareHandle;
    @XmlElement
    private String planString;
    @XmlElement
    private QueryCostTO queryCost;

    public String getPlanString() throws UnsupportedEncodingException {
        return URLDecoder.decode(this.planString, "UTF-8");
    }

    @ConstructorProperties(value={"tablesQueried", "hasSubQuery", "execMode", "scanMode", "prepareHandle", "planString", "queryCost"})
    public QueryPlan(List<String> tablesQueried, boolean hasSubQuery, String execMode, String scanMode, QueryPrepareHandle prepareHandle, String planString, QueryCostTO queryCost) {
        this.tablesQueried = tablesQueried;
        this.hasSubQuery = hasSubQuery;
        this.execMode = execMode;
        this.scanMode = scanMode;
        this.prepareHandle = prepareHandle;
        this.planString = planString;
        this.queryCost = queryCost;
    }

    protected QueryPlan() {
    }

    public List<String> getTablesQueried() {
        return this.tablesQueried;
    }

    public boolean isHasSubQuery() {
        return this.hasSubQuery;
    }

    public String getExecMode() {
        return this.execMode;
    }

    public String getScanMode() {
        return this.scanMode;
    }

    public QueryPrepareHandle getPrepareHandle() {
        return this.prepareHandle;
    }

    public void setPrepareHandle(QueryPrepareHandle prepareHandle) {
        this.prepareHandle = prepareHandle;
    }

    public QueryCostTO getQueryCost() {
        return this.queryCost;
    }
}

