/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.query;

import java.beans.ConstructorProperties;
import java.io.Serializable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.apache.lens.api.result.LensErrorTO;

@XmlRootElement
public class QueryStatus
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XmlElement
    private double progress;
    private Integer queueNumber;
    @XmlElement
    private Status status;
    @XmlElement
    private String statusMessage;
    @XmlElement
    private boolean isResultSetAvailable = false;
    private String progressMessage;
    private String errorMessage;
    @XmlElement
    private LensErrorTO lensErrorTO;

    public String toString() {
        StringBuilder str = new StringBuilder(" Status : ").append(this.status.toString()).append("\n");
        if (this.statusMessage != null) {
            str.append(" Message : ").append(this.statusMessage).append("\n");
        }
        str.append(" Progress : ").append(this.progress).append("\n");
        if (this.progressMessage != null) {
            str.append(" Progress Message : ").append(this.progressMessage).append("\n");
        }
        if (this.queueNumber != null) {
            str.append(" Position in queue : ").append(this.queueNumber).append("\n");
        }
        if (this.errorMessage != null) {
            str.append(" Error : ").append(this.errorMessage).append("\n");
        }
        if (this.status.equals((Object)Status.SUCCESSFUL)) {
            if (this.isResultSetAvailable) {
                str.append(" Result Available");
            } else {
                str.append(" Result Not Available");
            }
        }
        return str.toString();
    }

    public boolean finished() {
        return this.status.equals((Object)Status.SUCCESSFUL) || this.status.equals((Object)Status.FAILED) || this.status.equals((Object)Status.CANCELED);
    }

    public boolean launched() {
        return this.status.equals((Object)Status.LAUNCHED);
    }

    public boolean running() {
        return this.status.equals((Object)Status.RUNNING);
    }

    public boolean queued() {
        return this.status.equals((Object)Status.QUEUED);
    }

    public boolean failed() {
        return this.status.equals((Object)Status.FAILED);
    }

    public static boolean isValidTransition(Status oldState, Status newState) {
        switch (oldState) {
            case NEW: {
                switch (newState) {
                    case QUEUED: {
                        return true;
                    }
                }
                break;
            }
            case QUEUED: {
                switch (newState) {
                    case LAUNCHED: 
                    case FAILED: 
                    case CANCELED: {
                        return true;
                    }
                }
                break;
            }
            case LAUNCHED: {
                switch (newState) {
                    case LAUNCHED: 
                    case FAILED: 
                    case CANCELED: 
                    case RUNNING: 
                    case EXECUTED: {
                        return true;
                    }
                }
                break;
            }
            case RUNNING: {
                switch (newState) {
                    case FAILED: 
                    case CANCELED: 
                    case RUNNING: 
                    case EXECUTED: {
                        return true;
                    }
                }
                break;
            }
            case EXECUTED: {
                switch (newState) {
                    case FAILED: 
                    case CANCELED: 
                    case EXECUTED: 
                    case SUCCESSFUL: {
                        return true;
                    }
                }
                break;
            }
            case FAILED: 
            case CANCELED: 
            case SUCCESSFUL: {
                if (!Status.CLOSED.equals((Object)newState)) break;
                return true;
            }
        }
        return false;
    }

    public boolean isValidTransition(Status newState) {
        return QueryStatus.isValidTransition(this.status, newState);
    }

    public Integer getErrorCode() {
        return this.lensErrorTO != null ? Integer.valueOf(this.lensErrorTO.getCode()) : null;
    }

    public String getLensErrorTOErrorMsg() {
        return this.lensErrorTO != null ? this.lensErrorTO.getMessage() : null;
    }

    @ConstructorProperties(value={"progress", "queueNumber", "status", "statusMessage", "isResultSetAvailable", "progressMessage", "errorMessage", "lensErrorTO"})
    public QueryStatus(double progress, Integer queueNumber, Status status, String statusMessage, boolean isResultSetAvailable, String progressMessage, String errorMessage, LensErrorTO lensErrorTO) {
        this.progress = progress;
        this.queueNumber = queueNumber;
        this.status = status;
        this.statusMessage = statusMessage;
        this.isResultSetAvailable = isResultSetAvailable;
        this.progressMessage = progressMessage;
        this.errorMessage = errorMessage;
        this.lensErrorTO = lensErrorTO;
    }

    protected QueryStatus() {
    }

    public double getProgress() {
        return this.progress;
    }

    public Integer getQueueNumber() {
        return this.queueNumber;
    }

    public void setQueueNumber(Integer queueNumber) {
        this.queueNumber = queueNumber;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public boolean isResultSetAvailable() {
        return this.isResultSetAvailable;
    }

    public String getProgressMessage() {
        return this.progressMessage;
    }

    public void setProgressMessage(String progressMessage) {
        this.progressMessage = progressMessage;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @XmlType
    @XmlEnum
    public static enum Status {
        NEW,
        QUEUED,
        LAUNCHED,
        RUNNING,
        EXECUTED,
        SUCCESSFUL,
        FAILED,
        CANCELED,
        CLOSED;

    }
}

