/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.result;

import com.google.common.base.Preconditions;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import lombok.NonNull;
import org.apache.commons.lang.StringUtils;
import org.apache.lens.api.query.QuerySubmitResult;
import org.apache.lens.api.result.LensErrorTO;
import org.apache.lens.api.result.NoErrorPayload;
import org.apache.lens.api.result.NoResultData;

@XmlRootElement
@XmlSeeAlso(value={NoResultData.class, NoErrorPayload.class, QuerySubmitResult.class})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class LensAPIResult<DATA> {
    @XmlElement
    private String apiVersion;
    @XmlElement
    private String id;
    @XmlElement(name="data")
    private DATA data;
    @XmlElement(name="error")
    private LensErrorTO lensErrorTO;
    @XmlTransient
    private Response.Status httpStatusCode;

    public static <DATA> LensAPIResult<DATA> composedOf(String apiVersion, String id, @NonNull DATA data) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        return LensAPIResult.composedOf(apiVersion, id, data, Response.Status.OK);
    }

    public static <DATA> LensAPIResult<DATA> composedOf(String apiVersion, String id, @NonNull DATA data, @NonNull Response.Status httpStatusCode) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (httpStatusCode == null) {
            throw new NullPointerException("httpStatusCode");
        }
        return new LensAPIResult<DATA>(apiVersion, id, data, null, httpStatusCode);
    }

    public static LensAPIResult<NoResultData> composedOf(String apiVersion, String id, @NonNull LensErrorTO lensErrorTO, @NonNull Response.Status httpStatusCode) {
        if (lensErrorTO == null) {
            throw new NullPointerException("lensErrorTO");
        }
        if (httpStatusCode == null) {
            throw new NullPointerException("httpStatusCode");
        }
        return new LensAPIResult<Object>(apiVersion, id, null, lensErrorTO, httpStatusCode);
    }

    private LensAPIResult(String apiVersion, String id, DATA data, LensErrorTO lensErrorTO, @NonNull Response.Status httpStatusCode) {
        if (httpStatusCode == null) {
            throw new NullPointerException("httpStatusCode");
        }
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((String)id));
        this.apiVersion = apiVersion;
        this.id = id;
        this.data = data;
        this.lensErrorTO = lensErrorTO;
        this.httpStatusCode = httpStatusCode;
    }

    public boolean areValidStackTracesPresent() {
        return this.lensErrorTO != null && this.lensErrorTO.areValidStackTracesPresent();
    }

    public Response.Status getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public boolean isSuccessResult() {
        return this.lensErrorTO == null;
    }

    public boolean isErrorResult() {
        return !this.isSuccessResult();
    }

    public int getErrorCode() {
        Preconditions.checkState((boolean)this.isErrorResult());
        return this.lensErrorTO.getCode();
    }

    public String getErrorMessage() {
        Preconditions.checkState((boolean)this.isErrorResult());
        return this.lensErrorTO.getMessage();
    }

    LensAPIResult() {
    }

    public String toString() {
        return "LensAPIResult(apiVersion=" + this.apiVersion + ", id=" + this.getId() + ", data=" + this.getData() + ", lensErrorTO=" + this.getLensErrorTO() + ", httpStatusCode=" + this.getHttpStatusCode() + ")";
    }

    public String getId() {
        return this.id;
    }

    public DATA getData() {
        return this.data;
    }

    public LensErrorTO getLensErrorTO() {
        return this.lensErrorTO;
    }
}

