/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lens.api.util;

import java.io.File;
import java.nio.file.Paths;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.lens.api.LensConf;

public class PathValidator {
    private LensConf config;
    public static final String PATH_PREFIX = "filesystem.prefix.";

    public PathValidator(LensConf config) {
        this.createDefaultUriProperties();
        this.config.addProperties(config.getProperties());
    }

    private void createDefaultUriProperties() {
        this.config = new LensConf();
        this.config.addProperty("filesystem.prefix.hdfs", "://");
        this.config.addProperty("filesystem.prefix.s3", "://");
        this.config.addProperty("filesystem.prefix.s3n", "://");
    }

    public String getValidPath(File path, boolean shouldBeDirectory, boolean shouldExist) {
        if (path.getPath().indexOf(":/") > 0) {
            return this.removePrefixBeforeURI(path.getPath());
        }
        if (shouldExist && !path.exists()) {
            throw new RuntimeException("Path " + path + " doesn't exist.");
        }
        if (shouldBeDirectory && !path.isDirectory()) {
            throw new RuntimeException("Path " + path + " is not a directory");
        }
        if (!shouldBeDirectory && path.isDirectory()) {
            throw new RuntimeException("Path " + path + " is a directory");
        }
        return path.getAbsolutePath();
    }

    public String removePrefixBeforeURI(String path) {
        path = path.replaceAll("/+", "/");
        if ((path = path.replaceAll("/$", "")).startsWith("~")) {
            path = path.replaceFirst("~", System.getProperty("user.home"));
        }
        String projectDir = Paths.get("", new String[0]).toAbsolutePath().toString();
        int indexOfUriInit = path.indexOf(":/");
        int currDirLen = projectDir.length();
        String escapedSlashes = ":///";
        Pattern pattern = Pattern.compile("^(.*):/.*");
        Matcher match = pattern.matcher(path);
        if (match.find() && this.config.getProperties().get(PATH_PREFIX + match.group(1)) != null) {
            escapedSlashes = this.config.getProperties().get(PATH_PREFIX + match.group(1));
        }
        if (path.startsWith(projectDir) && indexOfUriInit != -1) {
            path = path.substring(currDirLen + 1, path.length());
        }
        if ((indexOfUriInit = path.indexOf(":/")) != -1 && !path.contains(":///")) {
            path = path.substring(0, indexOfUriInit) + escapedSlashes + path.substring(indexOfUriInit + 2);
        }
        return path;
    }
}

