/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.sessions;

import java.io.InputStream;
import java.net.URI;
import java.security.PrivilegedExceptionAction;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.livy.LivyConf;
import org.apache.livy.LivyConf$;
import org.apache.livy.Logging;
import org.apache.livy.sessions.Session$;
import org.apache.livy.sessions.SessionState;
import org.apache.livy.utils.AppInfo;
import org.apache.livy.utils.AppInfo$;
import org.slf4j.Logger;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutor;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\t\u0015r!B\u0001\u0003\u0011\u0003Y\u0011aB*fgNLwN\u001c\u0006\u0003\u0007\u0011\t\u0001b]3tg&|gn\u001d\u0006\u0003\u000b\u0019\tA\u0001\\5ws*\u0011q\u0001C\u0001\u0007CB\f7\r[3\u000b\u0003%\t1a\u001c:h\u0007\u0001\u0001\"\u0001D\u0007\u000e\u0003\t1QA\u0004\u0002\t\u0002=\u0011qaU3tg&|gn\u0005\u0002\u000e!A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001aDQaF\u0007\u0005\u0002a\ta\u0001P5oSRtD#A\u0006\u0007\u000fii\u0001\u0013aI\u00017\t\u0001\"+Z2pm\u0016\u0014\u00180T3uC\u0012\fG/Y\n\u00033AAq!H\rC\u0002\u001b\u0005a$\u0001\u0002jIV\tq\u0004\u0005\u0002\u0012A%\u0011\u0011E\u0005\u0002\u0004\u0013:$\b\u0002C\u0012\u000e\u0011\u000b\u0007I\u0011\u0001\u0013\u0002\u001f\r|gNZ5h\u00052\f7m\u001b'jgR,\u0012!\n\t\u0004M%bcBA\t(\u0013\tA##\u0001\u0004Qe\u0016$WMZ\u0005\u0003U-\u00121aU3u\u0015\tA#\u0003\u0005\u0002'[%\u0011af\u000b\u0002\u0007'R\u0014\u0018N\\4\t\u0011Aj\u0001\u0012!Q!\n\u0015\n\u0001cY8oM&<'\t\\1dW2K7\u000f\u001e\u0011\t\u000bIjA\u0011A\u001a\u0002\u0017A\u0014X\r]1sK\u000e{gN\u001a\u000b\bi]Jt)S&N!\u00111S\u0007\f\u0017\n\u0005YZ#aA'ba\")\u0001(\ra\u0001i\u0005!1m\u001c8g\u0011\u0015Q\u0014\u00071\u0001<\u0003\u0011Q\u0017M]:\u0011\u0007q\"EF\u0004\u0002>\u0005:\u0011a(Q\u0007\u0002\u007f)\u0011\u0001IC\u0001\u0007yI|w\u000e\u001e \n\u0003MI!a\u0011\n\u0002\u000fA\f7m[1hK&\u0011QI\u0012\u0002\u0004'\u0016\f(BA\"\u0013\u0011\u0015A\u0015\u00071\u0001<\u0003\u00151\u0017\u000e\\3t\u0011\u0015Q\u0015\u00071\u0001<\u0003!\t'o\u00195jm\u0016\u001c\b\"\u0002'2\u0001\u0004Y\u0014a\u00029z\r&dWm\u001d\u0005\u0006\u001dF\u0002\raT\u0001\tY&4\u0018pQ8oMB\u0011\u0001+U\u0007\u0002\t%\u0011!\u000b\u0002\u0002\t\u0019&4\u0018pQ8oM\")A+\u0004C\u0001+\u0006Y!/Z:pYZ,WKU%t)\rYd\u000b\u0017\u0005\u0006/N\u0003\raO\u0001\u0005kJL7\u000fC\u0003O'\u0002\u0007q\nC\u0003[\u001b\u0011\u00051,\u0001\u0006sKN|GN^3V%&#2\u0001\u00183g!\ti&-D\u0001_\u0015\ty\u0006-A\u0002oKRT\u0011!Y\u0001\u0005U\u00064\u0018-\u0003\u0002d=\n\u0019QKU%\t\u000b\u0015L\u0006\u0019\u0001/\u0002\u0007U\u0014\u0018\u000eC\u0003O3\u0002\u0007qJB\u0003\u000f\u0005\u0005\u0005\u0001nE\u0002h!%\u0004\"\u0001\u00156\n\u0005-$!a\u0002'pO\u001eLgn\u001a\u0005\t;\u001d\u0014)\u0019!C\u0001=!Aan\u001aB\u0001B\u0003%q$A\u0002jI\u0002B\u0001\u0002]4\u0003\u0006\u0004%\t!]\u0001\u0006_^tWM]\u000b\u0002Y!A1o\u001aB\u0001B\u0003%A&\u0001\u0004po:,'\u000f\t\u0005\t\u001d\u001e\u0014)\u0019!C\u0001kV\tq\n\u0003\u0005xO\n\u0005\t\u0015!\u0003P\u0003%a\u0017N^=D_:4\u0007\u0005C\u0003\u0018O\u0012\u0005\u0011\u0010\u0006\u0003{wrl\bC\u0001\u0007h\u0011\u0015i\u0002\u00101\u0001 \u0011\u0015\u0001\b\u00101\u0001-\u0011\u0015q\u0005\u00101\u0001P\u0011!yxM1A\u0005\u0014\u0005\u0005\u0011\u0001E3yK\u000e,H/[8o\u0007>tG/\u001a=u+\t\t\u0019\u0001\u0005\u0003\u0002\u0006\u0005-QBAA\u0004\u0015\r\tIAE\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BA\u0007\u0003\u000f\u0011\u0001$\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;Fq\u0016\u001cW\u000f^8s\u0011!\t\tb\u001aQ\u0001\n\u0005\r\u0011!E3yK\u000e,H/[8o\u0007>tG/\u001a=uA!I\u0011QC4A\u0002\u0013E\u0011qC\u0001\u0007?\u0006\u0004\b/\u00133\u0016\u0005\u0005e\u0001\u0003B\t\u0002\u001c1J1!!\b\u0013\u0005\u0019y\u0005\u000f^5p]\"I\u0011\u0011E4A\u0002\u0013E\u00111E\u0001\u000b?\u0006\u0004\b/\u00133`I\u0015\fH\u0003BA\u0013\u0003W\u00012!EA\u0014\u0013\r\tIC\u0005\u0002\u0005+:LG\u000f\u0003\u0006\u0002.\u0005}\u0011\u0011!a\u0001\u00033\t1\u0001\u001f\u00132\u0011!\t\td\u001aQ!\n\u0005e\u0011aB0baBLE\r\t\u0005\n\u0003k9\u0007\u0019!C\u0005\u0003o\tQb\u00187bgR\f5\r^5wSRLXCAA\u001d!\r\t\u00121H\u0005\u0004\u0003{\u0011\"\u0001\u0002'p]\u001eD\u0011\"!\u0011h\u0001\u0004%I!a\u0011\u0002#}c\u0017m\u001d;BGRLg/\u001b;z?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005\u0015\u0003BCA\u0017\u0003\u007f\t\t\u00111\u0001\u0002:!A\u0011\u0011J4!B\u0013\tI$\u0001\b`Y\u0006\u001cH/Q2uSZLG/\u001f\u0011\t\u0013\u00055s\r1A\u0005\n\u0005=\u0013AC:uC\u001eLgn\u001a#jeV\u0011\u0011\u0011\u000b\t\u0005\u0003'\ni&\u0004\u0002\u0002V)!\u0011qKA-\u0003\t17OC\u0002\u0002\\\u0019\ta\u0001[1e_>\u0004\u0018\u0002BA0\u0003+\u0012A\u0001U1uQ\"I\u00111M4A\u0002\u0013%\u0011QM\u0001\u000fgR\fw-\u001b8h\t&\u0014x\fJ3r)\u0011\t)#a\u001a\t\u0015\u00055\u0012\u0011MA\u0001\u0002\u0004\t\t\u0006\u0003\u0005\u0002l\u001d\u0004\u000b\u0015BA)\u0003-\u0019H/Y4j]\u001e$\u0015N\u001d\u0011\t\u000f\u0005=t\r\"\u0001\u0002\u0018\u0005)\u0011\r\u001d9JI\"I\u00111O4A\u0002\u0013\u0005\u0011QO\u0001\bCB\u0004\u0018J\u001c4p+\t\t9\b\u0005\u0003\u0002z\u0005}TBAA>\u0015\r\ti\bB\u0001\u0006kRLGn]\u0005\u0005\u0003\u0003\u000bYHA\u0004BaBLeNZ8\t\u0013\u0005\u0015u\r1A\u0005\u0002\u0005\u001d\u0015aC1qa&sgm\\0%KF$B!!\n\u0002\n\"Q\u0011QFAB\u0003\u0003\u0005\r!a\u001e\t\u0011\u00055u\r)Q\u0005\u0003o\n\u0001\"\u00199q\u0013:4w\u000e\t\u0005\b\u0003#;G\u0011AA\u001c\u00031a\u0017m\u001d;BGRLg/\u001b;z\u0011\u001d\t)j\u001aD\u0001\u0003/\u000b\u0001\u0002\\8h\u0019&tWm\u001d\u000b\u0003\u00033\u0003B\u0001PANY%\u0019\u0011Q\u0014$\u0003\u0015%sG-\u001a=fIN+\u0017\u000fC\u0004\u0002\"\u001e$\t!a)\u0002\u001dI,7m\u001c:e\u0003\u000e$\u0018N^5usR\u0011\u0011Q\u0005\u0005\b\u0003O;g\u0011AAU\u0003A\u0011XmY8wKJLX*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002,B\u0019\u0011QV\r\u000f\u00051\u0001\u0001bBAYO\u001a\u0005\u00111W\u0001\u0006gR\fG/Z\u000b\u0003\u0003k\u00032\u0001DA\\\u0013\r\tIL\u0001\u0002\r'\u0016\u001c8/[8o'R\fG/\u001a\u0005\b\u0003{;G\u0011AA`\u0003\u0011\u0019Ho\u001c9\u0015\u0005\u0005\u0005\u0007CBA\u0003\u0003\u0007\f)#\u0003\u0003\u0002F\u0006\u001d!A\u0002$viV\u0014X\rC\u0004\u0002J\u001e$\t%a3\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012\u0001\f\u0005\b\u0003\u001f<g\u0011CAR\u0003-\u0019Ho\u001c9TKN\u001c\u0018n\u001c8\t\u0013\u0005MwM1A\u0007\u0012\u0005]\u0011!\u00039s_bLXk]3s\u0011\u001d\t9n\u001aC\t\u00033\f\u0011\u0002Z8Bg>;h.\u001a:\u0016\t\u0005m\u0017\u0011\u001d\u000b\u0005\u0003;\f\u0019\u0010\u0005\u0003\u0002`\u0006\u0005H\u0002\u0001\u0003\t\u0003G\f)N1\u0001\u0002f\n\tA+\u0005\u0003\u0002h\u00065\bcA\t\u0002j&\u0019\u00111\u001e\n\u0003\u000f9{G\u000f[5oOB\u0019\u0011#a<\n\u0007\u0005E(CA\u0002B]fD\u0011\"!>\u0002V\u0012\u0005\r!a>\u0002\u0005\u0019t\u0007#B\t\u0002z\u0006u\u0017bAA~%\tAAHY=oC6,g\bC\u0004\u0002\u0000\u001e$\tB!\u0001\u0002%\r|\u0007/\u001f*fg>,(oY3U_\"#ei\u0015\u000b\u00069\n\r!1\u0003\u0005\t\u0005\u000b\ti\u00101\u0001\u0003\b\u0005QA-\u0019;b'R\u0014X-Y7\u0011\t\t%!qB\u0007\u0003\u0005\u0017Q1A!\u0004a\u0003\tIw.\u0003\u0003\u0003\u0012\t-!aC%oaV$8\u000b\u001e:fC6DqA!\u0006\u0002~\u0002\u0007A&\u0001\u0003oC6,\u0007b\u0002B\rO\u0012%!1D\u0001\u000eO\u0016$8\u000b^1hS:<G)\u001b:\u0015\t\u0005E#Q\u0004\u0005\t\u0003/\u00129\u00021\u0001\u0003 A!\u00111\u000bB\u0011\u0013\u0011\u0011\u0019#!\u0016\u0003\u0015\u0019KG.Z*zgR,W\u000e")
public abstract class Session
implements Logging {
    private final int id;
    private final String owner;
    private final LivyConf livyConf;
    private final ExecutionContextExecutor executionContext;
    private Option<String> _appId;
    private long _lastActivity;
    private Path org$apache$livy$sessions$Session$$stagingDir;
    private AppInfo appInfo;
    private final Logger logger;
    private volatile boolean bitmap$0;

    public static URI resolveURI(URI uRI, LivyConf livyConf) {
        return Session$.MODULE$.resolveURI(uRI, livyConf);
    }

    public static Seq<String> resolveURIs(Seq<String> seq, LivyConf livyConf) {
        return Session$.MODULE$.resolveURIs(seq, livyConf);
    }

    public static Map<String, String> prepareConf(Map<String, String> map, Seq<String> seq, Seq<String> seq2, Seq<String> seq3, Seq<String> seq4, LivyConf livyConf) {
        return Session$.MODULE$.prepareConf(map, seq, seq2, seq3, seq4, livyConf);
    }

    public static Set<String> configBlackList() {
        return Session$.MODULE$.configBlackList();
    }

    private Logger logger$lzycompute() {
        Session session = this;
        synchronized (session) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public int id() {
        return this.id;
    }

    public String owner() {
        return this.owner;
    }

    public LivyConf livyConf() {
        return this.livyConf;
    }

    public ExecutionContextExecutor executionContext() {
        return this.executionContext;
    }

    public Option<String> _appId() {
        return this._appId;
    }

    public void _appId_$eq(Option<String> x$1) {
        this._appId = x$1;
    }

    private long _lastActivity() {
        return this._lastActivity;
    }

    private void _lastActivity_$eq(long x$1) {
        this._lastActivity = x$1;
    }

    public Path org$apache$livy$sessions$Session$$stagingDir() {
        return this.org$apache$livy$sessions$Session$$stagingDir;
    }

    private void org$apache$livy$sessions$Session$$stagingDir_$eq(Path x$1) {
        this.org$apache$livy$sessions$Session$$stagingDir = x$1;
    }

    public Option<String> appId() {
        return this._appId();
    }

    public AppInfo appInfo() {
        return this.appInfo;
    }

    public void appInfo_$eq(AppInfo x$1) {
        this.appInfo = x$1;
    }

    public long lastActivity() {
        long l;
        SessionState sessionState = this.state();
        if (sessionState instanceof SessionState.Error) {
            long time;
            SessionState.Error error = (SessionState.Error)sessionState;
            l = time = error.time();
        } else if (sessionState instanceof SessionState.Dead) {
            long time;
            SessionState.Dead dead = (SessionState.Dead)sessionState;
            l = time = dead.time();
        } else if (sessionState instanceof SessionState.Success) {
            long time;
            SessionState.Success success = (SessionState.Success)sessionState;
            l = time = success.time();
        } else {
            l = this._lastActivity();
        }
        return l;
    }

    public abstract IndexedSeq<String> logLines();

    public void recordActivity() {
        this._lastActivity_$eq(System.nanoTime());
    }

    public abstract RecoveryMetadata recoveryMetadata();

    public abstract SessionState state();

    public Future<BoxedUnit> stop() {
        return Future$.MODULE$.apply((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Session $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                try {
                    this.$outer.info((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$stop$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopping ", "..."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$sessions$Session$$anonfun$$$outer()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                    this.$outer.stopSession();
                    this.$outer.info((Function0<Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$stop$1 $outer;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Stopped ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$livy$sessions$Session$$anonfun$$$outer()}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    });
                }
                catch (Exception exception) {
                    this.$outer.warn((Function0<Object>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$stop$1 $outer;
                        private final Exception e$1;

                        public final Tuple2<String, Exception> apply() {
                            return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error stopping session ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$livy$sessions$Session$$anonfun$$$outer().id())})), (Object)this.e$1);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.e$1 = e$1;
                        }
                    });
                }
                try {
                    if (this.$outer.org$apache$livy$sessions$Session$$stagingDir() != null) {
                        this.$outer.debug((Function0<Object>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$stop$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting session ", " staging directory ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$livy$sessions$Session$$anonfun$$$outer().id()), this.$outer.org$apache$livy$sessions$Session$$anonfun$$$outer().org$apache$livy$sessions$Session$$stagingDir()}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.$outer.doAsOwner(new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$stop$1 $outer;

                            public final boolean apply() {
                                return this.apply$mcZ$sp();
                            }

                            public boolean apply$mcZ$sp() {
                                FileSystem fs = FileSystem.newInstance((Configuration)this.$outer.org$apache$livy$sessions$Session$$anonfun$$$outer().livyConf().hadoopConf());
                                try {
                                    return fs.delete(this.$outer.org$apache$livy$sessions$Session$$anonfun$$$outer().org$apache$livy$sessions$Session$$stagingDir(), true);
                                }
                                finally {
                                    fs.close();
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    this.$outer.warn((Function0<Object>)new Serializable(this, exception){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$stop$1 $outer;
                        private final Exception e$2;

                        public final Tuple2<String, Exception> apply() {
                            return new Tuple2((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error cleaning up session ", " staging dir."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$livy$sessions$Session$$anonfun$$$outer().id())})), (Object)this.e$2);
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.e$2 = e$2;
                        }
                    });
                }
            }

            public /* synthetic */ Session org$apache$livy$sessions$Session$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, (ExecutionContext)this.executionContext());
    }

    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.getClass().getSimpleName(), BoxesRunTime.boxToInteger((int)this.id())}));
    }

    public abstract void stopSession();

    public abstract Option<String> proxyUser();

    public <T> T doAsOwner(Function0<T> fn) {
        Object object;
        String user = (String)this.proxyUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Session $outer;

            public final String apply() {
                return this.$outer.owner();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        if (user == null) {
            object = fn.apply();
        } else {
            UserGroupInformation ugi = UserGroupInformation.isSecurityEnabled() ? (this.livyConf().getBoolean(LivyConf$.MODULE$.IMPERSONATION_ENABLED()) ? UserGroupInformation.createProxyUser((String)user, (UserGroupInformation)UserGroupInformation.getCurrentUser()) : UserGroupInformation.getCurrentUser()) : UserGroupInformation.createRemoteUser((String)user);
            object = ugi.doAs(new PrivilegedExceptionAction<T>(this, fn){
                private final Function0 fn$1;

                public T run() {
                    return (T)this.fn$1.apply();
                }
                {
                    this.fn$1 = fn$1;
                }
            });
        }
        return (T)object;
    }

    public URI copyResourceToHDFS(InputStream dataStream, String name) {
        return (URI)this.doAsOwner((Function0)new Serializable(this, dataStream, name){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Session $outer;
            private final InputStream dataStream$1;
            private final String name$1;

            /*
             * WARNING - void declaration
             */
            public final URI apply() {
                FileSystem fs = FileSystem.newInstance((Configuration)this.$outer.livyConf().hadoopConf());
                try {
                    Path filePath = new Path(this.$outer.org$apache$livy$sessions$Session$$getStagingDir(fs), this.name$1);
                    this.$outer.debug((Function0<Object>)new Serializable(this, filePath){
                        public static final long serialVersionUID = 0L;
                        private final Path filePath$1;

                        public final String apply() {
                            return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Uploading user file to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.filePath$1}));
                        }
                        {
                            this.filePath$1 = filePath$1;
                        }
                    });
                    FSDataOutputStream outFile = fs.create(filePath, true);
                    byte[] buffer = new byte[524288];
                    int read = -1;
                    try {
                        while ((read = this.dataStream$1.read(buffer)) != -1) {
                            outFile.write(buffer, 0, read);
                        }
                    }
                    catch (Throwable throwable) {
                        void var4_3;
                        var4_3.close();
                        throw throwable;
                    }
                    outFile.close();
                    return filePath.toUri();
                }
                finally {
                    fs.close();
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.dataStream$1 = dataStream$1;
                this.name$1 = name$1;
            }
        });
    }

    public synchronized Path org$apache$livy$sessions$Session$$getStagingDir(FileSystem fs) {
        if (this.org$apache$livy$sessions$Session$$stagingDir() == null) {
            String stagingRoot = (String)Option$.MODULE$.apply((Object)this.livyConf().get(LivyConf$.MODULE$.SESSION_STAGING_DIR())).getOrElse((Function0)new Serializable(this, fs){
                public static final long serialVersionUID = 0L;
                private final FileSystem fs$1;

                public final String apply() {
                    return new Path(this.fs$1.getHomeDirectory(), ".livy-sessions").toString();
                }
                {
                    this.fs$1 = fs$1;
                }
            });
            Path sessionDir = new Path(stagingRoot, UUID.randomUUID().toString());
            fs.mkdirs(sessionDir);
            fs.setPermission(sessionDir, new FsPermission("700"));
            this.org$apache$livy$sessions$Session$$stagingDir_$eq(sessionDir);
            this.debug((Function0<Object>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Session $outer;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Session ", " staging directory is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.id()), this.$outer.org$apache$livy$sessions$Session$$stagingDir()}));
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
        }
        return this.org$apache$livy$sessions$Session$$stagingDir();
    }

    public Session(int id, String owner, LivyConf livyConf) {
        this.id = id;
        this.owner = owner;
        this.livyConf = livyConf;
        Logging.class.$init$((Logging)this);
        this.executionContext = ExecutionContext$.MODULE$.global();
        this._appId = None$.MODULE$;
        this._lastActivity = System.nanoTime();
        this.org$apache$livy$sessions$Session$$stagingDir = null;
        this.appInfo = new AppInfo(AppInfo$.MODULE$.apply$default$1(), AppInfo$.MODULE$.apply$default$2());
    }

    public static interface RecoveryMetadata {
        public int id();
    }
}

