/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.util.mutable.MutableValue;

public class FunctionAllGroupHeadsCollector
extends AbstractAllGroupHeadsCollector<GroupHead> {
    private final ValueSource groupBy;
    private final Map<?, ?> vsContext;
    private final Map<MutableValue, GroupHead> groups = new HashMap<MutableValue, GroupHead>();
    private final Sort sortWithinGroup;
    private FunctionValues.ValueFiller filler;
    private MutableValue mval;
    private LeafReaderContext readerContext;
    private Scorer scorer;

    public FunctionAllGroupHeadsCollector(ValueSource groupBy, Map<?, ?> vsContext, Sort sortWithinGroup) {
        super(sortWithinGroup.getSort().length);
        this.sortWithinGroup = sortWithinGroup;
        this.groupBy = groupBy;
        this.vsContext = vsContext;
        SortField[] sortFields = sortWithinGroup.getSort();
        for (int i = 0; i < sortFields.length; ++i) {
            this.reversed[i] = sortFields[i].getReverse() ? -1 : 1;
        }
    }

    @Override
    protected void retrieveGroupHeadAndAddIfNotExist(int doc) throws IOException {
        this.filler.fillValue(doc);
        GroupHead groupHead = this.groups.get(this.mval);
        if (groupHead == null) {
            MutableValue groupValue = this.mval.duplicate();
            groupHead = new GroupHead(groupValue, this.sortWithinGroup, doc);
            this.groups.put(groupValue, groupHead);
            this.temporalResult.stop = true;
        } else {
            this.temporalResult.stop = false;
        }
        this.temporalResult.groupHead = groupHead;
    }

    @Override
    protected Collection<GroupHead> getCollectedGroupHeads() {
        return this.groups.values();
    }

    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
        for (GroupHead groupHead : this.groups.values()) {
            for (LeafFieldComparator comparator : groupHead.leafComparators) {
                comparator.setScorer(scorer);
            }
        }
    }

    protected void doSetNextReader(LeafReaderContext context) throws IOException {
        this.readerContext = context;
        FunctionValues values = this.groupBy.getValues(this.vsContext, context);
        this.filler = values.getValueFiller();
        this.mval = this.filler.getValue();
        for (GroupHead groupHead : this.groups.values()) {
            for (int i = 0; i < groupHead.comparators.length; ++i) {
                groupHead.leafComparators[i] = groupHead.comparators[i].getLeafComparator(context);
            }
        }
    }

    public class GroupHead
    extends AbstractAllGroupHeadsCollector.GroupHead<MutableValue> {
        final FieldComparator<?>[] comparators;
        final LeafFieldComparator[] leafComparators;

        private GroupHead(MutableValue groupValue, Sort sort, int doc) throws IOException {
            super(groupValue, doc + ((FunctionAllGroupHeadsCollector)FunctionAllGroupHeadsCollector.this).readerContext.docBase);
            SortField[] sortFields = sort.getSort();
            this.comparators = new FieldComparator[sortFields.length];
            this.leafComparators = new LeafFieldComparator[sortFields.length];
            for (int i = 0; i < sortFields.length; ++i) {
                this.comparators[i] = sortFields[i].getComparator(1, i);
                this.leafComparators[i] = this.comparators[i].getLeafComparator(FunctionAllGroupHeadsCollector.this.readerContext);
                this.leafComparators[i].setScorer(FunctionAllGroupHeadsCollector.this.scorer);
                this.leafComparators[i].copy(0, doc);
                this.leafComparators[i].setBottom(0);
            }
        }

        @Override
        public int compare(int compIDX, int doc) throws IOException {
            return this.leafComparators[compIDX].compareBottom(doc);
        }

        @Override
        public void updateDocHead(int doc) throws IOException {
            for (LeafFieldComparator comparator : this.leafComparators) {
                comparator.copy(0, doc);
                comparator.setBottom(0);
            }
            this.doc = doc + ((FunctionAllGroupHeadsCollector)FunctionAllGroupHeadsCollector.this).readerContext.docBase;
        }
    }
}

