/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.h2obindings;

import org.apache.mahout.math.AbstractMatrix;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.SparseMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.flavor.MatrixFlavor;
import water.fvec.Chunk;

public class H2OBlockMatrix
extends AbstractMatrix {
    private Chunk[] chks;
    private Matrix cow;

    public H2OBlockMatrix(Chunk[] chks) {
        super(chks[0].len(), chks.length);
        this.chks = chks;
    }

    private void cow() {
        if (this.cow != null) {
            return;
        }
        this.cow = this.chks[0].isSparse() ? new SparseMatrix(this.chks[0].len(), this.chks.length) : new DenseMatrix(this.chks[0].len(), this.chks.length);
        for (int c = 0; c < this.chks.length; ++c) {
            for (int r = 0; r < this.chks[0].len(); ++r) {
                this.cow.setQuick(r, c, this.chks[c].atd(r));
            }
        }
    }

    public void setQuick(int row, int col, double val) {
        this.cow();
        this.cow.setQuick(row, col, val);
    }

    public Matrix like(int nrow, int ncol) {
        if (this.chks[0].isSparse()) {
            return new SparseMatrix(nrow, ncol);
        }
        return new DenseMatrix(nrow, ncol);
    }

    public Matrix like() {
        if (this.chks[0].isSparse()) {
            return new SparseMatrix(this.rowSize(), this.columnSize());
        }
        return new DenseMatrix(this.rowSize(), this.columnSize());
    }

    public double getQuick(int row, int col) {
        if (this.cow != null) {
            return this.cow.getQuick(row, col);
        }
        return this.chks[col].atd(row);
    }

    public Matrix assignRow(int row, Vector v) {
        this.cow();
        this.cow.assignRow(row, v);
        return this.cow;
    }

    public Matrix assignColumn(int col, Vector v) {
        this.cow();
        this.cow.assignColumn(col, v);
        return this.cow;
    }

    public MatrixFlavor getFlavor() {
        if (this.cow != null) {
            return this.cow.getFlavor();
        }
        if (this.chks[0].isSparse()) {
            return MatrixFlavor.SPARSELIKE;
        }
        return MatrixFlavor.DENSELIKE;
    }
}

