/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.h2obindings.ops;

import org.apache.mahout.h2obindings.drm.H2OBCast;
import org.apache.mahout.h2obindings.drm.H2ODrm;
import org.apache.mahout.math.DiagonalMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;

public class TimesRightMatrix {
    public static H2ODrm exec(H2ODrm drmA, Matrix B) {
        Frame A = drmA.frame;
        Vec keys = drmA.keys;
        Frame AinCoreB = null;
        AinCoreB = B instanceof DiagonalMatrix ? TimesRightMatrix.execDiagonal(A, B.viewDiagonal()) : TimesRightMatrix.execCommon(A, B);
        return new H2ODrm(AinCoreB, keys);
    }

    private static Frame execDiagonal(Frame A, Vector d) {
        final H2OBCast<Vector> bd = new H2OBCast<Vector>(d);
        return new MRTask(){

            public void map(Chunk[] chks, NewChunk[] ncs) {
                Vector D = (Vector)bd.value();
                int chunkSize = chks[0].len();
                for (int c = 0; c < ncs.length; ++c) {
                    for (int r = 0; r < chunkSize; ++r) {
                        double v = chks[c].atd(r) * D.getQuick(c);
                        ncs[c].addNum(v);
                    }
                }
            }
        }.doAll(d.size(), A).outputFrame(null, (String[][])null);
    }

    private static Frame execCommon(Frame A, Matrix b) {
        final H2OBCast<Matrix> bb = new H2OBCast<Matrix>(b);
        return new MRTask(){

            public void map(Chunk[] chks, NewChunk[] ncs) {
                Matrix B = (Matrix)bb.value();
                int chunkSize = chks[0].len();
                for (int c = 0; c < ncs.length; ++c) {
                    for (int r = 0; r < chunkSize; ++r) {
                        double v = 0.0;
                        for (int i = 0; i < chks.length; ++i) {
                            v += chks[i].atd(r) * B.getQuick(i, c);
                        }
                        ncs[c].addNum(v);
                    }
                }
            }
        }.doAll(b.columnSize(), A).outputFrame(null, (String[][])null);
    }
}

