/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.arff;

public enum ARFFType {
    NUMERIC("numeric"),
    INTEGER("integer"),
    REAL("real"),
    NOMINAL("{"),
    DATE("date"),
    STRING("string");

    private final String indicator;

    private ARFFType(String indicator) {
        this.indicator = indicator;
    }

    public String getIndicator() {
        return this.indicator;
    }

    public String getLabel(String line) {
        int idx = line.lastIndexOf(this.indicator);
        return ARFFType.removeQuotes(line.substring("@attribute".length(), idx));
    }

    public static String removeQuotes(String str) {
        String cleaned = str;
        if (cleaned != null) {
            boolean isQuoted;
            boolean bl = isQuoted = (cleaned = cleaned.trim()).length() > 1 && (cleaned.startsWith("\"") && cleaned.endsWith("\"") || cleaned.startsWith("'") && cleaned.endsWith("'"));
            if (isQuoted) {
                cleaned = cleaned.substring(1, cleaned.length() - 1);
            }
        }
        return cleaned;
    }
}

