/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.nlp.tfidf;

import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.scalabindings.RLikeOps$;
import org.apache.mahout.nlp.tfidf.TFIDF;
import org.apache.mahout.nlp.tfidf.TFIDFtestBase;
import org.apache.mahout.nlp.tfidf.TFIDFtestBase$;
import org.apache.mahout.nlp.tfidf.TermWeight;
import org.scalatest.FunSuite;
import org.scalatest.Tag;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public abstract class TFIDFtestBase$class {
    public static Tuple2 createDictionaryAndDfMaps(FunSuite $this, List documents) {
        scala.collection.immutable.Map dictMap = Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)documents.unzip((Function1)Predef$.MODULE$.conforms())._2()).mkString(" ").toLowerCase().split(" ")).groupBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        }).mapValues((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(String[] x$1) {
                return x$1.length;
            }
        });
        scala.collection.immutable.Map dictIndex = ((scala.collection.immutable.Map)((TraversableLike)dictMap.zipWithIndex(Map$.MODULE$.canBuildFrom())).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, Object> apply(Tuple2<Tuple2<String, Object>, Object> x) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(((Tuple2)x._1())._1()), (Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp()));
            }
        }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
        int[] docFrequencyCount = new int[dictMap.size()];
        dictMap.foreach((Function1)new Serializable($this, dictIndex, docFrequencyCount, documents){
            public static final long serialVersionUID = 0L;
            public final scala.collection.immutable.Map dictIndex$1;
            public final int[] docFrequencyCount$1;
            private final List documents$1;

            public final void apply(Tuple2<String, Object> token) {
                this.documents$1.foreach((Function1)new Serializable(this, token){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ TFIDFtestBase$.anonfun.createDictionaryAndDfMaps.1 $outer;
                    private final Tuple2 token$1;

                    public final void apply(Tuple2<Object, String> doc) {
                        if (Predef$.MODULE$.refArrayOps((Object[])((String)doc._2()).toLowerCase().split(" ")).contains(this.token$1._1())) {
                            int n = BoxesRunTime.unboxToInt((Object)this.$outer.dictIndex$1.apply(this.token$1._1()));
                            this.$outer.docFrequencyCount$1[n] = this.$outer.docFrequencyCount$1[n] + 1;
                        }
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.token$1 = token$1;
                    }
                });
            }
            {
                this.dictIndex$1 = dictIndex$1;
                this.docFrequencyCount$1 = docFrequencyCount$1;
                this.documents$1 = documents$1;
            }
        });
        scala.collection.immutable.Map docFrequencyMap = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.intArrayOps(docFrequencyCount).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Object> apply(Tuple2<Object, Object> x) {
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)x._2$mcI$sp())), (Object)BoxesRunTime.boxToInteger((int)x._1$mcI$sp()));
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toMap(Predef$.MODULE$.conforms());
        return new Tuple2((Object)dictIndex, (Object)docFrequencyMap);
    }

    public static Vector vectorizeDocument(FunSuite $this, String document, Map dictionaryMap, Map dfMap, TermWeight weight) {
        scala.collection.immutable.Map wordCounts = Predef$.MODULE$.refArrayOps((Object[])document.toLowerCase().split(" ")).groupBy((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x) {
                return (String)Predef$.MODULE$.identity((Object)x);
            }
        }).mapValues((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(String[] x$2) {
                return x$2.length;
            }
        });
        RandomAccessSparseVector vec = new RandomAccessSparseVector(dictionaryMap.size());
        int totalDFSize = dictionaryMap.size();
        int docSize = wordCounts.size();
        wordCounts.foreach((Function1)new Serializable($this, vec, totalDFSize, docSize, dictionaryMap, dfMap, weight){
            public static final long serialVersionUID = 0L;
            private final RandomAccessSparseVector vec$1;
            private final int totalDFSize$1;
            private final int docSize$1;
            private final Map dictionaryMap$1;
            private final Map dfMap$4;
            private final TermWeight weight$1;

            public final void apply(Tuple2<String, Object> word) {
                String term = (String)word._1();
                if (this.dictionaryMap$1.contains((Object)term)) {
                    int termFreq = word._2$mcI$sp();
                    int dictIndex = BoxesRunTime.unboxToInt((Object)this.dictionaryMap$1.apply((Object)term));
                    int docFreq = BoxesRunTime.unboxToInt((Object)this.dfMap$4.apply((Object)BoxesRunTime.boxToInteger((int)dictIndex)));
                    double currentWeight = this.weight$1.calculate(termFreq, docFreq, this.docSize$1, this.totalDFSize$1);
                    RLikeOps$.MODULE$.v2vOps((Vector)this.vec$1).update(dictIndex, currentWeight);
                }
            }
            {
                this.vec$1 = vec$1;
                this.totalDFSize$1 = totalDFSize$1;
                this.docSize$1 = docSize$1;
                this.dictionaryMap$1 = dictionaryMap$1;
                this.dfMap$4 = dfMap$4;
                this.weight$1 = weight$1;
            }
        });
        return vec;
    }

    public static TermWeight vectorizeDocument$default$4(FunSuite $this) {
        return new TFIDF();
    }

    public static void $init$(FunSuite $this) {
        ((TFIDFtestBase)$this).org$apache$mahout$nlp$tfidf$TFIDFtestBase$_setter_$epsilon_$eq(1.0E-6);
        ((TFIDFtestBase)$this).org$apache$mahout$nlp$tfidf$TFIDFtestBase$_setter_$documents_$eq(List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)"the first document contains 5 terms"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)"document two document contains 4 terms"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)3), (Object)"document three three terms"), new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)"each document including this document contain the term document")})));
        $this.test("TF test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new TFIDFtestBase$.anonfun.1($this));
        $this.test("TFIDF test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new TFIDFtestBase$.anonfun.2($this));
        $this.test("MLlib TFIDF test", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tag[0]), (Function0)new TFIDFtestBase$.anonfun.3($this));
    }
}

