/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.decompositions;

import org.apache.log4j.Logger;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;
import org.apache.mahout.math.CholeskyDecomposition;
import org.apache.mahout.math.Matrices;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.scalabindings.RLikeDoubleScalarOps$;
import org.apache.mahout.math.scalabindings.RLikeOps$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SSVD$ {
    public static final SSVD$ MODULE$;
    private final Logger log;

    static {
        new SSVD$();
    }

    private Logger log() {
        return this.log;
    }

    public Tuple3<Matrix, Matrix, Vector> ssvd(Matrix a, int k, int p, int q) {
        int n;
        int m = RLikeOps$.MODULE$.m2mOps(a).nrow();
        if (k > package$.MODULE$.min(m, n = RLikeOps$.MODULE$.m2mOps(a).ncol())) {
            throw new IllegalArgumentException("k cannot be greater than smaller of m,n");
        }
        int pfxed = package$.MODULE$.min(p, package$.MODULE$.min(m, n) - k);
        int r = k + pfxed;
        RandomWrapper rnd = RandomUtils.getRandom();
        Matrix omega = Matrices.symmetricUniformView((int)n, (int)r, (int)rnd.nextInt());
        ObjectRef y = new ObjectRef((Object)RLikeOps$.MODULE$.m2mOps(a).$percent$times$percent(omega));
        ObjectRef yty = new ObjectRef((Object)RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps((Matrix)y.elem).t()).$percent$times$percent((Matrix)y.elem));
        Matrix at2 = RLikeOps$.MODULE$.m2mOps(a).t();
        ObjectRef ch = new ObjectRef((Object)org.apache.mahout.math.scalabindings.package$.MODULE$.chol((Matrix)yty.elem, org.apache.mahout.math.scalabindings.package$.MODULE$.chol$default$2()));
        Predef$.MODULE$.assert(((CholeskyDecomposition)ch.elem).isPositiveDefinite(), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Rank-deficiency detected during s-SVD";
            }
        });
        ObjectRef bt = new ObjectRef((Object)((CholeskyDecomposition)ch.elem).solveRight(RLikeOps$.MODULE$.m2mOps(at2).$percent$times$percent((Matrix)y.elem)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), q).foreach$mVc$sp((Function1)new Serializable(a, y, yty, at2, ch, bt){
            public static final long serialVersionUID = 0L;
            private final Matrix a$1;
            private final ObjectRef y$1;
            private final ObjectRef yty$1;
            private final Matrix at$1;
            private final ObjectRef ch$1;
            private final ObjectRef bt$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.y$1.elem = RLikeOps$.MODULE$.m2mOps(this.a$1).$percent$times$percent((Matrix)this.bt$1.elem);
                this.yty$1.elem = RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps((Matrix)this.y$1.elem).t()).$percent$times$percent((Matrix)this.y$1.elem);
                this.ch$1.elem = org.apache.mahout.math.scalabindings.package$.MODULE$.chol((Matrix)this.yty$1.elem, org.apache.mahout.math.scalabindings.package$.MODULE$.chol$default$2());
                this.bt$1.elem = ((CholeskyDecomposition)this.ch$1.elem).solveRight(RLikeOps$.MODULE$.m2mOps(this.at$1).$percent$times$percent((Matrix)this.y$1.elem));
            }
            {
                this.a$1 = a$1;
                this.y$1 = y$1;
                this.yty$1 = yty$1;
                this.at$1 = at$1;
                this.ch$1 = ch$1;
                this.bt$1 = bt$1;
            }
        });
        Matrix bbt = RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps((Matrix)bt.elem).t()).$percent$times$percent((Matrix)bt.elem);
        Tuple2<Matrix, Vector> tuple2 = org.apache.mahout.math.scalabindings.package$.MODULE$.eigen(bbt);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Matrix uhat = (Matrix)tuple2._1();
            Vector d = (Vector)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)uhat, (Object)d);
            Matrix uhat2 = (Matrix)tuple23._1();
            Vector d2 = (Vector)tuple23._2();
            Vector s = RLikeOps$.MODULE$.v2vOps(d2).sqrt();
            Matrix u = RLikeOps$.MODULE$.m2mOps(((CholeskyDecomposition)ch.elem).solveRight((Matrix)y.elem)).$percent$times$percent(uhat2);
            boolean bl = true;
            Matrix v = RLikeOps$.MODULE$.m2mOps((Matrix)bt.elem).$percent$times$percent(RLikeOps$.MODULE$.m2mOps(uhat2).$percent$times$percent((Matrix)org.apache.mahout.math.scalabindings.package$.MODULE$.diagv(RLikeOps$.MODULE$.v2vOps(s).$div$colon((double)bl))));
            return new Tuple3((Object)RLikeOps$.MODULE$.m2mOps(u).apply(org.apache.mahout.math.scalabindings.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k)), (Object)RLikeOps$.MODULE$.m2mOps(v).apply(org.apache.mahout.math.scalabindings.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k)), (Object)RLikeOps$.MODULE$.v2vOps(s).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k)));
        }
        throw new MatchError(tuple2);
    }

    public int ssvd$default$3() {
        return 15;
    }

    public int ssvd$default$4() {
        return 0;
    }

    public Tuple3<Matrix, Matrix, Vector> spca(Matrix a, int k, int p, int q) {
        int n;
        int m = RLikeOps$.MODULE$.m2mOps(a).nrow();
        if (k > package$.MODULE$.min(m, n = RLikeOps$.MODULE$.m2mOps(a).ncol())) {
            throw new IllegalArgumentException("k cannot be greater than smaller of m,n");
        }
        int pfxed = package$.MODULE$.min(p, package$.MODULE$.min(m, n) - k);
        int r = k + pfxed;
        RandomWrapper rnd = RandomUtils.getRandom();
        Matrix omega = Matrices.symmetricUniformView((int)n, (int)r, (int)rnd.nextInt());
        Vector mu = RLikeOps$.MODULE$.m2mOps(a).colMeans();
        double mtm = mu.dot(mu);
        if (this.log().isDebugEnabled()) {
            this.log().debug((Object)new StringOps(Predef$.MODULE$.augmentString("xi=%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mu})));
        }
        ObjectRef y = new ObjectRef((Object)RLikeOps$.MODULE$.m2mOps(a).$percent$times$percent(omega));
        Vector s_o = RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps(omega).t()).$percent$times$percent(mu);
        RLikeOps$.MODULE$.m2mOps((Matrix)y.elem).$colon$eq((Function3<Object, Object, Object, Object>)new Serializable(s_o){
            public static final long serialVersionUID = 0L;
            private final Vector s_o$1;

            public final double apply(int r, int c, double v) {
                return v - RLikeOps$.MODULE$.v2vOps(this.s_o$1).apply(c);
            }
            {
                this.s_o$1 = s_o$1;
            }
        });
        ObjectRef yty = new ObjectRef((Object)RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps((Matrix)y.elem).t()).$percent$times$percent((Matrix)y.elem));
        ObjectRef ch = new ObjectRef((Object)org.apache.mahout.math.scalabindings.package$.MODULE$.chol((Matrix)yty.elem, org.apache.mahout.math.scalabindings.package$.MODULE$.chol$default$2()));
        ObjectRef qm = new ObjectRef((Object)((CholeskyDecomposition)ch.elem).solveRight((Matrix)y.elem));
        ObjectRef bt = new ObjectRef((Object)RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps(a).t()).$percent$times$percent((Matrix)qm.elem));
        ObjectRef s_q = new ObjectRef((Object)RLikeOps$.MODULE$.m2mOps((Matrix)qm.elem).colSums());
        ObjectRef s_b = new ObjectRef((Object)RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps((Matrix)bt.elem).t()).$percent$times$percent(mu));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), q).foreach$mVc$sp((Function1)new Serializable(a, mu, mtm, y, yty, ch, qm, bt, s_q, s_b){
            public static final long serialVersionUID = 0L;
            private final Matrix a$2;
            private final Vector mu$1;
            private final double mtm$1;
            private final ObjectRef y$2;
            private final ObjectRef yty$2;
            private final ObjectRef ch$2;
            private final ObjectRef qm$1;
            private final ObjectRef bt$2;
            private final ObjectRef s_q$1;
            private final ObjectRef s_b$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RLikeOps$.MODULE$.m2mOps((Matrix)this.bt$2.elem).$minus$eq(this.mu$1.cross((Vector)this.s_q$1.elem));
                this.y$2.elem = RLikeOps$.MODULE$.m2mOps(this.a$2).$percent$times$percent((Matrix)this.bt$2.elem);
                Vector vector = (Vector)this.s_b$1.elem;
                Vector st_b = RLikeOps$.MODULE$.v2vOps(RLikeDoubleScalarOps$.MODULE$.$times$extension1(RLikeOps$.MODULE$.double2Scalar(this.mtm$1), (Vector)this.s_q$1.elem)).$minus$eq$colon(vector);
                RLikeOps$.MODULE$.m2mOps((Matrix)this.y$2.elem).$colon$eq((Function3<Object, Object, Object, Object>)new Serializable(this, st_b){
                    public static final long serialVersionUID = 0L;
                    private final Vector st_b$1;

                    public final double apply(int r, int c, double v) {
                        return v - RLikeOps$.MODULE$.v2vOps(this.st_b$1).apply(c);
                    }
                    {
                        this.st_b$1 = st_b$1;
                    }
                });
                this.yty$2.elem = RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps((Matrix)this.y$2.elem).t()).$percent$times$percent((Matrix)this.y$2.elem);
                this.ch$2.elem = org.apache.mahout.math.scalabindings.package$.MODULE$.chol((Matrix)this.yty$2.elem, org.apache.mahout.math.scalabindings.package$.MODULE$.chol$default$2());
                this.qm$1.elem = ((CholeskyDecomposition)this.ch$2.elem).solveRight((Matrix)this.y$2.elem);
                this.bt$2.elem = RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps(this.a$2).t()).$percent$times$percent((Matrix)this.qm$1.elem);
                this.s_q$1.elem = RLikeOps$.MODULE$.m2mOps((Matrix)this.qm$1.elem).colSums();
                this.s_b$1.elem = RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps((Matrix)this.bt$2.elem).t()).$percent$times$percent(this.mu$1);
            }
            {
                this.a$2 = a$2;
                this.mu$1 = mu$1;
                this.mtm$1 = mtm$1;
                this.y$2 = y$2;
                this.yty$2 = yty$2;
                this.ch$2 = ch$2;
                this.qm$1 = qm$1;
                this.bt$2 = bt$2;
                this.s_q$1 = s_q$1;
                this.s_b$1 = s_b$1;
            }
        });
        Matrix c = ((Vector)s_q.elem).cross((Vector)s_b.elem);
        Matrix bbt = RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps(RLikeOps$.MODULE$.m2mOps((Matrix)bt.elem).t()).$percent$times$percent((Matrix)bt.elem)).$minus$eq(c)).$minus$eq(RLikeOps$.MODULE$.m2mOps(c).t())).$plus$eq(RLikeDoubleScalarOps$.MODULE$.$times$extension1(RLikeOps$.MODULE$.double2Scalar(mtm), (Vector)s_q.elem).cross((Vector)s_q.elem));
        Tuple2<Matrix, Vector> tuple2 = org.apache.mahout.math.scalabindings.package$.MODULE$.eigen(bbt);
        if (tuple2 != null) {
            Tuple2 tuple22;
            Matrix uhat = (Matrix)tuple2._1();
            Vector d = (Vector)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)uhat, (Object)d);
            Matrix uhat2 = (Matrix)tuple23._1();
            Vector d2 = (Vector)tuple23._2();
            Vector s = RLikeOps$.MODULE$.v2vOps(d2).sqrt();
            Matrix u = RLikeOps$.MODULE$.m2mOps((Matrix)qm.elem).$percent$times$percent(uhat2);
            Matrix matrix = uhat2;
            boolean bl = true;
            Matrix v = RLikeOps$.MODULE$.m2mOps((Matrix)bt.elem).$percent$times$percent(RLikeOps$.MODULE$.m2mOps((Matrix)org.apache.mahout.math.scalabindings.package$.MODULE$.diagv(RLikeOps$.MODULE$.v2vOps(s).$div$colon((double)bl))).$percent$times$percent$colon(matrix));
            return new Tuple3((Object)RLikeOps$.MODULE$.m2mOps(u).apply(org.apache.mahout.math.scalabindings.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k)), (Object)RLikeOps$.MODULE$.m2mOps(v).apply(org.apache.mahout.math.scalabindings.package$.MODULE$.$colon$colon(), RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k)), (Object)RLikeOps$.MODULE$.v2vOps(s).apply(RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), k)));
        }
        throw new MatchError(tuple2);
    }

    public int spca$default$3() {
        return 15;
    }

    public int spca$default$4() {
        return 0;
    }

    private SSVD$() {
        MODULE$ = this;
        this.log = Logger.getLogger(this.getClass());
    }
}

