/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.toolchain.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.Objects;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.toolchain.io.ToolchainsParseException;
import org.apache.maven.toolchain.io.ToolchainsReader;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.v4.MavenToolchainsStaxReader;

@Named
@Singleton
public class DefaultToolchainsReader
implements ToolchainsReader {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PersistedToolchains read(File input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (InputStream in = Files.newInputStream(input.toPath(), new OpenOption[0]);){
            PersistedToolchains persistedToolchains = new PersistedToolchains(new MavenToolchainsStaxReader().read(in, this.isStrict(options)));
            return persistedToolchains;
        }
        catch (XMLStreamException e) {
            throw new ToolchainsParseException(e.getMessage(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PersistedToolchains read(Reader input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (Reader in = input;){
            PersistedToolchains persistedToolchains = new PersistedToolchains(new MavenToolchainsStaxReader().read(in, this.isStrict(options)));
            return persistedToolchains;
        }
        catch (XMLStreamException e) {
            throw new ToolchainsParseException(e.getMessage(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PersistedToolchains read(InputStream input, Map<String, ?> options) throws IOException {
        Objects.requireNonNull(input, "input cannot be null");
        try (InputStream in = input;){
            PersistedToolchains persistedToolchains = new PersistedToolchains(new MavenToolchainsStaxReader().read(in, this.isStrict(options)));
            return persistedToolchains;
        }
        catch (XMLStreamException e) {
            throw new ToolchainsParseException(e.getMessage(), e.getLocation().getLineNumber(), e.getLocation().getColumnNumber(), e);
        }
    }

    private boolean isStrict(Map<String, ?> options) {
        Object value = options != null ? (Object)options.get("org.apache.maven.toolchains.io.isStrict") : null;
        return value == null || Boolean.parseBoolean(value.toString());
    }
}

