/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.policy.semver;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class SemVer {
    private static final Pattern SEMVER_PATTERN = Pattern.compile("^(0|[1-9]\\d*)\\.(0|[1-9]\\d*)\\.(0|[1-9]\\d*)(?:-((?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*)(?:\\.(?:0|[1-9]\\d*|\\d*[a-zA-Z-][0-9a-zA-Z-]*))*))?(?:\\+([0-9a-zA-Z-]+(?:\\.[0-9a-zA-Z-]+)*))?$");
    private final int major;
    private final int minor;
    private final int patch;
    private final String preRelease;
    private final String metadata;

    protected SemVer(int major, int minor, int patch, String preRelease, String metadata) {
        if (major < 0 || minor < 0 || patch < 0) {
            throw new IllegalArgumentException("Version numbers must be non-negative");
        }
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.preRelease = preRelease;
        this.metadata = metadata;
    }

    static SemVer parse(String version) {
        if (version == null || version.trim().isEmpty()) {
            throw new IllegalArgumentException("Version string cannot be null or empty");
        }
        Matcher matcher = SEMVER_PATTERN.matcher(version.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid semantic version format: " + version);
        }
        int major = Integer.parseInt(matcher.group(1));
        int minor = Integer.parseInt(matcher.group(2));
        int patch = Integer.parseInt(matcher.group(3));
        String preRelease = matcher.group(4);
        String metadata = matcher.group(5);
        return new SemVer(major, minor, patch, preRelease, metadata);
    }

    SemVer toReleaseVersion() {
        return new SemVer(this.major, this.minor, this.patch, null, null);
    }

    SemVer toSnapshotVersion() {
        if ("SNAPSHOT".equals(this.preRelease) && this.metadata == null) {
            return this;
        }
        return new SemVer(this.major, this.minor, this.patch, "SNAPSHOT", null);
    }

    SemVer next(Element element) {
        Objects.requireNonNull(element, "Element cannot be null");
        if (this.hasPreRelease() || this.hasMetadata()) {
            return this.toReleaseVersion();
        }
        switch (element.ordinal()) {
            case 0: {
                return new SemVer(this.major + 1, 0, 0, null, null);
            }
            case 1: {
                return new SemVer(this.major, this.minor + 1, 0, null, null);
            }
            case 2: {
                return new SemVer(this.major, this.minor, this.patch + 1, null, null);
            }
        }
        throw new IllegalArgumentException("Unknown element: " + (Object)((Object)element));
    }

    private boolean hasPreRelease() {
        return this.preRelease != null && !this.preRelease.isEmpty();
    }

    private boolean hasMetadata() {
        return this.metadata != null && !this.metadata.isEmpty();
    }

    int getMajor() {
        return this.major;
    }

    int getMinor() {
        return this.minor;
    }

    int getPatch() {
        return this.patch;
    }

    String getPreRelease() {
        return this.preRelease;
    }

    String getMetadata() {
        return this.metadata;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        if (this.preRelease != null && !this.preRelease.isEmpty()) {
            sb.append('-').append(this.preRelease);
        }
        if (this.metadata != null && !this.metadata.isEmpty()) {
            sb.append('+').append(this.metadata);
        }
        return sb.toString();
    }

    public static enum Element {
        MAJOR,
        MINOR,
        PATCH;

    }
}

