/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.report;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.apache.maven.surefire.report.SafeThrowable;
import org.apache.maven.surefire.report.SmartStackTraceParser;
import org.apache.maven.surefire.report.StackTraceWriter;

public class PojoStackTraceWriter
implements StackTraceWriter {
    private final Throwable t;
    private final String testClass;
    private final String testMethod;

    public PojoStackTraceWriter(String testClass, String testMethod, Throwable t) {
        this.testClass = testClass;
        this.testMethod = testMethod;
        this.t = t;
    }

    public String writeTraceToString() {
        if (this.t != null) {
            StringWriter w = new StringWriter();
            PrintWriter stackTrace = new PrintWriter(w);
            try {
                this.t.printStackTrace(stackTrace);
            }
            finally {
                stackTrace.close();
            }
            w.flush();
            StringBuffer builder = w.getBuffer();
            if (PojoStackTraceWriter.isMultiLineExceptionMessage(this.t)) {
                String exc = this.t.getClass().getName() + ": ";
                if (builder.toString().startsWith(exc)) {
                    builder.insert(exc.length(), '\n');
                }
            }
            return builder.toString();
        }
        return "";
    }

    public String smartTrimmedStackTrace() {
        return this.t == null ? "" : new SmartStackTraceParser(this.testClass, this.t, this.testMethod).getString();
    }

    public String writeTrimmedTraceToString() {
        return this.t == null ? "" : SmartStackTraceParser.stackTraceWithFocusOnClassAsString(this.t, this.testClass);
    }

    public SafeThrowable getThrowable() {
        return this.t == null ? null : new SafeThrowable(this.t);
    }

    private static boolean isMultiLineExceptionMessage(Throwable t) {
        String msg = t.getLocalizedMessage();
        if (msg != null) {
            int countNewLines = 0;
            int length = msg.length();
            for (int i = 0; i < length && (msg.charAt(i) != '\n' || ++countNewLines != 2); ++i) {
            }
            return countNewLines > 1 || countNewLines == 1 && !msg.trim().endsWith("\n");
        }
        return false;
    }
}

