/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import com.wordnik.swagger.annotations.ApiModelProperty;
import java.util.List;
import java.util.Set;
import javax.xml.bind.annotation.XmlType;
import org.apache.nifi.web.api.dto.ConnectableDTO;
import org.apache.nifi.web.api.dto.NiFiComponentDTO;
import org.apache.nifi.web.api.dto.PositionDTO;

@XmlType(name="connection")
public class ConnectionDTO
extends NiFiComponentDTO {
    private ConnectableDTO source;
    private ConnectableDTO destination;
    private String name;
    private Integer labelIndex;
    private Long zIndex;
    private Set<String> selectedRelationships;
    private Set<String> availableRelationships;
    private Long backPressureObjectThreshold;
    private String backPressureDataSizeThreshold;
    private String flowFileExpiration;
    private List<String> prioritizers;
    private List<PositionDTO> bends;

    @ApiModelProperty(value="The source of the connection.")
    public ConnectableDTO getSource() {
        return this.source;
    }

    public void setSource(ConnectableDTO source) {
        this.source = source;
    }

    @ApiModelProperty(value="The destination of the connection.")
    public ConnectableDTO getDestination() {
        return this.destination;
    }

    public void setDestination(ConnectableDTO destination) {
        this.destination = destination;
    }

    @ApiModelProperty(value="The name of the connection.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The bend points on the connection.")
    public List<PositionDTO> getBends() {
        return this.bends;
    }

    public void setBends(List<PositionDTO> bends) {
        this.bends = bends;
    }

    @ApiModelProperty(value="The index of the bend point where to place the connection label.")
    public Integer getLabelIndex() {
        return this.labelIndex;
    }

    public void setLabelIndex(Integer labelIndex) {
        this.labelIndex = labelIndex;
    }

    @ApiModelProperty(value="The z index of the connection.")
    public Long getzIndex() {
        return this.zIndex;
    }

    public void setzIndex(Long zIndex) {
        this.zIndex = zIndex;
    }

    @ApiModelProperty(value="The selected relationship that comprise the connection.")
    public Set<String> getSelectedRelationships() {
        return this.selectedRelationships;
    }

    public void setSelectedRelationships(Set<String> relationships) {
        this.selectedRelationships = relationships;
    }

    @ApiModelProperty(value="The relationships that the source of the connection currently supports. This property is read only.", readOnly=true)
    public Set<String> getAvailableRelationships() {
        return this.availableRelationships;
    }

    public void setAvailableRelationships(Set<String> availableRelationships) {
        this.availableRelationships = availableRelationships;
    }

    @ApiModelProperty(value="The object count threshold for determining when back pressure is applied. Updating this value is a passive change in the sense that it won't impact whether existing files over the limit are affected but it does help feeder processors to stop pushing too much into this work queue.")
    public Long getBackPressureObjectThreshold() {
        return this.backPressureObjectThreshold;
    }

    public void setBackPressureObjectThreshold(Long backPressureObjectThreshold) {
        this.backPressureObjectThreshold = backPressureObjectThreshold;
    }

    @ApiModelProperty(value="The object data size threshold for determining when back pressure is applied. Updating this value is a passive change in the sense that it won't impact whether existing files over the limit are affected but it does help feeder processors to stop pushing too much into this work queue.")
    public String getBackPressureDataSizeThreshold() {
        return this.backPressureDataSizeThreshold;
    }

    public void setBackPressureDataSizeThreshold(String backPressureDataSizeThreshold) {
        this.backPressureDataSizeThreshold = backPressureDataSizeThreshold;
    }

    @ApiModelProperty(value="The amount of time a flow file may be in the flow before it will be automatically aged out of the flow. Once a flow file reaches this age it will be terminated from the flow the next time a processor attempts to start work on it.")
    public String getFlowFileExpiration() {
        return this.flowFileExpiration;
    }

    public void setFlowFileExpiration(String flowFileExpiration) {
        this.flowFileExpiration = flowFileExpiration;
    }

    @ApiModelProperty(value="The comparators used to prioritize the queue.")
    public List<String> getPrioritizers() {
        return this.prioritizers;
    }

    public void setPrioritizers(List<String> prioritizers) {
        this.prioritizers = prioritizers;
    }

    public String toString() {
        return "ConnectionDTO [name: " + this.name + " from " + this.source + " to " + this.destination + "]";
    }
}

