/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.draw;

import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.dom.element.draw.DrawFrameElement;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.PresentationDocument;
import org.odftoolkit.simple.draw.Frame;
import org.odftoolkit.simple.draw.FrameContainer;
import org.odftoolkit.simple.draw.FrameRectangle;
import org.w3c.dom.Node;

public abstract class AbstractFrameContainer
implements FrameContainer {
    @Override
    public abstract OdfElement getFrameContainerElement();

    public Frame addFrame() {
        Frame frame = Frame.newFrame(this);
        return frame;
    }

    public Frame addFrame(FrameRectangle rectangle) {
        Frame frame = Frame.newFrame(this);
        frame.setRectangle(rectangle);
        return frame;
    }

    public Frame getFrameByName(String name) {
        if (name == null) {
            return null;
        }
        OdfElement container = this.getFrameContainerElement();
        DrawFrameElement element = (DrawFrameElement)OdfElement.findFirstChildNode(DrawFrameElement.class, (Node)container);
        while (element != null) {
            if (name.equals(element.getDrawNameAttribute())) {
                Frame frame = Frame.getInstanceof(element);
                frame.mFrameContainer = this;
                return frame;
            }
            element = (DrawFrameElement)OdfElement.findNextChildNode(DrawFrameElement.class, (Node)element);
        }
        return null;
    }

    public List<Frame> getFrameByPresentationclass(PresentationDocument.PresentationClass usage) {
        OdfElement container = this.getFrameContainerElement();
        Document doc = (Document)((OdfFileDom)container.getOwnerDocument()).getDocument();
        if (!(doc instanceof PresentationDocument)) {
            return null;
        }
        ArrayList<Frame> al = new ArrayList<Frame>();
        DrawFrameElement element = (DrawFrameElement)OdfElement.findFirstChildNode(DrawFrameElement.class, (Node)container);
        while (element != null) {
            if (usage.toString().equals(element.getPresentationClassAttribute())) {
                Frame frame = Frame.getInstanceof(element);
                frame.mFrameContainer = this;
                al.add(frame);
            }
            element = (DrawFrameElement)OdfElement.findNextChildNode(DrawFrameElement.class, (Node)element);
        }
        return al;
    }
}

