/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.Basic;
import javax.persistence.ElementCollection;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PostLoad;
import javax.persistence.PostPersist;
import javax.persistence.PostRemove;
import javax.persistence.PostUpdate;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.enhance.Reflection;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.AbstractMetaDataDefaults;
import org.apache.openjpa.meta.AccessCode;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.JavaTypes;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.meta.ValueMetaData;
import org.apache.openjpa.persistence.DetachedState;
import org.apache.openjpa.persistence.PersistenceStrategy;
import org.apache.openjpa.persistence.Persistent;
import org.apache.openjpa.persistence.PersistentCollection;
import org.apache.openjpa.persistence.PersistentMap;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.UserException;

public class PersistenceMetaDataDefaults
extends AbstractMetaDataDefaults {
    private static final Localizer _loc = Localizer.forPackage(PersistenceMetaDataDefaults.class);
    private static final Map<Class<?>, PersistenceStrategy> _strats = new HashMap();
    private static final Set<String> _ignoredAnnos = new HashSet<String>();
    protected AccessFilter propertyAccessFilter = new AccessFilter(AccessType.PROPERTY);
    protected AccessFilter fieldAccessFilter = new AccessFilter(AccessType.FIELD);
    protected MemberFilter fieldFilter = new MemberFilter(Field.class);
    protected MemberFilter methodFilter = new MemberFilter(Method.class);
    protected TransientFilter nonTransientFilter = new TransientFilter(false);
    protected AnnotatedFilter annotatedFilter = new AnnotatedFilter();
    protected GetterFilter getterFilter = new GetterFilter();
    protected SetterFilter setterFilter = new SetterFilter();
    private Boolean _isAbstractMappingUniDirectional = null;
    private Boolean _isNonDefaultMappingAllowed = null;

    public PersistenceMetaDataDefaults() {
        this.setCallbackMode(50);
        this.setDataStoreObjectIdFieldUnwrapped(true);
    }

    public static PersistenceStrategy getPersistenceStrategy(FieldMetaData fmd, Member member) {
        return PersistenceMetaDataDefaults.getPersistenceStrategy(fmd, member, false);
    }

    public static PersistenceStrategy getPersistenceStrategy(FieldMetaData fmd, Member member, boolean ignoreTransient) {
        int code;
        Class<?> type;
        if (member == null) {
            return null;
        }
        AnnotatedElement el = (AnnotatedElement)((Object)member);
        if (!ignoreTransient && ((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)el, Transient.class))).booleanValue()) {
            return PersistenceStrategy.TRANSIENT;
        }
        if (fmd != null && fmd.getManagement() != 3) {
            return null;
        }
        PersistenceStrategy pstrat = null;
        for (Annotation anno : el.getDeclaredAnnotations()) {
            if (pstrat != null && _strats.containsKey(anno.annotationType())) {
                throw new MetaDataException(_loc.get("already-pers", (Object)member));
            }
            if (pstrat != null) continue;
            pstrat = _strats.get(anno.annotationType());
        }
        if (pstrat != null) {
            return pstrat;
        }
        if (fmd != null) {
            type = fmd.getType();
            code = fmd.getTypeCode();
        } else if (member instanceof Field) {
            type = ((Field)member).getType();
            code = JavaTypes.getTypeCode(type);
        } else {
            type = ((Method)member).getReturnType();
            code = JavaTypes.getTypeCode(type);
        }
        switch (code) {
            case 11: {
                if (type != byte[].class && type != char[].class && type != Byte[].class && type != Character[].class) break;
                return PersistenceStrategy.BASIC;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 9: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return PersistenceStrategy.BASIC;
            }
            case 8: {
                if (!Enum.class.isAssignableFrom(type)) break;
                return PersistenceStrategy.BASIC;
            }
        }
        if (((Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction(type, Embeddable.class))).booleanValue()) {
            return PersistenceStrategy.EMBEDDED;
        }
        if (Serializable.class.isAssignableFrom(type)) {
            return PersistenceStrategy.BASIC;
        }
        return null;
    }

    public void setDefaultAccessType(String type) {
        if ("PROPERTY".equals(type.toUpperCase())) {
            this.setDefaultAccessType(AccessCode.PROPERTY);
        } else if ("FIELD".equals(type.toUpperCase())) {
            this.setDefaultAccessType(AccessCode.FIELD);
        } else {
            throw new IllegalArgumentException(_loc.get("access-invalid", (Object)type).toString());
        }
    }

    public void populate(ClassMetaData meta, int access) {
        this.populate(meta, access, false);
    }

    public void populate(ClassMetaData meta, int access, boolean ignoreTransient) {
        if (AccessCode.isUnknown((int)access)) {
            access = this.determineAccessType(meta);
        }
        if (AccessCode.isUnknown((int)access)) {
            this.error(meta, _loc.get("access-unknown", (Object)meta));
        }
        super.populate(meta, access, ignoreTransient);
        meta.setDetachable(true);
    }

    protected void populate(FieldMetaData fmd) {
        PersistenceMetaDataDefaults.setCascadeNone((ValueMetaData)fmd);
        PersistenceMetaDataDefaults.setCascadeNone(fmd.getKey());
        PersistenceMetaDataDefaults.setCascadeNone(fmd.getElement());
    }

    static void setCascadeNone(ValueMetaData vmd) {
        vmd.setCascadePersist(0);
        vmd.setCascadeRefresh(0);
        vmd.setCascadeAttach(0);
        vmd.setCascadeDetach(0);
    }

    ClassMetaData getCachedSuperclassMetaData(ClassMetaData meta) {
        if (meta == null) {
            return null;
        }
        Class cls = meta.getDescribedType();
        Class sup = cls.getSuperclass();
        if (sup == null || "java.lang.Object".equals(sup.getName())) {
            return null;
        }
        MetaDataRepository repos = meta.getRepository();
        ClassMetaData supMeta = repos.getCachedMetaData(sup);
        if (supMeta == null) {
            supMeta = repos.getMetaData(sup, null, false);
        }
        return supMeta;
    }

    private int determineAccessType(ClassMetaData meta) {
        ClassMetaData sup;
        if (meta == null) {
            return AccessCode.UNKNOWN;
        }
        if (meta.getDescribedType().isInterface()) {
            return AccessCode.PROPERTY;
        }
        if (!AccessCode.isUnknown((ClassMetaData)meta)) {
            return meta.getAccessType();
        }
        int access = this.determineExplicitAccessType(meta.getDescribedType());
        if (!AccessCode.isUnknown((int)access)) {
            return access;
        }
        access = this.determineImplicitAccessType(meta.getDescribedType(), meta.getRepository().getConfiguration());
        if (!AccessCode.isUnknown((int)access)) {
            return access;
        }
        ClassMetaData tmpSup = sup = this.getCachedSuperclassMetaData(meta);
        while (tmpSup != null && tmpSup.isExplicitAccess()) {
            if ((tmpSup = this.getCachedSuperclassMetaData(tmpSup)) == null) continue;
            sup = tmpSup;
        }
        if (sup != null && !AccessCode.isUnknown((ClassMetaData)sup)) {
            return sup.getAccessType();
        }
        this.trace(meta, _loc.get("access-default", (Object)meta, (Object)AccessCode.toClassString((int)this.getDefaultAccessType())));
        return this.getDefaultAccessType();
    }

    private int determineImplicitAccessType(Class<?> cls, OpenJPAConfiguration conf) {
        boolean mixed;
        if (cls.isInterface()) {
            return AccessCode.PROPERTY;
        }
        AnnotatedElement[] allFields = (Field[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldsAction(cls));
        AnnotatedElement[] methods = (Method[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction(cls));
        List<Field> fields = this.filter(allFields, new InclusiveFilter[]{new TransientFilter(true)});
        this.getterFilter.setIncludePrivate(conf.getCompatibilityInstance().getPrivatePersistentProperties());
        List<Method> getters = this.filter(methods, new InclusiveFilter[]{this.getterFilter});
        if (fields.isEmpty() && getters.isEmpty()) {
            return AccessCode.EMPTY;
        }
        fields = this.filter(fields, this.annotatedFilter);
        getters = this.filter(getters, this.annotatedFilter);
        List setters = this.filter(methods, new InclusiveFilter[]{this.setterFilter});
        getters = this.matchGetterAndSetter(getters, setters);
        boolean bl = mixed = !fields.isEmpty() && !getters.isEmpty();
        if (mixed) {
            throw new UserException(_loc.get("access-mixed", cls, (Object)this.toFieldNames(fields), (Object)this.toMethodNames(getters)));
        }
        if (!fields.isEmpty()) {
            return AccessCode.FIELD;
        }
        if (!getters.isEmpty()) {
            return AccessCode.PROPERTY;
        }
        return AccessCode.UNKNOWN;
    }

    private int determineExplicitAccessType(Class<?> cls) {
        Access access = cls.getAnnotation(Access.class);
        return access == null ? AccessCode.UNKNOWN : (access.value() == AccessType.FIELD ? AccessCode.FIELD : AccessCode.PROPERTY) | AccessCode.EXPLICIT;
    }

    private List<Method> matchGetterAndSetter(List<Method> getters, List<Method> setters) {
        ArrayList<Method> unmatched = new ArrayList<Method>();
        for (Method getter : getters) {
            String getterName = getter.getName();
            Class<?> getterReturnType = getter.getReturnType();
            String expectedSetterName = "set" + getterName.substring((PersistenceMetaDataDefaults.isBooleanGetter((Method)getter) ? "is" : "get").length());
            boolean matched = false;
            for (Method setter : setters) {
                Class<?> setterArgType = setter.getParameterTypes()[0];
                String actualSetterName = setter.getName();
                matched = actualSetterName.equals(expectedSetterName) && setterArgType == getterReturnType;
                if (!matched) continue;
                break;
            }
            if (matched) continue;
            unmatched.add(getter);
        }
        getters.removeAll(unmatched);
        return getters;
    }

    List<Field> getPersistentFields(ClassMetaData meta, boolean ignoreTransient) {
        boolean explicit = meta.isExplicitAccess();
        boolean unknown = AccessCode.isUnknown((ClassMetaData)meta);
        boolean isField = AccessCode.isField((ClassMetaData)meta);
        if (explicit || unknown || isField) {
            AnnotatedElement[] fields = (Field[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredFieldsAction((Class)meta.getDescribedType()));
            InclusiveFilter[] inclusiveFilterArray = new InclusiveFilter[4];
            inclusiveFilterArray[0] = this.fieldFilter;
            inclusiveFilterArray[1] = ignoreTransient ? null : this.nonTransientFilter;
            InclusiveFilter<AnnotatedElement> inclusiveFilter = inclusiveFilterArray[2] = unknown || isField ? null : this.annotatedFilter;
            inclusiveFilterArray[3] = explicit ? (isField ? null : this.fieldAccessFilter) : null;
            return this.filter(fields, inclusiveFilterArray);
        }
        return Collections.EMPTY_LIST;
    }

    List<Method> getPersistentMethods(ClassMetaData meta, boolean ignoreTransient) {
        boolean explicit = meta.isExplicitAccess();
        boolean unknown = AccessCode.isUnknown((int)meta.getAccessType());
        boolean isProperty = AccessCode.isProperty((int)meta.getAccessType());
        if (explicit || unknown || isProperty) {
            AnnotatedElement[] publicMethods = (Method[])AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction((Class)meta.getDescribedType()));
            this.getterFilter.setIncludePrivate(meta.getRepository().getConfiguration().getCompatibilityInstance().getPrivatePersistentProperties());
            InclusiveFilter[] inclusiveFilterArray = new InclusiveFilter[5];
            inclusiveFilterArray[0] = this.methodFilter;
            inclusiveFilterArray[1] = this.getterFilter;
            inclusiveFilterArray[2] = ignoreTransient ? null : this.nonTransientFilter;
            InclusiveFilter<AnnotatedElement> inclusiveFilter = inclusiveFilterArray[3] = unknown || isProperty ? null : this.annotatedFilter;
            inclusiveFilterArray[4] = explicit ? (isProperty ? null : this.propertyAccessFilter) : null;
            List<Method> getters = this.filter(publicMethods, inclusiveFilterArray);
            List setters = this.filter(publicMethods, new InclusiveFilter[]{this.setterFilter});
            getters = this.matchGetterAndSetter(getters, setters);
            return getters;
        }
        return Collections.EMPTY_LIST;
    }

    public List<Member> getPersistentMembers(ClassMetaData meta, boolean ignoreTransient) {
        ArrayList<Member> members = new ArrayList<Member>();
        List<Field> fields = this.getPersistentFields(meta, ignoreTransient);
        List<Method> getters = this.getPersistentMethods(meta, ignoreTransient);
        boolean isMixed = !fields.isEmpty() && !getters.isEmpty();
        boolean isEmpty = fields.isEmpty() && getters.isEmpty();
        boolean explicit = meta.isExplicitAccess();
        boolean unknown = AccessCode.isUnknown((int)meta.getAccessType());
        if (isEmpty) {
            this.warn(meta, _loc.get("access-empty", (Object)meta));
            return Collections.EMPTY_LIST;
        }
        if (explicit) {
            if (isMixed) {
                this.assertNoDuplicate(fields, getters);
                meta.setAccessType(AccessCode.MIXED | meta.getAccessType());
                members.addAll(fields);
                members.addAll(getters);
            } else {
                members.addAll(fields.isEmpty() ? getters : fields);
            }
        } else {
            if (isMixed) {
                this.error(meta, _loc.get("access-mixed", (Object)meta, fields, getters));
            }
            if (fields.isEmpty()) {
                meta.setAccessType(AccessCode.PROPERTY);
                members.addAll(getters);
            } else {
                meta.setAccessType(AccessCode.FIELD);
                members.addAll(fields);
            }
        }
        return members;
    }

    void assertNoDuplicate(List<Field> fields, List<Method> getters) {
    }

    void error(ClassMetaData meta, Localizer.Message message) {
        Log log = meta.getRepository().getConfiguration().getLog("openjpa.Runtime");
        log.error((Object)message.toString());
        throw new UserException(message.toString());
    }

    void warn(ClassMetaData meta, Localizer.Message message) {
        Log log = meta.getRepository().getConfiguration().getLog("openjpa.Runtime");
        log.warn((Object)message.toString());
    }

    void trace(ClassMetaData meta, Localizer.Message message) {
        Log log = meta.getRepository().getConfiguration().getLog("openjpa.Runtime");
        log.trace((Object)message.toString());
    }

    protected List<String> getFieldAccessNames(ClassMetaData meta) {
        return PersistenceMetaDataDefaults.toNames(this.getPersistentFields(meta, false));
    }

    protected List<String> getPropertyAccessNames(ClassMetaData meta) {
        return PersistenceMetaDataDefaults.toNames(this.getPersistentMethods(meta, false));
    }

    protected boolean isDefaultPersistent(ClassMetaData meta, Member member, String name) {
        return this.isDefaultPersistent(meta, member, name, false);
    }

    protected boolean isDefaultPersistent(ClassMetaData meta, Member member, String name, boolean ignoreTransient) {
        PersistenceStrategy strat;
        int mods = member.getModifiers();
        if (Modifier.isTransient(mods)) {
            return false;
        }
        int access = meta.getAccessType();
        if (member instanceof Field) {
            if (AccessCode.isProperty((int)access) && !this.isAnnotatedAccess(member, AccessType.FIELD)) {
                return false;
            }
        } else if (member instanceof Method) {
            if (AccessCode.isField((int)access) && !this.isAnnotatedAccess(member, AccessType.PROPERTY)) {
                return false;
            }
            try {
                Method setter = (Method)AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodAction((Class)meta.getDescribedType(), (String)("set" + StringUtils.capitalize((String)name)), (Class[])new Class[]{((Method)member).getReturnType()}));
                if (setter == null && !this.isAnnotatedTransient(member)) {
                    this.logNoSetter(meta, name, null);
                    return false;
                }
            }
            catch (Exception e) {
                if (!this.isAnnotatedTransient(member)) {
                    this.logNoSetter(meta, name, e);
                }
                return false;
            }
        }
        if ((strat = PersistenceMetaDataDefaults.getPersistenceStrategy(null, member, ignoreTransient)) == null) {
            this.warn(meta, _loc.get("no-pers-strat", (Object)name));
            return false;
        }
        return strat != PersistenceStrategy.TRANSIENT;
    }

    private boolean isAnnotatedTransient(Member member) {
        return member instanceof AnnotatedElement && (Boolean)AccessController.doPrivileged(J2DoPrivHelper.isAnnotationPresentAction((AnnotatedElement)((AnnotatedElement)((Object)member)), Transient.class)) != false;
    }

    private boolean isAnnotatedAccess(Member member, AccessType type) {
        if (member == null) {
            return false;
        }
        Access anno = (Access)AccessController.doPrivileged(J2DoPrivHelper.getAnnotationAction((AnnotatedElement)((AnnotatedElement)((Object)member)), Access.class));
        return anno != null && anno.value() == type;
    }

    private boolean isAnnotated(Member member) {
        return member != null && member instanceof AnnotatedElement && this.annotatedFilter.includes((AnnotatedElement)((Object)member));
    }

    private boolean isNotTransient(Member member) {
        return member != null && member instanceof AnnotatedElement && this.nonTransientFilter.includes((AnnotatedElement)((Object)member));
    }

    public Member getMemberByProperty(ClassMetaData meta, String property, int access, boolean applyDefaultRule) {
        int accessCode;
        Class cls = meta.getDescribedType();
        Field field = Reflection.findField((Class)cls, (String)property, (boolean)false);
        Method getter = Reflection.findGetter((Class)cls, (String)property, (boolean)false);
        Method setter = Reflection.findSetter((Class)cls, (String)property, (boolean)false);
        int n = accessCode = AccessCode.isUnknown((int)access) ? meta.getAccessType() : access;
        if (field == null && getter == null) {
            this.error(meta, _loc.get("access-no-property", (Object)cls, (Object)property));
        }
        if (this.isNotTransient(getter) && this.isAnnotated(getter) && this.isNotTransient(field) && this.isAnnotated(field)) {
            throw new IllegalStateException(_loc.get("access-duplicate", (Object)field, (Object)getter).toString());
        }
        if (AccessCode.isField((int)accessCode)) {
            if (this.isAnnotatedAccess(getter, AccessType.PROPERTY)) {
                meta.setAccessType(AccessCode.MIXED | meta.getAccessType());
                return getter;
            }
            return (Member)((Object)(field == null ? getter : field));
        }
        if (AccessCode.isProperty((int)accessCode)) {
            if (this.isAnnotatedAccess(field, AccessType.FIELD)) {
                meta.setAccessType(AccessCode.MIXED | meta.getAccessType());
                return field;
            }
            return (Member)((Object)(getter == null ? field : getter));
        }
        if (AccessCode.isUnknown((int)accessCode)) {
            if (this.isAnnotated(field)) {
                meta.setAccessType(AccessCode.FIELD);
                return field;
            }
            if (this.isAnnotated(getter)) {
                meta.setAccessType(AccessCode.PROPERTY);
                return getter;
            }
            this.warn(meta, _loc.get("access-none", (Object)meta, (Object)property));
            throw new IllegalStateException(_loc.get("access-none", (Object)meta, (Object)property).toString());
        }
        throw new InternalException(meta + " " + AccessCode.toClassString((int)meta.getAccessType()));
    }

    <T extends AnnotatedElement> List<T> filter(T[] array, InclusiveFilter ... filters) {
        ArrayList<T> result = new ArrayList<T>();
        for (T e : array) {
            boolean include = true;
            for (InclusiveFilter f : filters) {
                if (f == null || f.includes(e)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            result.add(e);
        }
        return result;
    }

    <T extends AnnotatedElement> List<T> filter(List<T> list, InclusiveFilter ... filters) {
        ArrayList<AnnotatedElement> result = new ArrayList<AnnotatedElement>();
        for (AnnotatedElement e : list) {
            boolean include = true;
            for (InclusiveFilter f : filters) {
                if (f == null || f.includes(e)) continue;
                include = false;
                break;
            }
            if (!include) continue;
            result.add(e);
        }
        return result;
    }

    private void logNoSetter(ClassMetaData meta, String name, Exception e) {
        Log log = meta.getRepository().getConfiguration().getLog("openjpa.MetaData");
        if (log.isWarnEnabled()) {
            log.warn((Object)_loc.get("no-setter-for-getter", (Object)name, (Object)meta.getDescribedType().getName()));
        } else if (log.isTraceEnabled()) {
            log.warn((Object)_loc.get("no-setter-for-getter", (Object)name, (Object)meta.getDescribedType().getName()), (Throwable)e);
        }
    }

    private Log getLog(ClassMetaData meta) {
        return meta.getRepository().getConfiguration().getLog("openjpa.MetaData");
    }

    String toFieldNames(List<Field> fields) {
        return fields.toString();
    }

    String toMethodNames(List<Method> methods) {
        return methods.toString();
    }

    public boolean isAbstractMappingUniDirectional(OpenJPAConfiguration conf) {
        if (this._isAbstractMappingUniDirectional == null) {
            this.setAbstractMappingUniDirectional(conf);
        }
        return this._isAbstractMappingUniDirectional;
    }

    public void setAbstractMappingUniDirectional(OpenJPAConfiguration conf) {
        this._isAbstractMappingUniDirectional = conf.getCompatibilityInstance().isAbstractMappingUniDirectional();
    }

    public boolean isNonDefaultMappingAllowed(OpenJPAConfiguration conf) {
        if (this._isNonDefaultMappingAllowed == null) {
            this.setNonDefaultMappingAllowed(conf);
        }
        return this._isNonDefaultMappingAllowed;
    }

    public void setNonDefaultMappingAllowed(OpenJPAConfiguration conf) {
        this._isNonDefaultMappingAllowed = conf.getCompatibilityInstance().isNonDefaultMappingAllowed();
    }

    static {
        _strats.put(Basic.class, PersistenceStrategy.BASIC);
        _strats.put(ManyToOne.class, PersistenceStrategy.MANY_ONE);
        _strats.put(OneToOne.class, PersistenceStrategy.ONE_ONE);
        _strats.put(Embedded.class, PersistenceStrategy.EMBEDDED);
        _strats.put(EmbeddedId.class, PersistenceStrategy.EMBEDDED);
        _strats.put(OneToMany.class, PersistenceStrategy.ONE_MANY);
        _strats.put(ManyToMany.class, PersistenceStrategy.MANY_MANY);
        _strats.put(Persistent.class, PersistenceStrategy.PERS);
        _strats.put(PersistentCollection.class, PersistenceStrategy.PERS_COLL);
        _strats.put(ElementCollection.class, PersistenceStrategy.ELEM_COLL);
        _strats.put(PersistentMap.class, PersistenceStrategy.PERS_MAP);
        _ignoredAnnos.add(DetachedState.class.getName());
        _ignoredAnnos.add(PostLoad.class.getName());
        _ignoredAnnos.add(PostPersist.class.getName());
        _ignoredAnnos.add(PostRemove.class.getName());
        _ignoredAnnos.add(PostUpdate.class.getName());
        _ignoredAnnos.add(PrePersist.class.getName());
        _ignoredAnnos.add(PreRemove.class.getName());
        _ignoredAnnos.add(PreUpdate.class.getName());
    }

    static class AnnotatedFilter
    implements InclusiveFilter<AnnotatedElement> {
        AnnotatedFilter() {
        }

        @Override
        public boolean includes(AnnotatedElement obj) {
            Annotation[] annos;
            for (Annotation anno : annos = (Annotation[])AccessController.doPrivileged(J2DoPrivHelper.getAnnotationsAction((AnnotatedElement)obj))) {
                String name = anno.annotationType().getName();
                if (!name.startsWith("javax.persistence.") && !name.startsWith("org.apache.openjpa.persistence.") || _ignoredAnnos.contains(name)) continue;
                return true;
            }
            return false;
        }
    }

    static class TransientFilter
    implements InclusiveFilter<AnnotatedElement> {
        final boolean modifierOnly;

        public TransientFilter(boolean modOnly) {
            this.modifierOnly = modOnly;
        }

        @Override
        public boolean includes(AnnotatedElement obj) {
            if (this.modifierOnly) {
                return !Modifier.isTransient(((Member)((Object)obj)).getModifiers());
            }
            return !obj.isAnnotationPresent(Transient.class) && !Modifier.isTransient(((Member)((Object)obj)).getModifiers());
        }
    }

    static class MemberFilter
    implements InclusiveFilter<AnnotatedElement> {
        final Class<?> target;

        public MemberFilter(Class<?> target) {
            this.target = target;
        }

        @Override
        public boolean includes(AnnotatedElement obj) {
            int mods = ((Member)((Object)obj)).getModifiers();
            return obj.getClass() == this.target && !Modifier.isStatic(mods) && !Modifier.isFinal(mods) && !Modifier.isTransient(mods) && !Modifier.isNative(mods);
        }
    }

    static class AccessFilter
    implements InclusiveFilter<AnnotatedElement> {
        final AccessType target;

        public AccessFilter(AccessType target) {
            this.target = target;
        }

        @Override
        public boolean includes(AnnotatedElement obj) {
            Access access = obj.getAnnotation(Access.class);
            return access != null && access.value().equals((Object)this.target);
        }
    }

    static class SetterFilter
    implements InclusiveFilter<Method> {
        SetterFilter() {
        }

        @Override
        public boolean includes(Method method) {
            return SetterFilter.isSetter(method);
        }

        public static boolean isSetter(Method method) {
            String methodName = method.getName();
            return AbstractMetaDataDefaults.startsWith((String)methodName, (String)"set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
        }
    }

    static class GetterFilter
    implements InclusiveFilter<Method> {
        private boolean includePrivate;

        GetterFilter() {
        }

        @Override
        public boolean includes(Method method) {
            return AbstractMetaDataDefaults.isGetter((Method)method, (boolean)this.isIncludePrivate());
        }

        public void setIncludePrivate(boolean includePrivate) {
            this.includePrivate = includePrivate;
        }

        public boolean isIncludePrivate() {
            return this.includePrivate;
        }
    }

    private static interface InclusiveFilter<T extends AnnotatedElement> {
        public boolean includes(T var1);
    }
}

