/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config.inheritance;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Set;
import javax.enterprise.context.NormalScope;
import javax.enterprise.inject.Stereotype;
import javax.inject.Qualifier;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.inheritance.AbstractBeanInheritedMetaData;
import org.apache.webbeans.util.AnnotationUtil;

public class BeanInheritedMetaData<T>
extends AbstractBeanInheritedMetaData<T> {
    public BeanInheritedMetaData(AbstractOwbBean<T> component) {
        super(component, component.getReturnType().getSuperclass());
    }

    @Override
    protected void setInheritedQualifiers() {
        if (this.inheritedClazz != null && this.inheritedClazz != Object.class) {
            this.setInheritedTypes(this.getInheritedQualifiers(), this.inheritedClazz, Qualifier.class);
        }
    }

    @Override
    protected void setInheritedInterceptorBindings() {
        if (this.inheritedClazz != null && this.inheritedClazz != Object.class) {
            this.setInheritedTypes(this.getInheritedInterceptorBindings(), this.inheritedClazz, InterceptorBinding.class);
        }
    }

    @Override
    protected void setInheritedScopeType() {
        if (this.inheritedClazz != null && this.inheritedClazz != Object.class) {
            this.setInheritedType(this.inheritedClazz, NormalScope.class);
            this.setInheritedType(this.inheritedClazz, Scope.class);
        }
    }

    @Override
    protected void setInheritedStereoTypes() {
        if (this.inheritedClazz != null && this.inheritedClazz != Object.class) {
            this.setInheritedTypes(this.getInheritedStereoTypes(), this.inheritedClazz, Stereotype.class);
        }
    }

    private void setInheritedType(Class<?> inheritedClass, Class<? extends Annotation> annotationType) {
        Annotation[] inheritedAnnotations = null;
        if (inheritedClass != null) {
            inheritedAnnotations = AnnotationUtil.getMetaAnnotations(inheritedClass.getDeclaredAnnotations(), annotationType);
        }
        if (inheritedAnnotations != null && inheritedAnnotations.length > 0) {
            if (inheritedAnnotations[0].annotationType().isAnnotationPresent(Inherited.class)) {
                Annotation annotation = inheritedAnnotations[0];
                if (annotationType.equals(NormalScope.class) || annotationType.equals(Scope.class)) {
                    this.inheritedScopeType = annotation;
                }
            }
        } else if (this.hasSuperType(inheritedClass)) {
            this.setInheritedType(inheritedClass.getSuperclass(), annotationType);
        }
    }

    private void setInheritedTypes(Set<Annotation> types, Class<?> inheritedClass, Class<? extends Annotation> annotationType) {
        Annotation[] annotations = null;
        if (inheritedClass != null) {
            annotations = AnnotationUtil.getMetaAnnotations(inheritedClass.getDeclaredAnnotations(), annotationType);
        }
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (types.contains(annotation) || !AnnotationUtil.hasClassAnnotation(annotation.annotationType(), Inherited.class)) continue;
                types.add(annotation);
            }
        }
        if (this.hasSuperType(inheritedClass)) {
            this.setInheritedTypes(types, inheritedClass.getSuperclass(), annotationType);
        }
    }

    private boolean hasSuperType(Class<?> clazz) {
        return clazz.getSuperclass() != Object.class;
    }
}

