/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;

public final class DecoratorResolverRules {
    private DecoratorResolverRules() {
        throw new UnsupportedOperationException();
    }

    public static boolean compareType(Type delegateType, Type beanType) {
        Asserts.assertNotNull(delegateType, "delegateType parameter is null");
        Asserts.assertNotNull(beanType, "beanType parameter is null");
        if (delegateType instanceof ParameterizedType && beanType instanceof Class) {
            return DecoratorResolverRules.beanIsRawAndDelegateIsParametrized(delegateType, beanType);
        }
        if (delegateType instanceof ParameterizedType && beanType instanceof ParameterizedType) {
            return DecoratorResolverRules.beanIsParametrizedAndDelegateIsParametrized((ParameterizedType)delegateType, (ParameterizedType)beanType);
        }
        if (beanType instanceof Class && delegateType instanceof Class) {
            Class clzDelType = (Class)delegateType;
            Class clzBeanType = (Class)beanType;
            return clzDelType == clzBeanType;
        }
        return false;
    }

    private static boolean recursiveCheckOnParametrizedTypeActualTypeArguments(Type[] delegateTypeArgs, Type[] beanTypeArgs) {
        Type delegateTypeArg = null;
        Type beanTypeArg = null;
        for (int i = 0; i < delegateTypeArgs.length; ++i) {
            delegateTypeArg = delegateTypeArgs[i];
            beanTypeArg = beanTypeArgs[i];
            if (ClassUtil.isParametrizedType(delegateTypeArg) && ClassUtil.isParametrizedType(beanTypeArg)) {
                return DecoratorResolverRules.beanIsParametrizedAndDelegateIsParametrized((ParameterizedType)delegateTypeArg, (ParameterizedType)beanTypeArg);
            }
            if (ClassUtil.isWildCardType(delegateTypeArg)) {
                return ClassUtil.checkRequiredTypeisWildCard(beanTypeArg, delegateTypeArg);
            }
            if (ClassUtil.isTypeVariable(delegateTypeArg) && ClassUtil.isTypeVariable(beanTypeArg)) {
                return ClassUtil.checkBeanTypeAndRequiredIsTypeVariable(delegateTypeArg, beanTypeArg);
            }
            if (beanTypeArg instanceof Class && ClassUtil.isTypeVariable(delegateTypeArg)) {
                return ClassUtil.checkRequiredTypeIsTypeVariableAndBeanTypeIsClass(beanTypeArg, delegateTypeArg);
            }
            if (beanTypeArg instanceof Class && delegateTypeArg instanceof Class) {
                if (beanTypeArg != delegateTypeArg) continue;
                return true;
            }
            if (!(delegateTypeArg instanceof Class) || !ClassUtil.isTypeVariable(beanTypeArg)) continue;
            return ClassUtil.checkRequiredTypeIsTypeVariableAndBeanTypeIsClass(delegateTypeArg, beanTypeArg);
        }
        return false;
    }

    private static boolean beanIsParametrizedAndDelegateIsParametrized(ParameterizedType delegateType, ParameterizedType beanType) {
        Class beanRawType;
        Class delegateRawType = (Class)delegateType.getRawType();
        if (delegateRawType == (beanRawType = (Class)beanType.getRawType())) {
            Type[] delegateTypeArgs = delegateType.getActualTypeArguments();
            Type[] beanTypeArgs = beanType.getActualTypeArguments();
            if (beanTypeArgs.length != delegateTypeArgs.length) {
                return false;
            }
            return DecoratorResolverRules.recursiveCheckOnParametrizedTypeActualTypeArguments(delegateTypeArgs, beanTypeArgs);
        }
        return false;
    }

    private static boolean beanIsRawAndDelegateIsParametrized(Type delegateType, Type beanType) {
        Class clazzReqType;
        boolean ok = true;
        ParameterizedType ptDelegate = (ParameterizedType)delegateType;
        Class clazzDelegateType = (Class)ptDelegate.getRawType();
        if (clazzDelegateType == (clazzReqType = (Class)beanType)) {
            Type[] parametrizedTypeArgs;
            for (Type actual : parametrizedTypeArgs = ptDelegate.getActualTypeArguments()) {
                if (ClassUtil.isUnboundedTypeVariable(actual)) continue;
                if (actual instanceof Class) {
                    Class clazz = (Class)actual;
                    if (clazz.equals(Object.class)) continue;
                    ok = false;
                } else {
                    ok = false;
                }
                break;
            }
        } else {
            ok = false;
        }
        return ok;
    }
}

