/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.decorator.Decorator;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.Asserts;

public class DecoratorsManager {
    private List<Class<?>> enabledDecorators = new CopyOnWriteArrayList();

    public static DecoratorsManager getInstance() {
        DecoratorsManager instance = (DecoratorsManager)WebBeansFinder.getSingletonInstance(DecoratorsManager.class.getName());
        return instance;
    }

    public void addNewDecorator(Class<?> decoratorClazz) {
        Asserts.assertNotNull(decoratorClazz, "decoratorClazz parameter can not be emtpy");
        if (!this.enabledDecorators.contains(decoratorClazz)) {
            this.enabledDecorators.add(decoratorClazz);
        }
    }

    public int compare(Class<?> src, Class<?> target) {
        Asserts.assertNotNull(src, "src parameter can not be  null");
        Asserts.assertNotNull(target, "target parameter can not be null");
        int srcIndex = this.enabledDecorators.indexOf(src);
        int targetIndex = this.enabledDecorators.indexOf(target);
        if (srcIndex == -1 || targetIndex == -1) {
            throw new IllegalArgumentException("One of the compare class of the list : [" + src.getName() + "," + target.getName() + "]" + " is not contained in the enabled decorators list!");
        }
        if (srcIndex == targetIndex) {
            return 0;
        }
        if (srcIndex < targetIndex) {
            return -1;
        }
        return 1;
    }

    public boolean isDecoratorEnabled(Class<?> decoratorClazz) {
        Asserts.nullCheckForClass(decoratorClazz, "decoratorClazz can not be null");
        return this.enabledDecorators.contains(decoratorClazz);
    }

    public void validateDecoratorClasses() {
        for (Class<?> decoratorClazz : this.enabledDecorators) {
            if (decoratorClazz.isAnnotationPresent(Decorator.class) || BeanManagerImpl.getManager().containsCustomDecoratorClass(decoratorClazz)) continue;
            throw new WebBeansConfigurationException("Given class : " + decoratorClazz + " is not a decorator class");
        }
    }
}

