/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.Asserts;

public final class JNDIUtil {
    private static InitialContext initialContext = null;
    private static final WebBeansLogger LOGGER = WebBeansLogger.getLogger(JNDIUtil.class);

    private JNDIUtil() {
    }

    public static InitialContext getInitialContext() {
        return initialContext;
    }

    public static void bind(String name, Object object) {
        Asserts.assertNotNull(name, "name parameter can not be null");
        Asserts.assertNotNull(object, "object parameter can not be null");
        try {
            Context context = initialContext;
            String[] parts = name.split("/");
            for (int i = 0; i < parts.length - 1; ++i) {
                try {
                    context = (Context)initialContext.lookup(parts[i]);
                    continue;
                }
                catch (NameNotFoundException e) {
                    context = initialContext.createSubcontext(parts[i]);
                }
            }
            context.bind(parts[parts.length - 1], object);
        }
        catch (NamingException e) {
            LOGGER.error("ERROR_0005", e, name);
        }
    }

    public static void unbind(String name) {
        Asserts.assertNotNull(name, "name parameter can not be null");
        try {
            initialContext.unbind(name);
        }
        catch (NamingException e) {
            LOGGER.error(e);
            throw new WebBeansException(LOGGER.getTokenString("EXCEPT_0009") + name, e);
        }
    }

    public static <T> T lookup(String name, Class<? extends T> expectedClass) throws WebBeansException {
        Asserts.assertNotNull(name, "name parameter can not be null");
        try {
            return (T)initialContext.lookup(name);
        }
        catch (NamingException e) {
            LOGGER.error(e);
            throw new WebBeansException(LOGGER.getTokenString("EXCEPT_0010") + name, e);
        }
    }

    static {
        try {
            initialContext = new InitialContext();
        }
        catch (Exception e) {
            LOGGER.error("ERROR_0004", e);
            throw new ExceptionInInitializerError(e);
        }
    }
}

