/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.scanner;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.decorator.Decorator;
import javax.interceptor.Interceptor;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.scanner.xbean.CdiArchive;
import org.apache.webbeans.corespi.scanner.xbean.OwbAnnotationFinder;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.spi.BDABeansXmlScanner;
import org.apache.webbeans.spi.BdaScannerService;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.UrlSet;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassLoaders;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.filter.Filter;

public abstract class AbstractMetaDataDiscovery
implements BdaScannerService {
    protected static final Logger logger = WebBeansLoggerFacade.getLogger(AbstractMetaDataDiscovery.class);
    public static final String META_INF_BEANS_XML = "META-INF/beans.xml";
    private BeanArchiveService beanArchiveService;
    private final UrlSet beanArchiveLocations = new UrlSet();
    private final Map<String, URL> beanDeploymentUrls = new HashMap<String, URL>();
    private Map<BeanArchiveService.BeanArchiveInformation, Set<Class<?>>> beanClassesPerBda;
    protected String[] scanningExcludes;
    protected ClassLoader loader;
    protected CdiArchive archive;
    protected OwbAnnotationFinder finder;
    protected boolean isBDAScannerEnabled;
    protected BDABeansXmlScanner bdaBeansXmlScanner;
    protected WebBeansContext webBeansContext;

    protected AnnotationFinder initFinder() {
        if (this.finder != null) {
            return this.finder;
        }
        if (this.beanArchiveService == null) {
            this.beanArchiveService = this.webBeansContext().getBeanArchiveService();
        }
        Filter userFilter = this.webBeansContext().getService(Filter.class);
        this.archive = new CdiArchive(this.beanArchiveService, WebBeansUtil.getCurrentClassLoader(), this.getBeanDeploymentUrls(), userFilter, this.getAdditionalArchive());
        this.finder = new OwbAnnotationFinder(this.archive);
        return this.finder;
    }

    protected Archive getAdditionalArchive() {
        return null;
    }

    protected Iterable<URL> getBeanArchiveUrls() {
        return this.beanArchiveLocations;
    }

    public Map<String, URL> getBeanDeploymentUrls() {
        return this.beanDeploymentUrls;
    }

    public void scan() throws WebBeansDeploymentException {
        try {
            this.configure();
            this.initFinder();
        }
        catch (Exception e) {
            throw new WebBeansDeploymentException(e);
        }
    }

    protected abstract void configure();

    protected void registerBeanArchives(ClassLoader loader) {
        this.loader = loader;
        try {
            Set classPathUrls = ClassLoaders.findUrls((ClassLoader)loader);
            Enumeration<URL> beansXmlUrls = loader.getResources(META_INF_BEANS_XML);
            block2: while (beansXmlUrls.hasMoreElements()) {
                URL beansXmlUrl = beansXmlUrls.nextElement();
                this.addWebBeansXmlLocation(beansXmlUrl);
                String beansXml = beansXmlUrl.toExternalForm();
                beansXml = this.stripProtocol(beansXml);
                Iterator cpIt = classPathUrls.iterator();
                while (cpIt.hasNext()) {
                    URL cpUrl = (URL)cpIt.next();
                    if (!beansXml.startsWith(this.stripProtocol(cpUrl.toExternalForm()))) continue;
                    cpIt.remove();
                    this.addDeploymentUrl(beansXml, cpUrl);
                    continue block2;
                }
            }
            boolean onlyBeansXmlJars = this.webBeansContext().getOpenWebBeansConfiguration().scanOnlyBeansXmlJars();
            if (!onlyBeansXmlJars) {
                this.filterExcludedJars(classPathUrls);
                for (URL url : classPathUrls) {
                    if (!this.isBdaUrlEnabled(url)) continue;
                    this.addWebBeansXmlLocation(url);
                    this.addDeploymentUrl(url.toExternalForm(), url);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String stripProtocol(String urlPath) {
        int pos = urlPath.lastIndexOf(":/");
        if (pos > 0) {
            return urlPath.substring(pos + 1);
        }
        return urlPath;
    }

    protected void filterExcludedJars(Set<URL> classPathUrls) {
        Iterator<URL> it = classPathUrls.iterator();
        while (it.hasNext()) {
            URL url = it.next();
            String path = url.toExternalForm();
            int knownJarIdx = this.isExcludedJar(path);
            if (knownJarIdx <= 0 || knownJarIdx >= path.indexOf(".jar")) continue;
            it.remove();
        }
    }

    protected int isExcludedJar(String path) {
        this.initScanningExcludes();
        for (String p : this.scanningExcludes) {
            int i = path.indexOf(p);
            if (i <= 0) continue;
            return i;
        }
        return -1;
    }

    public void release() {
        this.finder = null;
        this.archive = null;
        this.loader = null;
    }

    protected void addDeploymentUrl(String beansXml, URL cpUrl) {
        this.beanDeploymentUrls.put(beansXml, cpUrl);
    }

    protected boolean isBdaUrlEnabled(URL bdaUrl) {
        return true;
    }

    public void init(Object object) {
        String usage = WebBeansContext.currentInstance().getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.useBDABeansXMLScanner");
        this.isBDAScannerEnabled = Boolean.parseBoolean(usage);
        this.initScanningExcludes();
    }

    public void initScanningExcludes() {
        if (this.scanningExcludes == null) {
            OpenWebBeansConfiguration owbConfiguration = WebBeansContext.currentInstance().getOpenWebBeansConfiguration();
            String scanningExcludesProperty = owbConfiguration.getProperty("org.apache.webbeans.scanExclusionPaths");
            List<String> excludes = owbConfiguration.splitValues(scanningExcludesProperty);
            this.scanningExcludes = excludes.toArray(new String[excludes.size()]);
        }
    }

    protected void addWebBeansXmlLocation(URL beanArchiveUrl) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("added beans archive URL: " + beanArchiveUrl.toExternalForm());
        }
        this.doAddWebBeansXmlLocation(beanArchiveUrl);
    }

    protected void doAddWebBeansXmlLocation(URL beanArchiveUrl) {
        this.beanArchiveLocations.add(beanArchiveUrl);
        if (this.beanArchiveService == null) {
            this.beanArchiveService = this.webBeansContext().getBeanArchiveService();
        }
        this.beanArchiveService.getBeanArchiveInformation(beanArchiveUrl);
    }

    public Map<BeanArchiveService.BeanArchiveInformation, Set<Class<?>>> getBeanClassesPerBda() {
        if (this.beanClassesPerBda == null) {
            this.beanClassesPerBda = new HashMap();
            for (CdiArchive.FoundClasses foundClasses : this.archive.classesByUrl().values()) {
                HashSet classSet = new HashSet();
                boolean scanModeAnnotated = BeanArchiveService.BeanDiscoveryMode.ANNOTATED == foundClasses.getBeanArchiveInfo().getBeanDiscoveryMode();
                for (String className : foundClasses.getClassNames()) {
                    try {
                        Class<?> clazz;
                        AnnotationFinder.ClassInfo classInfo;
                        if (scanModeAnnotated && ((classInfo = this.finder.getClassInfo(className)) == null || !this.isBeanAnnotatedClass(classInfo)) || (clazz = ClassUtil.getClassFromName(className)) == null) continue;
                        clazz.getDeclaredFields();
                        classSet.add(clazz);
                    }
                    catch (NoClassDefFoundError e) {
                        if (!logger.isLoggable(Level.WARNING)) continue;
                        logger.log(Level.WARNING, "WARN_0018", new Object[]{className, e.toString()});
                    }
                }
                this.beanClassesPerBda.put(foundClasses.getBeanArchiveInfo(), classSet);
            }
        }
        return this.beanClassesPerBda;
    }

    public Set<Class<?>> getBeanClasses() {
        return Collections.EMPTY_SET;
    }

    protected boolean isBeanAnnotatedClass(AnnotationFinder.ClassInfo classInfo) {
        for (AnnotationFinder.AnnotationInfo annotationInfo : classInfo.getAnnotations()) {
            if (!Interceptor.class.getName().equals(annotationInfo.getName()) && !Decorator.class.getName().equals(annotationInfo.getName()) && !this.isBeanAnnotation(annotationInfo)) continue;
            return true;
        }
        return false;
    }

    protected boolean isBeanAnnotation(AnnotationFinder.AnnotationInfo annotationInfo) {
        String annotationName = annotationInfo.getName();
        try {
            Class<?> annotationType = WebBeansUtil.getCurrentClassLoader().loadClass(annotationName);
            boolean isBeanAnnotation = this.webBeansContext().getBeanManagerImpl().isScope(annotationType);
            if (!isBeanAnnotation) {
                isBeanAnnotation = this.webBeansContext().getBeanManagerImpl().isStereotype(annotationType);
            }
            return isBeanAnnotation;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Set<URL> getBeanXmls() {
        return Collections.unmodifiableSet(this.beanArchiveLocations);
    }

    public BDABeansXmlScanner getBDABeansXmlScanner() {
        return this.bdaBeansXmlScanner;
    }

    public boolean isBDABeansXmlScanningEnabled() {
        return this.isBDAScannerEnabled;
    }

    protected WebBeansContext webBeansContext() {
        if (this.webBeansContext == null) {
            this.webBeansContext = WebBeansContext.getInstance();
        }
        return WebBeansContext.getInstance();
    }
}

