/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.model.geom;

import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import org.apache.poi.xslf.model.geom.Context;
import org.apache.poi.xslf.model.geom.PathCommand;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPath2DArcTo;

public class ArcToCommand
implements PathCommand {
    private String hr;
    private String wr;
    private String stAng;
    private String swAng;

    ArcToCommand(CTPath2DArcTo arc) {
        this.hr = arc.getHR().toString();
        this.wr = arc.getWR().toString();
        this.stAng = arc.getStAng().toString();
        this.swAng = arc.getSwAng().toString();
    }

    @Override
    public void execute(GeneralPath path, Context ctx) {
        double rx = ctx.getValue(this.wr);
        double ry = ctx.getValue(this.hr);
        double start = ctx.getValue(this.stAng) / 60000.0;
        double extent = ctx.getValue(this.swAng) / 60000.0;
        Point2D pt = path.getCurrentPoint();
        double x0 = pt.getX() - rx - rx * Math.cos(Math.toRadians(start));
        double y0 = pt.getY() - ry - ry * Math.sin(Math.toRadians(start));
        Arc2D.Double arc = new Arc2D.Double(x0, y0, 2.0 * rx, 2.0 * ry, -start, -extent, 0);
        path.append(arc, true);
    }
}

