/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.vmpipe;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.mina.common.ConnectFuture;
import org.apache.mina.common.ExceptionMonitor;
import org.apache.mina.common.IoFilterChain;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoService;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.IoSession;
import org.apache.mina.common.IoSessionConfig;
import org.apache.mina.common.support.AbstractIoFilterChain;
import org.apache.mina.common.support.BaseIoConnectorConfig;
import org.apache.mina.common.support.BaseIoSessionConfig;
import org.apache.mina.common.support.DefaultConnectFuture;
import org.apache.mina.transport.vmpipe.VmPipeAcceptor;
import org.apache.mina.transport.vmpipe.VmPipeAddress;
import org.apache.mina.transport.vmpipe.VmPipeConnector;
import org.apache.mina.transport.vmpipe.support.VmPipe;
import org.apache.mina.transport.vmpipe.support.VmPipeIdleStatusChecker;
import org.apache.mina.transport.vmpipe.support.VmPipeSessionImpl;
import org.apache.mina.util.AnonymousSocketAddress;

public class QpidVmPipeConnector
extends VmPipeConnector {
    private static final IoSessionConfig CONFIG = new BaseIoSessionConfig(){};
    private final IoServiceConfig defaultConfig = new BaseIoConnectorConfig(){

        public IoSessionConfig getSessionConfig() {
            return CONFIG;
        }
    };

    public ConnectFuture connect(SocketAddress address, IoHandler handler, IoServiceConfig config) {
        return this.connect(address, null, handler, config);
    }

    public ConnectFuture connect(SocketAddress address, SocketAddress localAddress, IoHandler handler, IoServiceConfig config) {
        IoFilterChain filterChain;
        VmPipe entry;
        if (address == null) {
            throw new NullPointerException("address");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        if (!(address instanceof VmPipeAddress)) {
            throw new IllegalArgumentException("address must be VmPipeAddress.");
        }
        if (config == null) {
            config = this.getDefaultConfig();
        }
        if ((entry = (VmPipe)VmPipeAcceptor.boundHandlers.get(address)) == null) {
            return DefaultConnectFuture.newFailedFuture((Throwable)new IOException("Endpoint unavailable: " + address));
        }
        DefaultConnectFuture future = new DefaultConnectFuture();
        VmPipeSessionImpl localSession = new VmPipeSessionImpl((IoService)this, config, this.getListeners(), new Object(), (SocketAddress)new AnonymousSocketAddress(), handler, entry);
        VmPipeSessionImpl remoteSession = localSession.getRemoteSession();
        try {
            filterChain = remoteSession.getFilterChain();
            entry.getAcceptor().getFilterChainBuilder().buildFilterChain(filterChain);
            entry.getConfig().getFilterChainBuilder().buildFilterChain(filterChain);
            entry.getConfig().getThreadModel().buildFilterChain(filterChain);
            entry.getListeners().fireSessionCreated((IoSession)remoteSession);
            VmPipeIdleStatusChecker.getInstance().addSession(remoteSession);
        }
        catch (Throwable t) {
            ExceptionMonitor.getInstance().exceptionCaught(t);
            remoteSession.close();
        }
        try {
            filterChain = localSession.getFilterChain();
            this.getFilterChainBuilder().buildFilterChain(filterChain);
            config.getFilterChainBuilder().buildFilterChain(filterChain);
            config.getThreadModel().buildFilterChain(filterChain);
            localSession.setAttribute(AbstractIoFilterChain.CONNECT_FUTURE, (Object)future);
            this.getListeners().fireSessionCreated((IoSession)localSession);
            VmPipeIdleStatusChecker.getInstance().addSession(localSession);
        }
        catch (Throwable t) {
            future.setException(t);
        }
        return future;
    }

    public IoServiceConfig getDefaultConfig() {
        return this.defaultConfig;
    }
}

