/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.transport;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.transport.Method;
import org.apache.qpid.transport.MethodDelegate;
import org.apache.qpid.transport.Option;
import org.apache.qpid.transport.codec.Decoder;
import org.apache.qpid.transport.codec.Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExchangeDeclare
extends Method {
    public static final int TYPE = 1793;
    private short packing_flags = 0;
    private String exchange;
    private String type;
    private String alternateExchange;
    private Map<String, Object> arguments;

    @Override
    public final int getStructType() {
        return 1793;
    }

    @Override
    public final int getSizeWidth() {
        return 0;
    }

    @Override
    public final int getPackWidth() {
        return 2;
    }

    @Override
    public final boolean hasPayload() {
        return false;
    }

    @Override
    public final byte getEncodedTrack() {
        return 3;
    }

    @Override
    public final boolean isConnectionControl() {
        return false;
    }

    public ExchangeDeclare() {
    }

    public ExchangeDeclare(String exchange, String type, String alternateExchange, Map<String, Object> arguments, Option ... _options) {
        if (exchange != null) {
            this.setExchange(exchange);
        }
        if (type != null) {
            this.setType(type);
        }
        if (alternateExchange != null) {
            this.setAlternateExchange(alternateExchange);
        }
        if (arguments != null) {
            this.setArguments(arguments);
        }
        block9: for (int i = 0; i < _options.length; ++i) {
            switch (_options[i]) {
                case PASSIVE: {
                    this.packing_flags = (short)(this.packing_flags | 0x800);
                    continue block9;
                }
                case DURABLE: {
                    this.packing_flags = (short)(this.packing_flags | 0x1000);
                    continue block9;
                }
                case AUTO_DELETE: {
                    this.packing_flags = (short)(this.packing_flags | 0x2000);
                    continue block9;
                }
                case SYNC: {
                    this.setSync(true);
                    continue block9;
                }
                case BATCH: {
                    this.setBatch(true);
                    continue block9;
                }
                case UNRELIABLE: {
                    this.setUnreliable(true);
                    continue block9;
                }
                case NONE: {
                    continue block9;
                }
                default: {
                    throw new IllegalArgumentException("invalid option: " + (Object)((Object)_options[i]));
                }
            }
        }
    }

    @Override
    public <C> void dispatch(C context, MethodDelegate<C> delegate) {
        delegate.exchangeDeclare(context, this);
    }

    public final boolean hasExchange() {
        return (this.packing_flags & 0x100) != 0;
    }

    public final ExchangeDeclare clearExchange() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFEFF);
        this.exchange = null;
        this.dirty = true;
        return this;
    }

    public final String getExchange() {
        return this.exchange;
    }

    public final ExchangeDeclare setExchange(String value) {
        this.exchange = value;
        this.packing_flags = (short)(this.packing_flags | 0x100);
        this.dirty = true;
        return this;
    }

    public final ExchangeDeclare exchange(String value) {
        return this.setExchange(value);
    }

    public final boolean hasType() {
        return (this.packing_flags & 0x200) != 0;
    }

    public final ExchangeDeclare clearType() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFDFF);
        this.type = null;
        this.dirty = true;
        return this;
    }

    public final String getType() {
        return this.type;
    }

    public final ExchangeDeclare setType(String value) {
        this.type = value;
        this.packing_flags = (short)(this.packing_flags | 0x200);
        this.dirty = true;
        return this;
    }

    public final ExchangeDeclare type(String value) {
        return this.setType(value);
    }

    public final boolean hasAlternateExchange() {
        return (this.packing_flags & 0x400) != 0;
    }

    public final ExchangeDeclare clearAlternateExchange() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFFBFF);
        this.alternateExchange = null;
        this.dirty = true;
        return this;
    }

    public final String getAlternateExchange() {
        return this.alternateExchange;
    }

    public final ExchangeDeclare setAlternateExchange(String value) {
        this.alternateExchange = value;
        this.packing_flags = (short)(this.packing_flags | 0x400);
        this.dirty = true;
        return this;
    }

    public final ExchangeDeclare alternateExchange(String value) {
        return this.setAlternateExchange(value);
    }

    public final boolean hasPassive() {
        return (this.packing_flags & 0x800) != 0;
    }

    public final ExchangeDeclare clearPassive() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFF7FF);
        this.dirty = true;
        return this;
    }

    public final boolean getPassive() {
        return this.hasPassive();
    }

    public final ExchangeDeclare setPassive(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x800) : (short)(this.packing_flags & 0xFFFFF7FF);
        this.dirty = true;
        return this;
    }

    public final ExchangeDeclare passive(boolean value) {
        return this.setPassive(value);
    }

    public final boolean hasDurable() {
        return (this.packing_flags & 0x1000) != 0;
    }

    public final ExchangeDeclare clearDurable() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFEFFF);
        this.dirty = true;
        return this;
    }

    public final boolean getDurable() {
        return this.hasDurable();
    }

    public final ExchangeDeclare setDurable(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x1000) : (short)(this.packing_flags & 0xFFFFEFFF);
        this.dirty = true;
        return this;
    }

    public final ExchangeDeclare durable(boolean value) {
        return this.setDurable(value);
    }

    public final boolean hasAutoDelete() {
        return (this.packing_flags & 0x2000) != 0;
    }

    public final ExchangeDeclare clearAutoDelete() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFDFFF);
        this.dirty = true;
        return this;
    }

    public final boolean getAutoDelete() {
        return this.hasAutoDelete();
    }

    public final ExchangeDeclare setAutoDelete(boolean value) {
        this.packing_flags = value ? (short)(this.packing_flags | 0x2000) : (short)(this.packing_flags & 0xFFFFDFFF);
        this.dirty = true;
        return this;
    }

    public final ExchangeDeclare autoDelete(boolean value) {
        return this.setAutoDelete(value);
    }

    public final boolean hasArguments() {
        return (this.packing_flags & 0x4000) != 0;
    }

    public final ExchangeDeclare clearArguments() {
        this.packing_flags = (short)(this.packing_flags & 0xFFFFBFFF);
        this.arguments = null;
        this.dirty = true;
        return this;
    }

    public final Map<String, Object> getArguments() {
        return this.arguments;
    }

    public final ExchangeDeclare setArguments(Map<String, Object> value) {
        this.arguments = value;
        this.packing_flags = (short)(this.packing_flags | 0x4000);
        this.dirty = true;
        return this;
    }

    public final ExchangeDeclare arguments(Map<String, Object> value) {
        return this.setArguments(value);
    }

    @Override
    public void write(Encoder enc) {
        enc.writeUint16(this.packing_flags);
        if ((this.packing_flags & 0x100) != 0) {
            enc.writeStr8(this.exchange);
        }
        if ((this.packing_flags & 0x200) != 0) {
            enc.writeStr8(this.type);
        }
        if ((this.packing_flags & 0x400) != 0) {
            enc.writeStr8(this.alternateExchange);
        }
        if ((this.packing_flags & 0x4000) != 0) {
            enc.writeMap(this.arguments);
        }
    }

    @Override
    public void read(Decoder dec) {
        this.packing_flags = (short)dec.readUint16();
        if ((this.packing_flags & 0x100) != 0) {
            this.exchange = dec.readStr8();
        }
        if ((this.packing_flags & 0x200) != 0) {
            this.type = dec.readStr8();
        }
        if ((this.packing_flags & 0x400) != 0) {
            this.alternateExchange = dec.readStr8();
        }
        if ((this.packing_flags & 0x4000) != 0) {
            this.arguments = dec.readMap();
        }
    }

    @Override
    public Map<String, Object> getFields() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        if ((this.packing_flags & 0x100) != 0) {
            result.put("exchange", this.getExchange());
        }
        if ((this.packing_flags & 0x200) != 0) {
            result.put("type", this.getType());
        }
        if ((this.packing_flags & 0x400) != 0) {
            result.put("alternateExchange", this.getAlternateExchange());
        }
        if ((this.packing_flags & 0x800) != 0) {
            result.put("passive", this.getPassive());
        }
        if ((this.packing_flags & 0x1000) != 0) {
            result.put("durable", this.getDurable());
        }
        if ((this.packing_flags & 0x2000) != 0) {
            result.put("autoDelete", this.getAutoDelete());
        }
        if ((this.packing_flags & 0x4000) != 0) {
            result.put("arguments", this.getArguments());
        }
        return result;
    }
}

