/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authentication.unix.jaas;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.ranger.authentication.unix.jaas.ConsolePromptCallbackHandler;
import org.apache.ranger.authentication.unix.jaas.UnixGroupPrincipal;
import org.apache.ranger.authentication.unix.jaas.UnixUserPrincipal;

public class RemoteUnixLoginModule
implements LoginModule {
    private static final String DEBUG_PARAM = "ranger.unixauth.debug";
    private static final String REMOTE_LOGIN_HOST_PARAM = "ranger.unixauth.service.hostname";
    private static final String REMOTE_LOGIN_AUTH_SERVICE_PORT_PARAM = "ranger.unixauth.service.port";
    private static final String SSL_KEYSTORE_PATH_PARAM = "ranger.unixauth.keystore";
    private static final String SSL_KEYSTORE_PATH_PASSWORD_PARAM = "ranger.unixauth.keystore.password";
    private static final String SSL_TRUSTSTORE_PATH_PARAM = "ranger.unixauth.truststore";
    private static final String SSL_TRUSTSTORE_PATH_PASSWORD_PARAM = "ranger.unixauth.truststore.password";
    private static final String SSL_ENABLED_PARAM = "ranger.unixauth.ssl.enabled";
    private static final String SERVER_CERT_VALIDATION_PARAM = "ranger.unixauth.server.cert.validation";
    private static final String JAAS_ENABLED_PARAM = "ranger.unixauth.remote.login.enabled";
    private static final String SSL_ALGORITHM = "TLS";
    private String userName;
    private char[] password;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private boolean debug = true;
    private String remoteHostName;
    private int remoteHostAuthServicePort;
    private boolean loginSuccessful = false;
    private String loginGroups = null;
    private String keyStorePath;
    private String keyStorePathPassword;
    private String trustStorePath;
    private String trustStorePathPassword;
    private boolean SSLEnabled = false;
    private boolean serverCertValidation = true;
    private boolean remoteLoginEnabled = true;

    public RemoteUnixLoginModule() {
        this.log("Created RemoteUnixLoginModule");
    }

    @Override
    public boolean abort() throws LoginException {
        this.log("RemoteUnixLoginModule::abort() has been called.");
        this.loginSuccessful = false;
        return true;
    }

    @Override
    public boolean commit() throws LoginException {
        this.log("RemoteUnixLoginModule::commit() has been called. -> isLoginSuccess [" + this.loginSuccessful + "]");
        if (this.loginSuccessful) {
            if (this.subject != null) {
                this.subject.getPrincipals().add(new UnixUserPrincipal(this.userName.trim()));
                if (this.loginGroups != null) {
                    this.loginGroups = this.loginGroups.trim();
                    for (String group : this.loginGroups.split(",")) {
                        this.subject.getPrincipals().add(new UnixGroupPrincipal(group.trim()));
                    }
                }
            }
        } else if (this.subject != null) {
            this.subject.getPrincipals().clear();
        }
        return this.loginSuccessful;
    }

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.log("RemoteUnixLoginModule::initialize() has been called with callbackhandler: " + this.callbackHandler);
        if (this.callbackHandler == null) {
            this.callbackHandler = new ConsolePromptCallbackHandler();
        }
        Properties config = new Properties();
        config.putAll(options);
        this.initParams(config);
    }

    public void initParams(Properties options) {
        String val = (String)options.get(JAAS_ENABLED_PARAM);
        if (val != null) {
            this.remoteLoginEnabled = val.trim().equalsIgnoreCase("true");
            if (!this.remoteLoginEnabled) {
                this.log("Skipping RemoteLogin - [ranger.unixauth.remote.login.enabled] => [" + val + "]");
                return;
            }
        } else {
            this.remoteLoginEnabled = true;
        }
        this.debug = (val = (String)options.get(DEBUG_PARAM)) != null && !val.equalsIgnoreCase("false");
        this.remoteHostName = (String)options.get(REMOTE_LOGIN_HOST_PARAM);
        this.log("RemoteHostName:" + this.remoteHostName);
        val = (String)options.get(REMOTE_LOGIN_AUTH_SERVICE_PORT_PARAM);
        if (val != null) {
            this.remoteHostAuthServicePort = Integer.parseInt(val.trim());
        }
        this.log("remoteHostAuthServicePort:" + this.remoteHostAuthServicePort);
        val = (String)options.get(SSL_ENABLED_PARAM);
        this.SSLEnabled = val != null && val.trim().equalsIgnoreCase("true");
        this.log("SSLEnabled:" + this.SSLEnabled);
        if (this.SSLEnabled) {
            String certValidationFlag;
            this.trustStorePath = (String)options.get(SSL_TRUSTSTORE_PATH_PARAM);
            this.log("trustStorePath:" + this.trustStorePath);
            if (this.trustStorePath != null) {
                this.trustStorePathPassword = (String)options.get(SSL_TRUSTSTORE_PATH_PASSWORD_PARAM);
                if (this.trustStorePathPassword == null) {
                    this.trustStorePathPassword = "";
                }
                this.log("trustStorePathPassword:*****");
            }
            this.keyStorePath = (String)options.get(SSL_KEYSTORE_PATH_PARAM);
            this.log("keyStorePath:" + this.keyStorePath);
            if (this.keyStorePath != null) {
                this.keyStorePathPassword = (String)options.get(SSL_KEYSTORE_PATH_PASSWORD_PARAM);
                if (this.keyStorePathPassword == null) {
                    this.keyStorePathPassword = "";
                }
                this.log("keyStorePathPassword:*****");
            }
            this.serverCertValidation = (certValidationFlag = (String)options.get(SERVER_CERT_VALIDATION_PARAM)) == null || !"false".equalsIgnoreCase(certValidationFlag.trim());
            this.log("Server Cert Validation : " + this.serverCertValidation);
        }
    }

    @Override
    public boolean login() throws LoginException {
        if (this.remoteLoginEnabled && this.callbackHandler != null) {
            int atStartsAt;
            NameCallback nameCallback = new NameCallback("UserName:");
            PasswordCallback passwordCallback = new PasswordCallback("Password:", false);
            try {
                this.callbackHandler.handle(new Callback[]{nameCallback, passwordCallback});
            }
            catch (IOException e) {
                throw new LoginException("Unable to get username/password due to exception: " + e);
            }
            catch (UnsupportedCallbackException e) {
                throw new LoginException("Unable to get username/password due to exception: " + e);
            }
            String modifiedUserName = this.userName = nameCallback.getName();
            if (this.userName != null && (atStartsAt = this.userName.indexOf("@")) > -1) {
                modifiedUserName = this.userName.substring(0, atStartsAt);
            }
            this.password = passwordCallback.getPassword();
            this.log("userName:" + this.userName);
            this.log("modified UserName:" + modifiedUserName);
            char[] modifiedPasschar = this.password != null ? Arrays.copyOf(this.password, this.password.length) : new char[]{};
            this.doLogin(modifiedUserName, modifiedPasschar);
            Arrays.fill(this.password, ' ');
            Arrays.fill(modifiedPasschar, ' ');
            this.loginSuccessful = true;
        }
        return this.loginSuccessful;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.subject != null) {
            this.subject.getPrincipals().clear();
        }
        return true;
    }

    public void doLogin(String aUserName, char[] modifiedPasschar) throws LoginException {
        String ret = this.getLoginReplyFromAuthService(aUserName, modifiedPasschar);
        if (ret == null) {
            throw new LoginException("FAILED: unable to authenticate to AuthenticationService: " + this.remoteHostName + ":" + this.remoteHostAuthServicePort);
        }
        if (ret.startsWith("OK:")) {
            this.loginSuccessful = true;
            if (ret.length() > 3) {
                this.loginGroups = ret.substring(3);
            }
        } else {
            if (ret.startsWith("FAILED:")) {
                this.loginSuccessful = false;
                throw new LoginException("FAILED: unable to authenticate to AuthenticationService: " + this.remoteHostName + ":" + this.remoteHostAuthServicePort);
            }
            throw new LoginException("FAILED: unable to authenticate to AuthenticationService: " + this.remoteHostName + ":" + this.remoteHostAuthServicePort + ", msg:" + ret);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getLoginReplyFromAuthService(String aUserName, char[] modifiedPasschar) throws LoginException {
        String ret = null;
        Socket sslsocket = null;
        char[] prefix = new String("LOGIN:" + aUserName + " ").toCharArray();
        char[] tail = new String("\n").toCharArray();
        char[] loginData = new char[prefix.length + modifiedPasschar.length + tail.length];
        System.arraycopy(prefix, 0, loginData, 0, prefix.length);
        System.arraycopy(modifiedPasschar, 0, loginData, prefix.length, modifiedPasschar.length);
        System.arraycopy(tail, 0, loginData, prefix.length + modifiedPasschar.length, tail.length);
        try {
            try {
                if (this.SSLEnabled) {
                    SSLContext context = SSLContext.getInstance(SSL_ALGORITHM);
                    KeyManager[] km = null;
                    if (this.keyStorePath != null) {
                        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
                        InputStream in = null;
                        in = this.getFileInputStream(this.keyStorePath);
                        try {
                            ks.load(in, this.keyStorePathPassword.toCharArray());
                        }
                        finally {
                            if (in != null) {
                                in.close();
                            }
                        }
                        KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                        kmf.init(ks, this.keyStorePathPassword.toCharArray());
                        km = kmf.getKeyManagers();
                    }
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    TrustManager[] tm = null;
                    if (this.serverCertValidation) {
                        KeyStore trustStoreKeyStore = null;
                        if (this.trustStorePath != null) {
                            trustStoreKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                            InputStream in = null;
                            in = this.getFileInputStream(this.trustStorePath);
                            try {
                                trustStoreKeyStore.load(in, this.trustStorePathPassword.toCharArray());
                                trustManagerFactory.init(trustStoreKeyStore);
                                tm = trustManagerFactory.getTrustManagers();
                            }
                            finally {
                                if (in != null) {
                                    in.close();
                                }
                            }
                        }
                    } else {
                        X509TrustManager ignoreValidationTM = new X509TrustManager(){

                            @Override
                            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                            }

                            @Override
                            public X509Certificate[] getAcceptedIssuers() {
                                return new X509Certificate[0];
                            }

                            @Override
                            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                            }
                        };
                        tm = new TrustManager[]{ignoreValidationTM};
                    }
                    SecureRandom random = new SecureRandom();
                    context.init(km, tm, random);
                    SSLSocketFactory sf = context.getSocketFactory();
                    sslsocket = sf.createSocket(this.remoteHostName, this.remoteHostAuthServicePort);
                } else {
                    sslsocket = new Socket(this.remoteHostName, this.remoteHostAuthServicePort);
                }
                OutputStreamWriter writer = new OutputStreamWriter(sslsocket.getOutputStream());
                writer.write(loginData);
                writer.flush();
                BufferedReader reader = new BufferedReader(new InputStreamReader(sslsocket.getInputStream()));
                ret = reader.readLine();
                reader.close();
                writer.close();
            }
            finally {
                if (sslsocket != null) {
                    sslsocket.close();
                }
            }
            this.log("Login of user String: {" + aUserName + "}, return from AuthServer: {" + ret + "}");
        }
        catch (Throwable t) {
            try {
                throw new LoginException("FAILED: unable to authenticate to AuthenticationService: " + this.remoteHostName + ":" + this.remoteHostAuthServicePort + ", Exception: [" + t + "]");
            }
            catch (Throwable throwable) {
                this.log("Login of user String: {" + aUserName + "}, return from AuthServer: {" + ret + "}");
                Arrays.fill(loginData, ' ');
                Arrays.fill(modifiedPasschar, ' ');
                throw throwable;
            }
        }
        Arrays.fill(loginData, ' ');
        Arrays.fill(modifiedPasschar, ' ');
        return ret;
    }

    private InputStream getFileInputStream(String path) throws FileNotFoundException {
        InputStream ret = null;
        File f = new File(path);
        if (f.exists()) {
            ret = new FileInputStream(f);
        } else {
            ret = this.getClass().getResourceAsStream(path);
            if (ret == null && !path.startsWith("/")) {
                ret = this.getClass().getResourceAsStream("/" + path);
            }
            if (ret == null && (ret = ClassLoader.getSystemClassLoader().getResourceAsStream(path)) == null && !path.startsWith("/")) {
                ret = ClassLoader.getSystemResourceAsStream("/" + path);
            }
        }
        return ret;
    }

    private void log(String msg) {
        if (this.debug) {
            System.err.println("RemoteUnixLoginModule: " + msg);
        }
    }
}

