/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eq;

import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.FieldComparator;
import org.apache.solr.client.solrj.io.comp.MultipleFieldComparator;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.eq.MultipleFieldEqualitor;
import org.apache.solr.client.solrj.io.eq.StreamEqualitor;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FieldEqualitor
implements StreamEqualitor {
    private static final long serialVersionUID = 1L;
    private String leftFieldName;
    private String rightFieldName;

    public FieldEqualitor(String fieldName) {
        this.init(fieldName, fieldName);
    }

    public FieldEqualitor(String leftFieldName, String rightFieldName) {
        this.init(leftFieldName, rightFieldName);
    }

    private void init(String leftFieldName, String rightFieldName) {
        this.leftFieldName = leftFieldName;
        this.rightFieldName = rightFieldName;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.leftFieldName);
        if (!this.leftFieldName.equals(this.rightFieldName)) {
            sb.append("=");
            sb.append(this.rightFieldName);
        }
        return new StreamExpressionValue(sb.toString());
    }

    @Override
    public boolean test(Tuple leftTuple, Tuple rightTuple) {
        Comparable rightComp;
        Comparable leftComp = (Comparable)leftTuple.get(this.leftFieldName);
        if (leftComp == (rightComp = (Comparable)rightTuple.get(this.rightFieldName))) {
            return true;
        }
        if (null == leftComp || null == rightComp) {
            return false;
        }
        return 0 == leftComp.compareTo(rightComp);
    }

    public String getLeftFieldName() {
        return this.leftFieldName;
    }

    public String getRightFieldName() {
        return this.rightFieldName;
    }

    @Override
    public boolean isDerivedFrom(StreamEqualitor base) {
        MultipleFieldEqualitor baseEqs;
        if (null == base) {
            return false;
        }
        if (base instanceof FieldEqualitor) {
            FieldEqualitor baseEq = (FieldEqualitor)base;
            return this.leftFieldName.equals(baseEq.leftFieldName) && this.rightFieldName.equals(baseEq.rightFieldName);
        }
        if (base instanceof MultipleFieldEqualitor && (baseEqs = (MultipleFieldEqualitor)base).getEqs().length > 0) {
            return this.isDerivedFrom(baseEqs.getEqs()[0]);
        }
        return false;
    }

    @Override
    public boolean isDerivedFrom(StreamComparator base) {
        MultipleFieldComparator baseComps;
        if (null == base) {
            return false;
        }
        if (base instanceof FieldComparator) {
            FieldComparator baseComp = (FieldComparator)base;
            return this.leftFieldName.equals(baseComp.getLeftFieldName()) || this.rightFieldName.equals(baseComp.getRightFieldName());
        }
        if (base instanceof MultipleFieldComparator && (baseComps = (MultipleFieldComparator)base).getComps().length > 0) {
            return this.isDerivedFrom(baseComps.getComps()[0]);
        }
        return false;
    }
}

