/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.Closeable;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.solr.common.Callable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStateReader
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String BASE_URL_PROP = "base_url";
    public static final String NODE_NAME_PROP = "node_name";
    public static final String CORE_NODE_NAME_PROP = "core_node_name";
    public static final String ROLES_PROP = "roles";
    public static final String STATE_PROP = "state";
    public static final String CORE_NAME_PROP = "core";
    public static final String COLLECTION_PROP = "collection";
    public static final String ELECTION_NODE_PROP = "election_node";
    public static final String SHARD_ID_PROP = "shard";
    public static final String REPLICA_PROP = "replica";
    public static final String SHARD_RANGE_PROP = "shard_range";
    public static final String SHARD_STATE_PROP = "shard_state";
    public static final String SHARD_PARENT_PROP = "shard_parent";
    public static final String NUM_SHARDS_PROP = "numShards";
    public static final String LEADER_PROP = "leader";
    public static final String PROPERTY_PROP = "property";
    public static final String PROPERTY_VALUE_PROP = "property.value";
    public static final String MAX_AT_ONCE_PROP = "maxAtOnce";
    public static final String MAX_WAIT_SECONDS_PROP = "maxWaitSeconds";
    public static final String COLLECTIONS_ZKNODE = "/collections";
    public static final String LIVE_NODES_ZKNODE = "/live_nodes";
    public static final String ALIASES = "/aliases.json";
    public static final String CLUSTER_STATE = "/clusterstate.json";
    public static final String CLUSTER_PROPS = "/clusterprops.json";
    public static final String REJOIN_AT_HEAD_PROP = "rejoinAtHead";
    public static final String SOLR_SECURITY_CONF_PATH = "/security.json";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_SHARDS_PER_NODE = "maxShardsPerNode";
    public static final String AUTO_ADD_REPLICAS = "autoAddReplicas";
    public static final String ROLES = "/roles.json";
    public static final String CONFIGS_ZKNODE = "/configs";
    public static final String CONFIGNAME_PROP = "configName";
    public static final String LEGACY_CLOUD = "legacyCloud";
    public static final String URL_SCHEME = "urlScheme";
    protected volatile ClusterState clusterState;
    private static final int GET_LEADER_RETRY_INTERVAL_MS = 50;
    private static final int GET_LEADER_RETRY_DEFAULT_TIMEOUT = 4000;
    public static final String LEADER_ELECT_ZKNODE = "leader_elect";
    public static final String SHARD_LEADERS_ZKNODE = "leaders";
    public static final String ELECTION_NODE = "election";
    private final Set<String> interestingCollections = Collections.newSetFromMap(new ConcurrentHashMap());
    private Map<String, ClusterState.CollectionRef> legacyCollectionStates = Collections.emptyMap();
    private int legacyClusterStateVersion = 0;
    private final ConcurrentHashMap<String, DocCollection> watchedCollectionStates = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LazyCollectionRef> lazyCollectionStates = new ConcurrentHashMap();
    private volatile Set<String> liveNodes = Collections.emptySet();
    private final ZkConfigManager configManager;
    private ConfigData securityData;
    private final Runnable securityNodeListener;
    public static final Set<String> KNOWN_CLUSTER_PROPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("legacyCloud", "urlScheme", "autoAddReplicas")));
    private final SolrZkClient zkClient;
    private final boolean closeClient;
    private volatile Aliases aliases = new Aliases();
    private volatile boolean closed = false;
    private final Object refreshCollectionListLock = new Object();
    private final Object refreshLiveNodesLock = new Object();
    private final AtomicReference<Set<String>> lastFetchedLiveNodes = new AtomicReference();

    public String readConfigName(String collection) {
        String configName = null;
        String path = "/collections/" + collection;
        LOG.info("Load collection config from: [{}]", (Object)path);
        try {
            byte[] data = this.zkClient.getData(path, null, null, true);
            if (data != null) {
                ZkNodeProps props = ZkNodeProps.load(data);
                configName = props.getStr(CONFIGNAME_PROP);
            }
            if (configName != null) {
                if (!this.zkClient.exists("/configs/" + configName, true).booleanValue()) {
                    LOG.error("Specified config does not exist in ZooKeeper: [{}]", (Object)configName);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Specified config does not exist in ZooKeeper: " + configName);
                }
            } else {
                throw new ZooKeeperException(SolrException.ErrorCode.INVALID_STATE, "No config data found at path: " + path);
            }
            LOG.info("path=[{}] [{}]=[{}] specified config exists in ZooKeeper", new Object[]{path, CONFIGNAME_PROP, configName});
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading config name for collection " + collection, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading config name for collection " + collection, (Throwable)e);
        }
        return configName;
    }

    public ZkStateReader(SolrZkClient zkClient) {
        this(zkClient, null);
    }

    public ZkStateReader(SolrZkClient zkClient, Runnable securityNodeListener) {
        this.zkClient = zkClient;
        this.configManager = new ZkConfigManager(zkClient);
        this.closeClient = false;
        this.securityNodeListener = securityNodeListener;
    }

    public ZkStateReader(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout) {
        this.zkClient = new SolrZkClient(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new OnReconnect(){

            @Override
            public void command() {
                try {
                    ZkStateReader.this.createClusterStateWatchersAndUpdate();
                }
                catch (KeeperException e) {
                    LOG.error("A ZK error has occurred", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.error("Interrupted", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted", (Throwable)e);
                }
            }
        });
        this.configManager = new ZkConfigManager(this.zkClient);
        this.closeClient = true;
        this.securityNodeListener = null;
    }

    public ZkConfigManager getConfigManager() {
        return this.configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateClusterState() throws KeeperException, InterruptedException {
        Object object = this.getUpdateLock();
        synchronized (object) {
            if (this.clusterState == null) {
                this.createClusterStateWatchersAndUpdate();
                return;
            }
            this.refreshLegacyClusterState(null);
            ArrayList safeCopy = new ArrayList(this.watchedCollectionStates.keySet());
            for (String coll : safeCopy) {
                DocCollection newState = this.fetchCollectionState(coll, null);
                this.updateWatchedCollection(coll, newState);
            }
            this.refreshCollectionList(null);
            this.refreshLiveNodes(null);
            this.constructState();
        }
    }

    public void updateLiveNodes() throws KeeperException, InterruptedException {
        this.refreshLiveNodes(null);
    }

    public Aliases getAliases() {
        return this.aliases;
    }

    public Integer compareStateVersions(String coll, int version) {
        DocCollection collection = this.clusterState.getCollectionOrNull(coll);
        if (collection == null) {
            return null;
        }
        if (collection.getZNodeVersion() < version) {
            LOG.debug("Server older than client {}<{}", (Object)collection.getZNodeVersion(), (Object)version);
            DocCollection nu = ZkStateReader.getCollectionLive(this, coll);
            if (nu == null) {
                return -1;
            }
            if (nu.getZNodeVersion() > collection.getZNodeVersion()) {
                this.updateWatchedCollection(coll, nu);
                collection = nu;
            }
        }
        if (collection.getZNodeVersion() == version) {
            return null;
        }
        LOG.debug("Wrong version from client [{}]!=[{}]", (Object)version, (Object)collection.getZNodeVersion());
        return collection.getZNodeVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void createClusterStateWatchersAndUpdate() throws KeeperException, InterruptedException {
        LOG.info("Updating cluster state from ZooKeeper... ");
        if (!this.zkClient.exists(CLUSTER_STATE, true).booleanValue()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot connect to cluster at " + this.zkClient.getZkServerAddress() + ": cluster not found/not ready");
        }
        this.refreshLegacyClusterState(new LegacyClusterStateWatcher());
        this.refreshStateFormat2Collections();
        this.refreshCollectionList(new CollectionsChildWatcher());
        this.refreshLiveNodes(new LiveNodeWatcher());
        Object object = this.getUpdateLock();
        synchronized (object) {
            this.constructState();
            this.zkClient.exists(ALIASES, new Watcher(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void process(WatchedEvent event) {
                    if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                        return;
                    }
                    try {
                        Object object = ZkStateReader.this.getUpdateLock();
                        synchronized (object) {
                            LOG.info("Updating aliases... ");
                            2 thisWatch = this;
                            Stat stat = new Stat();
                            byte[] data = ZkStateReader.this.zkClient.getData(ZkStateReader.ALIASES, thisWatch, stat, true);
                            ZkStateReader.this.aliases = ClusterState.load(data);
                        }
                    }
                    catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                        LOG.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
                    }
                    catch (KeeperException e) {
                        LOG.error("A ZK error has occurred", (Throwable)e);
                        throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.warn("Interrupted", (Throwable)e);
                    }
                }
            }, true);
        }
        this.updateAliases();
        if (this.securityNodeListener != null) {
            this.addSecuritynodeWatcher(pair -> {
                ConfigData cd = new ConfigData();
                cd.data = pair.getKey() == null || ((byte[])pair.getKey()).length == 0 ? Collections.EMPTY_MAP : Utils.getDeepCopy((Map)Utils.fromJSON((byte[])pair.getKey()), 4, false);
                cd.version = pair.getValue() == null ? -1 : ((Stat)pair.getValue()).getVersion();
                this.securityData = cd;
                this.securityNodeListener.run();
            });
            this.securityData = this.getSecurityProps(true);
        }
    }

    private void addSecuritynodeWatcher(final Callable<Pair<byte[], Stat>> callback) throws KeeperException, InterruptedException {
        this.zkClient.exists(SOLR_SECURITY_CONF_PATH, new Watcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(WatchedEvent event) {
                if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                    return;
                }
                try {
                    Object object = ZkStateReader.this.getUpdateLock();
                    synchronized (object) {
                        LOG.info("Updating [{}] ... ", (Object)ZkStateReader.SOLR_SECURITY_CONF_PATH);
                        3 thisWatch = this;
                        Stat stat = new Stat();
                        byte[] data = ZkStateReader.this.getZkClient().getData(ZkStateReader.SOLR_SECURITY_CONF_PATH, thisWatch, stat, true);
                        try {
                            callback.call(new Pair<byte[], Stat>(data, stat));
                        }
                        catch (Exception e) {
                            LOG.error("Error running collections node listener", (Throwable)e);
                        }
                    }
                }
                catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                    LOG.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
                }
                catch (KeeperException e) {
                    LOG.error("A ZK error has occurred", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    LOG.warn("Interrupted", (Throwable)e);
                }
            }
        }, true);
    }

    private void constructState() {
        LinkedHashMap<String, ClusterState.CollectionRef> result = new LinkedHashMap<String, ClusterState.CollectionRef>(this.legacyCollectionStates);
        for (Map.Entry<String, DocCollection> entry : this.watchedCollectionStates.entrySet()) {
            result.putIfAbsent(entry.getKey(), new ClusterState.CollectionRef(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.lazyCollectionStates.entrySet()) {
            result.putIfAbsent(entry.getKey(), (ClusterState.CollectionRef)entry.getValue());
        }
        this.clusterState = new ClusterState(this.liveNodes, result, this.legacyClusterStateVersion);
        LOG.debug("clusterStateSet: legacy [{}] interesting [{}] watched [{}] lazy [{}] total [{}]", new Object[]{this.legacyCollectionStates.keySet().size(), this.interestingCollections.size(), ((ConcurrentHashMap.CollectionView)((Object)this.watchedCollectionStates.keySet())).size(), ((ConcurrentHashMap.CollectionView)((Object)this.lazyCollectionStates.keySet())).size(), this.clusterState.getCollectionStates().size()});
        if (LOG.isTraceEnabled()) {
            LOG.trace("clusterStateSet: legacy [{}] interesting [{}] watched [{}] lazy [{}] total [{}]", new Object[]{this.legacyCollectionStates.keySet(), this.interestingCollections, this.watchedCollectionStates.keySet(), this.lazyCollectionStates.keySet(), this.clusterState.getCollectionStates()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLegacyClusterState(Watcher watcher) throws KeeperException, InterruptedException {
        try {
            Stat stat = new Stat();
            byte[] data = this.zkClient.getData(CLUSTER_STATE, watcher, stat, true);
            ClusterState loadedData = ClusterState.load(stat.getVersion(), data, Collections.emptySet(), CLUSTER_STATE);
            Object object = this.getUpdateLock();
            synchronized (object) {
                if (this.legacyClusterStateVersion >= stat.getVersion()) {
                    return;
                }
                this.legacyCollectionStates = loadedData.getCollectionStates();
                this.legacyClusterStateVersion = stat.getVersion();
            }
        }
        catch (KeeperException.NoNodeException e) {
            Object object = this.getUpdateLock();
            synchronized (object) {
                this.legacyCollectionStates = Collections.emptyMap();
                this.legacyClusterStateVersion = 0;
            }
        }
    }

    private void refreshStateFormat2Collections() {
        for (String coll : this.interestingCollections) {
            new StateWatcher(coll).refreshAndWatch(this.watchedCollectionStates.containsKey(coll));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCollectionList(Watcher watcher) throws KeeperException, InterruptedException {
        Object object = this.refreshCollectionListLock;
        synchronized (object) {
            List<String> children = null;
            try {
                children = this.zkClient.getChildren(COLLECTIONS_ZKNODE, watcher, true);
            }
            catch (KeeperException.NoNodeException e) {
                LOG.warn("Error fetching collection names: [{}]", (Object)e.getMessage());
            }
            if (children == null || children.isEmpty()) {
                this.lazyCollectionStates.clear();
                return;
            }
            ((ConcurrentHashMap.CollectionView)((Object)this.lazyCollectionStates.keySet())).retainAll(children);
            for (String coll : children) {
                LazyCollectionRef existing;
                if (this.interestingCollections.contains(coll) || (existing = this.lazyCollectionStates.get(coll)) != null) continue;
                this.lazyCollectionStates.putIfAbsent(coll, new LazyCollectionRef(coll));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLiveNodes(Watcher watcher) throws KeeperException, InterruptedException {
        Set<String> oldLiveNodes;
        Set newLiveNodes;
        Object object = this.refreshLiveNodesLock;
        synchronized (object) {
            try {
                List<String> nodeList = this.zkClient.getChildren(LIVE_NODES_ZKNODE, watcher, true);
                newLiveNodes = new HashSet<String>(nodeList);
            }
            catch (KeeperException.NoNodeException e) {
                newLiveNodes = Collections.emptySet();
            }
            this.lastFetchedLiveNodes.set(newLiveNodes);
        }
        Object object2 = this.getUpdateLock();
        synchronized (object2) {
            newLiveNodes = this.lastFetchedLiveNodes.getAndSet(null);
            if (newLiveNodes == null) {
                return;
            }
            oldLiveNodes = this.liveNodes;
            this.liveNodes = newLiveNodes;
            if (this.clusterState != null) {
                this.clusterState.setLiveNodes(newLiveNodes);
            }
        }
        LOG.info("Updated live nodes from ZooKeeper... ({}) -> ({})", (Object)oldLiveNodes.size(), (Object)newLiveNodes.size());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated live nodes from ZooKeeper... {} -> {}", new TreeSet<String>(oldLiveNodes), new TreeSet(newLiveNodes));
        }
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public Object getUpdateLock() {
        return this;
    }

    @Override
    public void close() {
        this.closed = true;
        if (this.closeClient) {
            this.zkClient.close();
        }
    }

    public String getLeaderUrl(String collection, String shard, int timeout) throws InterruptedException {
        ZkCoreNodeProps props = new ZkCoreNodeProps(this.getLeaderRetry(collection, shard, timeout));
        return props.getCoreUrl();
    }

    public Replica getLeader(String collection, String shard) {
        Replica replica;
        if (this.clusterState != null && (replica = this.clusterState.getLeader(collection, shard)) != null && this.getClusterState().liveNodesContain(replica.getNodeName())) {
            return replica;
        }
        return null;
    }

    public Replica getLeaderRetry(String collection, String shard) throws InterruptedException {
        return this.getLeaderRetry(collection, shard, 4000);
    }

    public Replica getLeaderRetry(String collection, String shard, int timeout) throws InterruptedException {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS);
        while (true) {
            Replica leader;
            if ((leader = this.getLeader(collection, shard)) != null) {
                return leader;
            }
            if (System.nanoTime() >= timeoutAt || this.closed) break;
            Thread.sleep(50L);
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No registered leader was found after waiting for " + timeout + "ms " + ", collection: " + collection + " slice: " + shard);
    }

    public static String getShardLeadersPath(String collection, String shardId) {
        return "/collections/" + collection + "/" + SHARD_LEADERS_ZKNODE + (shardId != null ? "/" + shardId : "") + "/leader";
    }

    public static String getShardLeadersElectPath(String collection, String shardId) {
        return "/collections/" + collection + "/" + LEADER_ELECT_ZKNODE + (shardId != null ? "/" + shardId + "/" + ELECTION_NODE : "");
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, Replica.State mustMatchStateFilter) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, mustMatchStateFilter, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, Replica.State mustMatchStateFilter, Replica.State mustNotMatchStateFilter) {
        assert (thisCoreNodeName != null);
        ClusterState clusterState = this.clusterState;
        if (clusterState == null) {
            return null;
        }
        Map<String, Slice> slices = clusterState.getSlicesMap(collection);
        if (slices == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + collection + " " + clusterState.getCollections());
        }
        Slice replicas = slices.get(shardId);
        if (replicas == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find shardId in zk: " + shardId);
        }
        Map<String, Replica> shardMap = replicas.getReplicasMap();
        ArrayList<ZkCoreNodeProps> nodes = new ArrayList<ZkCoreNodeProps>(shardMap.size());
        for (Map.Entry<String, Replica> entry : shardMap.entrySet()) {
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps(entry.getValue());
            String coreNodeName = entry.getValue().getName();
            if (!clusterState.liveNodesContain(nodeProps.getNodeName()) || coreNodeName.equals(thisCoreNodeName) || mustMatchStateFilter != null && mustMatchStateFilter != Replica.State.getState(nodeProps.getState()) || mustNotMatchStateFilter != null && mustNotMatchStateFilter == Replica.State.getState(nodeProps.getState())) continue;
            nodes.add(nodeProps);
        }
        if (nodes.size() == 0) {
            return null;
        }
        return nodes;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public void updateAliases() throws KeeperException, InterruptedException {
        byte[] data = this.zkClient.getData(ALIASES, null, null, true);
        this.aliases = ClusterState.load(data);
    }

    public Map getClusterProps() {
        try {
            if (this.getZkClient().exists(CLUSTER_PROPS, true).booleanValue()) {
                return (Map)Utils.fromJSON(this.getZkClient().getData(CLUSTER_PROPS, null, new Stat(), true));
            }
            return new LinkedHashMap();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Thread interrupted. Error reading cluster properties", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading cluster properties", (Throwable)e);
        }
    }

    public void setClusterProperty(String propertyName, String propertyValue) {
        if (!KNOWN_CLUSTER_PROPS.contains(propertyName)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Not a known cluster property " + propertyName);
        }
        while (true) {
            Stat s = new Stat();
            try {
                if (this.getZkClient().exists(CLUSTER_PROPS, true).booleanValue()) {
                    Map properties = (Map)Utils.fromJSON(this.getZkClient().getData(CLUSTER_PROPS, null, s, true));
                    if (propertyValue == null) {
                        if (properties.get(propertyName) == null) break;
                        properties.remove(propertyName);
                        this.getZkClient().setData(CLUSTER_PROPS, Utils.toJSON(properties), s.getVersion(), true);
                        break;
                    }
                    if (propertyValue.equals(properties.get(propertyName))) break;
                    properties.put(propertyName, propertyValue);
                    this.getZkClient().setData(CLUSTER_PROPS, Utils.toJSON(properties), s.getVersion(), true);
                    break;
                }
                LinkedHashMap<String, String> properties = new LinkedHashMap<String, String>();
                properties.put(propertyName, propertyValue);
                this.getZkClient().create(CLUSTER_PROPS, Utils.toJSON(properties), CreateMode.PERSISTENT, true);
            }
            catch (KeeperException.BadVersionException | KeeperException.NodeExistsException e) {
                LOG.warn("Race condition while trying to set a new cluster prop on current version [{}]", (Object)s.getVersion());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("Thread Interrupted. Error updating path [{}]", (Object)CLUSTER_PROPS, (Object)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Thread Interrupted. Error updating cluster property " + propertyName, (Throwable)e);
            }
            catch (KeeperException e) {
                LOG.error("Error updating path [{}]", (Object)CLUSTER_PROPS, (Object)e);
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error updating cluster property " + propertyName, (Throwable)e);
            }
            break;
        }
    }

    public ConfigData getSecurityProps(boolean getFresh) {
        if (!getFresh) {
            if (this.securityData == null) {
                return new ConfigData(Collections.EMPTY_MAP, -1);
            }
            return new ConfigData(this.securityData.data, this.securityData.version);
        }
        try {
            Stat stat = new Stat();
            if (this.getZkClient().exists(SOLR_SECURITY_CONF_PATH, true).booleanValue()) {
                byte[] data = this.getZkClient().getData(SOLR_SECURITY_CONF_PATH, null, stat, true);
                return data != null && data.length > 0 ? new ConfigData((Map)Utils.fromJSON(data), stat.getVersion()) : null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading security properties", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading security properties", (Throwable)e);
        }
        return null;
    }

    public String getBaseUrlForNodeName(String nodeName) {
        int _offset = nodeName.indexOf("_");
        if (_offset < 0) {
            throw new IllegalArgumentException("nodeName does not contain expected '_' seperator: " + nodeName);
        }
        String hostAndPort = nodeName.substring(0, _offset);
        try {
            String path = URLDecoder.decode(nodeName.substring(1 + _offset), "UTF-8");
            String urlScheme = (String)this.getClusterProps().get(URL_SCHEME);
            if (urlScheme == null) {
                urlScheme = "http";
            }
            return urlScheme + "://" + hostAndPort + (path.isEmpty() ? "" : "/" + path);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JVM Does not seem to support UTF-8", e);
        }
    }

    public static DocCollection getCollectionLive(ZkStateReader zkStateReader, String coll) {
        try {
            return zkStateReader.fetchCollectionState(coll, null);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not load collection from ZK: " + coll, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not load collection from ZK: " + coll, (Throwable)e);
        }
    }

    private DocCollection fetchCollectionState(String coll, Watcher watcher) throws KeeperException, InterruptedException {
        String collectionPath = ZkStateReader.getCollectionPath(coll);
        while (true) {
            try {
                Stat stat = new Stat();
                byte[] data = this.zkClient.getData(collectionPath, watcher, stat, true);
                ClusterState state = ClusterState.load(stat.getVersion(), data, Collections.emptySet(), collectionPath);
                ClusterState.CollectionRef collectionRef = state.getCollectionStates().get(coll);
                return collectionRef == null ? null : collectionRef.get();
            }
            catch (KeeperException.NoNodeException e) {
                Stat exists;
                if (watcher != null && (exists = this.zkClient.exists(collectionPath, watcher, true)) != null) continue;
                return null;
            }
            break;
        }
    }

    public static String getCollectionPath(String coll) {
        return "/collections/" + coll + "/state.json";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCollectionWatch(String coll) {
        if (this.interestingCollections.add(coll)) {
            LOG.info("addZkWatch [{}]", (Object)coll);
            new StateWatcher(coll).refreshAndWatch(false);
            Object object = this.getUpdateLock();
            synchronized (object) {
                this.constructState();
            }
        }
    }

    private void updateWatchedCollection(String coll, DocCollection newState) {
        if (newState == null) {
            LOG.info("Deleting data for [{}]", (Object)coll);
            this.watchedCollectionStates.remove(coll);
            return;
        }
        while (this.interestingCollections.contains(coll)) {
            DocCollection oldState = this.watchedCollectionStates.get(coll);
            if (oldState == null) {
                if (this.watchedCollectionStates.putIfAbsent(coll, newState) != null) continue;
                LOG.info("Add data for [{}] ver [{}]", (Object)coll, (Object)newState.getZNodeVersion());
                break;
            }
            if (oldState.getZNodeVersion() >= newState.getZNodeVersion()) break;
            if (!this.watchedCollectionStates.replace(coll, oldState, newState)) continue;
            LOG.info("Updating data for [{}] from [{}] to [{}]", new Object[]{coll, oldState.getZNodeVersion(), newState.getZNodeVersion()});
            break;
        }
        if (!this.interestingCollections.contains(coll)) {
            this.watchedCollectionStates.remove(coll);
            LOG.info("Removing uninteresting collection [{}]", (Object)coll);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeZKWatch(String coll) {
        LOG.info("Removing watch for uninteresting collection [{}]", (Object)coll);
        this.interestingCollections.remove(coll);
        this.watchedCollectionStates.remove(coll);
        this.lazyCollectionStates.put(coll, new LazyCollectionRef(coll));
        Object object = this.getUpdateLock();
        synchronized (object) {
            this.constructState();
        }
    }

    public static class ConfigData {
        public Map<String, Object> data;
        public int version;

        public ConfigData() {
        }

        public ConfigData(Map<String, Object> data, int version) {
            this.data = data;
            this.version = version;
        }
    }

    class LiveNodeWatcher
    implements Watcher {
        LiveNodeWatcher() {
        }

        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            LOG.info("A live node change: [{}], has occurred - updating... (live nodes size: [{}])", (Object)event, (Object)ZkStateReader.this.liveNodes.size());
            this.refreshAndWatch();
        }

        public void refreshAndWatch() {
            try {
                ZkStateReader.this.refreshLiveNodes(this);
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                LOG.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                LOG.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted", (Throwable)e);
            }
        }
    }

    class CollectionsChildWatcher
    implements Watcher {
        CollectionsChildWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            LOG.info("A collections change: [{}], has occurred - updating...", (Object)event);
            this.refreshAndWatch();
            Object object = ZkStateReader.this.getUpdateLock();
            synchronized (object) {
                ZkStateReader.this.constructState();
            }
        }

        public void refreshAndWatch() {
            try {
                ZkStateReader.this.refreshCollectionList(this);
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                LOG.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                LOG.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted", (Throwable)e);
            }
        }
    }

    class LegacyClusterStateWatcher
    implements Watcher {
        LegacyClusterStateWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            int liveNodesSize = ZkStateReader.this.clusterState == null ? 0 : ZkStateReader.this.clusterState.getLiveNodes().size();
            LOG.info("A cluster state change: [{}], has occurred - updating... (live nodes size: [{}])", (Object)event, (Object)liveNodesSize);
            this.refreshAndWatch();
            Object object = ZkStateReader.this.getUpdateLock();
            synchronized (object) {
                ZkStateReader.this.constructState();
            }
        }

        public void refreshAndWatch() {
            try {
                ZkStateReader.this.refreshLegacyClusterState(this);
            }
            catch (KeeperException.NoNodeException e) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot connect to cluster at " + ZkStateReader.this.zkClient.getZkServerAddress() + ": cluster not found/not ready");
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                LOG.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                LOG.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.warn("Interrupted", (Throwable)e);
            }
        }
    }

    class StateWatcher
    implements Watcher {
        private final String coll;

        StateWatcher(String coll) {
            this.coll = coll;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            if (!ZkStateReader.this.interestingCollections.contains(this.coll)) {
                LOG.info("Uninteresting collection {}", (Object)this.coll);
                return;
            }
            int liveNodesSize = ZkStateReader.this.clusterState == null ? 0 : ZkStateReader.this.clusterState.getLiveNodes().size();
            LOG.info("A cluster state change: [{}] for collection [{}] has occurred - updating... (live nodes size: [{}])", new Object[]{event, this.coll, liveNodesSize});
            this.refreshAndWatch(true);
            Object object = ZkStateReader.this.getUpdateLock();
            synchronized (object) {
                ZkStateReader.this.constructState();
            }
        }

        public void refreshAndWatch(boolean expectExists) {
            try {
                DocCollection newState = ZkStateReader.this.fetchCollectionState(this.coll, this);
                ZkStateReader.this.updateWatchedCollection(this.coll, newState);
            }
            catch (KeeperException.NoNodeException e) {
                if (expectExists) {
                    LOG.warn("State node vanished for collection: [{}]", (Object)this.coll, (Object)e);
                }
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                LOG.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                LOG.error("Unwatched collection: [{}]", (Object)this.coll, (Object)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOG.error("Unwatched collection: [{}]", (Object)this.coll, (Object)e);
            }
        }
    }

    private class LazyCollectionRef
    extends ClusterState.CollectionRef {
        private final String collName;

        public LazyCollectionRef(String collName) {
            super(null);
            this.collName = collName;
        }

        @Override
        public DocCollection get() {
            return ZkStateReader.getCollectionLive(ZkStateReader.this, this.collName);
        }

        @Override
        public boolean isLazilyLoaded() {
            return true;
        }

        @Override
        public String toString() {
            return "LazyCollectionRef(" + this.collName + ")";
        }
    }
}

