/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrServer;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.zookeeper.KeeperException;
import org.eclipse.jetty.servlet.FilterHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaosMonkey {
    private static Logger log = LoggerFactory.getLogger(ChaosMonkey.class);
    private static final int CONLOSS_PERCENT = 10;
    private static final int EXPIRE_PERCENT = 10;
    private Map<String, List<AbstractFullDistribZkTestBase.CloudJettyRunner>> shardToJetty;
    private static final Boolean MONKEY_ENABLED = Boolean.valueOf(System.getProperty("solr.tests.cloud.cm.enabled", "true"));
    private static final Boolean CONN_LOSS = Boolean.valueOf(System.getProperty("solr.tests.cloud.cm.connloss", null));
    private static final Boolean EXP = Boolean.valueOf(System.getProperty("solr.tests.cloud.cm.exp", null));
    private ZkTestServer zkServer;
    private ZkStateReader zkStateReader;
    private String collection;
    private volatile boolean stop = false;
    private AtomicInteger stops = new AtomicInteger();
    private AtomicInteger starts = new AtomicInteger();
    private AtomicInteger expires = new AtomicInteger();
    private AtomicInteger connloss = new AtomicInteger();
    private Map<String, List<SolrServer>> shardToClient;
    private boolean expireSessions;
    private boolean causeConnectionLoss;
    private boolean aggressivelyKillLeaders;
    private Map<String, AbstractFullDistribZkTestBase.CloudJettyRunner> shardToLeaderJetty;
    private long startTime;
    private Thread monkeyThread;

    public ChaosMonkey(ZkTestServer zkServer, ZkStateReader zkStateReader, String collection, Map<String, List<AbstractFullDistribZkTestBase.CloudJettyRunner>> shardToJetty, Map<String, AbstractFullDistribZkTestBase.CloudJettyRunner> shardToLeaderJetty) {
        this.shardToJetty = shardToJetty;
        this.shardToLeaderJetty = shardToLeaderJetty;
        this.zkServer = zkServer;
        this.zkStateReader = zkStateReader;
        this.collection = collection;
        if (!MONKEY_ENABLED.booleanValue()) {
            ChaosMonkey.monkeyLog("The Monkey is Disabled and will not run");
            return;
        }
        Random random = LuceneTestCase.random();
        this.expireSessions = EXP != null ? EXP.booleanValue() : random.nextBoolean();
        this.causeConnectionLoss = CONN_LOSS != null ? CONN_LOSS.booleanValue() : random.nextBoolean();
        ChaosMonkey.monkeyLog("init - expire sessions:" + this.expireSessions + " cause connection loss:" + this.causeConnectionLoss);
    }

    public void expireSession(JettySolrRunner jetty) {
        CoreContainer cores;
        ChaosMonkey.monkeyLog("expire session for " + jetty.getLocalPort() + " !");
        SolrDispatchFilter solrDispatchFilter = (SolrDispatchFilter)jetty.getDispatchFilter().getFilter();
        if (solrDispatchFilter != null && (cores = solrDispatchFilter.getCores()) != null) {
            ChaosMonkey.causeConnectionLoss(jetty, cores.getZkController().getClientTimeout() + 200);
        }
    }

    public void expireRandomSession() throws KeeperException, InterruptedException {
        String sliceName = this.getRandomSlice();
        AbstractFullDistribZkTestBase.CloudJettyRunner jetty = this.getRandomJetty(sliceName, this.aggressivelyKillLeaders);
        if (jetty != null) {
            this.expireSession(jetty.jetty);
            this.expires.incrementAndGet();
        }
    }

    public void randomConnectionLoss() throws KeeperException, InterruptedException {
        ChaosMonkey.monkeyLog("cause connection loss!");
        String sliceName = this.getRandomSlice();
        AbstractFullDistribZkTestBase.CloudJettyRunner jetty = this.getRandomJetty(sliceName, this.aggressivelyKillLeaders);
        if (jetty != null) {
            ChaosMonkey.causeConnectionLoss(jetty.jetty);
            this.connloss.incrementAndGet();
        }
    }

    public static void causeConnectionLoss(JettySolrRunner jetty) {
        ChaosMonkey.causeConnectionLoss(jetty, 2200);
    }

    public static void causeConnectionLoss(JettySolrRunner jetty, int pauseTime) {
        CoreContainer cores;
        SolrDispatchFilter solrDispatchFilter = (SolrDispatchFilter)jetty.getDispatchFilter().getFilter();
        if (solrDispatchFilter != null && (cores = solrDispatchFilter.getCores()) != null) {
            SolrZkClient zkClient = cores.getZkController().getZkClient();
            zkClient.getSolrZooKeeper().pauseCnxn((long)pauseTime);
        }
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner stopShard(String slice, int index) throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = this.shardToJetty.get(slice).get(index);
        this.stopJetty(cjetty);
        return cjetty;
    }

    public void stopJetty(AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) throws Exception {
        ChaosMonkey.stop(cjetty.jetty);
        this.stops.incrementAndGet();
    }

    public void killJetty(AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) throws Exception {
        ChaosMonkey.kill(cjetty);
        this.stops.incrementAndGet();
    }

    public void stopJetty(JettySolrRunner jetty) throws Exception {
        this.stops.incrementAndGet();
        ChaosMonkey.stopJettySolrRunner(jetty);
    }

    private static void stopJettySolrRunner(JettySolrRunner jetty) throws Exception {
        SolrDispatchFilter sdf;
        assert (jetty != null);
        ChaosMonkey.monkeyLog("stop shard! " + jetty.getLocalPort());
        FilterHolder fh = jetty.getDispatchFilter();
        if (fh != null && (sdf = (SolrDispatchFilter)fh.getFilter()) != null) {
            sdf.destroy();
        }
        jetty.stop();
        if (!jetty.isStopped()) {
            throw new RuntimeException("could not stop jetty");
        }
    }

    public static void kill(AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) throws Exception {
        JettySolrRunner jetty = cjetty.jetty;
        ChaosMonkey.monkeyLog("kill shard! " + jetty.getLocalPort());
        jetty.stop();
        ChaosMonkey.stop(jetty);
        if (!jetty.isStopped()) {
            throw new RuntimeException("could not kill jetty");
        }
    }

    public void stopShard(String slice) throws Exception {
        List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(slice);
        for (AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
            this.stopJetty(jetty);
        }
    }

    public void stopShardExcept(String slice, String shardName) throws Exception {
        List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(slice);
        for (AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
            if (jetty.nodeName.equals(shardName)) continue;
            this.stopJetty(jetty);
        }
    }

    public JettySolrRunner getShard(String slice, int index) throws Exception {
        JettySolrRunner jetty = this.shardToJetty.get((Object)slice).get((int)index).jetty;
        return jetty;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner stopRandomShard() throws Exception {
        String sliceName = this.getRandomSlice();
        return this.stopRandomShard(sliceName);
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner stopRandomShard(String slice) throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = this.getRandomJetty(slice, this.aggressivelyKillLeaders);
        if (cjetty != null) {
            this.stopJetty(cjetty);
        }
        return cjetty;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner killRandomShard() throws Exception {
        String sliceName = this.getRandomSlice();
        return this.killRandomShard(sliceName);
    }

    private String getRandomSlice() {
        Map slices = this.zkStateReader.getClusterState().getSlicesMap(this.collection);
        ArrayList sliceKeyList = new ArrayList(slices.size());
        sliceKeyList.addAll(slices.keySet());
        String sliceName = (String)sliceKeyList.get(LuceneTestCase.random().nextInt(sliceKeyList.size()));
        return sliceName;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner killRandomShard(String slice) throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = this.getRandomJetty(slice, this.aggressivelyKillLeaders);
        if (cjetty != null) {
            this.killJetty(cjetty);
        }
        return cjetty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFullDistribZkTestBase.CloudJettyRunner getRandomJetty(String slice, boolean aggressivelyKillLeaders) throws KeeperException, InterruptedException {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty;
        int numRunning = 0;
        int numRecovering = 0;
        int numActive = 0;
        for (AbstractFullDistribZkTestBase.CloudJettyRunner cloudJetty : this.shardToJetty.get(slice)) {
            boolean running = true;
            this.zkStateReader.updateClusterState(true);
            Slice theShards = (Slice)this.zkStateReader.getClusterState().getSlicesMap(this.collection).get(slice);
            ZkNodeProps props = (ZkNodeProps)theShards.getReplicasMap().get(cloudJetty.coreNodeName);
            if (props == null) {
                throw new RuntimeException("shard name " + cloudJetty.coreNodeName + " not found in " + theShards.getReplicasMap().keySet());
            }
            String state = props.getStr("state");
            String nodeName = props.getStr("node_name");
            if (!(cloudJetty.jetty.isRunning() && state.equals("active") && this.zkStateReader.getClusterState().liveNodesContain(nodeName))) {
                running = false;
            }
            if (cloudJetty.jetty.isRunning() && state.equals("recovering") && this.zkStateReader.getClusterState().liveNodesContain(nodeName)) {
                ++numRecovering;
            }
            if (cloudJetty.jetty.isRunning() && state.equals("active") && this.zkStateReader.getClusterState().liveNodesContain(nodeName)) {
                ++numActive;
            }
            if (!running) continue;
            ++numRunning;
        }
        if (numActive < 2) {
            ChaosMonkey.monkeyLog("only one active node in shard - monkey cannot kill :(");
            return null;
        }
        Random random = LuceneTestCase.random();
        int chance = random.nextInt(10);
        if (chance <= 5 && aggressivelyKillLeaders) {
            cjetty = this.shardToLeaderJetty.get(slice);
        } else {
            boolean isLeader;
            boolean rtIsLeader;
            List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(slice);
            int index = random.nextInt(jetties.size());
            cjetty = jetties.get(index);
            Replica leader = null;
            try {
                leader = this.zkStateReader.getLeaderRetry(this.collection, slice);
            }
            catch (Throwable t) {
                log.error("Could not get leader", t);
                return null;
            }
            FilterHolder fh = cjetty.jetty.getDispatchFilter();
            if (fh == null) {
                ChaosMonkey.monkeyLog("selected jetty not running correctly - skip");
                return null;
            }
            SolrDispatchFilter df = (SolrDispatchFilter)fh.getFilter();
            if (df == null) {
                ChaosMonkey.monkeyLog("selected jetty not running correctly - skip");
                return null;
            }
            CoreContainer cores = df.getCores();
            if (cores == null) {
                ChaosMonkey.monkeyLog("selected jetty not running correctly - skip");
                return null;
            }
            SolrCore core = cores.getCore(leader.getStr("core"));
            if (core == null) {
                ChaosMonkey.monkeyLog("selected jetty not running correctly - skip");
                return null;
            }
            try {
                rtIsLeader = core.getCoreDescriptor().getCloudDescriptor().isLeader();
            }
            finally {
                core.close();
            }
            boolean bl = isLeader = leader.getStr("node_name").equals(jetties.get((int)index).nodeName) || rtIsLeader;
            if (!aggressivelyKillLeaders && isLeader) {
                ChaosMonkey.monkeyLog("abort! I don't kill leaders");
                return null;
            }
        }
        if (cjetty.jetty.getLocalPort() == -1) {
            ChaosMonkey.monkeyLog("abort! This guy is already dead");
            return null;
        }
        ChaosMonkey.monkeyLog("chose a victim! " + cjetty.jetty.getLocalPort());
        return cjetty;
    }

    public SolrServer getRandomClient(String slice) throws KeeperException, InterruptedException {
        this.zkStateReader.updateClusterState(true);
        List<SolrServer> clients = this.shardToClient.get(slice);
        int index = LuceneTestCase.random().nextInt(clients.size() - 1);
        SolrServer client = clients.get(index);
        return client;
    }

    public void startTheMonkey(boolean killLeaders, final int roundPauseUpperLimit) {
        if (!MONKEY_ENABLED.booleanValue()) {
            ChaosMonkey.monkeyLog("The Monkey is disabled and will not start");
            return;
        }
        ChaosMonkey.monkeyLog("starting");
        this.aggressivelyKillLeaders = killLeaders;
        this.startTime = System.currentTimeMillis();
        this.stop = false;
        this.monkeyThread = new Thread(){
            private List<AbstractFullDistribZkTestBase.CloudJettyRunner> deadPool = new ArrayList<AbstractFullDistribZkTestBase.CloudJettyRunner>();

            @Override
            public void run() {
                while (!ChaosMonkey.this.stop) {
                    try {
                        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty;
                        Random random = LuceneTestCase.random();
                        Thread.sleep(random.nextInt(roundPauseUpperLimit));
                        if (random.nextBoolean() && !this.deadPool.isEmpty()) {
                            int index = random.nextInt(this.deadPool.size());
                            JettySolrRunner jetty = this.deadPool.get((int)index).jetty;
                            if (!ChaosMonkey.start(jetty)) continue;
                            this.deadPool.remove(index);
                            ChaosMonkey.this.starts.incrementAndGet();
                            continue;
                        }
                        int rnd = random.nextInt(10);
                        if (ChaosMonkey.this.expireSessions && rnd < 10) {
                            ChaosMonkey.this.expireRandomSession();
                        }
                        if (ChaosMonkey.this.causeConnectionLoss && rnd < 10) {
                            ChaosMonkey.this.randomConnectionLoss();
                        }
                        if ((cjetty = random.nextBoolean() ? ChaosMonkey.this.stopRandomShard() : ChaosMonkey.this.killRandomShard()) == null) continue;
                        this.deadPool.add(cjetty);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ChaosMonkey.monkeyLog("finished");
                ChaosMonkey.monkeyLog("I ran for " + (float)(System.currentTimeMillis() - ChaosMonkey.this.startTime) / 1000.0f + "sec. I stopped " + ChaosMonkey.this.stops + " and I started " + ChaosMonkey.this.starts + ". I also expired " + ChaosMonkey.this.expires.get() + " and caused " + ChaosMonkey.this.connloss + " connection losses");
            }
        };
        this.monkeyThread.start();
    }

    public static void monkeyLog(String msg) {
        log.info("monkey: " + msg);
    }

    public void stopTheMonkey() {
        this.stop = true;
        try {
            this.monkeyThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public int getStarts() {
        return this.starts.get();
    }

    public static void stop(JettySolrRunner jetty) throws Exception {
        ChaosMonkey.stopJettySolrRunner(jetty);
    }

    public static boolean start(JettySolrRunner jetty) throws Exception {
        try {
            jetty.start();
        }
        catch (Exception e) {
            jetty.stop();
            Thread.sleep(2000L);
            try {
                jetty.start();
            }
            catch (Exception e2) {
                jetty.stop();
                Thread.sleep(5000L);
                try {
                    jetty.start();
                }
                catch (Exception e3) {
                    log.error("Could not get the port to start jetty again", (Throwable)e3);
                    jetty.stop();
                    return false;
                }
            }
        }
        return true;
    }
}

