/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.lucene.util.LuceneTestCase;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.cloud.AbstractFullDistribZkTestBase;
import org.apache.solr.cloud.IpTables;
import org.apache.solr.cloud.ZkTestServer;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZkStateReader;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.SolrCore;
import org.apache.solr.servlet.SolrDispatchFilter;
import org.apache.solr.update.DirectUpdateHandler2;
import org.apache.solr.util.RTimer;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChaosMonkey {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int CONLOSS_PERCENT = 10;
    private static final int EXPIRE_PERCENT = 10;
    private Map<String, List<AbstractFullDistribZkTestBase.CloudJettyRunner>> shardToJetty;
    private static final Boolean MONKEY_ENABLED = Boolean.valueOf(System.getProperty("solr.tests.cloud.cm.enabled", "true"));
    private static final Boolean CONN_LOSS = Boolean.valueOf(System.getProperty("solr.tests.cloud.cm.connloss", null));
    private static final Boolean EXP = Boolean.valueOf(System.getProperty("solr.tests.cloud.cm.exp", null));
    private ZkTestServer zkServer;
    private ZkStateReader zkStateReader;
    private String collection;
    private volatile boolean stop = false;
    private AtomicInteger stops = new AtomicInteger();
    private AtomicInteger starts = new AtomicInteger();
    private AtomicInteger expires = new AtomicInteger();
    private AtomicInteger connloss = new AtomicInteger();
    private Map<String, List<SolrClient>> shardToClient;
    private boolean expireSessions;
    private boolean causeConnectionLoss;
    private boolean aggressivelyKillLeaders;
    private Map<String, AbstractFullDistribZkTestBase.CloudJettyRunner> shardToLeaderJetty;
    private volatile RTimer runTimer;
    private List<AbstractFullDistribZkTestBase.CloudJettyRunner> deadPool = new ArrayList<AbstractFullDistribZkTestBase.CloudJettyRunner>();
    private Thread monkeyThread;

    public ChaosMonkey(ZkTestServer zkServer, ZkStateReader zkStateReader, String collection, Map<String, List<AbstractFullDistribZkTestBase.CloudJettyRunner>> shardToJetty, Map<String, AbstractFullDistribZkTestBase.CloudJettyRunner> shardToLeaderJetty) {
        this.shardToJetty = shardToJetty;
        this.shardToLeaderJetty = shardToLeaderJetty;
        this.zkServer = zkServer;
        this.zkStateReader = zkStateReader;
        this.collection = collection;
        if (!MONKEY_ENABLED.booleanValue()) {
            ChaosMonkey.monkeyLog("The Monkey is Disabled and will not run");
            return;
        }
        Random random = LuceneTestCase.random();
        this.expireSessions = EXP != null ? EXP.booleanValue() : random.nextBoolean();
        this.causeConnectionLoss = CONN_LOSS != null ? CONN_LOSS.booleanValue() : random.nextBoolean();
        ChaosMonkey.monkeyLog("init - expire sessions:" + this.expireSessions + " cause connection loss:" + this.causeConnectionLoss);
    }

    public void expireSession(JettySolrRunner jetty) {
        ChaosMonkey.monkeyLog("expire session for " + jetty.getLocalPort() + " !");
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null) {
            ChaosMonkey.causeConnectionLoss(jetty);
            long sessionId = cores.getZkController().getZkClient().getSolrZooKeeper().getSessionId();
            this.zkServer.expire(sessionId);
        }
    }

    public void expireRandomSession() throws KeeperException, InterruptedException {
        String sliceName = this.getRandomSlice();
        AbstractFullDistribZkTestBase.CloudJettyRunner jetty = this.getRandomJetty(sliceName, this.aggressivelyKillLeaders);
        if (jetty != null) {
            this.expireSession(jetty.jetty);
            this.expires.incrementAndGet();
        }
    }

    public void randomConnectionLoss() throws KeeperException, InterruptedException {
        ChaosMonkey.monkeyLog("cause connection loss!");
        String sliceName = this.getRandomSlice();
        AbstractFullDistribZkTestBase.CloudJettyRunner jetty = this.getRandomJetty(sliceName, this.aggressivelyKillLeaders);
        if (jetty != null) {
            ChaosMonkey.causeConnectionLoss(jetty.jetty);
            this.connloss.incrementAndGet();
        }
    }

    public static void causeConnectionLoss(JettySolrRunner jetty) {
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null) {
            SolrZkClient zkClient = cores.getZkController().getZkClient();
            zkClient.getSolrZooKeeper().closeCnxn();
        }
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner stopShard(String slice, int index) throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = this.shardToJetty.get(slice).get(index);
        this.stopJetty(cjetty);
        return cjetty;
    }

    public void stopJetty(AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) throws Exception {
        ChaosMonkey.stop(cjetty.jetty);
        this.stops.incrementAndGet();
    }

    public void killJetty(AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) throws Exception {
        ChaosMonkey.kill(cjetty);
        this.stops.incrementAndGet();
    }

    public void stopJetty(JettySolrRunner jetty) throws Exception {
        this.stops.incrementAndGet();
        ChaosMonkey.stopJettySolrRunner(jetty);
    }

    private static void stopJettySolrRunner(JettySolrRunner jetty) throws Exception {
        assert (jetty != null);
        ChaosMonkey.monkeyLog("stop shard! " + jetty.getLocalPort());
        SolrDispatchFilter sdf = jetty.getSolrDispatchFilter();
        if (sdf != null) {
            sdf.destroy();
        }
        jetty.stop();
        if (!jetty.isStopped()) {
            throw new RuntimeException("could not stop jetty");
        }
    }

    public static void kill(List<JettySolrRunner> jettys) throws Exception {
        for (JettySolrRunner jetty : jettys) {
            ChaosMonkey.kill(jetty);
        }
    }

    public static void kill(JettySolrRunner jetty) throws Exception {
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null && cores.isZooKeeperAware()) {
            int zklocalport = ((InetSocketAddress)cores.getZkController().getZkClient().getSolrZooKeeper().getSocketAddress()).getPort();
            IpTables.blockPort(zklocalport);
        }
        IpTables.blockPort(jetty.getLocalPort());
        ChaosMonkey.monkeyLog("kill shard! " + jetty.getLocalPort());
        jetty.stop();
        ChaosMonkey.stop(jetty);
        if (!jetty.isStopped()) {
            throw new RuntimeException("could not kill jetty");
        }
    }

    public static void kill(AbstractFullDistribZkTestBase.CloudJettyRunner cjetty) throws Exception {
        ChaosMonkey.kill(cjetty.jetty);
    }

    public void stopAll(int pauseBetweenMs) throws Exception {
        Set<String> keys = this.shardToJetty.keySet();
        for (String key : keys) {
            List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(key);
            for (AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
                Thread.sleep(pauseBetweenMs);
                this.stopJetty(jetty);
            }
        }
    }

    public void startAll() throws Exception {
        Set<String> keys = this.shardToJetty.keySet();
        for (String key : keys) {
            List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(key);
            for (AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
                ChaosMonkey.start(jetty.jetty);
            }
        }
    }

    public void stopShard(String slice) throws Exception {
        List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(slice);
        for (AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
            this.stopJetty(jetty);
        }
    }

    public void stopShardExcept(String slice, String shardName) throws Exception {
        List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(slice);
        for (AbstractFullDistribZkTestBase.CloudJettyRunner jetty : jetties) {
            if (jetty.nodeName.equals(shardName)) continue;
            this.stopJetty(jetty);
        }
    }

    public JettySolrRunner getShard(String slice, int index) throws Exception {
        JettySolrRunner jetty = this.shardToJetty.get((Object)slice).get((int)index).jetty;
        return jetty;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner stopRandomShard() throws Exception {
        String sliceName = this.getRandomSlice();
        return this.stopRandomShard(sliceName);
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner stopRandomShard(String slice) throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = this.getRandomJetty(slice, this.aggressivelyKillLeaders);
        if (cjetty != null) {
            this.stopJetty(cjetty);
        }
        return cjetty;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner killRandomShard() throws Exception {
        String sliceName = this.getRandomSlice();
        return this.killRandomShard(sliceName);
    }

    private String getRandomSlice() {
        Map slices = this.zkStateReader.getClusterState().getSlicesMap(this.collection);
        ArrayList sliceKeyList = new ArrayList(slices.size());
        sliceKeyList.addAll(slices.keySet());
        String sliceName = (String)sliceKeyList.get(LuceneTestCase.random().nextInt(sliceKeyList.size()));
        return sliceName;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner killRandomShard(String slice) throws Exception {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty = this.getRandomJetty(slice, this.aggressivelyKillLeaders);
        if (cjetty != null) {
            this.killJetty(cjetty);
        }
        return cjetty;
    }

    public AbstractFullDistribZkTestBase.CloudJettyRunner getRandomJetty(String slice, boolean aggressivelyKillLeaders) throws KeeperException, InterruptedException {
        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty;
        int numActive = 0;
        if ((numActive = this.checkIfKillIsLegal(slice, numActive)) < 2) {
            ChaosMonkey.monkeyLog("only one active node in shard - monkey cannot kill :(");
            return null;
        }
        int numRunning = 0;
        for (AbstractFullDistribZkTestBase.CloudJettyRunner cjetty2 : this.shardToJetty.get(slice)) {
            if (this.deadPool.contains(cjetty2)) continue;
            ++numRunning;
        }
        if (numRunning < 2) {
            ChaosMonkey.monkeyLog("only one active node in shard - monkey cannot kill :(");
            return null;
        }
        Random random = LuceneTestCase.random();
        int chance = random.nextInt(10);
        if (chance <= 5 && aggressivelyKillLeaders) {
            cjetty = this.shardToLeaderJetty.get(slice);
        } else {
            boolean isLeader;
            boolean rtIsLeader;
            List<AbstractFullDistribZkTestBase.CloudJettyRunner> jetties = this.shardToJetty.get(slice);
            int index = random.nextInt(jetties.size());
            cjetty = jetties.get(index);
            Replica leader = null;
            try {
                leader = this.zkStateReader.getLeaderRetry(this.collection, slice);
            }
            catch (Throwable t) {
                log.error("Could not get leader", t);
                return null;
            }
            try (SolrCore core = cjetty.jetty.getCoreContainer().getCore(leader.getStr("core"));){
                if (core == null) {
                    ChaosMonkey.monkeyLog("selected jetty not running correctly - skip");
                    AbstractFullDistribZkTestBase.CloudJettyRunner cloudJettyRunner = null;
                    return cloudJettyRunner;
                }
                rtIsLeader = core.getCoreDescriptor().getCloudDescriptor().isLeader();
            }
            boolean bl = isLeader = leader.getStr("node_name").equals(jetties.get((int)index).nodeName) || rtIsLeader;
            if (!aggressivelyKillLeaders && isLeader) {
                ChaosMonkey.monkeyLog("abort! I don't kill leaders");
                return null;
            }
        }
        if (cjetty.jetty.getLocalPort() == -1) {
            ChaosMonkey.monkeyLog("abort! This guy is already dead");
            return null;
        }
        ChaosMonkey.monkeyLog("chose a victim! " + cjetty.jetty.getLocalPort());
        return cjetty;
    }

    private int checkIfKillIsLegal(String slice, int numActive) throws KeeperException, InterruptedException {
        for (AbstractFullDistribZkTestBase.CloudJettyRunner cloudJetty : this.shardToJetty.get(slice)) {
            this.zkStateReader.updateClusterState();
            Slice theShards = (Slice)this.zkStateReader.getClusterState().getSlicesMap(this.collection).get(slice);
            ZkNodeProps props = (ZkNodeProps)theShards.getReplicasMap().get(cloudJetty.coreNodeName);
            if (props == null) {
                throw new RuntimeException("shard name " + cloudJetty.coreNodeName + " not found in " + theShards.getReplicasMap().keySet());
            }
            Replica.State state = Replica.State.getState((String)props.getStr("state"));
            String nodeName = props.getStr("node_name");
            if (!cloudJetty.jetty.isRunning() || state != Replica.State.ACTIVE || !this.zkStateReader.getClusterState().liveNodesContain(nodeName)) continue;
            ++numActive;
        }
        return numActive;
    }

    public SolrClient getRandomClient(String slice) throws KeeperException, InterruptedException {
        this.zkStateReader.updateClusterState();
        List<SolrClient> clients = this.shardToClient.get(slice);
        int index = LuceneTestCase.random().nextInt(clients.size() - 1);
        SolrClient client = clients.get(index);
        return client;
    }

    public void startTheMonkey(boolean killLeaders, final int roundPauseUpperLimit) {
        if (!MONKEY_ENABLED.booleanValue()) {
            ChaosMonkey.monkeyLog("The Monkey is disabled and will not start");
            return;
        }
        ChaosMonkey.monkeyLog("starting");
        if (LuceneTestCase.random().nextBoolean()) {
            ChaosMonkey.monkeyLog("Jetty will not commit on close");
            DirectUpdateHandler2.commitOnClose = false;
        }
        this.aggressivelyKillLeaders = killLeaders;
        this.runTimer = new RTimer();
        this.stop = false;
        this.monkeyThread = new Thread(){

            @Override
            public void run() {
                while (!ChaosMonkey.this.stop) {
                    try {
                        AbstractFullDistribZkTestBase.CloudJettyRunner cjetty;
                        Random random = LuceneTestCase.random();
                        Thread.sleep(random.nextInt(roundPauseUpperLimit));
                        if (random.nextBoolean() && !ChaosMonkey.this.deadPool.isEmpty()) {
                            int index = random.nextInt(ChaosMonkey.this.deadPool.size());
                            JettySolrRunner jetty = ((AbstractFullDistribZkTestBase.CloudJettyRunner)((ChaosMonkey)ChaosMonkey.this).deadPool.get((int)index)).jetty;
                            if (jetty.isStopped() && !ChaosMonkey.start(jetty)) continue;
                            ChaosMonkey.this.deadPool.remove(index);
                            ChaosMonkey.this.starts.incrementAndGet();
                            continue;
                        }
                        int rnd = random.nextInt(10);
                        if (ChaosMonkey.this.expireSessions && rnd < 10) {
                            ChaosMonkey.this.expireRandomSession();
                        }
                        if (ChaosMonkey.this.causeConnectionLoss && rnd < 10) {
                            ChaosMonkey.this.randomConnectionLoss();
                        }
                        if ((cjetty = random.nextBoolean() ? ChaosMonkey.this.stopRandomShard() : ChaosMonkey.this.killRandomShard()) == null) continue;
                        ChaosMonkey.this.deadPool.add(cjetty);
                    }
                    catch (InterruptedException e) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ChaosMonkey.monkeyLog("finished");
                ChaosMonkey.monkeyLog("I ran for " + ChaosMonkey.this.runTimer.getTime() / 1000.0 + "s. I stopped " + ChaosMonkey.this.stops + " and I started " + ChaosMonkey.this.starts + ". I also expired " + ChaosMonkey.this.expires.get() + " and caused " + ChaosMonkey.this.connloss + " connection losses");
            }
        };
        this.monkeyThread.start();
    }

    public static void monkeyLog(String msg) {
        log.info("monkey: " + msg);
    }

    public void stopTheMonkey() {
        this.stop = true;
        try {
            this.monkeyThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.runTimer.stop();
        DirectUpdateHandler2.commitOnClose = true;
        double runtime = this.runTimer.getTime() / 1000.0;
        if (runtime > 45.0 && this.stops.get() == 0) {
            LuceneTestCase.fail((String)"The Monkey ran for over 45 seconds and no jetties were stopped - this is worth investigating!");
        }
    }

    public int getStarts() {
        return this.starts.get();
    }

    public static void stop(List<JettySolrRunner> jettys) throws Exception {
        for (JettySolrRunner jetty : jettys) {
            ChaosMonkey.stop(jetty);
        }
    }

    public static void stop(JettySolrRunner jetty) throws Exception {
        ChaosMonkey.stopJettySolrRunner(jetty);
    }

    public static void start(List<JettySolrRunner> jettys) throws Exception {
        for (JettySolrRunner jetty : jettys) {
            ChaosMonkey.start(jetty);
        }
    }

    public static boolean start(JettySolrRunner jetty) throws Exception {
        IpTables.unblockPort(jetty.getLocalPort());
        try {
            jetty.start();
        }
        catch (Exception e) {
            jetty.stop();
            Thread.sleep(3000L);
            try {
                jetty.start();
            }
            catch (Exception e2) {
                jetty.stop();
                Thread.sleep(10000L);
                try {
                    jetty.start();
                }
                catch (Exception e3) {
                    jetty.stop();
                    Thread.sleep(30000L);
                    try {
                        jetty.start();
                    }
                    catch (Exception e4) {
                        log.error("Could not get the port to start jetty again", (Throwable)e4);
                        jetty.stop();
                        return false;
                    }
                }
            }
        }
        CoreContainer cores = jetty.getCoreContainer();
        if (cores != null && cores.isZooKeeperAware()) {
            int zklocalport = ((InetSocketAddress)cores.getZkController().getZkClient().getSolrZooKeeper().getSocketAddress()).getPort();
            IpTables.unblockPort(zklocalport);
        }
        return true;
    }
}

