/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.solr.SolrTestCaseJ4;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.embedded.JettyConfig;
import org.apache.solr.client.solrj.embedded.JettySolrRunner;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.request.CoreAdminRequest;
import org.apache.solr.client.solrj.request.CoreStatus;
import org.apache.solr.cloud.MiniSolrCloudCluster;
import org.apache.solr.common.cloud.ClusterProperties;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.junit.AfterClass;
import org.junit.Before;

public class SolrCloudTestCase
extends SolrTestCaseJ4 {
    public static final int DEFAULT_TIMEOUT = 30;
    protected static MiniSolrCloudCluster cluster;

    protected SolrZkClient zkClient() {
        return cluster.getSolrClient().getZkStateReader().getZkClient();
    }

    protected static Builder configureCluster(int nodeCount) {
        return new Builder(nodeCount, SolrCloudTestCase.createTempDir());
    }

    @AfterClass
    public static void shutdownCluster() throws Exception {
        if (cluster != null) {
            cluster.shutdown();
        }
        cluster = null;
    }

    @Before
    public void checkClusterConfiguration() {
        if (cluster == null) {
            throw new RuntimeException("MiniSolrCloudCluster not configured - have you called configureCluster().configure()?");
        }
    }

    protected DocCollection getCollectionState(String collectionName) {
        return cluster.getSolrClient().getZkStateReader().getClusterState().getCollection(collectionName);
    }

    protected void waitForState(String message, String collection, CollectionStatePredicate predicate) {
        AtomicReference state = new AtomicReference();
        try {
            cluster.getSolrClient().waitForState(collection, 30L, TimeUnit.SECONDS, (n, c) -> {
                state.set(c);
                return predicate.matches(n, c);
            });
        }
        catch (Exception e) {
            SolrCloudTestCase.fail((String)(message + "\n" + e.getMessage() + "\nLast available state: " + state.get()));
        }
    }

    public static CollectionStatePredicate clusterShape(int expectedShards, int expectedReplicas) {
        return (liveNodes, collectionState) -> {
            if (collectionState == null) {
                return false;
            }
            if (collectionState.getSlices().size() != expectedShards) {
                return false;
            }
            for (Slice slice : collectionState) {
                int activeReplicas = 0;
                for (Replica replica : slice) {
                    if (!replica.isActive(liveNodes)) continue;
                    ++activeReplicas;
                }
                if (activeReplicas == expectedReplicas) continue;
                return false;
            }
            return true;
        };
    }

    protected static Slice getRandomShard(DocCollection collection) {
        ArrayList shards = new ArrayList(collection.getActiveSlices());
        if (shards.size() == 0) {
            SolrCloudTestCase.fail((String)("Couldn't get random shard for collection as it has no shards!\n" + collection.toString()));
        }
        Collections.shuffle(shards, SolrCloudTestCase.random());
        return (Slice)shards.get(0);
    }

    protected static Replica getRandomReplica(Slice slice) {
        ArrayList replicas = new ArrayList(slice.getReplicas());
        if (replicas.size() == 0) {
            SolrCloudTestCase.fail((String)("Couldn't get random replica from shard as it has no replicas!\n" + slice.toString()));
        }
        Collections.shuffle(replicas, SolrCloudTestCase.random());
        return (Replica)replicas.get(0);
    }

    protected static Replica getRandomReplica(Slice slice, Predicate<Replica> matchPredicate) {
        ArrayList replicas = new ArrayList(slice.getReplicas());
        if (replicas.size() == 0) {
            SolrCloudTestCase.fail((String)("Couldn't get random replica from shard as it has no replicas!\n" + slice.toString()));
        }
        Collections.shuffle(replicas, SolrCloudTestCase.random());
        for (Replica replica : replicas) {
            if (!matchPredicate.test(replica)) continue;
            return replica;
        }
        SolrCloudTestCase.fail((String)("Couldn't get random replica that matched conditions\n" + slice.toString()));
        return null;
    }

    protected static CoreStatus getCoreStatus(Replica replica) throws IOException, SolrServerException {
        JettySolrRunner jetty = cluster.getReplicaJetty(replica);
        try (HttpSolrClient client = SolrCloudTestCase.getHttpSolrClient(jetty.getBaseUrl().toString(), cluster.getSolrClient().getHttpClient());){
            CoreStatus coreStatus = CoreAdminRequest.getCoreStatus((String)replica.getCoreName(), (SolrClient)client);
            return coreStatus;
        }
    }

    static /* synthetic */ JettyConfig access$000(String x0) {
        return SolrCloudTestCase.buildJettyConfig(x0);
    }

    protected static class Builder {
        private final int nodeCount;
        private final Path baseDir;
        private String solrxml = "<solr>\n\n  <str name=\"shareSchema\">${shareSchema:false}</str>\n  <str name=\"configSetBaseDir\">${configSetBaseDir:configsets}</str>\n  <str name=\"coreRootDirectory\">${coreRootDirectory:.}</str>\n\n  <shardHandlerFactory name=\"shardHandlerFactory\" class=\"HttpShardHandlerFactory\">\n    <str name=\"urlScheme\">${urlScheme:}</str>\n    <int name=\"socketTimeout\">${socketTimeout:90000}</int>\n    <int name=\"connTimeout\">${connTimeout:15000}</int>\n  </shardHandlerFactory>\n\n  <solrcloud>\n    <str name=\"host\">127.0.0.1</str>\n    <int name=\"hostPort\">${hostPort:8983}</int>\n    <str name=\"hostContext\">${hostContext:solr}</str>\n    <int name=\"zkClientTimeout\">${solr.zkclienttimeout:30000}</int>\n    <bool name=\"genericCoreNodeNames\">${genericCoreNodeNames:true}</bool>\n    <int name=\"leaderVoteWait\">10000</int>\n    <int name=\"distribUpdateConnTimeout\">${distribUpdateConnTimeout:45000}</int>\n    <int name=\"distribUpdateSoTimeout\">${distribUpdateSoTimeout:340000}</int>\n  </solrcloud>\n  \n</solr>\n";
        private JettyConfig jettyConfig = SolrCloudTestCase.access$000("/solr");
        private List<Config> configs = new ArrayList<Config>();
        private Map<String, String> clusterProperties = new HashMap<String, String>();

        public Builder(int nodeCount, Path baseDir) {
            this.nodeCount = nodeCount;
            this.baseDir = baseDir;
        }

        public Builder withJettyConfig(JettyConfig jettyConfig) {
            this.jettyConfig = jettyConfig;
            return this;
        }

        public Builder withSolrXml(String solrXml) {
            this.solrxml = solrXml;
            return this;
        }

        public Builder withSolrXml(Path solrXml) {
            try {
                this.solrxml = new String(Files.readAllBytes(solrXml), Charset.defaultCharset());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Builder addConfig(String configName, Path configPath) {
            this.configs.add(new Config(configName, configPath));
            return this;
        }

        public Builder withProperty(String propertyName, String propertyValue) {
            this.clusterProperties.put(propertyName, propertyValue);
            return this;
        }

        public void configure() throws Exception {
            cluster = new MiniSolrCloudCluster(this.nodeCount, this.baseDir, this.solrxml, this.jettyConfig);
            CloudSolrClient client = cluster.getSolrClient();
            for (Config config : this.configs) {
                client.uploadConfig(config.path, config.name);
            }
            if (this.clusterProperties.size() > 0) {
                ClusterProperties props = new ClusterProperties(cluster.getSolrClient().getZkStateReader().getZkClient());
                for (Map.Entry<String, String> entry : this.clusterProperties.entrySet()) {
                    props.setClusterProperty(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private static class Config {
        final String name;
        final Path path;

        private Config(String name, Path path) {
            this.name = name;
            this.path = path;
        }
    }
}

