/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.Row;
import org.apache.spark.sql.catalyst.expressions.UnsafeColumnWriter;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeRowConverter$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u001f\t\u0011RK\\:bM\u0016\u0014vn^\"p]Z,'\u000f^3s\u0015\t\u0019A!A\u0006fqB\u0014Xm]:j_:\u001c(BA\u0003\u0007\u0003!\u0019\u0017\r^1msN$(BA\u0004\t\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003\u0013)\tQa\u001d9be.T!a\u0003\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005i\u0011aA8sO\u000e\u00011C\u0001\u0001\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\"Aq\u0003\u0001B\u0001B\u0003%\u0001$\u0001\u0006gS\u0016dG\rV=qKN\u00042!E\r\u001c\u0013\tQ\"CA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001d?5\tQD\u0003\u0002\u001f\r\u0005)A/\u001f9fg&\u0011\u0001%\b\u0002\t\t\u0006$\u0018\rV=qK\")!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001\n\u0014\u0011\u0005\u0015\u0002Q\"\u0001\u0002\t\u000b]\t\u0003\u0019\u0001\r\t\u000b\t\u0002A\u0011\u0001\u0015\u0015\u0005\u0011J\u0003\"\u0002\u0016(\u0001\u0004Y\u0013AB:dQ\u0016l\u0017\r\u0005\u0002\u001dY%\u0011Q&\b\u0002\u000b'R\u0014Xo\u0019;UsB,\u0007BB\u0018\u0001A\u0003%\u0001'A\u0005v]N\fg-\u001a*poB\u0011Q%M\u0005\u0003e\t\u0011\u0011\"\u00168tC\u001a,'k\\<\t\rQ\u0002\u0001\u0015!\u00036\u0003\u001d9(/\u001b;feN\u00042!E\r7!\t)s'\u0003\u00029\u0005\t\u0011RK\\:bM\u0016\u001cu\u000e\\;n]^\u0013\u0018\u000e^3s\u0011\u0019Q\u0004\u0001)A\u0005w\u0005ya-\u001b=fI2+gn\u001a;i'&TX\r\u0005\u0002\u0012y%\u0011QH\u0005\u0002\u0004\u0013:$\b\"B \u0001\t\u0003\u0001\u0015AE4fiNK'0\u001a*fcVL'/Z7f]R$\"aO!\t\u000b\ts\u0004\u0019A\"\u0002\u0007I|w\u000f\u0005\u0002E\u000f:\u0011Q%R\u0005\u0003\r\n\tq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\n\u0019!k\\<\u000b\u0005\u0019\u0013\u0001\"B&\u0001\t\u0003a\u0015\u0001C<sSR,'k\\<\u0015\tmje\n\u0017\u0005\u0006\u0005*\u0003\ra\u0011\u0005\u0006\u001f*\u0003\r\u0001U\u0001\u000bE\u0006\u001cXm\u00142kK\u000e$\bCA)W\u001b\u0005\u0011&BA*U\u0003\u0011a\u0017M\\4\u000b\u0003U\u000bAA[1wC&\u0011qK\u0015\u0002\u0007\u001f\nTWm\u0019;\t\u000beS\u0005\u0019\u0001.\u0002\u0015\t\f7/Z(gMN,G\u000f\u0005\u0002\u00127&\u0011AL\u0005\u0002\u0005\u0019>tw\r")
public class UnsafeRowConverter {
    private final UnsafeRow unsafeRow = new UnsafeRow();
    private final UnsafeColumnWriter[] writers;
    private final int fixedLengthSize;

    public int getSizeRequirement(Row row) {
        int variableLengthFieldSize = 0;
        for (int fieldNumber = 0; fieldNumber < this.writers.length; ++fieldNumber) {
            if (row.isNullAt(fieldNumber)) continue;
            variableLengthFieldSize += this.writers[fieldNumber].getSize(row, fieldNumber);
        }
        return this.fixedLengthSize + variableLengthFieldSize;
    }

    public int writeRow(Row row, Object baseObject, long baseOffset) {
        this.unsafeRow.pointTo(baseObject, baseOffset, this.writers.length, null);
        int appendCursor = this.fixedLengthSize;
        for (int fieldNumber = 0; fieldNumber < this.writers.length; ++fieldNumber) {
            if (row.isNullAt(fieldNumber)) {
                this.unsafeRow.setNullAt(fieldNumber);
                continue;
            }
            appendCursor += this.writers[fieldNumber].write(row, this.unsafeRow, fieldNumber, appendCursor);
        }
        return appendCursor;
    }

    public UnsafeRowConverter(DataType[] fieldTypes) {
        this.writers = (UnsafeColumnWriter[])Predef$.MODULE$.refArrayOps((Object[])fieldTypes).map((Function1)new $anonfun$1(this), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(UnsafeColumnWriter.class)));
        this.fixedLengthSize = 8 * fieldTypes.length + UnsafeRow.calculateBitSetWidthInBytes(fieldTypes.length);
    }

    public UnsafeRowConverter(StructType schema) {
        this((DataType[])Predef$.MODULE$.refArrayOps((Object[])schema.fields()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final DataType apply(StructField x$1) {
                return x$1.dataType();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(DataType.class))));
    }
}

