/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.expressions.UnsafeArrayData;
import org.apache.spark.sql.catalyst.expressions.UnsafeMapData;
import org.apache.spark.unsafe.Platform;

public class UnsafeReaders {
    public static UnsafeArrayData readArray(Object baseObject, long baseOffset, int numBytes) {
        int numElements = Platform.getInt((Object)baseObject, (long)baseOffset);
        UnsafeArrayData array = new UnsafeArrayData();
        array.pointTo(baseObject, baseOffset + 4L, numElements, numBytes - 4);
        return array;
    }

    public static UnsafeMapData readMap(Object baseObject, long baseOffset, int numBytes) {
        int numElements = Platform.getInt((Object)baseObject, (long)baseOffset);
        int keyArraySize = Platform.getInt((Object)baseObject, (long)(baseOffset + 4L));
        int valueArraySize = numBytes - 8 - keyArraySize;
        UnsafeArrayData keyArray = new UnsafeArrayData();
        keyArray.pointTo(baseObject, baseOffset + 8L, numElements, keyArraySize);
        UnsafeArrayData valueArray = new UnsafeArrayData();
        valueArray.pointTo(baseObject, baseOffset + 8L + (long)keyArraySize, numElements, valueArraySize);
        return new UnsafeMapData(keyArray, valueArray);
    }
}

